#!/bin/sh

if [ -f /etc/systemui/savepress.xml ]; then {
	echo "running savepress.."
	}
	else {
		echo '<powerkeymenu path="/">
 <title>powerup_application_title</title>
 <po>osso-powerup-shutdown</po>

 <menuitem priority="200" name="Savepress is active" visible="on">
  <keyfile>/tmp/savepress</keyfile>
 </menuitem>

</powerkeymenu>' > /etc/systemui/savepress.xml
	killall systemui
	echo "wrote systemui-button.."
	echo "running savepress.."
	}
fi

echo "checking button.."

if [ "`cat /home/user/.config/savepress | grep "vdeley" | sed 's/vdeley: //g'`" == "true" ]; then {
	sleep 2
	}
fi

if [ `hal-get-property --udi /org/freedesktop/Hal/devices/platform_kb_lock --key button.state.value` == true ]; then {
	echo "button pressed.."
		if [ -f /tmp/savepress ]; then {
			echo "disabling.."
			dbus-send --system --type=method_call --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:"unlocked"
			rm /tmp/savepress
			run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"powersave is disabled!"

			# restore settings
			/usr/sbin/kernel-config limits `cat /tmp/savepress-value | grep "min" | sed 's/min: //g'` `cat /tmp/savepress-value | grep "max" | sed 's/max: //g'`
			rm /tmp/savepress-value
			}
		else {
			echo "activating.."
			dbus-send --system --type=method_call --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:"unlocked"
			echo "on" > /tmp/savepress
			run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"savepress is activated!"

			# activate settings
			echo "`/usr/sbin/kernel-config show | grep "max" | sed 's/. frequency//g'`" > /tmp/savepress-value
			echo "`/usr/sbin/kernel-config show | grep "min" | sed 's/. frequency//g'`" >> /tmp/savepress-value
			/usr/sbin/kernel-config limits `cat /home/user/.config/savepress | grep "vmin" | sed 's/vmin: //g'` `cat /home/user/.config/savepress | grep "vmax" | sed 's/vmax: //g'`
			if [ "`cat /home/user/.config/savepress | grep "vwlan" | sed 's/vwlan: //g'`" == "true" ]; then {
				if [ "`/sbin/ifconfig wlan0 | grep "inet addr" | awk -F: '{print $2}' | awk '{print $1}'`" != "" ]; then
					dbus-send --system --dest=com.nokia.icd /com/nokia/icd_ui com.nokia.icd_ui.disconnect boolean:true
				fi
				}
			fi
			sleep 1
			dbus-send --system --type=method_call --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:"locked"
			}
		fi
	echo "done.."
	}
else {
	echo "not pressed.."
	}
fi

echo "exit"
exit