#include "settingsdialog.h"
#include <QDebug>
#include <QGridLayout>
#include <QLayout>
#include <sabconnector.h>

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent)
{
    settings = new Settings();

    adress = new QLabel(tr("Adress:"));
    lineEditAddr = new QLineEdit;
    lineEditAddr->setText(settings->getAdress());
    adress->setBuddy(lineEditAddr);

    port = new QLabel(tr("Port:"));
    lineEditPort = new QLineEdit;
    //int port = settings->getPort();
    lineEditPort->setText(QString::number(settings->getPort()));
    port->setBuddy(lineEditPort);

    apikey = new QLabel(tr("Api key:"));
    lineEditApi = new QLineEdit;
    lineEditApi->setText(settings->getAPIkey());
    apikey->setBuddy(lineEditApi);

    username = new QLabel(tr("Username:"));
    lineEditUsername = new QLineEdit;
    lineEditUsername->setText(settings->getUsername());
    username->setBuddy(lineEditUsername);

    password = new QLabel(tr("Password:"));
    lineEditPassword = new QLineEdit;
    lineEditPassword->setText(settings->getPassword());
    password->setBuddy(lineEditPassword);
    lineEditPassword->setEchoMode(QLineEdit::Password);

    saveButton = new QPushButton(tr("&Save"));
    saveButton->setDefault(true);

    testButton = new QPushButton(tr("&Test\nSettings"));

    QGridLayout *inputLayout = new QGridLayout;
    inputLayout->addWidget(adress,0,0);
    inputLayout->addWidget(lineEditAddr,0,1);
    inputLayout->addWidget(port,1,0);
    inputLayout->addWidget(lineEditPort,1,1);
    inputLayout->addWidget(apikey,2,0);
    inputLayout->addWidget(lineEditApi,2,1);
    inputLayout->addWidget(username,3,0);
    inputLayout->addWidget(lineEditUsername,3,1);
    inputLayout->addWidget(password,4,0);
    inputLayout->addWidget(lineEditPassword,4,1);

    QGridLayout *mainLayout = new QGridLayout;
    //mainLayout->setSizeConstraint(QLayout::SetFixedSize);
    //mainLayout->setSizeConstraint(QLayout::SetMinimumSize);
    mainLayout->addLayout(inputLayout, 0, 0, 2, 1);
    mainLayout->addWidget(testButton, 0, 1);
    mainLayout->addWidget(saveButton, 1, 1);
    setLayout(mainLayout);

    setWindowTitle(tr("Settings"));

    connect(saveButton, SIGNAL(clicked(bool)), this, SLOT(saveSettings(bool)));
    connect(testButton, SIGNAL(clicked(bool)), this, SLOT(testSettings(bool)));
}

void SettingsDialog::saveSettings(bool)
{
    qDebug() << "saveSettings";
    if ( settings->setAddress(lineEditAddr->text()) &&
         settings->setPort(lineEditPort->text()) &&
         settings->setAPIkey(lineEditApi->text()) &&
         settings->setUsername(lineEditUsername->text()) &&
         settings->setPassword(lineEditPassword->text())
        )
        this->close();
    else
        qDebug() << "saveSettings ERROR";
}

void SettingsDialog::testSettings(bool)
{
    lineEditAddr->setStyleSheet("QLineEdit { background-color: orange; }");
    lineEditPort->setStyleSheet("QLineEdit { background-color: orange; }");
    lineEditApi->setStyleSheet("QLineEdit { background-color: orange; }");

    SabConnector sc;
    int testresult = sc.testConnection(lineEditAddr->text(),lineEditPort->text(),lineEditApi->text());
    if(testresult==0)
    {
        lineEditAddr->setStyleSheet("QLineEdit { background-color: red; }");
        lineEditPort->setStyleSheet("QLineEdit { background-color: red; }");
        lineEditApi->setStyleSheet("QLineEdit { background-color: red; }");
        qDebug() << "test failed";
    }
    else if (testresult>0)
    {
        lineEditAddr->setStyleSheet("QLineEdit { background-color: green; }");
        lineEditPort->setStyleSheet("QLineEdit { background-color: green; }");
        qDebug() << "Port and url OK";
    }
    if(testresult>1)
        lineEditApi->setStyleSheet("QLineEdit { background-color: green; }");
    else
        lineEditApi->setStyleSheet("QLineEdit { background-color: red; }");

    //qDebug() << "testSettings";
}
