/*
 * Copyright (C) 2010 Collabora Ltd.
 *   @author Marco Barisione <marco.barisione@collabora.co.uk>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef RINGTONED_IS_COMPILING_APP
#error "Don't include this file directly, use ringtoned/plugin.h instead"
#endif


#ifndef __RINGTONED_DISPATCHER_H__
#define __RINGTONED_DISPATCHER_H__

#include "call.h"


G_BEGIN_DECLS
 
#define RINGTONED_FILTER_PRIORITY_HIGH -100
#define RINGTONED_FILTER_PRIORITY_DEFAULT 0
#define RINGTONED_FILTER_PRIORITY_LOW 100

#define RINGTONED_TYPE_DISPATCHER             (ringtoned_dispatcher_get_type ())
#define RINGTONED_DISPATCHER(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), RINGTONED_TYPE_DISPATCHER, RingtonedDispatcher))
#define RINGTONED_DISPATCHER_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), RINGTONED_TYPE_DISPATCHER, RingtonedDispatcherClass))
#define RINGTONED_IS_DISPATCHER(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RINGTONED_TYPE_DISPATCHER))
#define RINGTONED_IS_DISPATCHER_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), RINGTONED_TYPE_DISPATCHER))
#define RINGTONED_DISPATCHER_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), RINGTONED_TYPE_DISPATCHER, RingtonedDispatcherClass))

typedef struct _RingtonedDispatcher        RingtonedDispatcher;
typedef struct _RingtonedDispatcherClass   RingtonedDispatcherClass;
typedef struct _RingtonedDispatcherPrivate RingtonedDispatcherPrivate;

struct _RingtonedDispatcher
{
    GObject parent;

    /*< private >*/
    RingtonedDispatcherPrivate *priv;
};

struct _RingtonedDispatcherClass
{
    GObjectClass parent_class;
};

typedef gboolean (*RingtonedFilterCb) (RingtonedDispatcher *dispatcher,
                                       RingtonedCall       *call,
                                       gpointer             user_data);

GType                   ringtoned_dispatcher_get_type (void) G_GNUC_CONST;

RingtonedDispatcher *   ringtoned_dispatcher_new      (void);

void                    ringtoned_dispatcher_add_filter_real
                                                      (RingtonedDispatcher *self,
                                                       gint                 priority,
                                                       const gchar         *plugin_name,
                                                       const gchar         *func_name,
                                                       RingtonedFilterCb    cb,
                                                       gpointer             user_data,
                                                       GDestroyNotify       destroy_notify_cb);

G_END_DECLS

#endif /* __RINGTONED_DISPATCHER_H__ */
