/*
 * Copyright (C) 2010 Collabora Ltd.
 *   @author Marco Barisione <marco.barisione@collabora.co.uk>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef RINGTONED_IS_COMPILING_LIB
#error "Don't include this file directly, use libringtoned/ringtoned.h instead"
#endif


#ifndef __RINGTONED_PLAYER_H__
#define __RINGTONED_PLAYER_H__

#include <glib-object.h>


G_BEGIN_DECLS
 
#define RINGTONED_TYPE_PLAYER            (ringtoned_player_get_type ())
#define RINGTONED_PLAYER(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), RINGTONED_TYPE_PLAYER, RingtonedPlayer))
#define RINGTONED_PLAYER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), RINGTONED_TYPE_PLAYER, RingtonedPlayerClass))
#define RINGTONED_IS_PLAYER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RINGTONED_TYPE_PLAYER))
#define RINGTONED_IS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RINGTONED_TYPE_PLAYER))
#define RINGTONED_PLAYER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), RINGTONED_TYPE_PLAYER, RingtonedPlayerClass))

typedef struct _RingtonedPlayer        RingtonedPlayer;
typedef struct _RingtonedPlayerClass   RingtonedPlayerClass;
typedef struct _RingtonedPlayerPrivate RingtonedPlayerPrivate;

struct _RingtonedPlayer
{
    GObject parent;

    /*< private >*/
    RingtonedPlayerPrivate *priv;
};

struct _RingtonedPlayerClass
{
    GObjectClass parent_class;
};

GType               ringtoned_player_get_type (void) G_GNUC_CONST;

RingtonedPlayer *   ringtoned_player_new      (const gchar          *file_path,
                                               gboolean              preview);

void                ringtoned_player_start    (RingtonedPlayer      *player);
void                ringtoned_player_stop     (RingtonedPlayer      *player);

G_END_DECLS

#endif /* __RINGTONED_PLAYER_H__ */
