/*************************************************************************}
{ includes.h - common includes                                            }
{                                                                         }
{ This file is a part of the project                                      }
{   Rhapsodie - Music player for N900                                     }
{                                                                         }
{ (c) Alexey Parfenov, 2012                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This program is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This program is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 31 May 2012                                              }
{*************************************************************************/

#ifndef INCLUDES_H
#define INCLUDES_H


#include <QtCore>
#include <QtGui>
#include <QtDBus>

#include <phonon/audiooutput.h>
#include <phonon/audiodataoutput.h>
#include <phonon/backendcapabilities.h>
#include <phonon/effect.h>
#include <phonon/effectparameter.h>
#include <phonon/EffectDescription>
#include <phonon/mediaobject.h>

#ifdef MAEMO5
#include "mce/dbus-names.h"
#include "mce/mode-names.h"
#endif

#include "../inc/qwidgethelper.h"
#include "../inc/fsman.h"
#include "../inc/controls/qkineticwidget.h"
#include "../inc/qiodevicehelper.h"
#include "../inc/stringhash.h"


#define ITEM_HEIGHT 82
#define CONTROLBUTTON_PUSHOFFSET 5
#define ICON_SIZE 64
#define CONTROLBUTTON_SIZE 64
#define CONTROLBUTTON_PADDING 10
#define SKIN_INI_FILENAME "skin.ini"
#define DEFAULT_SKIN_NAME "default"
#define PLAYLIST_FILENAME "playlist"
#define PREFINISH_MARK 600

#define MAINWINDOW MainWindow::getInstance()
#define OPTIONS MAINWINDOW->getOptionsWindow()->getOptions()
#define SKIN MAINWINDOW->getSkin()
#define PLAYER MAINWINDOW->getPlayer()
#define APP_DIR MAINWINDOW->getAppDir()


#include "skin.h"


class MainWindow;
class OptionsWindow;


class Label : public QLabel {
    Q_OBJECT

public:
    Label(QWidget* parent = 0, Qt::WindowFlags f = 0):QLabel(parent, f){}
};

class Slider : public QSlider {
    Q_OBJECT

public:
    Slider(QWidget* parent = 0):QSlider(parent){}
};


#endif // INCLUDES_H
