/*************************************************************************}
{ kineticlistitem.h - an item to be used in a kinetic scroller            }
{                                                                         }
{ This file is a part of the project                                      }
{   Rhapsodie - Music player for N900                                     }
{                                                                         }
{ (c) Alexey Parfenov, 2012                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This program is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This program is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 31 Mar 2012                                              }
{*************************************************************************/

#ifndef KINETICLISTITEM_H
#define KINETICLISTITEM_H

#include "includes.h"

class KineticListItem : public QCommandLinkButton
{
    Q_OBJECT

protected:
    void mousePressEvent(QMouseEvent *event){event->ignore();}
    void mouseReleaseEvent(QMouseEvent *event){event->ignore();}
    void mouseMoveEvent(QMouseEvent *event){event->ignore();}

    QString stringValue;
    bool boolValue;
    int intValue;

public:
    explicit KineticListItem(QWidget *parent = 0);

    inline const QString& getString() const {return stringValue;}
    virtual void setString(const QString& newValue){stringValue = newValue;}
    inline bool getBool() const {return boolValue;}
    virtual void setBool(bool newValue){boolValue = newValue;}
    inline int getInt() const {return intValue;}
    virtual void setInt(int newValue){intValue = newValue;}
};

#endif // KINETICLISTITEM_H
