/*************************************************************************}
{ equalizerwindow.h - equalizer settings and presets window               }
{                                                                         }
{ This file is a part of the project                                      }
{   Rhapsodie - Music player for N900                                     }
{                                                                         }
{ (c) Alexey Parfenov, 2012                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This program is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This program is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 21 Mar 2012                                              }
{*************************************************************************/

#ifndef EQUALIZERWINDOW_H
#define EQUALIZERWINDOW_H

#include "includes.h"
#include "commondialog.h"
#include "phononplayer.h"
#include "button.h"
#include "selectwindow.h"

class EqualizerWindow : public CommonDialog
{
    Q_OBJECT

public:
    explicit EqualizerWindow(QWidget *parent = 0);
    ~EqualizerWindow();
    static QString showEqualizerWindow(const QString& presetName = "");

protected:
    void initGui();
    void deinitGui();
    void reposition(const QSize& sz);

    void updateLevels();
    void updateLevel(int bandIndex);
    void updateLevelLabel(QLabel* label, int level);
    int getBarIndex(QWidget* bar);
    void updateSelectorLabel();
    void selectPreset(const QString& presetName);
    void setControlsEnabled(bool isEnabled);
    void checkForSave();
    Equalizer* eq() const;

    QWidget* placeholder;
    QWidget** bars; // array of containers
    QPushButton* selector;
    Button *btnNew, *btnRename, *btnSave, *btnDelete;

    QString selectedPreset;
    QString presetOff;
    bool isChanged;

protected slots:
    void onLevelChange(int level);
    void onNewClick();
    void onRenameClick();
    void onSaveClick();
    void onDeleteClick();
    void onSelectorClick();
};

#endif // EQUALIZERWINDOW_H
