/*************************************************************************}
{ phononplayer.h - Phonon-based audio player                              }
{                                                                         }
{ This file is a part of the project                                      }
{   Rhapsodie - Music player for N900                                     }
{                                                                         }
{ (c) Alexey Parfenov, 2012                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This program is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This program is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 21 Mar 2012                                              }
{*************************************************************************/

#ifndef PHONONPLAYER_H
#define PHONONPLAYER_H

#include "includes.h"
#include "equalizer.h"

typedef enum {
    pp_state_Idle,
    pp_state_Playing,
    pp_state_Paused
} PhononPlayerState;

typedef enum {
    pp_stype_None,
    pp_stype_File,
    pp_stype_Memory,
    pp_stype_Remote
} PhononPlayerSourceType;

class PhononPlayer : public QObject
{
    Q_OBJECT
public:
    explicit PhononPlayer(QObject *parent = 0);
    ~PhononPlayer();
    inline const QStringList& getKnownExtensions(){return knownExtensions;}
    inline const QStringList& getSupportedMime(){return supportedMime;}
    inline const QStringList& getSupportedExtensions(){return supportedExtensions;}
    inline const QStringList& getKnownPlaylistExtensions(){return knownPlaylistExtensions;}
    inline const QString& getUnzipPath(){return unzipPath;}
    inline const QString& getCurrentFilename(){return currentFilename;}
    inline Equalizer* getEqualizer(){return equalizer;}
    inline PhononPlayerState getState(){return state;}
    inline PhononPlayerSourceType getSourceType(){return sourceType;}
    bool play(const QString& filename);
    void pause();
    void unpause();
    void stop();
    bool isHeadsetConnected();
    inline bool isEqualizerEnabled(){return equalizerEnabled;}
    bool setEqualizerEnabled(bool doEnable);
    inline bool isCalling(){return calling;}

public slots:
    void updateSupportedMime();
    void close(bool emitStop = true);

signals:
    void onPlayEnd();
    void onError();
    void onStateChanged();
    void onHeadsetStatusChange(bool isConnected);
    void onCallStart();
    void onCallEnd();
    void onTitleChange(const QString& title);

protected:
    void createMediaObject();
    void updateKnownMime();
    void findUnzip();
    void updateNameFilters();
    bool unzip(const QString& filename);
    void killLater(QObject* obsoleteObject);

    QFile devFile;
    QBuffer devMem;
    QIODevice* dev;
    PhononPlayerState state;
    PhononPlayerSourceType sourceType;
    Equalizer* equalizer;
    bool equalizerEnabled;
    qint64 lastPos;
    bool calling;

    QHash<QString, QStringList> mimeExtensions;
    QStringList knownExtensions;
    QStringList supportedMime;
    QStringList supportedExtensions;
    QStringList knownPlaylistExtensions;
    QString unzipPath;
    QString tmpFilenameBase;
    QString tmpFilename;
    QObjectList obsoleteObjects;

    Phonon::MediaObject *mediaObject;
    Phonon::AudioOutput *audioOutput;
    Phonon::Path mediaPath;
    QString currentFilename;
    QString lastSentFullTitle;

protected slots:
    void stateChanged(Phonon::State newstate, Phonon::State oldstate);
    void onCustomPlayEnd();
    void onHeadsetCondition();
    void onDeviceAdd();
    void onCheckHeadset();
    void onCallStateChange(QString callState);
    void onKillObsoleteObject();
    void onMetaDataChanged();

};

#endif // PHONONPLAYER_H
