/*
 * greddit - a very simple GLib-friendly reddit client
 * Copyright (c) 2009 Thomas Thurman
 * thomas@thurman.org.uk
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have be able to view the GNU General Public License at 
 * http://www.gnu.org/copyleft/gpl.html ; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef GREDDIT_H
#define GREDDIT_H 1

#include <glib-object.h>

/**
 * A single post on reddit.
 */
typedef struct {
  /**
   * Reddit's internal ID code for the post.  It looks like
   * "t3_9fvgj".  (You may want to split off the underscore
   * and everything before it, since that's a constant type
   * code.)
   */
  char *id;
  /**
   * The final part of the ID.  For example, an ID of "t3_9fvgj"
   * will have a suffix of "9fvgj".  This is often used to
   * construct URLs.
   */
  char *suffix;
  /**
   * The title of the post.
   */
  char* title;
  /**
   * The address of the site which the post is about.
   */
  char *url;
  /**
   * The number of points (up votes minus down votes).
   */
  int score;
  /**
   * The username of the user who created the post.
   */
  char *author;
  /**
   * The subsection of reddit.com which bears this post.
   */
  char *subreddit;
  /**
   * The number of comments the post has received on Reddit.
   */
  guint comment_count;

  /* ... more may be added here later. */

} GRedditPost;

typedef void (*GRedditLoadingCallback) (int so_far, int total);

/**
 * Returns a list of the top posts currently on reddit.com.
 */
GSList *greddit_get_posts (void);

/**
 * Returns a list of the top posts currently on reddit.com
 * and calls a callback every so often to say how much has
 * been loaded.
 */
GSList *greddit_get_posts_with_callback (GRedditLoadingCallback callback);

/**
 * Frees a list which was previously returned by greddit_get_posts().
 *
 * \param posts  the list.
 */
void greddit_free_posts (GSList *posts);

#endif

/* eof greddit.h */
