/*
 * Copyright (C) 2015 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "resources.h"
#include <QCoreApplication>
#include <QStringList>
#include <iostream>

void printUsage() {
    std::cout << "Usage:\n\tqyoutube-videos-delete OPTION... VIDEO_ID" \
    "Delete a YouTube video.\n\n" \
    "Options:\n\t-apiKey\t\t\tThe api key.\n\t" \
    "-accessToken\t\tThe access token.\n\t" \
    "-refreshToken\t\tThe refresh token.\n\t" \
    "-output\t\t\tThe output format (html, json, tsv (default), xml).";
}

QString getParam(QStringList &args, const QString &name, const QString &defaultValue = QString()) {
    int i = args.indexOf(name);

    if ((i >= 0) && (i < args.size() - 1)) {
        args.removeAt(i);
        return args.takeAt(i);
    }

    return defaultValue;
}

int main(int argc, char *argv[]) {
    QCoreApplication app(argc, argv);
    app.setOrganizationName("QYouTube");
    app.setApplicationName("cli");

    QStringList args = app.arguments();

    if (args.size() < 2) {
	printUsage();
	return 1;
    }

    args.removeFirst();

    const QString key = getParam(args, "-apiKey");

    if (key.isEmpty())
        printUsage();
        return 1;
    }

    const QString token = getParam(args, "-accessToken");

    if (token.isEmpty()) {
        printUsage();
        return 1;
    }

    const QString refresh = getParam(args, "-refreshToken");
    
    if (refresh.isEmpty()) {
        printUsage();
        return 1;
    }    

    const QString output = getParam(args, "-output", "tsv");

    if (args.size() != 1) {
        printUsage();
        return 1;
    }
    
    QYouTube::Resources resources;
    resources.setApiKey(key);
    resources.setAccessToken(token);
    resources.setRefreshToken(refresh);
    resources.setOutputFormat(output);
    resources.del(args.takeFirst(), "/videos");
    QObject::connect(&resources, SIGNAL(finished()), &app, SLOT(quit()));
    
    return app.exec();
}
