/*
 * Copyright (C) 2015 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "subtitles.h"
#include "printer.h"
#include "subtitlesrequest.h"

namespace QYouTube {

Subtitles::Subtitles(QObject *parent) :
    QObject(parent),
    m_request(0),
    m_format("tsv")
{
}

QString Subtitles::outputFormat() const {
    return m_format;
}

void Subtitles::setOutputFormat(const QString &format) {
    m_format = format.toLower();
}

void Subtitles::list(const QString &id) {
    if (!m_request) {
        m_request = new SubtitlesRequest(this);
        connect(m_request, SIGNAL(finished()), this, SLOT(onRequestFinished()));
    }

    if (m_request->status() == SubtitlesRequest::Loading) {
        return;
    }

    m_request->list(id);
}

void Subtitles::printResult() const {
    QVariantMap result;
    result["items"] = m_results;
    
    if (outputFormat() == "html") {
        Printer::printHtml(result);
    }
    else if (outputFormat() == "json") {
        Printer::printJson(result);
    }
    else if (outputFormat() == "xml") {
        Printer::printXml(result);
    }
    else {
        if (!m_results.isEmpty()) {
            Printer::printTsvHeader(m_results.first());
            Printer::printTsv(result);
        }
    }
}

void Subtitles::onRequestFinished() {
    m_results = m_request->result().toList();
    printResult();
    emit finished();
}

}
