/*
 * Copyright (C) 2015 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef QYOUTUBECLIRESOURCES_H
#define QYOUTUBECLIRESOURCES_H

#include <QObject>
#include <QVariantList>

namespace QYouTube {

class ResourcesRequest;

class Resources : public QObject
{
    Q_OBJECT

public:
    explicit Resources(QObject *parent = 0);

    QString apiKey() const;
    void setApiKey(const QString &key);

    QString accessToken() const;
    void setAccessToken(const QString &token);

    QString refreshToken() const;
    void setRefreshToken(const QString &token);

    QString outputFormat() const;
    void setOutputFormat(const QString &format);

    void del(const QString &id, const QString &resourcePath);
    void insert(const QVariantMap &resource, const QString &resourcePath, const QStringList &part,
                const QVariantMap &params);
    void list(const QString &resourcePath, const QStringList &part, const QVariantMap &filters,
              const QVariantMap &params);
    void update(const QString &resourcePath, const QVariantMap &resource, const QStringList &part);

private Q_SLOTS:
    void onRequestFinished();

Q_SIGNALS:
    void finished();

private:
    void initRequest();
    
    void printResult() const;
    
    ResourcesRequest *m_request;

    QString m_key;
    QString m_token;
    QString m_refresh;
    QString m_format;
    QVariantMap m_result;
};

}

#endif // QYOUTUBECLIRESOURCES_H
