import QtQuick 1.0
import QtWebKit 1.0

Rectangle {
    property string articleName : ""
    property string articleCurrent : ""
    property int articleScale : 0
    x: parent.width
    anchors.verticalCenter: parent.verticalCenter
    opacity: 1
    width: parent.width
    height: parent.height
    //color: "#7d7b97"
    gradient: Gradient {
        GradientStop {
            position: 0
            color: "#7d7b97"
        }

        GradientStop {
            position: 1
            color: "#313f4d"
        }
    }
    /*

    Loader {
        id: loader
        sourceComponent : triche;
    } */

    Item {
        id: details
        x: 0
        y: 0
        width: parent.width // - 20
        height:  parent.height-menu.height
        //anchors { top: parent.top; topMargin: 0; bottom: parent.bottom; bottomMargin: 0 }

        ParseModel { id: parseModel }

        Repeater {
            id: triche
            model: parseModel
            Flickable {
                id: flickable
                width: fond.width
                height:  fond.height
                contentWidth: Math.max(flickable.width,webView.width)
                contentHeight: Math.max(flickable.height,webView.height)
                pressDelay: 100

                WebView {
                    id: webView
                    transformOrigin: Item.TopLeft
                    smooth: false
                    //width: fond.width
                    width: fond.width // * articleScale
                    preferredWidth: fond.width // * articleScale
                    preferredHeight: parent.height
                    contentsScale: 1 // articleScale
                    settings.defaultFontSize: 24 +articleScale
                    //url: "http://"+schModel.from+".m.wikipedia.org/wiki?search="+articleName
                    html: "<div style=\"background-color:white\">"+article+"</div>"
                    /*
                    onLoadStarted: {
                        loading.opacity=1;
                    } */
                    onLoadFailed: { console.debug="==========================>PB"  }
                    onLoadFinished: {
                        loading.opacity=0;
                        // details.state="loaded";
                    }
                }
            }
        }

        Rectangle {
            id: loading
            width: 40; height: 40;
            radius: 4
            color: "#7d7b97"
            anchors.centerIn: parent
            Loading {
                anchors.centerIn: parent
                width: 32; height: 32; //visible: webView.progress != 1
            }
        }


        states: State {
            name: "loaded";
        }

        transitions: Transition { NumberAnimation { target: details; property: "opacity"; duration: 200 } }
    }


    Rectangle { id: menuArticle
        x: 0 // bg.width
        y: bg.height-44
        width: bg.width
        height: 44
        gradient: Gradient {
            GradientStop {
                position: 0
                color: "#313f4d" // "#7d7b97"
            }
            GradientStop {
                position: 0.15
                color: "#000000"
            }
            GradientStop {
                position: 1
                color: "#000000"
            }
        }
        anchors.margins: 6
        //anchors.horizontalCenter: bg.horizontalCenter

        Flow {
            // x: bg.width
            id: flowMenuArticle
            anchors.fill: parent
            anchors.margins: 6
            //flow: Flow.TopToBottom
            anchors.verticalCenter: parent.verticalCenter
            spacing: 24

            Image { source: "../icons/undo_32x32.png";
                MouseArea { anchors.fill: parent
                    onClicked: { fond.state = "" }
                }
            }

            Image { id: iconArticle
                source: "../icons/article_32x32.png";
                opacity: 0
                MouseArea { anchors.fill: parent
                    onClicked: {
                        loading.opacity=1;
                        iconArticleTalkpage.opacity=1;
                        iconArticle.opacity=0;
                        articleCurrent = articleName;
                        // webView.url="http://"+schModel.from+".m.wikipedia.org/wiki?search="+articleCurrent;
                    }
                }
            }
            Image { id: iconArticleTalkpage
                source: "../icons/chat_alt_stroke_32x32.png";
                MouseArea { anchors.fill: parent
                    onClicked: {
                        loading.opacity=1;
                        iconArticleTalkpage.opacity=0;
                        iconArticle.opacity=1;
                        articleCurrent = 'Talk:'+articleName;
                        //webView.reload();
                    }
                }
            }

            Image { source: "../icons/plus_32x32.png";
                MouseArea { anchors.fill: parent
                    onClicked: {
                        articleScale = articleScale + 1;
                        minusZoom.opacity = 1;
                        // webView.reload();
                    }
                }
            }
            Image { id: minusZoom
                opacity: 0
                anchors.verticalCenter: parent.verticalCenter
                source: "../icons/minus_32x8.png";
                MouseArea { anchors.fill: parent
                    onClicked: {
                        articleScale = articleScale - 1;
                        if(articleScale==0) { minusZoom.opacity=0; }
                        // webView.reload();
                    }
                }
            }
            move: Transition {
                NumberAnimation {
                    properties: "x,y"
                    //easing.type: Easing.OutBounce; easing.amplitude: 3.0; easing.period: 1.0; duration: 1000
                    easing.type: Easing.easeOutBounce
                }
            }
        }
    }



}
