import QtQuick 1.0
import QtWebKit 1.0
import "content" as Content


Rectangle {
    id: bg
    width: 420; height: 800
    // width: 800; height: 420
    color: "#7d7b97" // "#4C4C4B" //#B5BAB4"

    Rectangle {
        id: fond
        x: 0; y: 0
        width: parent.width; height: parent.height-menu.height
        color: "#7d7b97" // "#7d7b97" "#4C4C4B" //#B5BAB4"

        /*    Image {
        id: image1
        rotation: 0
        anchors.fill: parent
        source: "content/background.png"
    }
*/
        /*
    Timer {
        id: timer
        interval: 1000; repeat: true
        running: true
        triggeredOnStart: true
        onTriggered: {
            xmlModel.reload()
        }
    }
*/
        //    Content.RssModel { id: xmlModel }

        Rectangle { id: firstView
            x: 0
            width:  parent.width
            height: parent.height
            color: "#000000" // orange" // "#313f4d"

            Content.SearchModel { id: schModel }
            Content.Loading { anchors.centerIn: parent; visible: schModel.status==XmlListModel.Loading}

            Text {
                width: 180
                text: "Problem.";
                color: "#cccccc"; style: Text.Raised; styleColor: "black"; wrapMode: Text.WordWrap
                visible: schModel.status==XmlListModel.Error; anchors.centerIn: parent
            }

            Content.SearchDelegate { id: schDelegate }

            ListView {
                id: mainView; model: schModel.model; delegate: schDelegate;
                width: parent.width; height: parent.height; x: 0; cacheBuffer: 100;
            }
        }

        /*
        Content.RcDelegate { id: rcDelegate }

        ListView { id: lstRC
            anchors.fill: parent
            model: xmlModel
            delegate: rcDelegate
        }
    } /* */
        /*
        Rectangle { id: droite
            x: parent.width
            anchors.verticalCenter: parent.verticalCenter
            opacity: 1
            width: parent.width
            height: parent.height
            // color: "#f93838"
            color: "#DBC293"

            MouseArea {
                anchors.fill: parent
                onClicked: { fond.state = '' }
            }

            Text {
                id: text1
                width: 80
                height: 20
                text: "Panneau droit"
                anchors.leftMargin: 5
                anchors.topMargin: 5
                anchors.left: parent.left
                anchors.top: parent.top
                font.pixelSize: 12
            }
        } */

        Content.Config { id: gauche }
        Content.Article { id: article }
        Content.UserChoice { id: userchoice }

        states: [
            State {
                name: "Parametrage"
                PropertyChanges { target: article; x: 0; }
                PropertyChanges { target: firstView; x: -fond.width; }
                PropertyChanges { target: menu; x: -bg.width; }
                //PropertyChanges { target: menuArticle; x: 0; }
            },
            State {
                name: "Configuration"
                PropertyChanges {
                    target: gauche
                    y: bg.height-gauche.height-menu.height
                }
            },
            State {
                name: "UserChoice"
                PropertyChanges {
                    target: userchoice
                    y: fond.height-userchoice.height
                }
            }
        ]

        transitions: Transition {
            NumberAnimation { properties: "x,y"; easing.type: Easing.OutBounce; easing.amplitude: 3.0; easing.period: 1.0; duration: 1000 }
        }
    }

    Rectangle { id: menu
        x: 0
        y: bg.height-44
        width: bg.width
        height: 44
        gradient: Gradient {
            GradientStop {
                position: 0
                color: "#313f4d" // "#7d7b97"
            }
            GradientStop {
                position: 0.15
                color: "#000000"
            }
            GradientStop {
                position: 1
                color: "#000000"
            }
        }
        anchors.margins: 6
        //anchors.horizontalCenter: bg.horizontalCenter

        //opacity: 0.9

        Flow {
            id: mainMenu
            anchors.fill: parent
            anchors.margins: 6
            spacing: 24

            Image { source: "icons/magnifying_glass_alt_32x32.png";
                // width: 48
                // height: 48
                MouseArea { anchors.fill: parent
                    onClicked: { fond.state = "Configuration" }
                }
            }
            Image { source: "icons/x_alt_32x32.png";
                //width: 48
                //height: 48
                MouseArea { anchors.fill: parent
                    onClicked: { Qt.quit() }
                }
            }
        }
    }

}
