import QtQuick 1.0

Rectangle {
    y: bg.height
    anchors.horizontalCenter: parent.horizontalCenter
    opacity: 1
    width: parent.width
    height: parent.height
    color: "black"

    ListModel {
        id: userModel
        ListElement {
            name: "WatchList"
         //   bouton: "button-green.png"
         //   btmenu: "Configuration"
         //   action: ""
        }
        ListElement {
            name: "RecentChanges"
        //   bouton: "button-blue.png"
        //    btmenu: ""
        //    action: "load"
        }
        /*
        ListElement {
            name: "Bill Smyth"
            bouton: "button-purple.png"
            btmenu: "UserChoice"
            action: ""
        }
        ListElement {
            name: "Sam Wise"
            bouton: "button-red.png"
            btmenu: "Parametrage"
            action: ""
        }
        */
    }

    Component {
        id: userDelegate
        Item {
            width: grid.cellWidth; height: grid.cellHeight
            Column {
                anchors.fill: parent
                Rectangle {
                    x: 2
                    width:  parent.width-4
                    height:  parent.height-4
                    radius: 5
                    // anchors.fill: parent
                    // color: "blue"
                    gradient: Gradient {
                        GradientStop {
                            position: 0
                            color: "#7d7b97"
                        }

                        GradientStop {
                            position: 1
                            color: "#313f4d"
                        }
                    }
                    Text { text: name
                        color:  "white"
                        font.bold: true
                        anchors.horizontalCenter: parent.horizontalCenter
                        anchors.verticalCenter: parent.verticalCenter
                        MouseArea {
                            anchors.fill: parent
                            onClicked: {
                                fond.state = btmenu
                            }
                        }
                    }
                }
            }
        }
    }

    GridView {
        id: grid
        width: parent.width
        height: parent.height
        anchors.verticalCenter: parent.verticalCenter
        anchors.verticalCenterOffset: 8
        contentWidth: parent.width
        cellWidth: parent.width
        cellHeight: 60
        model: userModel
        delegate: userDelegate
        focus: true
    }
}
