import QtQuick 1.0

ShadowRectangle {
    y: parent.height
    anchors.horizontalCenter: parent.horizontalCenter
    opacity: 1
    width: parent.width
    height: bg.height // wrappersc.height
    color: "#7d7b97"

    Flow {
        id: wrappersc
        flow: Flow.TopToBottom
        anchors.horizontalCenter: parent.horizontalCenter
        anchors.verticalCenter: parent.verticalCenter
        spacing:  10
        anchors.bottomMargin: 5
        anchors.topMargin: 5
        Text {
            text: "Language:"
            font.bold: true; color: "white"; style: Text.Raised; styleColor: "black"
            horizontalAlignment: Qt.AlignRight
        }
        Input{
            id: fromIn
            KeyNavigation.backtab: searchbutton
            KeyNavigation.tab:phraseIn
            onAccepted:searchbutton.doSearch();
            focus: true
            text: schModel.from
        }
        Text {
            text: "Search:"
            font.bold: true; color: "white"; style: Text.Raised; styleColor: "black"
            horizontalAlignment: Qt.AlignRight
        }
        Input{
            id: phraseIn
            KeyNavigation.backtab: fromIn
            KeyNavigation.tab:searchbutton
            onAccepted:searchbutton.doSearch();
            text: schModel.phrase
        }

        Button {
            x: 2
            width: menu.width-4
            height: menu.height
            id: searchbutton
            keyUsing: true;
            opacity: 1
            text: "Go"
            KeyNavigation.tab: fromIn
            Keys.onReturnPressed: searchbutton.doSearch();
            Keys.onEnterPressed: searchbutton.doSearch();
            Keys.onSelectPressed: searchbutton.doSearch();
            Keys.onSpacePressed: searchbutton.doSearch();
            onClicked: searchbutton.doSearch();

            function doSearch() {
                // Search ! allowed
                if (wrappersc.state=="invalidinput")
                    return;
                schModel.from=fromIn.text;
                schModel.phrase = phraseIn.text;
                fond.focus = true;
                fond.state = ""
            }
        }
    }

    states:
        State {
        name: "invalidinput"
        when: fromIn.text=="" // && phraseIn.text==""
        PropertyChanges { target: searchbutton ; opacity: 0.6 ; }
    }

    transitions:
        Transition {
        NumberAnimation { target: searchbutton; property: "opacity"; duration: 200 }
    }
}

