import QtQuick 1.0

Item {
    id: wrapper
    property variant model: schModel
    property string from : "en"
    property string to : ""
    property string phrase : "A"

    property string mode : "everyone"
    property int status: schModel.status
    function reload() { schModel.reload(); }

    XmlListModel {
        id: schModel

        source: "http://"+from+".wikipedia.org/w/api.php?action=opensearch&search="+phrase+"&limit=100&format=xml"
        namespaceDeclarations: "declare default element namespace 'http://opensearch.org/searchsuggest2'; ";
        query: "/SearchSuggestion/Section/Item"

        XmlRole { name: "name"; query: "Text/string()" }
        XmlRole { name: "statusText"; query: "Description/string()" }
        XmlRole { name: "source"; query: "Url/string()" }
        XmlRole { name: "userImage"; query: "Image/@source/string()" }
    }
}
