import QtQuick 1.0
import QtWebKit 1.0


Component { id: rcDelegate
    Item {
        id: delegateItem
        property real detailsOpacity : 0
        property real minSize : 18
        width: parent.width;
        height: 120
        Rectangle {
            id: background
            x: 2; y: 2; width: parent.width - x*2; height: parent.height - y*2
            // color: "#c0c0c0"
            //            border.color: "#606060"
            radius: 3
            //opacity: delegateItem.detailsOpacity
            gradient: Gradient {
                GradientStop {
                    position: 0
                    color: "#7d7b97"
                }

                GradientStop {
                    position: 1
                    color: "#313f4d"
                }
            }
        }
        MouseArea {
            anchors.fill: parent
            onClicked: {
                delegateItem.state = 'Details';
                timer.stop();
                loader.sourceComponent = webViewPage;
            }
        }

        Row {
            id: topLayout
            //anchors.verticalCenter: parent.verticalCenter
            spacing: 5
            width: parent.width-10
            height:  parent.height-4
            x: 5
            Column {
                ///anchors.verticalCenter: parent.verticalCenter
                ///anchors.margins: 5
                width: parent.width
                height:  parent.height
                //width: 2*parent.width/3
                Text {
                    anchors.margins: 5
                    id: innerTxt
                    width: delegateItem.width;
                    text: title
                    color: "white"
                    font.pixelSize: delegateItem.minSize+2
                    font.bold: true
                    wrapMode: Text.WrapAtWordBoundaryOrAnywhere
                    // opacity: delegateItem.detailsOpacity
                }
                Row {
                    spacing: 5
                    Column {
                        Text { text: comment
                            width: delegateItem.width;
                            color: "White"
                            font.pixelSize: delegateItem.minSize
                            wrapMode: Text.WrapAtWordBoundaryOrAnywhere
                            // opacity: delegateItem.detailsOpacity
                        }
                    }
                }
                Row {
                    spacing: 5
                    width: parent.width
                    ///anchors.bottom: parent.bottom
                    Column {
                        width: parent.width/2-2
                        Text {
                            text: user
                            color: "white"
                            //font.bold: true
                            font.pixelSize: delegateItem.minSize
                            anchors.left: parent.left
                        }
                    }
                    Column {
                        width: parent.width/2-2
                        Text { text: timestamp
                            color: "White"
                            font.pixelSize: delegateItem.minSize
                            anchors.right: parent.right
                            //opacity: delegateItem.detailsOpacity
                        }
                    }
                }
            }
        }

        Item {
            id: details
            x: 0; width: parent.width //- 20
            anchors { top: topLayout.top; topMargin: 0; bottom: parent.bottom; bottomMargin: 0 }
            // anchors.margins: 10
            opacity: delegateItem.detailsOpacity
            //opacity: webView.progress == 1.0 ? 0.0 : 1.0


            Grid {
                columns: 1 //3
                id: pages
                height: parent.height; width: parent.width

                Component {
                    id: webViewPage
                    //Content.ParseModel { id: parseModel }

                    Rectangle {
                        //width: webView.width
                        //height: webView.height
                        //border.color: "gray"
                        //color: "red"
                        /*
                        Content.ParseModel { id: parseModel }
                        WebView {
                            id: webView
                            width: details.width
                            height: details.height-60
                            newWindowComponent: webViewPage
                            newWindowParent: pages
                            //url: "http://en.wikipedia.org/w/index.php?title=" + innerTxt.text
                            //url: "http://fr.wikipedia.org/w/api.php?action=parse&page="+innerTxt.text
                                             +"&format=xml"

                            function getArticle(title) {
                                parseModel.reload();

                                var article = parseModel.get(0).article;
                                console.debug("=>>>>innerText"+title);
                                return article;
                            }
                            html: getArticle(innerTxt.text)
                        }  */
                        ParseModel { id: parseModel }

                        ListView {
                            id: lstTest
                            anchors.fill: parent
                            model: parseModel

                            delegate:
                                //Text { text: article }
                                Rectangle {
                                color: "green"
                                width: details.width
                                height: details.height
/*
                                Flickable {
                                             id: flickable
                                             width: parent.width
                                             height:  parent.height
                                             contentWidth: Math.max(flickable.width,webView.width)
                                             contentHeight: Math.max(flickable.height,webView.height)
                                             pressDelay: 100
*/
                                WebView {
                                    id: webView

                                    transformOrigin: Item.TopLeft

                            //        smooth: false // We don't want smooth scaling, since we only scale during (fast) transitions
                             //       focus: true


                                    width: parent.width
                                    height: parent.height
                                    newWindowComponent: webViewPage
                                    newWindowParent: pages
                                    //color:"white"
                                    html: "<div style=\"background-color:white\">"+article+"</div>" }
                            }
                        }
                       // }
                    }
                }
                /*              Flickable {
                    id: flickable
                    width: parent.width
                    height:  parent.height
                    contentWidth: Math.max(flickable.width,webView.width)
                    contentHeight: Math.max(flickable.height,webView.height)
                    pressDelay: 100 */

                Loader {
                    id: loader
                }
                // }

                // Loader { sourceComponent: webViewPage }
            }
        }

        // A button to close the detailed view, i.e. set the state back to default ('').
        TextButton {
            //y: 10
            anchors { right: background.right; bottom: background.bottom ;rightMargin: 10 }
            opacity: delegateItem.detailsOpacity
            text: "Close"

            onClicked: {
                delegateItem.state = '';
                timer.start();
            }
        }

        // Animate adding and removing of items:

        ListView.onAdd: SequentialAnimation {
            PropertyAction { target: delegateItem; property: "height"; value: 0 }
            NumberAnimation { target: delegateItem; property: "height"; to: 120; duration: 250; easing.type: Easing.InOutQuad }
        }

        ListView.onRemove: SequentialAnimation {
            PropertyAction { target: delegateItem; property: "ListView.delayRemove"; value: true }
            NumberAnimation { target: delegateItem; property: "height"; to: 0; duration: 250; easing.type: Easing.InOutQuad }

            // Make sure delayRemove is set back to false so that the item can be destroyed
            PropertyAction { target: delegateItem; property: "ListView.delayRemove"; value: false }
        }

        states: State {
            name: "Details"

            PropertyChanges { target: background; color: "#c0c0c0" }
            //PropertyChanges { target: recipeImage; width: 130; height: 130 } // Make picture bigger
            PropertyChanges { target: delegateItem; detailsOpacity: 1; x: 0 } // Make details visible
            PropertyChanges { target: delegateItem; height: lstRC.height } // Fill the entire list area with the detailed view

            // Move the list so that this item is at the top.
            PropertyChanges { target: delegateItem.ListView.view; explicit: true; contentY: delegateItem.y }

            // Disallow flicking while we're in detailed view
            PropertyChanges { target: delegateItem.ListView.view; interactive: false }
        }

        transitions: Transition {
            // Make the state changes smooth
            ParallelAnimation {
                ColorAnimation { property: "color"; duration: 500 }
                NumberAnimation { duration: 300; properties: "detailsOpacity,x,contentY,height,width" }
            }
        }

    }
}
