import QtQuick 1.0
import QtWebKit 1.0

Rectangle {
    property string articleName : ""
    property string articleCurrent : ""
    x: parent.width
    anchors.verticalCenter: parent.verticalCenter
    opacity: 1
    width: parent.width
    height: parent.height
    //color: "#7d7b97"
    gradient: Gradient {
        GradientStop {
            position: 0
            color: "#7d7b97"
        }

        GradientStop {
            position: 1
            color: "#313f4d"
        }
    }
    /*

    Loader {
        id: loader
        sourceComponent : triche;
    } */

    Item {
        id: details
        x: 0; width: parent.width // - 20
        anchors { top: parent.top; topMargin: 0; bottom: parent.bottom; bottomMargin: 0 }

        ParseModel { id: parseModel }

        Repeater {
            id: triche
            model: parseModel
            Flickable {
                id: flickable
                width: fond.width
                height:  fond.height
                contentWidth: Math.max(flickable.width,webView.width)
                contentHeight: Math.max(flickable.height,webView.height)
                pressDelay: 100

                WebView {
                    id: webView
                    transformOrigin: Item.TopLeft
                    smooth: false
                    width: fond.width
                    preferredHeight: fond.height
                    contentsScale: 1
                    //url: "http://"+schModel.from+".m.wikipedia.org/wiki?search="+articleName
                    html: "<div style=\"background-color:white\">"+article+"</div>"
                    /*
                    onLoadStarted: {
                        loading.opacity=1;
                    } */
                    onLoadFailed: { console.debug="==========================>PB"  }
                    onLoadFinished: {
                        loading.opacity=0;
                        // details.state="loaded";
                    }
                }
            }
        }

        Rectangle {
            id: loading
            width: 40; height: 40;
            radius: 4
            color: "#7d7b97"
            anchors.centerIn: parent
        Loading {
            anchors.centerIn: parent
            width: 32; height: 32; //visible: webView.progress != 1
        }
        }


        states: State {
            name: "loaded";
        }

        transitions: Transition { NumberAnimation { target: details; property: "opacity"; duration: 200 } }
    }

    ShadowRectangle { id: menuArticle
        x: fond.width-60
        y: 24
        width: 60
        height: 52 * 4
        color: "#7d7b97"
        anchors.margins: 6
        //anchors.horizontalCenter: bg.horizontalCenter
        opacity: 0.66

        Flow {
            x: 0
            id: flowMenuArticle
            // width: parent.width
            // height: parent.height
            anchors.fill: parent
            anchors.margins: 6
            flow: Flow.TopToBottom
            spacing: 24

            Image { source: "../icons/179-notepad.png";
                //anchors.centerIn: parent
                opacity: 1
                width: 48
                height: 48
                MouseArea { anchors.fill: parent
                    onClicked: {
                        loading.opacity=1;
                        articleCurrent = articleName;
                        // webView.url="http://"+schModel.from+".m.wikipedia.org/wiki?search="+articleCurrent;
                    }
                }
            }

            Image { source: "../icons/08-chat.png";
                //                 anchors.centerIn: parent
                width: 48
                height: 48
                MouseArea { anchors.fill: parent
                    onClicked: {
                        loading.opacity=1;
                        articleCurrent = 'Talk:'+articleName;
                        webView.reload();
                    }
                }
            }
/*
            Rectangle{
                color:  "#7d7b97"
                opacity: 0.66
                width: 54
                height: 54
            }
*/
            Image { source: "../icons/113-navigation.png";
                //         anchors.centerIn: parent
                width: 48
                height: 48
                MouseArea { anchors.fill: parent
                    onClicked: { fond.state = "" }
                }
            }
        }

    }

/*
    Image { source: "../icons/113-navigation.png";
        //         anchors.centerIn: parent
        x:parent.width-60
            y:parent.height
        width: 48
        height: 48
        MouseArea { anchors.fill: parent
            onClicked: { fond.state = "" }
        }
    }
*/

}
