/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "Settings.h"
#include "Windows/ModeWindow.h"
#include "Windows/RestoreCrashBackupWindow.h"

#include "ui_dialog.h"

#include <QDebug>
#include <QtGui>
#include <QtGui/QApplication>
#include <QHash>

#include <glib-2.0/glib.h>
void g_log_default_handler (const gchar *log_domain, GLogLevelFlags log_level, const gchar *message, gpointer)
{
	qDebug() << "GLIB: <D>" << log_domain << "<L>" << log_level << "<M>" << message << "\n";
}

int main(int argc, char *argv[])
{
	g_log_set_default_handler(g_log_default_handler, NULL);

	QApplication app(argc, argv);

	Settings settings;

	if (app.arguments().count() > 1 || app.arguments().first() != app.applicationFilePath())
	{
		settings.setAppMode(Settings::APPMODE_CONSOLE);

//		QHash<QString, QString> argHash;
//		for(int i = 0; i < argc; ++i)
//		{
//			std::string val(argv[i]);
//			QString val2 = QString(val.substr(val.find_first_not_of(" -")).c_str()).trimmed();
//			argHash.insert(val2, val2);
//		}
	}
	else
		settings.setAppMode(Settings::APPMODE_GUI);

	Windows::RestoreCrashBackupWindow* window = new Windows::RestoreCrashBackupWindow(settings);
	window->show();


	//Ui_Dialog * ud = new Ui_Dialog();
	//QDialog * d = new QDialog();
	//ud->setupUi(d);
	//d->show();

	return app.exec();
}
