/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "EventWriters/VMGWriter.h"

#include "EventTypes/iVMGEvent.h"
#include "EventTypes/iEvent.h"
#include "Settings.h"

#include <QDateTime>
#include <QDir>
#include <QFile>
#include <QTextStream>

#include <typeinfo>
#include <utime.h>

using namespace EventWriters;

VMGWriter::VMGWriter(const Settings &settings, const NumberToNameLookup &numberToNameLookup)
	: m_Settings(settings), m_NumberToNameLookup(numberToNameLookup)
{
}

void VMGWriter::Write(EventTypes::iEvent &event)
{
	EventTypes::iVMGEvent *vmgEvent(dynamic_cast<EventTypes::iVMGEvent *>(&event));
	if(vmgEvent)
	{
		// Build the path and ensure it exists...
		QString eventFilename(CurrentSettings().Directory());
		eventFilename += vmgEvent->PathForVMG();
		QDir().mkpath(eventFilename);

		// ...then build the filename and open it.
		eventFilename += QString::number(event.Timestamp().toUTC().toTime_t()) + ".vmg";
		QFile data(eventFilename);
		if (data.open(QFile::WriteOnly | QFile::Truncate))
		{
			QTextStream stream(&data);

			//QTextCodec *oldCodec = stream.codec();
			stream.setAutoDetectUnicode(false);
			stream.setCodec("UTF-16LE");

			vmgEvent->WriteVMG(stream, NameLookup());

			data.close();
		}

		utimbuf fileTimes;
		fileTimes.modtime = event.Timestamp().toUTC().toTime_t();
		utime(eventFilename.toAscii(), &fileTimes);
	}
}
