/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef EVENTTYPES_ICSVSYMBIANEVENT_H
#define EVENTTYPES_ICSVSYMBIANEVENT_H

class NumberToNameLookup;

class QChar;
template <typename T1, typename T2> class QHash;
class QString;
class QTextStream;
template <typename T1> class QVector;

namespace EventTypes
{
	class iCSVSymbianEvent
	{
	public:
		typedef QVector<QString> ColumnIndicesByIndexHash;
		typedef QHash<QString, unsigned int> SymbianEventLogStrings;
		virtual void WriteCSVSymbian(QTextStream &stream, const ColumnIndicesByIndexHash &headerIndices, const QChar delimiter, const NumberToNameLookup &numberToNameLookup, SymbianEventLogStrings &strings) const =0;
	};
}

#endif // EVENTTYPES_ICSVSYMBIANEVENT_H
