/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef EVENTTYPES_SMS_H
#define EVENTTYPES_SMS_H

#include <QDateTime>
#include <QDebug>
#include <QList>
#include <QString>

#include "RtcomEvent.h"
#include "EventTypes/iCSVSymbianEvent.h"
#include "EventTypes/iVMGEvent.h"

#include "AttachmentCollection.h"

class Settings;

namespace EventTypes
{
	class SMS : public RtcomEvent, public EventTypes::iVMGEvent, public EventTypes::iCSVSymbianEvent
	{
	public:
		enum eDestination
		{
			INBOX,
			SENT
		};

	public:
		virtual const DBBackends::iDBBackend &DB() const;

		SMS(const Settings &settings);
		~SMS();

		virtual const uint HashCode() const;

		const float Version() const { return m_Version; }
		void Version(const float version) { m_Version = version; }

		const bool IsRead() const { return m_Read; }
		void IsRead(const bool isRead) { m_Read = isRead; }

		const eDestination Destination() const { return m_Destination; }
		void Destination(const eDestination destination) { m_Destination = destination; }

		virtual const QDateTime Timestamp() const { return m_Timestamp; }
		void Timestamp(const QDateTime timestamp) { m_Timestamp = timestamp; }

		const QString Tel() const { return m_Tel; }
		void Tel(const QString tel) { m_Tel = tel; }

		QString Contents() const { return m_Contents; }
		void Contents(const QString contents) { m_Contents = contents; }

		bool Pending() const { return m_Pending; }
		void Pending(const bool pending) { m_Pending = pending; }

		virtual const AttachmentCollection & Attachments() const { return m_Attachments; }
		virtual AttachmentCollection & Attachments() { return m_Attachments; }

	public:
		SMS(const Settings &settings, const RTComElEvent& event, const QList<RTComElAttachment*> attachments = QList<RTComElAttachment*>());
		virtual RTComElEvent * toRTComEvent(const NumberToNameLookup &numberToNameLookup) const;

	public:
		virtual void WriteCSVSymbian(QTextStream &stream, const ColumnIndicesByIndexHash &headerIndices, const QChar delimiter, const NumberToNameLookup &numberToNameLookup, SymbianEventLogStrings &strings) const;
		virtual const QString PathForVMG() const;
		virtual void WriteVMG(QTextStream &stream, const NumberToNameLookup &numberToNameLookup) const;

	protected:
		const Settings &CurrentSettings() const { return m_Settings; }

	private:
		const Settings &m_Settings;
		float m_Version;
		bool m_Read;
		eDestination m_Destination;
		QDateTime m_Timestamp;
		QString m_Tel;
		QString m_Contents;
		AttachmentCollection m_Attachments;
		bool m_Pending;
	};
}

QDebug operator<<(QDebug dbg, EventTypes::SMS & event);

#endif // EVENTTYPES_SMS_H
