/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "RtcomEvent.h"

#include <QDebug>

#include <QHash>
#include <QString>

#include <rtcom-eventlogger/event.h>
#include <rtcom-eventlogger/eventlogger.h>

#include <stdexcept>

using namespace EventTypes;

RtcomEvent::RtcomEvent()
{
}

void RtcomEvent::freeRTComContents(RTComElEvent &event)
{
	rtcom_el_event_free_contents(&event);
}

const unsigned int RtcomEvent::GetFlagValue(const QString &value) const
{
	static QHash<QString, uint> valueLookups;

	if(!valueLookups.contains(value))
	{
		RTComEl *el(rtcom_el_new());
		if(NULL != el)
		{
			gint flagValue;
			if(-1 != (flagValue = rtcom_el_get_flag_value(el, value.toUtf8())))
				valueLookups.insert(value, flagValue);

			g_object_unref(el);

			if(-1 == flagValue)
			{
				throw std::runtime_error(
					QString("Unable to find flag value '%1'' in rtcom database")
						.arg(value).toStdString());
			}
		}
		else
			qDebug() << "Failed to create event logger.";
	}

	return valueLookups.value(value);
}

