/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef EVENTPROCESSORS_WRITER_H
#define EVENTPROCESSORS_WRITER_H

#include "iEventProcessor.h"

#include "EventWriters/iEventWriter.h"
class NumberToNameLookup;
class Settings;

#include <QObject>
template <typename T1> class QList;
#include <QSharedPointer>

namespace EventProcessors
{
	class Writer : public QObject, public iEventProcessor
	{
		Q_OBJECT

	public:
		Writer(Settings &settings, const NumberToNameLookup &numberToNamelookup);
		~Writer();

		const Settings & CurrentSettings() { return m_Settings; }

		virtual void Process(EventTypes::iEvent &event);
		virtual void EmitEventProcessed(int eventsProcessed, int totalEvents);

	private:
		const Settings & m_Settings;
		QList<QSharedPointer<EventWriters::iEventWriter> > m_Writers;

	signals:
		void EventProcessed(int current, int total);
	};
}

#endif // EVENTPROCESSORS_WRITER_H
