/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "Writer.h"

#include "EventTypes/iEvent.h"
#include "EventWriters/iEventWriter.h"
#include "EventWriters/CSVSymbianEventLogWriter.h"
#include "EventWriters/VMGWriter.h"
#include "Settings.h"

#include <QDebug>

#include <QList>
#include <QSharedPointer>

using namespace EventProcessors;

Writer::Writer(Settings &settings, const NumberToNameLookup &numberToNamelookup)
	: m_Settings(settings)
{
	m_Writers.append(QSharedPointer<EventWriters::iEventWriter>(new EventWriters::CSVSymbianEventLogWriter(CurrentSettings(), numberToNamelookup)));
	m_Writers.append(QSharedPointer<EventWriters::iEventWriter>(new EventWriters::VMGWriter(CurrentSettings(), numberToNamelookup)));
}

Writer::~Writer()
{
}

void Writer::Process(EventTypes::iEvent &event)
{
	foreach (QSharedPointer<EventWriters::iEventWriter> writer, m_Writers)
		writer->Write(event);
}

void Writer::EmitEventProcessed(int eventsProcessed, int totalEvents)
{
	emit EventProcessed(eventsProcessed, totalEvents);
}
