/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef EVENTPROCESSORS_HASHER_H
#define EVENTPROCESSORS_HASHER_H

#include "iEventProcessor.h"
#include "iHashable.h"

#include <QObject>
#include <QSet>

namespace EventProcessors
{
	class Hasher : public QObject, public iEventProcessor
	{
		Q_OBJECT

	public:
		QSet<iHashable::Hash> m_Hashes;

		virtual void Process(EventTypes::iEvent &event);
		virtual void EmitEventProcessed(int eventsProcessed, int totalEvents);

	signals:
		void EventProcessed(int current, int total);
	};
}

#endif // EVENTPROCESSORS_HASHER_H
