/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef EVENTPARSERS_VMGEntities_IWRITER_H
#define EVENTPARSERS_VMGEntities_IWRITER_H

namespace EventTypes { class SMS; }
class NumberToNameLookup;

class QTextStream;

namespace EventParsers
{
	namespace VMGEntities
	{
		class iWriter
		{
		public:
			virtual ~iWriter() {};
			virtual void Write(QTextStream& stream, const EventTypes::SMS& event, const NumberToNameLookup &numberToNameLookup) = 0;
		};
	}
}

#endif // EVENTPARSERS_VMGEntities_IWRITER_H
