/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef EVENTPARSERS_VMGEntities_VMESSAGEWRITER_H
#define EVENTPARSERS_VMGEntities_VMESSAGEWRITER_H

#include "SMSEntity.h"
#include "iReader.h"
#include "iWriter.h"

class Settings;

class QString;
class QTextStream;

namespace EventTypes { class SMS; }

namespace EventParsers
{
	namespace VMGEntities
	{
		class VCard;
		class VEnvelope;

		class VMessage : public SMSEntity, public iWriter, public iReader
		{
		public:
			VMessage(const Settings &settings, const SMSEntity* parent);
			//VMessage(QTextStream& stream);
			VMessage(const Settings &settings, const SMSEntity* parent, float version);
			~VMessage();

			virtual bool Read(const QString & initialLine, QTextStream& stream, EventTypes::SMS & event);
			virtual void Write(QTextStream & stream, const EventTypes::SMS & event, const NumberToNameLookup &numberToNameLookup);

		protected:
			virtual const char * getTagName() const { return "VMSG"; }

		private:
			float m_Version;
		};
	}
}

#endif // EVENTPARSERS_VMGEntities_VMESSAGEWRITER_H
