/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "VEnvelope.h"

#include "Factory.h"
#include "VBody.h"

#include <QTextStream>

#include <QDebug>

using namespace EventParsers::VMGEntities;

VEnvelope::VEnvelope(const Settings &settings, const SMSEntity* parent) :
	SMSEntity(settings, parent)
{
}

//VEnvelope::VEnvelope(QTextStream& stream)
//{
//}

VEnvelope::~VEnvelope()
{
	foreach(iWriter *contentWriter, m_ContentWriters)
		delete contentWriter;

	m_ContentWriters.empty();
}

void VEnvelope::Write(QTextStream &stream, const EventTypes::SMS &event, const NumberToNameLookup &numberToNameLookup)
{
	stream << "BEGIN:" << getTagName() << "\n";

	foreach(iWriter *contentWriter, m_ContentWriters)
		contentWriter->Write(stream, event, numberToNameLookup);

	stream << "END:" << getTagName() << "\n";
}

bool VEnvelope::Read(const QString &initialLine, QTextStream &stream, EventTypes::SMS &event)
{
	bool hasEnded(false);

	// Stream may or may not have a 'BEGIN' present. Swallow it if it's ours.
	QString lineData(initialLine.length() > 0 ? initialLine : stream.readLine());
	if(lineData.startsWith("BEGIN:"))
	{
		if(lineData != QString("BEGIN:") + getTagName())
		{
			qDebug() << "Invalid stream";
			return false;
		}
		else // ...discard this line
			lineData = stream.readLine();
	}

	do
	{
		if(lineData.startsWith("BEGIN:"))
		{
			iReader* reader = Factory::Instantiate(CurrentSettings(), lineData, this);
			bool valid(NULL != reader && reader->Read(lineData, stream, event));
			delete reader;

			// Quit processing if the nested content is not valid
			if(!valid)
				return valid;
		}
		else if(lineData.startsWith("END:"))
		{
			if(lineData != QString("END:") + getTagName())
			{
				qDebug() << getTagName() << " parser mismatch error" << lineData;
				return false;
			}
			else
			{
				hasEnded = true;
				break;
			}
		}

		lineData = stream.readLine();
	}while(!hasEnded && !stream.atEnd());

	if(hasEnded)
	{
		//event.fld_is_read = isRead;
		//event.fld_outgoing = isOutgoing;
		//event.fld_start_time = timestamp.toUTC().toTime_t();
	}

	return true;
}
