/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef EVENTPARSERS_MMSPARSER_H
#define EVENTPARSERS_MMSPARSER_H

#include "iEventParser.h"

class QFile;
class QString;

namespace EventParsers
{
	class MMSParser : public iEventParser
	{
	public:
		static iEventParser *IsValid(QFile &eventFile);

		MMSParser(const QString &filename);

		virtual EventTypes::EventFromFileList ParseFile(QFile &eventFile, const QList<uint> &recordsToReturn);
	};
}

#endif // EVENTPARSERS_MMSPARSER_H
