/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef DBBACKENDS_IDBBACKEND_H
#define DBBACKENDS_IDBBACKEND_H

namespace EventProcessors { class iEventProcessor; }
namespace EventTypes { class RtcomEvent; class iEvent; }
class NumberToNameLookup;

template <typename T1> class QList;

namespace DBBackends
{
	class iDBBackend
	{
	public:
		virtual ~iDBBackend() {}

		virtual void PreInsert() =0;
		virtual void Insert(EventTypes::iEvent &event, const NumberToNameLookup &numberToNameLookup) =0;
		virtual void PostInsert() =0;

		virtual void ClearInsertedIDs() =0;
		//virtual uint Remove();

		virtual void Process(EventProcessors::iEventProcessor &eventProcessor) =0;

	protected:
		virtual const QList<unsigned int> &InsertedIDs() const =0;

	};
}

#endif // DBBACKENDS_IDBBACKEND_H
