/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef DBBACKENDS_ALLBACKENDS_H
#define DBBACKENDS_ALLBACKENDS_H

namespace EventProcessors { class iEventProcessor; }
namespace EventTypes { class iEvent; }

class NumberToNameLookup;
class Settings;
#include <QList>
template <typename T1> class QSharedPointer;

#include "iDBBackend.h"

namespace DBBackends
{
	class AllBackends
	{
	public:
		AllBackends(const Settings &settings);

		void Process(EventProcessors::iEventProcessor &eventProcessor);
		void PreInsert();
		void Insert(EventTypes::iEvent &event, const NumberToNameLookup &numberToNameLookup);
		void PostInsert();

	public:
		const Settings &CurrentSettings() const { return m_Settings; }
		const QList<QSharedPointer<iDBBackend> > &Backends() const { return m_Backends; }

	private:
		const Settings &m_Settings;
		const QList<QSharedPointer<iDBBackend> > m_Backends;
	};
}

#endif // DBBACKENDS_ALLBACKENDS_H
