/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef SYNCERTHREAD_H
#define SYNCERTHREAD_H

#include "EventTypes/EventFromFileList.h"

class Settings;

#include <QThread>
#include <QWaitCondition>
#include <QMutex>

class NumberToNameLookup;

class SyncerThread : public QThread
{
	Q_OBJECT

private:
	QMutex m_Mutex;
	QWaitCondition m_Condition;
	bool m_Restart;
	bool m_Abort;

	Settings& m_Settings;

protected:
	virtual void run();

signals:
	void EventProcessed(int current, int total);

public:
	explicit SyncerThread(Settings& settings);
	~SyncerThread();

	void Sync();
	EventTypes::EventFromFileList ProcessFile(const QString &path, const QList<uint> &recordsToReturn = QList<uint>()) const;
	uint InsertNewEvent(const EventTypes::iEvent &event, const NumberToNameLookup &numberToNameLookup);

	Settings &CurrentSettings() const { return m_Settings; }
};

#endif // SYNCERTHREAD_H
