/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "Settings.h"

Settings::Settings()
{
	// Default to console
	setAppMode(APPMODE_CONSOLE);

	// Not confirmed by default
	setConfirmed(false);

	// Default to export mode so we can't overwrite any device data
	setMode(MODE_EXPORT);

	// We don't process anything by default
	setShouldProcess(TYPE_SENT, EVENTTYPE_SMS, false);
	setShouldProcess(TYPE_SENT, EVENTTYPE_MMS, false);
	setShouldProcess(TYPE_SENT, EVENTTYPE_CHAT, false);

	// We still don't process anything by default
	setShouldProcess(TYPE_RECIEVED, EVENTTYPE_SMS, false);
	setShouldProcess(TYPE_RECIEVED, EVENTTYPE_MMS, false);
	setShouldProcess(TYPE_RECIEVED, EVENTTYPE_CHAT, false);

	// Default to the UK :)
	setCountryCode(44);

	// It's OK to disable the radio by default
	setDisableCellular(true);
}
