/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef EVENTPARSERS_VMGEntities_VBODYWRITER_H
#define EVENTPARSERS_VMGEntities_VBODYWRITER_H

#include <QMap>

#include "SMSEntity.h"
#include "iReader.h"
#include "iWriter.h"

class QString;

namespace EventTypes { class SMS; }

namespace EventParsers
{
	namespace VMGEntities
	{
		class VBody : public SMSEntity, public iWriter, public iReader
		{
		public:
			VBody(const SMSEntity *parent);
			//VBody(QTextStream& stream);
			~VBody();

			virtual bool Read(const QString &initialLine, QTextStream &stream, EventTypes::SMS &event);
			virtual void Write(QTextStream &stream, const EventTypes::SMS &event);

		protected:
			virtual const char *getTagName() const { return "VBODY"; }

		private:
			static const QMap<int, const char *> & BinaryMIMETypes()
			{
				static QMap<int, const char *> s_BinaryMIMETypes;
				if(s_BinaryMIMETypes.count() == 0)
				{
					s_BinaryMIMETypes.insert(0x00, "*/*");
					s_BinaryMIMETypes.insert(0x01, "text/*");
					s_BinaryMIMETypes.insert(0x02, "text/html");
					s_BinaryMIMETypes.insert(0x03, "text/plain");
					s_BinaryMIMETypes.insert(0x04, "text/x-hdml");
					s_BinaryMIMETypes.insert(0x05, "text/x-ttml");
					s_BinaryMIMETypes.insert(0x06, "text/x-vCalendar");
					s_BinaryMIMETypes.insert(0x07, "text/x-vCard");
					s_BinaryMIMETypes.insert(0x08, "text/vnd.wap.wml");
					s_BinaryMIMETypes.insert(0x09, "text/vnd.wap.wmlscript");
					s_BinaryMIMETypes.insert(0x0A, "text/vnd.wap.wta-event");
					s_BinaryMIMETypes.insert(0x0B, "multipart/*");
					s_BinaryMIMETypes.insert(0x0C, "multipart/mixed");
					s_BinaryMIMETypes.insert(0x0D, "multipart/form-data");
					s_BinaryMIMETypes.insert(0x0E, "multipart/byterantes");
					s_BinaryMIMETypes.insert(0x0F, "multipart/alternative");
					s_BinaryMIMETypes.insert(0x10, "application/*");
					s_BinaryMIMETypes.insert(0x11, "application/java-vm");
					s_BinaryMIMETypes.insert(0x12, "application/x-www-form-urlencoded");
					s_BinaryMIMETypes.insert(0x13, "application/x-hdmlc");
					s_BinaryMIMETypes.insert(0x14, "application/vnd.wap.wmlc");
					s_BinaryMIMETypes.insert(0x15, "application/vnd.wap.wmlscriptc");
					s_BinaryMIMETypes.insert(0x16, "application/vnd.wap.wta-eventc");
					s_BinaryMIMETypes.insert(0x17, "application/vnd.wap.uaprof");
					s_BinaryMIMETypes.insert(0x18, "application/vnd.wap.wtls-ca-certificate");
					s_BinaryMIMETypes.insert(0x19, "application/vnd.wap.wtls-user-certificate");
					s_BinaryMIMETypes.insert(0x1A, "application/x-x509-ca-cert");
					s_BinaryMIMETypes.insert(0x1B, "application/x-x509-user-cert");
					s_BinaryMIMETypes.insert(0x1C, "image/*");
					s_BinaryMIMETypes.insert(0x1D, "image/gif");
					s_BinaryMIMETypes.insert(0x1E, "image/jpeg");
					s_BinaryMIMETypes.insert(0x1F, "image/tiff");
					s_BinaryMIMETypes.insert(0x20, "image/png");
					s_BinaryMIMETypes.insert(0x21, "image/vnd.wap.wbmp");
					s_BinaryMIMETypes.insert(0x22, "application/vnd.wap.multipart.*");
					s_BinaryMIMETypes.insert(0x23, "application/vnd.wap.multipart.mixed");
					s_BinaryMIMETypes.insert(0x24, "application/vnd.wap.multipart.form-data");
					s_BinaryMIMETypes.insert(0x25, "application/vnd.wap.multipart.byteranges");
					s_BinaryMIMETypes.insert(0x26, "application/vnd.wap.multipart.alternative");
					s_BinaryMIMETypes.insert(0x27, "application/xml");
					s_BinaryMIMETypes.insert(0x28, "text/xml");
					s_BinaryMIMETypes.insert(0x29, "application/vnd.wap.wbxml");
					s_BinaryMIMETypes.insert(0x2A, "application/x-x968-cross-cert");
					s_BinaryMIMETypes.insert(0x2B, "application/x-x968-ca-cert");
					s_BinaryMIMETypes.insert(0x2C, "application/x-x968-user-cert");
					s_BinaryMIMETypes.insert(0x2D, "text/vnd.wap.si");
					s_BinaryMIMETypes.insert(0x2E, "application/vnd.wap.sic");
					s_BinaryMIMETypes.insert(0x2F, "text/vnd.wap.sl");
					s_BinaryMIMETypes.insert(0x30, "application/vnd.wap.slc");
					s_BinaryMIMETypes.insert(0x31, "text/vnd.wap.co");
					s_BinaryMIMETypes.insert(0x32, "application/vnd.wap.coc");
					s_BinaryMIMETypes.insert(0x33, "application/vnd.wap.multipart.related");
					s_BinaryMIMETypes.insert(0x34, "application/vnd.wap.sia");
					s_BinaryMIMETypes.insert(0x35, "text/vnd.wap.connectivity-xml");
					s_BinaryMIMETypes.insert(0x36, "application/vnd.wap.connectivity-wbxml");
					s_BinaryMIMETypes.insert(0x37, "application/pkcs7-mime");
					s_BinaryMIMETypes.insert(0x38, "application/vnd.wap.hashed-certificate");
					s_BinaryMIMETypes.insert(0x39, "application/vnd.wap.signed-certificate");
					s_BinaryMIMETypes.insert(0x3A, "application/vnd.wap.cert-response");
					s_BinaryMIMETypes.insert(0x3B, "application/xhtml+xml");
					s_BinaryMIMETypes.insert(0x3C, "application/wml+xml");
					s_BinaryMIMETypes.insert(0x3D, "text/css");
					s_BinaryMIMETypes.insert(0x3E, "application/vnd.wap.mms-message");
					s_BinaryMIMETypes.insert(0x3F, "application/vnd.wap.rollover-certificate");
					s_BinaryMIMETypes.insert(0x40, "application/vnd.wap.locc+wbxml");
					s_BinaryMIMETypes.insert(0x41, "application/vnd.wap.loc+xml");
					s_BinaryMIMETypes.insert(0x42, "application/vnd.syncml.dm+wbxml");
					s_BinaryMIMETypes.insert(0x43, "application/vnd.syncml.dm+xml");
					s_BinaryMIMETypes.insert(0x44, "application/vnd.syncml.notification");
					s_BinaryMIMETypes.insert(0x45, "application/vnd.wap.xhtml+xml");
					s_BinaryMIMETypes.insert(0x46, "application/vnd.wv.csp.cir");
					s_BinaryMIMETypes.insert(0x47, "application/vnd.oma.dd+xml");
					s_BinaryMIMETypes.insert(0x48, "application/vnd.oma.drm.message");
					s_BinaryMIMETypes.insert(0x49, "application/vnd.oma.drm.content");
					s_BinaryMIMETypes.insert(0x4A, "application/vnd.oma.drm.rights+xml");
					s_BinaryMIMETypes.insert(0x4B, "application/vnd.oma.drm.rights+wbxml");
				}

				return s_BinaryMIMETypes;
			}
		};
	}
}

#endif // EVENTPARSERS_VMGEntities_VBODYWRITER_H
