/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "MMSParser.h"

#include <QDebug>

#include <QFile>
#include <QString>

using namespace EventParsers;

iEventParser *MMSParser::IsValid(QFile &eventFile)
{
	qDebug() << "Checking if a MMS file...";

	// A buffer that can hold 3 fields with a single byte value...and a
	// bonus terminator byte if required (2*3 + 1)
	char fileIDBuf[0x07];
	qint64 bytesRead(eventFile.read(fileIDBuf, sizeof(fileIDBuf) - 1));
	eventFile.seek(0);
	if(bytesRead == sizeof(fileIDBuf) - 1)
	{
		// This is the hex 8c (message type '0c' with high bit set), 80 (transaction id), 8D, 92, 85, 04
		char fieldMessageType = 0x8C;
		char fieldTransactionID = 0x98; // Optional
		char fieldMessageMMSVersion = 0x8D;
		char fieldMessageDate = 0x85;
		uint offset = 0;
		if(fileIDBuf[offset++] == fieldMessageType)
		{
			char valueMessageType = fileIDBuf[offset++] ^ 0x80;
			qDebug() << "...looks like a MMS file. Message type is: " << valueMessageType;

			char valueTransactionID = -1;
			if(fileIDBuf[offset] == fieldTransactionID)
				valueTransactionID = fileIDBuf[offset++] ^ 0x80;

			if(fileIDBuf[offset] == fieldMessageMMSVersion)
			{
				char valueMessageMMSVersion = fileIDBuf[offset++] ^ 0x80;
				int majorVersion(valueMessageMMSVersion >> 4);
				int minorVersion(valueMessageMMSVersion & 0x0F);
				qDebug() << QString("...MMS version type is: %1.%2")
							.arg(majorVersion)
							.arg(minorVersion);

				// We only support up to version 1.3
				if(majorVersion == 1 && minorVersion <= 3)
					return new MMSParser(eventFile.fileName());
				else
					qDebug() << QString("%1 is an unsupported MMS version")
								.arg(eventFile.fileName());
			}
			else
				qDebug() << QString("%1 is a malformed MMS. Expected %2, got %3")
							.arg(eventFile.fileName())
							.arg(fieldMessageMMSVersion).arg(fileIDBuf[offset]);
//				}
//				else
//				{
//					QString hexs;
//					for(int i(0); i<0x16; ++i)
//						hexs.append(QString::number(fileIDBuf[i], 16).rightJustified(2, '0'));
//					qDebug() << eventFile.fileName() << " has bad signature: " << hexs;
		}
	}
	else
		qDebug() << eventFile.fileName() << " has size mismatch.";

	return false;
}

MMSParser::MMSParser(const QString &filename)
{
}

EventTypes::EventFromFileList MMSParser::ParseFile(QFile &eventFile, const QList<uint> &recordsToReturn)
{
	qDebug() << "MMS Parsing NYI!";
	return EventTypes::EventFromFileList();
}
