/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "Factory.h"

#include "CSVSymbianEventLogParser.h"
#include "MMSParser.h"
#include "VMGParser.h"

#include <QDebug>

#include <QFile>

using namespace EventParsers;

iEventParser * Factory::CreateParser(const Settings &settings, const QString &filename)
{
	qDebug() << filename << endl;
	QFile eventFile(filename);

	// If the file's ok, process it...
	if (eventFile.open(QFile::ReadOnly))
	{
		iEventParser *parser(NULL);

		// Check for VMG-format SMS messages
		if((parser = VMGParser::IsValid(settings, eventFile)))
			return parser;

		// Check for CSV-format call logs
		if((parser = CSVSymbianEventLogParser::IsValid(eventFile)))
			return parser;

		// Check for MMS-format MMS messages
		if((parser = MMSParser::IsValid(eventFile)))
			return parser;

		// Check for Pidgin-formatted chat logs (NYI)
		if((parser = NULL))
			return parser;
	}

	qDebug() << filename << " is unrecognised. Ignoring.";

	return NULL;
}
