/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "AllBackends.h"

#include "Fmms.h"
#include "RtcomEventLogger.h"

#include <QList>

using namespace DBBackends;

AllBackends::AllBackends(const Settings &settings) :
	m_Settings(settings)
{
}

const QList<iDBBackend *> & AllBackends::Backends() const
{
	const static QList<iDBBackend *> availableBackends(QList<iDBBackend *>()
		<< new RtcomEventLogger(CurrentSettings())
		<< new Fmms(CurrentSettings()));

	return availableBackends;
}

void AllBackends::Process(EventProcessors::iEventProcessor &eventProcessor)
{
	foreach(iDBBackend *backend, Backends())
		backend->Process(eventProcessor);
}

void AllBackends::Insert(EventTypes::iEvent &event, const NumberToNameLookup &numberToNameLookup)
{
	foreach(iDBBackend *backend, Backends())
		backend->Insert(event, numberToNameLookup);
}
