#    Copyright 2009, Brent Chiodo.

#    Quick Clip is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

from settings import *
from history import *
from target_files import *

import os
import subprocess
import commands
import gtk
import hildon

class Clip_Tools:
   def __init__(self):
      self.settings = Settings().load()

   def clip_selection(self, widget, name, menu):
      date_stamp = commands.getoutput('date +"%m/%d/%y, %l:%M %p: "')

      clipboard = gtk.clipboard_get("PRIMARY")
      clip = clipboard.wait_for_text()
      separater = "______"

      if clip == None:
         self.error(menu, 2, "Nothing Selected.")
         return

      try:
         open_file = open(self.settings['path'] + name + '.txt', 'a')

         file_contents = '\n\n'

         if self.settings['use_date_stamp']:
            file_contents = file_contents + date_stamp

         file_contents = file_contents + clip

         if self.settings['use_separater']:
            file_contents = file_contents + '\n' + separater

         open_file.write(file_contents)
         self.error(menu, 1, "Clipped!")

      except Exception, e:
         self.error(menu, 3, "Error Clipping: " + str(e))

      history_file = name
      History().update(clip, history_file)

      open_file.close()

      clip = ""

# Clip entry

   def clip_entry(self, name, text, menu):
      date_stamp = commands.getoutput('date +"%m/%d/%y, %l:%M %p: "')
      separater = "______"

      try:
         open_file = open(self.settings['path'] + name + '.txt', 'a')

         file_contents = '\n\n'

         if self.settings['use_date_stamp']:
            file_contents = file_contents + date_stamp

         file_contents = file_contents + text

         if self.settings['use_separater']:
            file_contents = file_contents + '\n' + separater

         open_file.write(file_contents)
         self.error(menu, 1, "Clipped!")
         
      except Exception, e:
         self.error(menu, 3, "Error Clipping: " + str(e))

      history_file = name
      History().update(text, history_file)

      open_file.close()

# View function

   def view_file(self, widget, name):

      if self.settings['view_program'] == "$builtin":
         command = '/usr/bin/quickclip_viewer.py "%s"' % (name)
         if not os.path.exists(self.settings['path'] + name + '.txt'):
            self.error(widget, 3, "Error: File does not exist.")
            return
         subprocess.Popen(command, shell=True)
      else:
         command = self.settings['view_program'] % (self.settings['path'] + name)
         command = command + '.txt'
         subprocess.Popen(command, shell=True)

# Edit function

   def edit_file(self, widget, name):

      command = self.settings['edit_program'] % (self.settings['path'] + name)
      command = command + '.txt'
      subprocess.Popen(command, shell=True)

# Clear function

   def clear_file(self, widget, name, menu):
      dialog = gtk.MessageDialog(None,gtk.DIALOG_MODAL, gtk.MESSAGE_QUESTION)
      yes_button = dialog.add_button(gtk.STOCK_YES, gtk.RESPONSE_YES)
      no_button = dialog.add_button(gtk.STOCK_NO, gtk.RESPONSE_NO)

      text = "Are you sure you want to permanently erase the contents of <b>" + name + "</b>?"
      dialog.set_markup(text)

      response = dialog.run()

      if response == gtk.RESPONSE_YES:
         try:
            file = self.settings['path'] + name + '.txt'
            os.remove(file)
            f = open(file, 'w')
            f.close()
            self.error(menu, None, name + " Cleared.")
         except OSError, e:
            self.error(menu, 3, str(e))
            print e
      else:
         dialog.destroy()
         return

      dialog.destroy()

# Delete function

   def delete_file(self, widget, name, menu):
      dialog = gtk.MessageDialog(None,gtk.DIALOG_MODAL, gtk.MESSAGE_QUESTION)
      yes_button = dialog.add_button(gtk.STOCK_YES, gtk.RESPONSE_YES)
      no_button = dialog.add_button(gtk.STOCK_NO, gtk.RESPONSE_NO)

      text = "Are you sure you want to permanently delete <b>" + name + "</b>?"
      dialog.set_markup(text)

      response = dialog.run()

      if response == gtk.RESPONSE_YES:
         try:
            file = self.settings['path'] + name + '.txt'
            os.remove(file)
            files = Target_Files().get_files()
            files.remove(name)
            Target_Files().set_files(files)
            self.error(menu, None, name + " Deleted.")

         except Exception, e:
            self.error(menu, 3, str(e))
            print e
      else:
         dialog.destroy()
         return

      dialog.destroy()
      
   def error(self, widget, kind, e):
      if kind is 1: # Success icon
         icon = "qgn_indi_voip_clear_summary"
      elif kind is 2: # Warning icon
         icon = "qgn_note_gene_syswarning"
      elif kind is 3: # Error icon
         icon = "qgn_note_gene_syserror"
      else: # Information icon
         icon = None
      
      hildon.hildon_banner_show_information(widget, icon, e)