#    Copyright 2009, Brent Chiodo.

#    Quick Clip is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

import gtk
import pygtk
import hildon
import hildondesktop
#import hildonhelp
#import commands
import os
#import ConfigParser
#import subprocess
#import osso
#import xml.etree.ElementTree as ET
#import cPickle
import sys

HOME = os.getenv('HOME')

sys.path.append('/usr/lib/quickclip/')

from history import *
from manage_files import *
from settings import *
from settings_dialog import *
from target_files import *
from main_menu import *
from clip_tools import *
from dialogs import *

# Main class

# ============================
class statusbar_applet(hildondesktop.StatusbarItem):
   def __init__(self):
      hildondesktop.StatusbarItem.__init__(self)

      self.settings = Settings().load()
      self.files = Target_Files().get_files()
      self.history, self.history_target = History().load()

      self.button = gtk.ToggleButton()
      self.button.set_image(gtk.image_new_from_file("/usr/share/icons/hicolor/40x40/hildon/quick_clip-40x40.png"))
      self.button.set_name("hildon-statusbar-button-one")
      self.button.set_size_request(40,40)
      self.button.connect("clicked",self.popup_menu)
      self.add(self.button)
      self.show_all()

      Target_Files().create_files()

   def create_menu(self):
      self.menu = gtk.Menu()

      self.settings = Settings().load()
      self.files = Target_Files().get_files()
      self.history, self.history_target = History().load()

      if int(self.settings['default_menu_positioning']) == 0:
         self.default_menu_positioning_func()
         self.menu.append(gtk.SeparatorMenuItem())

      self.create_parent_func()

      if int(self.settings['default_menu_positioning']) == 1:
         self.menu.append(gtk.SeparatorMenuItem())
         self.default_menu_positioning_func()

      self.menu.show_all()

      self.menu.set_name("menu_from_statusbar")
      self.menu.connect("selection-done", self.menu_done)
      self.menu.show_all()

# Main menu call

   def popup_menu(self,widget,data=None):
      if (self.button.get_active() == True):
         self.create_menu()
         self.menu.popup(None,None,self.menu_position,0,gtk.get_current_event_time())

# Cleaup?

   def menu_done(self, widget, data=None):
      self.button.set_active(False)
      self.menu.destroy()

   def menu_position(self,data=None):
      (reqw, reqh) = self.menu.size_request()
      (x,y) = self.button.get_parent_window().get_position()
      button_allocation = self.button.get_allocation()
      y = y + button_allocation.y + button_allocation.height
      x = x + button_allocation.x + button_allocation.width - reqw
      return (x,y,True)
# ===================

   def create_parent_func(self):

      for item in self.files:
         menu_group = gtk.MenuItem(item)
         self.menu.append(menu_group)

         self.submenu = gtk.Menu()
         menu_selection = gtk.MenuItem("Selection >> File")
         menu_entry = gtk.MenuItem("Entry >> File")
         menu_view = gtk.MenuItem("View")
         menu_edit = gtk.MenuItem("Edit")
         menu_clear = gtk.MenuItem("Clear")
         menu_delete = gtk.MenuItem("Delete")
         self.submenu.append(menu_selection)
         self.submenu.append(menu_entry)
         self.submenu.append(gtk.SeparatorMenuItem())
         self.submenu.append(menu_view)
         self.submenu.append(menu_edit)
         self.submenu.append(gtk.SeparatorMenuItem())
         self.submenu.append(menu_clear)
         self.submenu.append(menu_delete)
         menu_selection.connect('activate', Clip_Tools().clip_selection, item, self.button)
         menu_entry.connect('activate', Dialogs().entry_dialog, item, self.button)
         menu_view.connect('activate', Clip_Tools().view_file, item)
         menu_edit.connect('activate', Clip_Tools().edit_file, item)
         menu_clear.connect('activate', Clip_Tools().clear_file, item, self.button)
         menu_delete.connect('activate', Clip_Tools().delete_file, item, self.button)
         menu_group.set_submenu(self.submenu)

   def default_menu_positioning_func(self):

      menu_group = gtk.MenuItem("Options")
      self.menu.append(menu_group)

      self.submenu = gtk.Menu()
      about_item = gtk.MenuItem("About Quick Clip")
      manage_item = gtk.MenuItem("Manage Files...")
      settings_item = gtk.MenuItem("Settings...")
      donations_item = gtk.MenuItem("Donations")
      help_item = gtk.MenuItem("Help")
      self.submenu.append(about_item)
      self.submenu.append(manage_item)
      self.submenu.append(settings_item)
      self.submenu.append(donations_item)
      self.submenu.append(help_item)
      about_item.connect('activate',Dialogs().about_dialog)
      manage_item.connect('activate',Manage_Files().manage_files)
      settings_item.connect('activate',Settings_Dialog().settings_dialog)
      donations_item.connect('activate',Dialogs().donations)
      help_item.connect('activate',Dialogs().help)
      menu_group.set_submenu(self.submenu)

      self.history_menu()

# History menu

   def history_menu(self):

      menu_group = gtk.MenuItem("History")
      self.menu.append(menu_group)

      self.submenu = gtk.Menu()

      if len(self.history) == 0:
         history_label = gtk.MenuItem("(No History)")
         history_label.set_sensitive(False)
         history_label.modify_fg(gtk.STATE_INSENSITIVE, None)
         self.submenu.append(history_label)
      else:
         clear_label = gtk.MenuItem("Clear History")
         clear_label.connect('activate', History().clear)
         self.submenu.append(clear_label)
         self.submenu.append(gtk.SeparatorMenuItem())

      for item in self.history:
         name = item
         target_index = self.history.index(item)
         self.set_history_menu(name, target_index, self.submenu)

      menu_group.set_submenu(self.submenu)

   def set_history_menu(self, name, target_index, submenu):
      menu_item = gtk.MenuItem(name)
      self.submenu.append(menu_item)
      menu_item.connect("activate", Clip_Tools().view_file, self.history_target[target_index])

#====================

# Tests to see if system files exist...

if not os.path.exists(HOME + '/.quickclip/'):
   subprocess.Popen('mkdir ' + HOME + '/.quickclip', shell=True)

if not os.path.exists(HOME + '/MyDocs/Quick_Clip/'):
   subprocess.Popen('mkdir ' + HOME + '/MyDocs/Quick_Clip/', shell=True)

if not os.path.exists(HOME + '/.quickclip/quickclip.conf'):

   user_config_file = open(HOME + '/.quickclip/quickclip.conf', 'w')
   user_config_access = ConfigParser.RawConfigParser()

   user_config_access.set('DEFAULT', 'path', HOME + '/MyDocs/Quick_Clip/')
   user_config_access.set('DEFAULT', 'view_program', '$builtin')
   user_config_access.set('DEFAULT', 'edit_program', '/usr/bin/dbus-send --print-reply --dest=com.nokia.osso_notes /com/nokia/osso_notes com.nokia.osso_notes.mime_open string:"%s"')
   user_config_access.set('DEFAULT', 'use_date_stamp', True)
   user_config_access.set('DEFAULT', 'use_separater', True)
   user_config_access.set('DEFAULT', 'default_menu_positioning', 0)

   user_config_access.write(user_config_file)
   user_config_file.close()

if not os.path.exists(HOME + '/.quickclip/parent_files.xml'):

   parent_files = open(HOME + '/.quickclip/parent_files.xml', 'w')
   parent_files.write("""<config>
  <file>Example File 1</file>
  <file>Example File 2</file>
  <file>Etc...</file>
</config>""")

# ============================
# Main program

def hd_plugin_get_objects():
   plugin = statusbar_applet()
   return [plugin]

# ============================