/*
 * This file is a part of Queen Beecon Widget
 * queen-beecon-exec-async: Utility for QBW Asynchronous Command Execution Management
 *
 * http://talk.maemo.org/showthread.php?t=45388
 *
 * Copyright (c) 2010 No!No!No!Yes! (Alessandro Peralma)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version. or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef QUEEN_BEECON_EXEC_ASYNC_H
#define QUEEN_BEECON_EXEC_ASYNC_H

// Asynchronous command execution management functions
void queen_beecon_async_execute_cb_child_watch(GPid pid, gint status, QueenBeecon *self);
gboolean queen_beecon_async_execute_cb_out_watch(GIOChannel *channel, GIOCondition  cond, QueenBeecon *self);
gboolean queen_beecon_async_execute_cb_timeout(QueenBeecon *self);
void queen_beecon_async_execute(gchar *cmd, QueenBeecon *self);
gchar *g_strreplace (const gchar *string, const gchar *search, const gchar *replacement);
gchar *queen_beecon_g_command_param_subst(QueenBeecon *self, const gchar *cmd, const gchar *action);

#endif /* QUEEN_BEECON_EXEC_ASYNC_H */

