/*

queen-beecon.h - Queen Beecon Widget
http://talk.maemo.org/showthread.php?t=

Copyright (c) 2010 No!No!No!Yes! (Alessandro Peralma)

From and idea/application by cpscotti (Clovis Peruchi Scotti)
(Desktop Command Execution Widget http://talk.maemo.org/showthread.php?t=39177)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

[No!No!No!Yes!]

*/

#ifndef _QUEEN_BEECON
#define _QUEEN_BEECON
#include <libhildondesktop/libhildondesktop.h>
#include <conic.h>

G_BEGIN_DECLS

#define QUEEN_BEECON_TYPE queen_beecon_get_type()

#define QUEEN_BEECON(obj) \
(G_TYPE_CHECK_INSTANCE_CAST ((obj), QUEEN_BEECON_TYPE, QueenBeecon))

#define QUEEN_BEECON_CLASS(klass) \
(G_TYPE_CHECK_CLASS_CAST ((klass), QUEEN_BEECON_TYPE, QueenBeeconClass))

#define QUEEN_BEECON_IS(obj) \
(G_TYPE_CHECK_INSTANCE_TYPE ((obj), QUEEN_BEECON_TYPE))

#define QUEEN_BEECON_IS_CLASS(klass) \
(G_TYPE_CHECK_CLASS_TYPE ((klass), QUEEN_BEECON_TYPE))

#define QUEEN_BEECON_GET_CLASS(obj) \
(G_TYPE_INSTANCE_GET_CLASS ((obj), QUEEN_BEECON_TYPE, QueenBeeconClass))

typedef struct _QueenBeecon        QueenBeecon;
typedef struct _QueenBeeconClass   QueenBeeconClass;
typedef struct _QueenBeeconPrivate QueenBeeconPrivate;

struct _QueenBeecon
{
  HDHomePluginItem parent;

	QueenBeeconPrivate *priv;
};

struct _QueenBeeconClass
{
  HDHomePluginItemClass  parent;
  DBusGConnection *dbus_conn;
  DBusGProxy	*bus_proxy;
  gboolean 		dbus_registered;
  //GMutex 		*config_file_mutex;

  gboolean 		housekeeping;
  gboolean 		settingsOn;

  // Signal functions Declarations
  void (*queen_beecon_dbus_sig_content_updated) (QueenBeecon *self, gint exitCode);
};

GType queen_beecon_get_type (void);

//Constant & Other definitions
#define HOME_DIR g_get_home_dir()

#define QUEEN_BEECON_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE (obj, QUEEN_BEECON_TYPE, QueenBeeconPrivate))

#define QUEEN_BEECON_SETTINGS_FILE "/.queen_beecon"
#define QUEEN_BEECON_PRIVATE_DIR "/.queen_beecon_dir/"
#define SYSTEM_PUBLIC_ICON_DIR "/usr/share/icons/hicolor/48x48/hildon/"
#define QUEEN_BEECON_MYDOCS_IMAGE_DIR "/MyDocs/.images/queen_beecon_dir/"
#define QUEEN_BEECON_INSTANCE_BASENAME "queen-beecon.desktop-"
#define SYSTEM_INSTANCE_BASE_DIR "/var/lib/gconf/apps/osso/hildon-desktop/applets"
#define QUEEN_BEECON_SETTINGS_VERSION 1.0

//main settings window
#define NON_GTK_RESPONSE_ADD_CMD 10
#define NON_GTK_RESPONSE_EDIT_CMD 20
#define NON_GTK_RESPONSE_DELETE_CMD 30
#define NON_GTK_RESPONSE_SAVE_AND_RUN 40
#define NON_GTK_RESPONSE_ADVANCED 50
//save is GTK_RESPONSE_OK

#define NETWORK__UNRELATED 0
#define NETWORK__ONLY_CONNECTED 1
#define NETWORK__ONLY_DISCONNECTED 2

#define SIZE_WIDTH_ALL 800
#define SIZE_HEIGHT_ALL 420//AP3
#define SIZE_BEECON_RATIO 2 * 1.7//AP3

#define QBW_PROGRESS_ANIMATION_FRAMES_MAX 30

enum {
	SIG_CONTENT_UPDATED,
	LAST_SIGNAL
};

enum {
	QBW_TIMER_UPDATE,
	QBW_STARTUP_UPDATE,
	QBW_SETTINGS_SAVE_RUN,
	QBW_TEST_DRIVE,
	QBW_WAKEUP_CLICK,
	QBW_CLICK,
	QBW_DESKTOP_SWITCH,
	QBW_CONNECTION_EVENT,
	QBW_DBUS_SET_PARAM_UPDATE,
	QBW_DBUS_WAKEUP,
	QBW_DBUS_UPDATE_CONTENT,
	QBW_DBUS_EXEC,
	QBW_DBUS_MONITOR,
	QBW_LAST
};

struct _colorAux {
	GdkColor *WC;
	GtkWidget *WP;
	gboolean FG;
};

struct _colorsRGB
{
	gchar *colorName;
	gchar *colorRGB;
};

// QBW functions Declarations
gboolean queen_beecon_update_content (QueenBeecon *self, const gchar *impulse);
void queen_beecon_update_content_layout (QueenBeecon *self);
void queen_beecon_draw_canvas(GtkWidget *widget);
gboolean queen_beecon_expose_event (GtkWidget *widget, GdkEventExpose *event);
gboolean queen_beecon_button_release_exec (QueenBeecon *self);

//Dialogs prototypes:
gboolean queen_beecon_edit_add_dialog ( QueenBeecon *self, gboolean new, gint curr);
void queen_beecon_settings (HDHomePluginItem *hitem, QueenBeecon *self);

//Auxiliary functions' prototypes:
void AddCommand(QueenBeecon *self, gchar * s_title, gchar * s_command, gboolean doInstantiate);
void EditCommand(QueenBeecon *self, gchar * s_title, gchar * s_command, gboolean doInstantiate, int index);
void DelCommand(QueenBeecon *self, int index);
guint GetSeconds(guint index);

struct _QueenBeeconPrivate
{
	GtkWidget 		*homeWidget;
	GtkWidget 		*currentDialog;
	GtkWidget 		*event;
	GtkWidget 		*contents;

	GtkWidget 		*cmdTitle_lb;
	GtkWidget 		*cmdTitle_img;

	GtkWidget 		*cmdResult_lb;
	GtkWidget 		*cmdResult_img;

	/* widget's instance identification str */
	gchar 			*widgetID;

	//config data

	//global data
		gchar 		**c_titles;
		gchar 		**c_commands;
		guint 		c_size;

	//instance data
		guint	 		widgetType;//AP3
		guint	 		widgetVisible;//0=hidden; 1=visible
		guint 			operationalStatus; // Instance status 0 maximized/enabled, 1 minimized/disabled

		guint			progressAnimationFrames;
		guint			progressAnimationTimer;
		guint			progressAnimationPos;
		gboolean		progressAnimationAtClickXY;
		gchar			*progressAnimationBasename;

		gboolean 		hideCanvas;
		gboolean 		hideClickCanvas;
		gboolean 		updOnStartup;
		gboolean 		updOnClick;
		gboolean 		isPressed;
		gboolean 		clicksCount;
		guint 			clicksTimerID;
		gint			clickX,xx;
		gint			clickY,yy;
		//gboolean		isFingerTap;

		gboolean 		updOnDesktop;
		guint 			updNeworkPolicy;
		gboolean 		updOnSight;
		gboolean 		qbwOnSight;
		gboolean		startupAnimation;
		gboolean		animationInProgress;

		gint			widXOrigin;
		gint			widYOrigin;
		gdouble 		widWidth;
		gdouble 		widHeight;//AP

		guint 			snippetBgRGB;
		gchar			*snippetExtBgRGB;

		guint 			beecon_lt0_BgRGB;
		gchar 			*beecon_lt0_ExtBgRGB;
		gchar			*beecon_lt0_ImgFilename;
		guint 			beecon_lt0_ImgZoom;

		guint 			beecon_eq0_BgRGB;
		gchar 			*beecon_eq0_ExtBgRGB;
		gchar			*beecon_eq0_ImgFilename;
		guint 			beecon_eq0_ImgZoom;

		guint 			beecon_eq1_BgRGB;
		gchar 			*beecon_eq1_ExtBgRGB;
		gchar			*beecon_eq1_ImgFilename;
		guint 			beecon_eq1_ImgZoom;

		guint 			beecon_ge2_BgRGB;
		gchar 			*beecon_ge2_ExtBgRGB;
		gchar			*beecon_ge2_ImgFilename;
		guint 			beecon_ge2_ImgZoom;

		guint 			beecon_idxge2_BgRGB;
		gchar 			*beecon_idxge2_ExtBgRGB;
		gchar			*beecon_idxge2_ImgFilename;
		guint 			beecon_idxge2_ImgZoom;

		gint 			cmdExitStatus;//AP3
		guint 			cmdStatus;//AP3
		guint			syncOutExec;
		gchar			*rememberMe;

		GtkWidget 		*tableLayout;
		GtkWidget 		*hotSpot;
		GtkWidget 		*hotSpotEvent;
		guint			hotSpotIndex;
		GtkWidget 		*tableHotSpots;

		GtkWidget 		*beeExecuting_fixed;
		GtkWidget 		*beeExecuting_img;
		GtkWidget 		*beeExecuting_lb;
		GdkPixbuf      	*beeExecuting_pixbuf[QBW_PROGRESS_ANIMATION_FRAMES_MAX];
		guint			beeExecuting_imgidx;
		gchar			*cmdImgFilename;
		guint			cmdImgAngle;
		guint 			cmdImgZoom;
		guint 			cmdFgRGB;
		gchar 			*cmdExtFgRGB;
		guint 			cmdVisibilityPosition;//AP3
		guint 			cmdImgVisibilityPosition;//AP3
		guint			cmdTextAngle;
		guint 			cmdJustify;//AP3
		gchar			*cmdExtFont;
		gint 			cmdFontName;//AP1
		gdouble 		cmdFontSize;//AP1

		gchar			*resImgFilename;
		guint			resImgAngle;
		guint 			resImgZoom;
		guint 			resFgRGB;
		gchar 			*resExtFgRGB;
		guint 			resVisibilityPosition;//AP3
		guint 			resImgVisibilityPosition;//AP3
		guint			resTextAngle;
		guint 			resJustify;//AP3
		gchar			*resExtFont;
		gint 			resFontName;//AP1
		gdouble 		resFontSize;//AP1

		gchar 			*instanceTitle;
		gchar 			*instanceCmd;

		// Proxy Data
		gchar			*qbwHttpProxy;
		gchar			*qbwHttpsProxy;
		gchar			*qbwIgnoreHosts;
		gchar			*qbwFtpProxy;
		gchar			*qbwSocksProxy;
		gchar			*qbwRTSPProxy;
		gchar			*qbwAutoConfigProxy;

		//DBUS update policy
		DBusConnection *dbus_mon_connection;
		DBusError 		dbus_mon_error;
		guint			updOnDBUS;
		guint			updOnDBUSBus; //(0=system/1=session)
		gchar			*updOnDBUSMatchRule; //(0=system/1=session)
		GString 		*dbusVerboseMsg;
		gboolean		execDBUSMatchInProgress;

		//exec input/output
		gchar			*execAuxOutput;
		gboolean		execInProgress;
		gboolean		clickExecInProgress;
		GMutex 			*execInProgressMutex;
		guint			child_watch_id;
		guint			io_watch_id;

		//Update on timer data
		guint 			delaySeconds;
		guint 			delayIndex;//index of delaySeconds in the array defined inside "queen_beecon_settings"
		guint 			customIntervalSecs;//custom interval in seconds

		guint 			startupExecTimerID;
		//timer process id; used to stop when closing app or changing delay
		guint 			updateTimerID;

	    /* Progress bar that will be updated */
	    GIOChannel 		*out_ch,
						*err_ch;
	    GtkProgressBar *progress;

	    /* Timeout source id */
	    gint 			timeout_id;

		//network connection query ptr
		ConIcConnection	*connection;
		gboolean 		isConnected;

		//Advanced Dialog data
		gboolean 		instanceImportOK;
		GtkTextBuffer 	*importExportBuffer, *cmdTestDriveBuffer, *cmdOutputBuffer; // Buffers for advanced dialog box
		GtkWidget 		*commandPicker;

		// DBUS Widget ID
		gchar 			*qbwDbusId;

		//CB local Data
		gboolean 		dMM; //DBUS Method Monitor flag for debug purposes

		GtkWidget *advancedDialog;

		// Widgets in Settings Dialog
		GtkWidget *selectorW;
		GtkWidget *cmdSelectorW;
		GtkWidget *dialogW;
		GtkWidget *settingsAreaW;
		GtkWidget *scrollW;
		GtkWidget *content_areaW;
		GtkWidget *widCmdTypeBoxW;
		GtkWidget *widgetTypeW;
		GtkWidget *widgetTypeSelectorW;
		GtkWidget *widgetVisibleW;
		GtkWidget *widgetVisibleSelectorW;
		GtkWidget *widgetOperationalStatusW;
		GtkWidget *widgetOperationalStatusSelectorW;
		GtkWidget *widHelpLabelW;
		GtkWidget *widgetSizeLabelW;
		GtkWidget *widthBoxW;
		GtkWidget *widthLabelW;
		GtkWidget *widthSelectW;
		GtkWidget *widthEntryW;
		gulong     widthEntryWSignal;
		GtkWidget *heightBoxW;
		GtkWidget *heightLabelW;
		GtkWidget *heightSelectW;
		GtkWidget *heightEntryW;
		gulong     heightEntryWSignal;
		GtkWidget *widPositionBoxW;
		GtkWidget *widPositionLabelW;
		GtkWidget *widPositionXW;
		GtkWidget *widPositionYW;
		GtkWidget *widgetBgLabelW;
		GtkWidget *hidCanvSnipBgBoxW;
		GtkWidget *checkBtHideCanvasW;
		GtkWidget *checkBtHideClkCanvasW;
		GdkColor snippetBgRGBC;
		GtkWidget *snippetBgRGBSelectorW;
		GtkWidget *snippetBgRGBW;
		GtkWidget *snipHelpLabelW;
		GtkWidget *beeconExitStatusesLabelW;
		GtkWidget *beelt0BoxW;
		GtkWidget *beelt0BoxxW;
		GtkWidget *beecon_lt0_ImgLabelW;
		GtkWidget *beecon_lt0_ImgEntryW;
		GtkWidget *beecon_lt0_ImgZoomW;
		GtkWidget *beecon_lt0_ImgZoomSelectorW;
		GdkColor lt0_BgRGBC;
		GtkWidget *beecon_lt0_BgRGBSelectorW;
		GtkWidget *beecon_lt0_BgRGBW;
		GtkWidget *beeeq0BoxW;
		GtkWidget *beeeq0BoxxW;
		GtkWidget *beecon_eq0_ImgLabelW;
		GtkWidget *beecon_eq0_ImgEntryW;
		GtkWidget *beecon_eq0_ImgZoomW;
		GtkWidget *beecon_eq0_ImgZoomSelectorW;
		GdkColor eq0_BgRGBC;
		GtkWidget *beecon_eq0_BgRGBW;
		GtkWidget *beecon_eq0_BgRGBSelectorW;
		GtkWidget *beeeq1BoxW;
		GtkWidget *beeeq1BoxxW;
		GtkWidget *beecon_eq1_ImgLabelW;
		GtkWidget *beecon_eq1_ImgEntryW;
		GtkWidget *beecon_eq1_ImgZoomW;
		GtkWidget *beecon_eq1_ImgZoomSelectorW;
		GdkColor eq1_BgRGBC;
		GtkWidget *beecon_eq1_BgRGBSelectorW;
		GtkWidget *beecon_eq1_BgRGBW;
		GtkWidget *beege2BoxW;
		GtkWidget *beege2BoxxW;
		GtkWidget *beecon_ge2_ImgLabelW;
		GtkWidget *beecon_ge2_ImgEntryW;
		GtkWidget *beecon_ge2_ImgZoomW;
		GtkWidget *beecon_ge2_ImgZoomSelectorW;
		GdkColor ge2_BgRGBC;
		GtkWidget *beecon_ge2_BgRGBSelectorW;
		GtkWidget *beecon_ge2_BgRGBW;
		GtkWidget *beeidxge2BoxW;
		GtkWidget *beeidxge2BoxxW;
		GtkWidget *beecon_idxge2_ImgLabelW;
		GtkWidget *beecon_idxge2_ImgEntryW;
		GtkWidget *beecon_idxge2_ImgZoomW;
		GtkWidget *beecon_idxge2_ImgZoomSelectorW;
		GdkColor idxge2_BgRGBC;
		GtkWidget *beecon_idxge2_BgRGBSelectorW;
		GtkWidget *beecon_idxge2_BgRGBW;
		GtkWidget *LayoutCmdLabelW;
		GtkWidget *cmdImgVisPosBoxW;
		GtkWidget *titleImgEntryW;
		GtkWidget *cmdImgAngleW;
		GtkWidget *cmdImgAngleSelectorW;
		GtkWidget *beecon_cmdImgZoomW;
		GtkWidget *beecon_cmdImgZoomSelectorW;
		GtkWidget *cmdImgVisibilityPositionW;
		GtkWidget *cmdImgVisibilityPositionSelectorW;
		GtkWidget *cmdFontBoxW;
		GtkWidget *cmdFontFamW;
		GtkWidget *cmdFontSelectorW;
		GtkWidget *cmdFontSzW;
		GtkWidget *cmdExtFontBoxW;
		GtkWidget *cmdExtFontFamW;
		GdkColor cmdFgRGBC;
		GtkWidget *cmdFgRGBSelectorW;
		GtkWidget *cmdFgRGBW;
		GtkWidget *cmdPosColJusBoxW;
		GtkWidget *cmdVisibilityPositionW;
		GtkWidget *cmdVisibilityPositionSelectorW;
		GtkWidget *cmdTextAngleW;
		GtkWidget *cmdTextAngleSelectorW;
		GtkWidget *cmdJustifyW;
		GtkWidget *cmdJustifySelectorW;
		GtkWidget *LayoutResLabelW;
		GtkWidget *resImgVisPosBoxW;
		GtkWidget *resultsImgEntryW;
		GtkWidget *resImgAngleW;
		GtkWidget *resImgAngleSelectorW;
		GtkWidget *beecon_resImgZoomW;
		GtkWidget *beecon_resImgZoomSelectorW;
		GtkWidget *resImgVisibilityPositionW;
		GtkWidget *resImgVisibilityPositionSelectorW;
		GtkWidget *resFontBoxW;
		GtkWidget *resFontFamW;
		GtkWidget *resFontSelectorW;
		GtkWidget *resFontSzW;
		GtkWidget *resExtFontBoxW;
		GtkWidget *resExtFontFamW;
		GdkColor resFgRGBC;
		GtkWidget *resFgRGBSelectorW;
		GtkWidget *resFgRGBW;
		GtkWidget *resVisColJusBoxW;
		GtkWidget *resVisibilityPositionW;
		GtkWidget *resVisibilityPositionSelectorW;
		GtkWidget *resTextAngleW;
		GtkWidget *resTextAngleSelectorW;
		GtkWidget *resJustifyW;
		GtkWidget *resJustifySelectorW;

		//DBUS Progress Animation
		GtkWidget *progrAnimLabelW;
		GtkWidget *progrAnimBoxW;
		GtkWidget *progrAnimFramesSelectorW;
		GtkWidget *progrAnimFramesW;
		GtkWidget *progrAnimTimerSelectorW;
		GtkWidget *progrAnimTimerW;
		GtkWidget *progrAnimPosSelectorW;
		GtkWidget *progrAnimPosW;
		GtkWidget *checkAnimClkXYW;
		GtkWidget *progrAnimBaseLabelW;
		GtkWidget *progrAnimBasenameW;

		//DBUS update policy
		GtkWidget *monDBUSLabelW;
		GtkWidget *updOnDBUSW;
		GtkWidget *updOnDBUSSelectorW;
		GtkWidget *updOnDBUSbusSelectorW;
		GtkWidget *updOnDBUSbusW; //(0=system/1=session)
		GtkWidget *DBUSBoxW;
		GtkWidget *updOnDBUSMatchRuleBoxW;
		GtkWidget *updOnDBUSMatchRuleW;
		GtkWidget *updOnDBUSMatchRuleLabelW;

		//Remember Me Value
		GtkWidget *rememberMeLabelW;
		GtkWidget *rememberMeW;

		GtkWidget *updPolicyLabelW;
		GtkWidget *updBoxW;
		GtkWidget *checkBtStartupW;
		GtkWidget *checkBtClickW;
		GtkWidget *checkBtDesktopW;
		GtkWidget *intervalNetBoxW;
		GtkWidget *intervalSelectorW;
		GtkWidget *intervalSelBtW;
		GtkWidget *intervalCustomEntryW;
		GtkWidget *updIntervalLabelW;
		GtkWidget *networkPolicySelW;
		GtkWidget *networkPolBtW;
		GtkWidget *networkPolBtHelpW;
		GtkWidget *checkBtSightW;
		GtkWidget *goProW;
};

G_END_DECLS

#endif /* _QUEEN_BEECON */
