/*
 * This file is a part of Queen Beecon Widget
 * queen-beecon-progress-animation: Utility for QBW progress animation management
 *
 * http://talk.maemo.org/showthread.php?t=45388
 *
 * Copyright (c) 2010 No!No!No!Yes! (Alessandro Peralma)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version. or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glib.h>
#include <glib/gprintf.h>
#include <gtk/gtk.h>
#include "queen-beecon-logger.h"
#include "queen-beecon.h"
#include "queen-beecon-progress-animation.h"

gchar *qbwProgressAnimationAction[] = {
	"QBW_INIT_PROGRESS_ANIMATION",
	"QBW_CUSTOM_PROGRESS_ANIMATION",
	"QBW_START_PROGRESS_ANIMATION",
	"QBW_STOP_PROGRESS_ANIMATION",
	"QBW_FRAME_PROGRESS_ANIMATION",
	"QBW_DEINIT_PROGRESS_ANIMATION",
	NULL
};

void queen_beecon_exec_animation_progress(QueenBeecon *self, QbwProgressAnimationAction action)
{
	if (action!=QBW_FRAME_PROGRESS_ANIMATION) qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) %s action=%s OnSight=%d", self, G_STRFUNC, qbwProgressAnimationAction[action],self->priv->qbwOnSight);
	guint i;

	if (action!=QBW_INIT_PROGRESS_ANIMATION && action!=QBW_STOP_PROGRESS_ANIMATION && !self->priv->progressAnimationFrames) return; // If animation hidden and we are not initializing then we have nothing to do
	gchar *progressImgFilename;

	switch (action) {
	case QBW_INIT_PROGRESS_ANIMATION:
//		for (i=0; i < QBW_PROGRESS_ANIMATION_FRAMES_MAX; i++) {
			progressImgFilename = g_strdup_printf("%squeen-beecon-progress0.png", SYSTEM_PUBLIC_ICON_DIR);
			qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V4, "(%p) Loading frame pixbuf %s", self, progressImgFilename);
			self->priv->beeExecuting_pixbuf[0] = gdk_pixbuf_new_from_file(progressImgFilename, NULL);
			g_free(progressImgFilename);
//		}
		self->priv->beeExecuting_img = gtk_image_new_from_pixbuf(self->priv->beeExecuting_pixbuf[0]);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Progress Image %p size[%dx%d]", self, self->priv->beeExecuting_img, (gint)self->priv->widWidth, (gint)self->priv->widHeight);
		gtk_widget_set_size_request(GTK_WIDGET(self->priv->beeExecuting_img), 1, 1);//(gint)self->priv->widWidth, (gint)self->priv->widHeight);
		gtk_table_attach(GTK_TABLE(self->priv->tableLayout), GTK_WIDGET(self->priv->beeExecuting_img), 0, 1, 0, 1, GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 0, 0);
		gtk_misc_set_alignment(GTK_MISC (self->priv->beeExecuting_img),0.5,0.5);
		break;
	case QBW_CUSTOM_PROGRESS_ANIMATION:
		if (!self->priv->qbwOnSight) break; // Is widget On Sight? If no, nonsense to trigger animation
		for (i=0; i < self->priv->progressAnimationFrames; i++) {
			gchar *progressCustomImgFilename = NULL;
			gchar *progressCustomAux1ImgFilename = g_strdup_printf("%s%s%s%d.png", HOME_DIR, QUEEN_BEECON_MYDOCS_IMAGE_DIR, self->priv->progressAnimationBasename, i);
			gchar *progressCustomAux2ImgFilename = g_strdup_printf("%s%s%s%d.png", HOME_DIR, QUEEN_BEECON_PRIVATE_DIR, self->priv->progressAnimationBasename, i);
			gint w,h;
			GdkPixbufFormat *progressPixBufFmt = NULL;
			qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) progressAnimationFrame [%d/%d]", self, i, self->priv->progressAnimationFrames);
			qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Progress Image Aux1 [%s]", self, progressCustomAux1ImgFilename);
			progressPixBufFmt = gdk_pixbuf_get_file_info(progressCustomAux1ImgFilename,&w,&h);
			if (progressPixBufFmt!=NULL) {
				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Progress Image Aux1 [%s] found", self, progressCustomAux1ImgFilename);
				progressCustomImgFilename = progressCustomAux1ImgFilename;
			} else {
				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Progress Image Aux2 [%s]", self, progressCustomAux2ImgFilename);
				progressPixBufFmt = gdk_pixbuf_get_file_info(progressCustomAux2ImgFilename,&w,&h);
				if (progressPixBufFmt!=NULL) {
					qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Progress Image Aux2 [%s] found", self, progressCustomAux2ImgFilename);
					progressCustomImgFilename = progressCustomAux2ImgFilename;
				}
			}
			qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Custom Progress Image [%s] self->priv->beeExecuting_pixbuf[i]=%p", self, progressCustomImgFilename, self->priv->beeExecuting_pixbuf[i]);
			if (progressCustomImgFilename!=NULL) {
				GError *error = NULL;
				GdkPixbuf *pixbuf = NULL;
				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Custom Progress Image [%s] loading", self, progressCustomImgFilename);
				pixbuf = gdk_pixbuf_new_from_file(progressCustomImgFilename, &error);
				if (!pixbuf) {
					qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Custom Progress Image [%s] pixbuf ERROR [%s]", self, progressCustomImgFilename, error->message);
					g_free(error);
				} else {
					qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Custom Progress Image [%s] pixbuf SUCCESS", self, progressCustomImgFilename);
					if (self->priv->beeExecuting_pixbuf[i] != NULL) {g_object_unref (self->priv->beeExecuting_pixbuf[i]);}
					self->priv->beeExecuting_pixbuf[i] = pixbuf;
				}
			} else {
				progressImgFilename = g_strdup_printf("%squeen-beecon-progress%d.png", SYSTEM_PUBLIC_ICON_DIR, i);
				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V4, "(%p) Loading frame pixbuf %s", self, progressImgFilename);
				self->priv->beeExecuting_pixbuf[i] = gdk_pixbuf_new_from_file(progressImgFilename, NULL);
				g_free(progressImgFilename);
			}
			g_free(progressCustomAux1ImgFilename);
			g_free(progressCustomAux2ImgFilename);
		}
		gtk_image_set_from_pixbuf (GTK_IMAGE(self->priv->beeExecuting_img), self->priv->beeExecuting_pixbuf[0]);
//		break;
//	case QBW_START_PROGRESS_ANIMATION:
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) progressAnimationFrames [%d]", self, self->priv->progressAnimationFrames);
		self->priv->beeExecuting_imgidx=0;
		gtk_misc_set_alignment(GTK_MISC (self->priv->beeExecuting_img),((self->priv->progressAnimationPos)%3)*0.5,((self->priv->progressAnimationPos)/3)*0.5);
		gtk_widget_show(self->priv->beeExecuting_img);
		self->priv->beeExecuting_imgidx++;
		break;
	case QBW_FRAME_PROGRESS_ANIMATION:
		i = self->priv->beeExecuting_imgidx % self->priv->progressAnimationFrames;
		GdkPixbuf *pixbuf = self->priv->beeExecuting_pixbuf[i];
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V4, "(%p) progressAnimationFrame [%d/%d=%p]", self, i, self->priv->progressAnimationFrames, pixbuf);
		gtk_image_set_from_pixbuf (GTK_IMAGE(self->priv->beeExecuting_img), pixbuf);
		self->priv->beeExecuting_imgidx++;
		break;
	case QBW_STOP_PROGRESS_ANIMATION:
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) progressAnimationFrames [%d]", self, self->priv->progressAnimationFrames);
		gtk_widget_hide(self->priv->beeExecuting_img);
		break;
	case QBW_DEINIT_PROGRESS_ANIMATION:
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) progressAnimationFrames [%d]", self, self->priv->progressAnimationFrames);
		for (i=0; i < QBW_PROGRESS_ANIMATION_FRAMES_MAX; i++) if (self->priv->beeExecuting_pixbuf[i] != NULL) g_object_unref (self->priv->beeExecuting_pixbuf[i]);
		break;
	default:
		return;
	}
	return;
}
