/*

queen-beecon.c - Queen Beecon Widget
http://talk.maemo.org/showthread.php?t=45388

Copyright (c) 2010 No!No!No!Yes! (Alessandro Peralma)

From and idea/application by cpscotti (Clovis Peruchi Scotti)
(Desktop Command Execution Widget http://talk.maemo.org/showthread.php?t=39177)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

[No!No!No!Yes!]
*/

#define xNEW_COLOR_DIALOG
#define NEW_FONT_DIALOG
#define DBUS_MONITOR_MODE

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "queen-beecon.h"
#include "queen-beecon-service.h"
#include <hildon/hildon.h>
#include <hildon/hildon-file-chooser-dialog.h>
#include <glib.h>
#include <glib/gprintf.h>
#include <gtk/gtk.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <sys/wait.h>
#include <libintl.h>
#include <stdlib.h>
#include <string.h>

#include "he-color-dialog.h"
#include "he-font-dialog.h"
#include "dbus-print-message.h"

#include <conic.h>

#define HOME_DIR g_get_home_dir()

#define _(String) dgettext("hildon-libs", String)

#define QUEEN_BEECON_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE (obj, QUEEN_BEECON_TYPE, QueenBeeconPrivate))

#define QUEEN_BEECON_SETTINGS_FILE "/.queen_beecon"
#define QUEEN_BEECON_PRIVATE_DIR "/.queen_beecon_dir/"
#define SYSTEM_PUBLIC_ICON_DIR "/usr/share/icons/hicolor/48x48/hildon/"
#define QUEEN_BEECON_MYDOCS_IMAGE_DIR "/MyDocs/.images/queen_beecon_dir/"
#define QUEEN_BEECON_INSTANCE_BASENAME "queen-beecon.desktop-"
#define SYSTEM_INSTANCE_BASE_DIR "/var/lib/gconf/apps/osso/hildon-desktop/applets"
#define QUEEN_BEECON_SETTINGS_VERSION 1.0

//main settings window
#define NON_GTK_RESPONSE_ADD_CMD 10
#define NON_GTK_RESPONSE_EDIT_CMD 20
#define NON_GTK_RESPONSE_DELETE_CMD 30
#define NON_GTK_RESPONSE_SAVE_AND_RUN 40
#define NON_GTK_RESPONSE_ADVANCED 50
//save is GTK_RESPONSE_OK

#define NETWORK__UNRELATED 0
#define NETWORK__ONLY_CONNECTED 1
#define NETWORK__ONLY_DISCONNECTED 2

#define SIZE_WIDTH_ALL 800
#define SIZE_HEIGHT_ALL 420//AP3
#define SIZE_BEECON_RATIO 2 * 1.7//AP3

enum {
	SIG_CONTENT_UPDATED,
	LAST_SIGNAL
};

enum {
	QBW_TIMER_UPDATE,
	QBW_STARTUP_UPDATE,
	QBW_SETTINGS_SAVE_RUN,
	QBW_TEST_DRIVE,
	QBW_WAKEUP_CLICK,
	QBW_CLICK,
	QBW_DESKTOP_SWITCH,
	QBW_CONNECTION_EVENT,
	QBW_DBUS_SET_PARAM_UPDATE,
	QBW_DBUS_WAKEUP,
	QBW_DBUS_UPDATE_CONTENT,
	QBW_DBUS_EXEC,
	QBW_DBUS_MONITOR,
	QBW_LAST
};
gchar *qbwExecReason[] = {
	"QBW_TIMER_UPDATE",
	"QBW_STARTUP_UPDATE",
	"QBW_SETTINGS_SAVE_RUN",
	"QBW_TEST_DRIVE",
	"QBW_WAKEUP_CLICK",
	"QBW_CLICK",
	"QBW_DESKTOP_SWITCH",
	"QBW_CONNECTION_EVENT",
	"QBW_DBUS_SET_PARAM_UPDATE",
	"QBW_DBUS_WAKEUP",
	"QBW_DBUS_UPDATE_CONTENT",
	"QBW_DBUS_EXEC",
	"QBW_DBUS_MONITOR",
	NULL
};

typedef enum {
	QBW_INIT_PROGRESS_ANIMATION,
	QBW_CUSTOM_PROGRESS_ANIMATION,
	QBW_START_PROGRESS_ANIMATION,
	QBW_STOP_PROGRESS_ANIMATION,
	QBW_FRAME_PROGRESS_ANIMATION,
	QBW_DEINIT_PROGRESS_ANIMATION
} QbwProgressAnimationAction;
#define QBW_PROGRESS_ANIMATION_FRAMES 4
gchar *qbwProgressAnimationAction[] = {
	"QBW_INIT_PROGRESS_ANIMATION",
	"QBW_CUSTOM_PROGRESS_ANIMATION",
	"QBW_START_PROGRESS_ANIMATION",
	"QBW_STOP_PROGRESS_ANIMATION",
	"QBW_FRAME_PROGRESS_ANIMATION",
	"QBW_DEINIT_PROGRESS_ANIMATION",
	NULL
};

typedef enum {
	QBW_INIT_DBUS_MONITOR,
	QBW_DEINIT_DBUS_MONITOR
} QbwDBUSMonitorAction;
gchar *qbwDBUSMonitorAction[] = {
	"QBW_INIT_DBUS_MONITOR",
	"QBW_DEINIT_DBUS_MONITOR"
};

static guint queen_beecon_signals[LAST_SIGNAL] = { 0 };

struct _colorAux {
	GdkColor *WC;
	GtkWidget *WP;
	gboolean FG;
};

struct _colorsRGB
{
	gchar *colorName;
	gchar *colorRGB;
} p_colors[] = {//AP3
		{"Black",	"#000000" },
		{"White", 	"#FFFFFF" },
		{"Gray",	"#808080" },
		{"Lime",	"#00FF00" },
		{"Yellow",	"#FFFF00" },
		{"Red",		"#FF0000" },
		{"Magenta",	"#FF00FF" },
		{"Silver",	"#C0C0C0" },
		{"Olive",	"#808000" },
		{"Purple",	"#800080" },
		{"Maroon",	"#800000" },
		{"Aqua",	"#00FFFF" },
		{"Teal",	"#008080" },
		{"Green",	"#008000" },
		{"Blue",	"#0000FF" },
		{"Navy",	"#000080" },
		{NULL,		"#000000" }
};

gchar * p_justification[] = {//AP3
	"Left","Right","Center","Fill", NULL};//AP1

gchar * p_visible_position[] = {//AP3
	"Hidden","Top Left","Top Center","Top Right","Center Left","Center","Center Right","Bottom Left","Bottom Center","Bottom Right",NULL};//AP1

gchar * p_fonts[] = {//AP1
		"Nokia Sans","NewCourier","NewTimes","Monospace","Nokia Sans Cn","Nokia Sans Maps","Nokia Sans SemiBold","Sans","Serif","SwissA","Tanseek Pro Arabic","Univers OTS Arabic",NULL};//AP1

gchar * p_fonts_types[] = {//AP1
	 "regular", "italic", "bold","bold italic", NULL};//AP1

static gboolean queen_beecon_update_content (QueenBeecon *self, const gchar *impulse);
static void queen_beecon_draw_canvas(GtkWidget *widget);
static void queen_beecon_update_content_layout (QueenBeecon *self);
static gboolean queen_beecon_expose_event (GtkWidget *widget, GdkEventExpose *event);

//Dialogs prototypes:
static gboolean queen_beecon_advanced_dialog ( QueenBeecon *self, gint cmdSel);
static gboolean queen_beecon_edit_add_dialog ( QueenBeecon *self, gboolean new, gint curr);
static void queen_beecon_settings (HDHomePluginItem *hitem, QueenBeecon *self);

//Auxiliary functions' prototypes:
static void AddCommand(QueenBeecon *self, gchar * s_title, gchar * s_command, gboolean doInstantiate);
static void EditCommand(QueenBeecon *self, gchar * s_title, gchar * s_command, gboolean doInstantiate, int index);
static void DelCommand(QueenBeecon *self, int index);
static guint GetSeconds(guint index);
static guint checksum(gchar *buffer);
static gchar *queen_beecon_g_command_param_subst(QueenBeecon *self, const gchar *cmd, const gchar *action);
static gchar *g_strreplace (const gchar *string, const gchar *search, const gchar *replacement);

// Configuration file management functions
static void queen_beecon_read_settings ( QueenBeecon *self, gboolean needInstanceSettings, gboolean isImportFromADB, gchar *importData);
static void queen_beecon_write_settings (QueenBeecon *self, gboolean needInstanceSettings);
static gchar *queen_beecon_g_key_file_get_string(GKeyFile *key_file, const gchar *group_name, const gchar *key, gchar *defaultValue);
static gboolean queen_beecon_g_key_file_get_boolean(GKeyFile *key_file, const gchar *group_name, const gchar *key, gboolean defaultValue);
static gint queen_beecon_g_key_file_get_integer(GKeyFile *key_file, const gchar *group_name, const gchar *key, gint defaultValue);
static gdouble queen_beecon_g_key_file_get_double(GKeyFile *key_file, const gchar *group_name, const gchar *key, gdouble defaultValue);
static gboolean write_settings_have_key(const gchar *group_name, const gchar *key, void *value, char keyType);
static gchar *read_settings_have_key (const gchar *group_name, const gchar *key);
// Asynchronous command execution management functions
static void queen_beecon_async_execute_cb_child_watch(GPid pid, gint status, QueenBeecon *self);
static gboolean queen_beecon_async_execute_cb_out_watch(GIOChannel *channel, GIOCondition  cond, QueenBeecon *self);
static gboolean queen_beecon_async_execute_cb_timeout(QueenBeecon *self);
static void queen_beecon_async_execute(gchar *cmd, QueenBeecon *self);
static void queen_beecon_exec_animation_progress(QueenBeecon *self, QbwProgressAnimationAction action);
// DBUS Management functions
static DBusHandlerResult queen_beecon_dbus_monitor_filter_function(DBusConnection *connection, DBusMessage *message, QueenBeecon *self);
static gboolean queen_beecon_dbus_monitor_manager(QueenBeecon *self, QbwDBUSMonitorAction action, guint DBUSBus, const gchar *DBUSMatchRule);

guint housekeeping = 0;
static void beecon_config_file_housekeeping(gpointer data);

struct _QueenBeeconPrivate
{

	GtkWidget 		*homeWidget;
	GtkWidget 		*currentDialog;
	GtkWidget 		*event;
	GtkWidget 		*contents;

	GtkWidget 		*cmdTitle_lb;
	GtkWidget 		*cmdTitle_img;

	GtkWidget 		*cmdResult_lb;
	GtkWidget 		*cmdResult_img;

	gboolean 		isPressed;

	/* widget's instance identification str */
	gchar 			*widgetID;

	//config data

	//global data
		gchar 		**c_titles;
		gchar 		**c_commands;
		guint 		c_size;

	//instance data
		guint	 		widgetType;//AP3
		guint	 		widgetVisible;//0=hidden; 1=visible
		guint 			operationalStatus; // Instance status 0 maximized/enabled, 1 minimized/disabled

		gboolean 		hideCanvas;
		gboolean 		updOnStartup;
		gboolean 		updOnClick;
		gboolean 		updOnDesktop;
		guint 			updNeworkPolicy;

		gint			widXOrigin;
		gint			widYOrigin;
		gdouble 		widWidth;
		gdouble 		widHeight;//AP

		guint 			snippetBgRGB;
		gchar			*snippetExtBgRGB;

		guint 			beecon_lt0_BgRGB;
		gchar 			*beecon_lt0_ExtBgRGB;
		gchar			*beecon_lt0_ImgFilename;
		guint 			beecon_lt0_ImgZoom;

		guint 			beecon_eq0_BgRGB;
		gchar 			*beecon_eq0_ExtBgRGB;
		gchar			*beecon_eq0_ImgFilename;
		guint 			beecon_eq0_ImgZoom;

		guint 			beecon_eq1_BgRGB;
		gchar 			*beecon_eq1_ExtBgRGB;
		gchar			*beecon_eq1_ImgFilename;
		guint 			beecon_eq1_ImgZoom;

		guint 			beecon_ge2_BgRGB;
		gchar 			*beecon_ge2_ExtBgRGB;
		gchar			*beecon_ge2_ImgFilename;
		guint 			beecon_ge2_ImgZoom;

		guint 			beecon_idxge2_BgRGB;
		gchar 			*beecon_idxge2_ExtBgRGB;
		gchar			*beecon_idxge2_ImgFilename;
		guint 			beecon_idxge2_ImgZoom;

		gint 			cmdExitStatus;//AP3
		guint 			cmdStatus;//AP3
		guint			syncOutExec;

		GtkWidget 		*tableLayout;
		GtkWidget 		*beeExecuting_img;
		GdkPixbuf      	*beeExecuting_pixbuf[QBW_PROGRESS_ANIMATION_FRAMES];
		guint			beeExecuting_imgidx;
		gchar			*cmdImgFilename;
		guint 			cmdImgZoom;
		guint 			cmdFgRGB;
		gchar 			*cmdExtFgRGB;
		guint 			cmdVisibilityPosition;//AP3
		guint 			cmdImgVisibilityPosition;//AP3
		guint			cmdTextAngle;
		guint 			cmdJustify;//AP3
		gchar			*cmdExtFont;
		gint 			cmdFontName;//AP1
		gdouble 		cmdFontSize;//AP1

		gchar			*resImgFilename;
		guint 			resImgZoom;
		guint 			resFgRGB;
		gchar 			*resExtFgRGB;
		guint 			resVisibilityPosition;//AP3
		guint 			resImgVisibilityPosition;//AP3
		guint			resTextAngle;
		guint 			resJustify;//AP3
		gchar			*resExtFont;
		gint 			resFontName;//AP1
		gdouble 		resFontSize;//AP1

		gchar 			*instanceTitle;
		gchar 			*instanceCmd;

		//DBUS update policy
		DBusConnection *dbus_mon_connection;
		DBusError 		dbus_mon_error;
		guint			updOnDBUS;
		guint			updOnDBUSBus; //(0=system/1=session)
		gchar			*updOnDBUSMatchRule; //(0=system/1=session)
		GString 		*dbusVerboseMsg;

		//exec input/output
		gchar			*execAuxOutput;
		gboolean		execInProgress;

		//Update on timer data
		guint 			delaySeconds;
		guint 			delayIndex;//index of delaySeconds in the array defined inside "queen_beecon_settings"
		guint 			customIntervalSecs;//custom interval in seconds

		//timer process id; used to stop when closing app or changing delay
		guint 			updateTimerID;

	    /* Progress bar that will be updated */
	    GIOChannel 		*out_ch,
						*err_ch;
	    GtkProgressBar *progress;

	    /* Timeout source id */
	    gint 			timeout_id;

		//network connection query ptr
		ConIcConnection	*connection;
		gboolean 		isConnected;

		//Advanced Dialog data
		gboolean 		instanceImportOK;
		GtkTextBuffer 	*importExportBuffer, *cmdTestDriveBuffer, *cmdOutputBuffer; // Buffers for advanced dialog box
		GtkWidget 		*commandPicker;

		// DBUS Widget ID
		gchar 			*qbwDbusId;

		//CB Glocal Data
		gboolean 		dMM; //DBUS Method Monitor flag for debug purposes

		GtkWidget *advancedDialog;

		// Widgets in Settings Dialog
		GtkWidget *selectorW;
		GtkWidget *cmdSelectorW;
		GtkWidget *dialogW;
		GtkWidget *settingsAreaW;
		GtkWidget *scrollW;
		GtkWidget *content_areaW;
		GtkWidget *widCmdTypeBoxW;
		GtkWidget *widgetTypeW;
		GtkWidget *widgetTypeSelectorW;
		GtkWidget *widgetVisibleW;
		GtkWidget *widgetVisibleSelectorW;
		GtkWidget *widgetOperationalStatusW;
		GtkWidget *widgetOperationalStatusSelectorW;
		GtkWidget *widHelpLabelW;
		GtkWidget *widgetSizeLabelW;
		GtkWidget *widthBoxW;
		GtkWidget *widthLabelW;
		GtkWidget *widthSelectW;
		GtkWidget *heightBoxW;
		GtkWidget *heightLabelW;
		GtkWidget *heightSelectW;
		GtkWidget *widPositionBoxW;
		GtkWidget *widPositionLabelW;
		GtkWidget *widPositionXW;
		GtkWidget *widPositionYW;
		GtkWidget *widgetBgLabelW;
		GtkWidget *hidCanvSnipBgBoxW;
		GtkWidget *checkBtHideCanvasW;
		GdkColor snippetBgRGBC;
		GtkWidget *snippetBgRGBSelectorW;
		GtkWidget *snippetBgRGBW;
		GtkWidget *snipHelpLabelW;
		GtkWidget *beeconExitStatusesLabelW;
		GtkWidget *beelt0BoxW;
		GtkWidget *beelt0BoxxW;
		GtkWidget *beecon_lt0_ImgLabelW;
		GtkWidget *beecon_lt0_ImgEntryW;
		GtkWidget *beecon_lt0_ImgZoomW;
		GtkWidget *beecon_lt0_ImgZoomSelectorW;
		GdkColor lt0_BgRGBC;
		GtkWidget *beecon_lt0_BgRGBSelectorW;
		GtkWidget *beecon_lt0_BgRGBW;
		GtkWidget *beeeq0BoxW;
		GtkWidget *beeeq0BoxxW;
		GtkWidget *beecon_eq0_ImgLabelW;
		GtkWidget *beecon_eq0_ImgEntryW;
		GtkWidget *beecon_eq0_ImgZoomW;
		GtkWidget *beecon_eq0_ImgZoomSelectorW;
		GdkColor eq0_BgRGBC;
		GtkWidget *beecon_eq0_BgRGBW;
		GtkWidget *beecon_eq0_BgRGBSelectorW;
		GtkWidget *beeeq1BoxW;
		GtkWidget *beeeq1BoxxW;
		GtkWidget *beecon_eq1_ImgLabelW;
		GtkWidget *beecon_eq1_ImgEntryW;
		GtkWidget *beecon_eq1_ImgZoomW;
		GtkWidget *beecon_eq1_ImgZoomSelectorW;
		GdkColor eq1_BgRGBC;
		GtkWidget *beecon_eq1_BgRGBSelectorW;
		GtkWidget *beecon_eq1_BgRGBW;
		GtkWidget *beege2BoxW;
		GtkWidget *beege2BoxxW;
		GtkWidget *beecon_ge2_ImgLabelW;
		GtkWidget *beecon_ge2_ImgEntryW;
		GtkWidget *beecon_ge2_ImgZoomW;
		GtkWidget *beecon_ge2_ImgZoomSelectorW;
		GdkColor ge2_BgRGBC;
		GtkWidget *beecon_ge2_BgRGBSelectorW;
		GtkWidget *beecon_ge2_BgRGBW;
		GtkWidget *beeidxge2BoxW;
		GtkWidget *beeidxge2BoxxW;
		GtkWidget *beecon_idxge2_ImgLabelW;
		GtkWidget *beecon_idxge2_ImgEntryW;
		GtkWidget *beecon_idxge2_ImgZoomW;
		GtkWidget *beecon_idxge2_ImgZoomSelectorW;
		GdkColor idxge2_BgRGBC;
		GtkWidget *beecon_idxge2_BgRGBSelectorW;
		GtkWidget *beecon_idxge2_BgRGBW;
		GtkWidget *LayoutCmdLabelW;
		GtkWidget *cmdImgVisPosBoxW;
		GtkWidget *titleImgEntryW;
		GtkWidget *beecon_cmdImgZoomW;
		GtkWidget *beecon_cmdImgZoomSelectorW;
		GtkWidget *cmdImgVisibilityPositionW;
		GtkWidget *cmdImgVisibilityPositionSelectorW;
		GtkWidget *cmdFontBoxW;
		GtkWidget *cmdFontFamW;
		GtkWidget *cmdFontSelectorW;
		GtkWidget *cmdFontSzW;
		GtkWidget *cmdExtFontBoxW;
		GtkWidget *cmdExtFontFamW;
		GdkColor cmdFgRGBC;
		GtkWidget *cmdFgRGBSelectorW;
		GtkWidget *cmdFgRGBW;
		GtkWidget *cmdPosColJusBoxW;
		GtkWidget *cmdVisibilityPositionW;
		GtkWidget *cmdVisibilityPositionSelectorW;
		GtkWidget *cmdTextAngleW;
		GtkWidget *cmdTextAngleSelectorW;
		GtkWidget *cmdJustifyW;
		GtkWidget *cmdJustifySelectorW;
		GtkWidget *LayoutResLabelW;
		GtkWidget *resImgVisPosBoxW;
		GtkWidget *resultsImgEntryW;
		GtkWidget *beecon_resImgZoomW;
		GtkWidget *beecon_resImgZoomSelectorW;
		GtkWidget *resImgVisibilityPositionW;
		GtkWidget *resImgVisibilityPositionSelectorW;
		GtkWidget *resFontBoxW;
		GtkWidget *resFontFamW;
		GtkWidget *resFontSelectorW;
		GtkWidget *resFontSzW;
		GtkWidget *resExtFontBoxW;
		GtkWidget *resExtFontFamW;
		GdkColor resFgRGBC;
		GtkWidget *resFgRGBSelectorW;
		GtkWidget *resFgRGBW;
		GtkWidget *resVisColJusBoxW;
		GtkWidget *resVisibilityPositionW;
		GtkWidget *resVisibilityPositionSelectorW;
		GtkWidget *resTextAngleW;
		GtkWidget *resTextAngleSelectorW;
		GtkWidget *resJustifyW;
		GtkWidget *resJustifySelectorW;

		//DBUS update policy
		GtkWidget *monDBUSLabelW;
		GtkWidget *updOnDBUSW;
		GtkWidget *updOnDBUSSelectorW;
		GtkWidget *updOnDBUSbusSelectorW;
		GtkWidget *updOnDBUSbusW; //(0=system/1=session)
		GtkWidget *DBUSBoxW;
		GtkWidget *updOnDBUSMatchRuleBoxW;
		GtkWidget *updOnDBUSMatchRuleW;
		GtkWidget *updOnDBUSMatchRuleLabelW;

		GtkWidget *updPolicyLabelW;
		GtkWidget *updBoxW;
		GtkWidget *checkBtStartupW;
		GtkWidget *checkBtClickW;
		GtkWidget *checkBtDesktopW;
		GtkWidget *intervalNetBoxW;
		GtkWidget *intervalSelectorW;
		GtkWidget *intervalSelBtW;
		GtkWidget *intervalCustomEntryW;
		GtkWidget *updIntervalLabelW;
		GtkWidget *networkPolicySelW;
		GtkWidget *networkPolBtW;
		GtkWidget *networkPolBtHelpW;
		GtkWidget *goProW;
};

HD_DEFINE_PLUGIN_MODULE (QueenBeecon, queen_beecon, HD_TYPE_HOME_PLUGIN_ITEM);

//Settings file functions

static void queen_beecon_read_settings ( QueenBeecon *self, gboolean needInstanceSettings, gboolean isImportFromADB, gchar *importData)
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	gchar *filename=NULL, *sourceGroup=NULL;
	gboolean fileExists;
	GKeyFile *keyFile=NULL;
	GError *error=NULL;

	if(self->priv->widgetID == NULL) {
		//g_warning("(%p) Widget instance not initialized, not reading settings..", self);
		return;
	}

	keyFile = g_key_file_new();
	//g_warning("(%p) keyfile %p", self, keyFile);
	if (!isImportFromADB) {
		sourceGroup=self->priv->widgetID;
	} else {
		//g_warning("(%p) Import from ADB", self);
		sourceGroup="queen-beecon-exported-instance";
		fileExists = g_key_file_load_from_data (keyFile, importData, strlen(importData), G_KEY_FILE_KEEP_COMMENTS, NULL);
		if (!fileExists) {
			//g_warning("(%p) Import from ADB buffer error", self);
			return;
		} else goto needInstanceSettings;
	}
	filename = g_strconcat (HOME_DIR, QUEEN_BEECON_SETTINGS_FILE, NULL);
	//g_warning("(%p) filename %s", self, filename);
	fileExists = g_key_file_load_from_file (keyFile, filename, G_KEY_FILE_KEEP_COMMENTS, NULL);
	//g_warning("(%p) fileExists %d", self, fileExists);

	gdouble settingsVer = queen_beecon_g_key_file_get_double (keyFile, "config", "version", QUEEN_BEECON_SETTINGS_VERSION);
	g_warning("(%p) settingsVer %f", self, settingsVer);

	guint cmdListInConsistent = 0;
	if (fileExists) {
		//gets "global" data/commands list
		//BEGIN get list
		g_strfreev(self->priv->c_commands);
		self->priv->c_commands = (gchar **) g_key_file_get_string_list (keyFile, "config", "c_commands", &(self->priv->c_size) ,&error);
		//g_warning("(%p) c_size=%d", self, self->priv->c_size);
		//gint i;	for (i=0;i<self->priv->c_size;i++) g_ warning("(%p) c_commands[%d]=%s", self, i, self->priv->c_commands[i]);
		if (error) {
			//g_warning("(%p) ERROR g_key_file_get_string_list (keyFile, \"config\", \"c_commands\", ...)", self);
			cmdListInConsistent++;
			g_clear_error (&error);
			error = NULL;
		}

		guint consistencyCheck = -1;

		g_strfreev(self->priv->c_titles);
		self->priv->c_titles = g_key_file_get_string_list (keyFile, "config", "c_titles", &consistencyCheck ,&error);
		gint j;	for (j=0;j<consistencyCheck;j++) {
			;
			//g_warning("(%p) c_titles[%d]=%s", self, j, self->priv->c_titles[j]);
		}
		if (error) {
			//g_warning("(%p) ERROR g_key_file_get_string_list (keyFile, \"config\", \"c_titles\", ...)", self);
			cmdListInConsistent++;
			g_clear_error (&error);
			error = NULL;
		}

		if(consistencyCheck != self->priv->c_size) {
			//g_warning("(%p) consistencyCheck FAILED=%d", self, consistencyCheck);
			//g_warning("(%p) Settings file corrupted!", self);
			cmdListInConsistent++;
		}
		//END
	} else
		cmdListInConsistent++;
	if (cmdListInConsistent) {
		#define QUEEN_BEECON_TOTAL_FIXED_COMMANDS 13
		gchar * p_titles[] = { "appOK", "appWRN", "appERR", "sysERR", "Uptime:", "Battery(%):", "Battery(mAh):", "Boot Reason:", "Boot Count:", "External IP:", "Internal IP:", "Rootfs(%):", "Free Rootfs:", NULL};
		gchar * p_commands[] = {
		"echo test && exit 0",
		"echo test && exit 1",
		"echo test && exit 2",
		"all_work_and_no_play_makes_jack_a_dull_boy",
		"uptime|cut -d\" \" -f4-|sed 's/\\, *load.*//'",
		"hal-device bme | awk -F\"[. ]\" '$5 == \"is_charging\" {chrg = $7}; $5 == \"percentage\" {perc = $7} END if (chrg == \"false\") {print perc \"%\"} else {print \"Chrg\"}'",
		"hal-device bme | grep battery.reporting | awk -F. '{print $3}' | sort | awk '$1 == \"current\" { current = $3}; $1== \"design\" {print current \"/\" $3}'",
		"cat /proc/bootreason",
		"cat /var/lib/dsme/boot_count",
		"wget -q -O - api.myiptest.com | awk -F \"\\\"\" '{print $4}'",
		"/sbin/ifconfig | grep \"inet addr\" | awk -F: '{print $2}' | awk '{print $1}'",
		"df | awk '$1 == \"rootfs\" {print $5}'",
		"df -h | awk ' $1 == \"rootfs\" {print $4\"B\"}'",
		NULL};
		//g_warning("(%p) Records empty, filling with pre-loaded vals", self);
		self->priv->c_size = QUEEN_BEECON_TOTAL_FIXED_COMMANDS;
		//clean possible oldies
		g_strfreev(self->priv->c_titles);
		self->priv->c_titles = NULL;
		g_strfreev(self->priv->c_commands);
		self->priv->c_commands = NULL;
		//assign new from stack values
		self->priv->c_titles = g_strdupv(p_titles);
		self->priv->c_commands = g_strdupv(p_commands);
	}

needInstanceSettings:
	if (needInstanceSettings) {
		/*getting instance specific data*/
		//g_warning("(%p) Getting instance specific data: %s", self, sourceGroup);
		//BEGIN
		self->priv->widgetType = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "widgetType", 0);//0=Beecon
		self->priv->widgetVisible = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "widgetVisible", 1);//0=Hidden; 1=Visible
		self->priv->operationalStatus = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "operationalStatus", 0);//0=Maximized/Enabled
		self->priv->hideCanvas = queen_beecon_g_key_file_get_boolean (keyFile, sourceGroup, "hideCanvas", FALSE);//FALSE=Show Canvas by default
		self->priv->snippetBgRGB = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "snippetBgRGB", 0);//0=Black

#ifdef xNEW_COLOR_DIALOG
		//g_warning("(%p) self->priv->snippetExtBgRGB = %p", self, self->priv->snippetExtBgRGB);
		g_free(self->priv->snippetExtBgRGB);self->priv->snippetExtBgRGB=NULL;
		self->priv->snippetExtBgRGB = g_strdup(queen_beecon_g_key_file_get_string (keyFile, sourceGroup, "snippetExtBgRGB", p_colors[self->priv->resFgRGB].colorRGB));//No Image filename
		//g_warning("(%p) self->priv->snippetExtBgRGB = %p", self, self->priv->snippetExtBgRGB);
#endif

		//g_warning("(%p) self->priv->beecon_lt0_ImgFilename = %p", self, self->priv->beecon_lt0_ImgFilename);
		g_free(self->priv->beecon_lt0_ImgFilename);self->priv->beecon_lt0_ImgFilename=NULL;
		self->priv->beecon_lt0_ImgFilename = g_strdup(queen_beecon_g_key_file_get_string (keyFile, sourceGroup, "beecon_lt0_ImgFilename", "queen-beecon-syserr.png"));//No Image filename
		//g_warning("(%p) self->priv->beecon_lt0_ImgFilename = %p", self, self->priv->beecon_lt0_ImgFilename);

		self->priv->beecon_lt0_ImgZoom = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "beecon_lt0_ImgZoom", 0);//0=100% 1=Fit to Widget
		self->priv->beecon_lt0_BgRGB = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "beecon_lt0_BgRGB", 2);//2=Gray

#ifdef xNEW_COLOR_DIALOG
		//g_warning("(%p) self->priv->beecon_lt0_ExtBgRGB = %p", self, self->priv->beecon_lt0_ExtBgRGB);
		g_free(self->priv->beecon_lt0_ExtBgRGB);self->priv->beecon_lt0_ExtBgRGB=NULL;
		self->priv->beecon_lt0_ExtBgRGB = g_strdup(queen_beecon_g_key_file_get_string (keyFile, sourceGroup, "beecon_lt0_ExtBgRGB", p_colors[self->priv->beecon_lt0_BgRGB].colorRGB));//No Image filename
		//g_warning("(%p) self->priv->beecon_lt0_ExtBgRGB = %p", self, self->priv->beecon_lt0_ExtBgRGB);
#endif

		//g_warning("(%p) self->priv->beecon_eq0_ImgFilename = %p", self, self->priv->beecon_eq0_ImgFilename);
		g_free(self->priv->beecon_eq0_ImgFilename);self->priv->beecon_eq0_ImgFilename=NULL;
		self->priv->beecon_eq0_ImgFilename = g_strdup(queen_beecon_g_key_file_get_string (keyFile, sourceGroup, "beecon_eq0_ImgFilename", "queen-beecon-appok.png"));//No Image filename
		//g_warning("(%p) self->priv->beecon_eq0_ImgFilename = %p", self, self->priv->beecon_eq0_ImgFilename);

		self->priv->beecon_eq0_ImgZoom = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "beecon_eq0_ImgZoom", 0);//0=100% 1=Fit to Widget
		self->priv->beecon_eq0_BgRGB = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "beecon_eq0_BgRGB", 3);//3=Green

#ifdef xNEW_COLOR_DIALOG
		//g_warning("(%p) self->priv->beecon_eq0_ExtBgRGB = %p", self, self->priv->beecon_eq0_ExtBgRGB);
		g_free(self->priv->beecon_eq0_ExtBgRGB);self->priv->beecon_eq0_ExtBgRGB=NULL;
		self->priv->beecon_eq0_ExtBgRGB = g_strdup(queen_beecon_g_key_file_get_string (keyFile, sourceGroup, "beecon_eq0_ExtBgRGB", p_colors[self->priv->beecon_eq0_BgRGB].colorRGB));//No Image filename
		//g_warning("(%p) self->priv->beecon_eq0_ExtBgRGB = %p", self, self->priv->beecon_eq0_ExtBgRGB);
#endif

		//g_warning("(%p) self->priv->beecon_eq1_ImgFilename = %p", self, self->priv->beecon_eq1_ImgFilename);
		g_free(self->priv->beecon_eq1_ImgFilename);self->priv->beecon_eq1_ImgFilename=NULL;
		self->priv->beecon_eq1_ImgFilename = g_strdup(queen_beecon_g_key_file_get_string (keyFile, sourceGroup, "beecon_eq1_ImgFilename", "queen-beecon-appwrn.png"));//No Image filename
		//g_warning("(%p) self->priv->beecon_eq1_ImgFilename = %p", self, self->priv->beecon_eq1_ImgFilename);

		self->priv->beecon_eq1_ImgZoom = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "beecon_eq1_ImgZoom", 0);//0=100% 1=Fit to Widget
		self->priv->beecon_eq1_BgRGB = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "beecon_eq1_BgRGB", 4);//4=yellow

#ifdef xNEW_COLOR_DIALOG
		//g_warning("(%p) self->priv->beecon_eq1_ExtBgRGB = %p", self, self->priv->beecon_eq1_ExtBgRGB);
		g_free(self->priv->beecon_eq1_ExtBgRGB);self->priv->beecon_eq1_ExtBgRGB=NULL;
		self->priv->beecon_eq1_ExtBgRGB = g_strdup(queen_beecon_g_key_file_get_string (keyFile, sourceGroup, "beecon_eq1_ExtBgRGB", p_colors[self->priv->beecon_eq1_BgRGB].colorRGB));//No Image filename
		//g_warning("(%p) self->priv->beecon_eq1_ExtBgRGB = %p", self, self->priv->beecon_eq1_ExtBgRGB);
#endif

		//g_warning("(%p) self->priv->beecon_ge2_ImgFilename = %p", self, self->priv->beecon_ge2_ImgFilename);
		g_free(self->priv->beecon_ge2_ImgFilename);self->priv->beecon_ge2_ImgFilename=NULL;
		self->priv->beecon_ge2_ImgFilename = g_strdup(queen_beecon_g_key_file_get_string (keyFile, sourceGroup, "beecon_ge2_ImgFilename", "queen-beecon-apperr.png"));//No Image filename
		//g_warning("(%p) self->priv->beecon_ge2_ImgFilename = %p", self, self->priv->beecon_ge2_ImgFilename);

		self->priv->beecon_ge2_ImgZoom = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "beecon_ge2_ImgZoom", 0);//0=100% 1=Fit to Widget
		self->priv->beecon_ge2_BgRGB = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "beecon_ge2_BgRGB", 5);//5=red

#ifdef xNEW_COLOR_DIALOG
		//g_warning("(%p) self->priv->beecon_ge2_ExtBgRGB = %p", self, self->priv->beecon_ge2_ExtBgRGB);
		g_free(self->priv->beecon_ge2_ExtBgRGB);self->priv->beecon_ge2_ExtBgRGB=NULL;
		self->priv->beecon_ge2_ExtBgRGB = g_strdup(queen_beecon_g_key_file_get_string (keyFile, sourceGroup, "beecon_ge2_ExtBgRGB", p_colors[self->priv->beecon_ge2_BgRGB].colorRGB));//No Image filename
		//g_warning("(%p) self->priv->beecon_ge2_ExtBgRGB = %p", self, self->priv->beecon_ge2_ExtBgRGB);
#endif

		//g_warning("(%p) self->priv->beecon_idxge2_ImgFilename = %p", self, self->priv->beecon_idxge2_ImgFilename);
		g_free(self->priv->beecon_idxge2_ImgFilename);self->priv->beecon_idxge2_ImgFilename=NULL;
		self->priv->beecon_idxge2_ImgFilename = g_strdup(queen_beecon_g_key_file_get_string (keyFile, sourceGroup, "beecon_idxge2_ImgFilename", "queen-beecon-index.png"));//No Image filename
		//g_warning("(%p) self->priv->beecon_idxge2_ImgFilename = %p", self, self->priv->beecon_idxge2_ImgFilename);

		self->priv->beecon_idxge2_ImgZoom = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "beecon_idxge2_ImgZoom", 0);//0=100% 1=Fit to Widget
		self->priv->beecon_idxge2_BgRGB = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "beecon_idxge2_BgRGB", 11);//5=aqua

#ifdef xNEW_COLOR_DIALOG
		//g_warning("(%p) self->priv->beecon_idxge2_ExtBgRGB = %p", self, self->priv->beecon_idxge2_ExtBgRGB);
		g_free(self->priv->beecon_idxge2_ExtBgRGB);self->priv->beecon_idxge2_ExtBgRGB=NULL;
		self->priv->beecon_idxge2_ExtBgRGB = g_strdup(queen_beecon_g_key_file_get_string (keyFile, sourceGroup, "beecon_idxge2_ExtBgRGB", p_colors[self->priv->beecon_idxge2_BgRGB].colorRGB));//No Image filename
		//g_warning("(%p) self->priv->beecon_idxge2_ExtBgRGB = %p", self, self->priv->beecon_idxge2_ExtBgRGB);
#endif

		self->priv->widWidth = queen_beecon_g_key_file_get_double (keyFile, sourceGroup, "widWidth", 130.0);//130px
		self->priv->widHeight = queen_beecon_g_key_file_get_double (keyFile, sourceGroup, "widHeight", 115.0);//115px

//----------
		//g_warning("(%p) self->priv->cmdImgFilename = %p", self, self->priv->cmdImgFilename);
		g_free(self->priv->cmdImgFilename);self->priv->cmdImgFilename=NULL;
		self->priv->cmdImgFilename = g_strdup(queen_beecon_g_key_file_get_string (keyFile, sourceGroup, "cmdImgFilename", "queen-beecon.png"));//No Image filename
		//g_warning("(%p) self->priv->cmdImgFilename = %p", self, self->priv->cmdImgFilename);

		self->priv->cmdImgZoom = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "cmdImgZoom", 0);//0=100% 1=Fit to Widget
		self->priv->cmdFgRGB = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "cmdFgRGB", 1);//1-White

#ifdef xNEW_COLOR_DIALOG
		//g_warning("(%p) self->priv->cmdExtFgRGB = %p", self, self->priv->cmdExtFgRGB);
		g_free(self->priv->cmdExtFgRGB);self->priv->cmdExtFgRGB=NULL;
		self->priv->cmdExtFgRGB = g_strdup(queen_beecon_g_key_file_get_string (keyFile, sourceGroup, "cmdExtFgRGB", p_colors[self->priv->cmdFgRGB].colorRGB));//No Image filename
		//g_warning("(%p) self->priv->cmdExtFgRGB = %p", self, self->priv->cmdExtFgRGB);
#endif

		self->priv->cmdTextAngle = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "cmdTextAngle", 0); //Horizontal, Left to Right
		self->priv->cmdVisibilityPosition = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "cmdVisibilityPosition", 2);//2=top-center
		self->priv->cmdImgVisibilityPosition = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "cmdImgVisibilityPosition", 5);//1=center
		self->priv->cmdJustify = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "cmdJustify", 0);//0=left
		self->priv->cmdFontName = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "cmdFontName", 3);//
		self->priv->cmdFontSize = queen_beecon_g_key_file_get_double (keyFile, sourceGroup, "cmdFontSize", 12);//12

		gchar *cmdFontTtl = g_strdup_printf("%s %s %ld", p_fonts[self->priv->cmdFontName/4], self->priv->cmdFontName%4?p_fonts_types[self->priv->cmdFontName%4]:"", (long) self->priv->cmdFontSize);//AP1
		//g_warning("(%p) Command Font: %s",self, cmdFontTtl);
		g_free(self->priv->cmdExtFont);self->priv->cmdExtFont=NULL;
		self->priv->cmdExtFont = g_strdup(queen_beecon_g_key_file_get_string (keyFile, sourceGroup, "cmdExtFont", cmdFontTtl));//No Image filename
		g_free(cmdFontTtl);
		//g_warning("(%p) self->priv->cmdExtFont = [%p] %s", self, self->priv->cmdExtFont, self->priv->cmdExtFont);

//----------
		//g_warning("(%p) self->priv->resImgFilename = %p", self, self->priv->resImgFilename);
		g_free(self->priv->resImgFilename);self->priv->resImgFilename=NULL;
		self->priv->resImgFilename = g_strdup(queen_beecon_g_key_file_get_string (keyFile, sourceGroup, "resImgFilename", "queen-beecon-resimg.png"));//No Image filename
		//g_warning("(%p) self->priv->resImgFilename = %p", self, self->priv->resImgFilename);

		self->priv->resImgZoom = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "resImgZoom", 0);//0=100% 1=Fit to Widget
		self->priv->resFgRGB = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "resFgRGB", 1);//1=White
#ifdef xNEW_COLOR_DIALOG
		//g_warning("(%p) self->priv->resExtFgRGB = %p", self, self->priv->resExtFgRGB);
		g_free(self->priv->resExtFgRGB);self->priv->resExtFgRGB=NULL;
		self->priv->resExtFgRGB = g_strdup(queen_beecon_g_key_file_get_string (keyFile, sourceGroup, "resExtFgRGB", p_colors[self->priv->resFgRGB].colorRGB));//No Image filename
		//g_warning("(%p) self->priv->resExtFgRGB = %p", self, self->priv->resExtFgRGB);
#endif

		self->priv->resTextAngle = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "resTextAngle", 0); //Horizontal, Left to Right
		self->priv->resVisibilityPosition = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "resVisibilityPosition", 8);//center-center
		self->priv->resImgVisibilityPosition = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "resImgVisibilityPosition", 9);//bottom-center
		self->priv->resJustify = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "resJustify", 0);//0=left

		self->priv->resFontName = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "resFontName", 2);//
		self->priv->resFontSize = queen_beecon_g_key_file_get_double (keyFile, sourceGroup, "resFontSize", 12);//12

		gchar *resFontTtl = g_strdup_printf("%s %s %ld", p_fonts[self->priv->resFontName/4], self->priv->resFontName%4?p_fonts_types[self->priv->resFontName%4]:"", (long) self->priv->resFontSize);//AP1
		//g_warning("(%p) Result Font: %s",self, resFontTtl);
		g_free(self->priv->resExtFont);self->priv->resExtFont=NULL;
		self->priv->resExtFont = g_strdup(queen_beecon_g_key_file_get_string (keyFile, sourceGroup, "resExtFont", resFontTtl));//No Image filename
		g_free(resFontTtl);
		//g_warning("(%p) self->priv->resExtFont = [%p] %s", self, self->priv->resExtFont, self->priv->resExtFont);
//----------
		//g_warning("(%p) self->priv->instanceTitle = %p [%s]", self, self->priv->instanceTitle, self->priv->instanceTitle);
		if (self->priv->instanceTitle!=NULL) g_free(self->priv->instanceTitle); self->priv->instanceTitle = NULL;
		self->priv->instanceTitle = queen_beecon_g_key_file_get_string (keyFile, sourceGroup, "instanceTitle", NULL); //If value not found assume first command in fixed list
		//g_warning("(%p) self->priv->instanceTitle = %p [%s]", self, self->priv->instanceTitle, self->priv->instanceTitle);

		//g_warning("(%p) self->priv->instanceCmd = %p [%s]", self, self->priv->instanceCmd, self->priv->instanceCmd);
		if (self->priv->instanceCmd!=NULL) g_free(self->priv->instanceCmd); self->priv->instanceCmd = NULL;
		self->priv->instanceCmd = queen_beecon_g_key_file_get_string (keyFile, sourceGroup, "instanceCmd", NULL); //If value not found assume first command in fixed list
		//g_warning("(%p) self->priv->instanceCmd = %p [%s]", self, self->priv->instanceCmd, self->priv->instanceCmd);
//----------
		//BEGIN update policy
		self->priv->updOnStartup = queen_beecon_g_key_file_get_boolean (keyFile, sourceGroup, "updOnStartup", FALSE);//FALSE= Do NOT Update when widget launched
		self->priv->updOnClick = queen_beecon_g_key_file_get_boolean (keyFile, sourceGroup, "updOnClick", TRUE);//TRUE= Update when clicked
		self->priv->updOnDesktop = queen_beecon_g_key_file_get_boolean (keyFile, sourceGroup, "updOnDesktop", FALSE);//TRUE= Do NOT Update when widget's desktop switched
		self->priv->delayIndex = (guint) queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "delayIndex", 0);//0=Assume no timer event
		if (self->priv->delayIndex) self->priv->delaySeconds = GetSeconds(self->priv->delayIndex);
		self->priv->customIntervalSecs = (guint) queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "customIntervalSecs", 0);//0=Assume no timer event
		if (self->priv->delayIndex==9) self->priv->delaySeconds = self->priv->customIntervalSecs;
		self->priv->updNeworkPolicy = (guint) queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "updNeworkPolicy", NETWORK__UNRELATED);
//---------- DBUS parameters

#ifdef DBUS_MONITOR_MODE
		self->priv->updOnDBUS = queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "updOnDBUS", 0);//FALSE= Do NOT Update on DBUS events
		self->priv->updOnDBUSBus = (guint) queen_beecon_g_key_file_get_integer (keyFile, sourceGroup, "updOnDBUSBus", 0); //Defaults to System DBUS

		//g_warning("(%p) self->priv->updOnDBUSMatchRule = %p [%s]", self, self->priv->updOnDBUSMatchRule, self->priv->updOnDBUSMatchRule);
		if (self->priv->updOnDBUSMatchRule!=NULL) g_free(self->priv->updOnDBUSMatchRule); self->priv->updOnDBUSMatchRule = NULL;
		self->priv->updOnDBUSMatchRule = g_strdup(queen_beecon_g_key_file_get_string (keyFile, sourceGroup, "updOnDBUSMatchRule", ""));
		//g_warning("(%p) self->priv->updOnDBUSMatchRule = %p [%s]", self, self->priv->updOnDBUSMatchRule, self->priv->updOnDBUSMatchRule);
#endif
		//END
	}
	g_key_file_free (keyFile);
	if (!isImportFromADB) g_free (filename);

	queen_beecon_write_settings (self, TRUE);
	//g_warning("(%p) Settings file loaded successfully", self);
}

static void queen_beecon_write_settings (QueenBeecon *self, gboolean needInstanceSettings)
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	GKeyFile *keyFile=NULL;
	gboolean fileExists;

	gchar *fileData=NULL;
	FILE *iniFile=NULL;
	gsize size;
	gchar *filename=NULL;

	if(self->priv->widgetID == NULL) {
		//g_warning("(%p) Widget instance not initialized, not writing settings..", self);
		return;
	}

	keyFile = g_key_file_new();
	//g_warning("(%p) keyfile %p", self, keyFile);

	filename = g_strconcat (HOME_DIR, QUEEN_BEECON_SETTINGS_FILE, NULL);
	//g_warning("(%p) filename %s", self, filename);
	fileExists = g_key_file_load_from_file (keyFile, filename, G_KEY_FILE_KEEP_COMMENTS, NULL);
	//g_warning("(%p) fileExists %d", self, fileExists);

	g_key_file_set_double (keyFile, "config", "version", QUEEN_BEECON_SETTINGS_VERSION);

	if(self->priv->c_titles != NULL && self->priv->c_commands != NULL)
	{
		//g_warning("(%p) self->priv->c_titles=%p self->priv->c_commands=%p", self, self->priv->c_titles, self->priv->c_commands);
		g_key_file_set_string_list(keyFile, "config", "c_titles", (const gchar **)(self->priv->c_titles),self->priv->c_size);
		g_key_file_set_string_list(keyFile, "config", "c_commands", (const gchar **)(self->priv->c_commands),self->priv->c_size);
	}

	if (needInstanceSettings) {
		g_key_file_set_integer (keyFile, self->priv->widgetID, "widgetType", self->priv->widgetType);//AP3
		g_key_file_set_integer (keyFile, self->priv->widgetID, "widgetVisible", self->priv->widgetVisible);//AP3
		g_key_file_set_integer (keyFile, self->priv->widgetID, "operationalStatus", self->priv->operationalStatus);//AP3
		g_key_file_set_boolean (keyFile, self->priv->widgetID, "hideCanvas", self->priv->hideCanvas);//FALSE=Show Canvas by default
		g_key_file_set_integer (keyFile, self->priv->widgetID, "snippetBgRGB", self->priv->snippetBgRGB);//AP3
		g_key_file_set_string (keyFile, self->priv->widgetID, "snippetExtBgRGB", self->priv->snippetExtBgRGB);//AP3
		g_key_file_set_integer (keyFile, self->priv->widgetID, "beecon_lt0_ImgZoom", self->priv->beecon_lt0_ImgZoom);//AP3
		g_key_file_set_integer (keyFile, self->priv->widgetID, "beecon_lt0_BgRGB", self->priv->beecon_lt0_BgRGB);//AP3
		g_key_file_set_string (keyFile, self->priv->widgetID, "beecon_lt0_ExtBgRGB", self->priv->beecon_lt0_ExtBgRGB);//AP3
		g_key_file_set_string (keyFile, self->priv->widgetID, "beecon_lt0_ImgFilename", self->priv->beecon_lt0_ImgFilename);//AP3
		g_key_file_set_integer (keyFile, self->priv->widgetID, "beecon_eq0_ImgZoom", self->priv->beecon_eq0_ImgZoom);//AP3
		g_key_file_set_integer (keyFile, self->priv->widgetID, "beecon_eq0_BgRGB", self->priv->beecon_eq0_BgRGB);//AP3
		g_key_file_set_string (keyFile, self->priv->widgetID, "beecon_eq0_ExtBgRGB", self->priv->beecon_eq0_ExtBgRGB);//AP3
		g_key_file_set_string (keyFile, self->priv->widgetID, "beecon_eq0_ImgFilename", self->priv->beecon_eq0_ImgFilename);//AP3
		g_key_file_set_integer (keyFile, self->priv->widgetID, "beecon_eq1_ImgZoom", self->priv->beecon_eq1_ImgZoom);//AP3
		g_key_file_set_integer (keyFile, self->priv->widgetID, "beecon_eq1_BgRGB", self->priv->beecon_eq1_BgRGB);//AP3
		g_key_file_set_string (keyFile, self->priv->widgetID, "beecon_eq1_ExtBgRGB", self->priv->beecon_eq1_ExtBgRGB);//AP3
		g_key_file_set_string (keyFile, self->priv->widgetID, "beecon_eq1_ImgFilename", self->priv->beecon_eq1_ImgFilename);//AP3
		g_key_file_set_integer (keyFile, self->priv->widgetID, "beecon_ge2_ImgZoom", self->priv->beecon_ge2_ImgZoom);//AP3
		g_key_file_set_integer (keyFile, self->priv->widgetID, "beecon_ge2_BgRGB", self->priv->beecon_ge2_BgRGB);//AP3
		g_key_file_set_string (keyFile, self->priv->widgetID, "beecon_ge2_ExtBgRGB", self->priv->beecon_ge2_ExtBgRGB);//AP3
		g_key_file_set_string (keyFile, self->priv->widgetID, "beecon_ge2_ImgFilename", self->priv->beecon_ge2_ImgFilename);//AP3
		g_key_file_set_integer (keyFile, self->priv->widgetID, "beecon_idxge2_ImgZoom", self->priv->beecon_idxge2_ImgZoom);//AP3
		g_key_file_set_integer (keyFile, self->priv->widgetID, "beecon_idxge2_BgRGB", self->priv->beecon_idxge2_BgRGB);//AP3
		g_key_file_set_string (keyFile, self->priv->widgetID, "beecon_idxge2_ExtBgRGB", self->priv->beecon_idxge2_ExtBgRGB);//AP3
		g_key_file_set_string (keyFile, self->priv->widgetID, "beecon_idxge2_ImgFilename", self->priv->beecon_idxge2_ImgFilename);//AP3
		g_key_file_set_double (keyFile, self->priv->widgetID, "widWidth", self->priv->widWidth);
		g_key_file_set_double (keyFile, self->priv->widgetID, "widHeight", self->priv->widHeight);

		if(self->priv->instanceTitle == NULL || self->priv->instanceCmd == NULL)
		{
			//g_warning("(%p) self->priv->instanceTitle = %p [%s]", self, self->priv->instanceTitle, self->priv->instanceTitle);
			if (self->priv->instanceTitle != NULL) {g_free(self->priv->instanceTitle);self->priv->instanceTitle = NULL;}
			self->priv->instanceTitle = g_strdup(self->priv->c_titles[0]);
			//g_warning("(%p) self->priv->instanceTitle = %p [%s]", self, self->priv->instanceTitle, self->priv->instanceTitle);

			//g_warning("(%p) self->priv->instanceCmd = %p [%s]", self, self->priv->instanceCmd, self->priv->instanceCmd);
			if (self->priv->instanceCmd != NULL) {g_free(self->priv->instanceCmd);self->priv->instanceCmd = NULL;}
			self->priv->instanceCmd = g_strdup(self->priv->c_commands[0]);
			//g_warning("(%p) self->priv->instanceCmd = %p [%s]", self, self->priv->instanceCmd, self->priv->instanceCmd);
		}
		g_key_file_set_string (keyFile, self->priv->widgetID, "instanceTitle", self->priv->instanceTitle);
		g_key_file_set_string (keyFile, self->priv->widgetID, "instanceCmd", self->priv->instanceCmd);
		g_key_file_set_string (keyFile, self->priv->widgetID, "cmdImgFilename", self->priv->cmdImgFilename);//AP3
		g_key_file_set_integer (keyFile, self->priv->widgetID, "cmdImgZoom", self->priv->cmdImgZoom);//AP3
		g_key_file_set_integer (keyFile, self->priv->widgetID, "cmdFgRGB", self->priv->cmdFgRGB);//AP3
		g_key_file_set_string (keyFile, self->priv->widgetID, "cmdExtFgRGB", self->priv->cmdExtFgRGB);//AP3
		g_key_file_set_integer (keyFile, self->priv->widgetID, "cmdTextAngle", self->priv->cmdTextAngle);//AP1
		g_key_file_set_integer (keyFile, self->priv->widgetID, "cmdVisibilityPosition", self->priv->cmdVisibilityPosition);//AP2
		g_key_file_set_integer (keyFile, self->priv->widgetID, "cmdImgVisibilityPosition", self->priv->cmdImgVisibilityPosition);//AP2
		g_key_file_set_integer (keyFile, self->priv->widgetID, "cmdJustify", self->priv->cmdJustify);//AP2
		g_key_file_set_string (keyFile, self->priv->widgetID, "cmdExtFont", self->priv->cmdExtFont);//AP3
		g_key_file_set_integer (keyFile, self->priv->widgetID, "cmdFontName", self->priv->cmdFontName);//AP1
		g_key_file_set_double (keyFile, self->priv->widgetID, "cmdFontSize", self->priv->cmdFontSize);//AP1
		g_key_file_set_string (keyFile, self->priv->widgetID, "resImgFilename", self->priv->resImgFilename);//AP3
		g_key_file_set_integer (keyFile, self->priv->widgetID, "resImgZoom", self->priv->resImgZoom);//AP3
		g_key_file_set_integer (keyFile, self->priv->widgetID, "resFgRGB", self->priv->resFgRGB);//AP3
		g_key_file_set_string (keyFile, self->priv->widgetID, "resExtFgRGB", self->priv->resExtFgRGB);//AP3
		g_key_file_set_integer (keyFile, self->priv->widgetID, "resTextAngle", self->priv->resTextAngle);//AP1
		g_key_file_set_integer (keyFile, self->priv->widgetID, "resVisibilityPosition", self->priv->resVisibilityPosition);//AP2
		g_key_file_set_integer (keyFile, self->priv->widgetID, "resImgVisibilityPosition", self->priv->resImgVisibilityPosition);//AP2
		g_key_file_set_integer (keyFile, self->priv->widgetID, "resJustify", self->priv->resJustify);//AP2
		g_key_file_set_string (keyFile, self->priv->widgetID, "resExtFont", self->priv->resExtFont);//AP3
		g_key_file_set_integer (keyFile, self->priv->widgetID, "resFontName", self->priv->resFontName);//AP1
		g_key_file_set_double (keyFile, self->priv->widgetID, "resFontSize", self->priv->resFontSize);//AP1
		g_key_file_set_boolean (keyFile, self->priv->widgetID, "updOnStartup", self->priv->updOnStartup);
		g_key_file_set_boolean (keyFile, self->priv->widgetID, "updOnClick", self->priv->updOnClick);
		g_key_file_set_boolean (keyFile, self->priv->widgetID, "updOnDesktop", self->priv->updOnDesktop);
		g_key_file_set_integer (keyFile, self->priv->widgetID, "delayIndex", self->priv->delayIndex);
		g_key_file_set_integer (keyFile, self->priv->widgetID, "customIntervalSecs", self->priv->customIntervalSecs);
		g_key_file_set_integer (keyFile, self->priv->widgetID, "updNeworkPolicy", self->priv->updNeworkPolicy);
#ifdef DBUS_MONITOR_MODE
		g_key_file_set_integer (keyFile, self->priv->widgetID,"updOnDBUS", 				self->priv->updOnDBUS);
		g_key_file_set_integer (keyFile, self->priv->widgetID,"updOnDBUSBus", 			self->priv->updOnDBUSBus);//AP3
		g_key_file_set_string  (keyFile, self->priv->widgetID,"updOnDBUSMatchRule", 	self->priv->updOnDBUSMatchRule);//AP3
#endif
	}
	filename = g_strconcat (HOME_DIR, QUEEN_BEECON_SETTINGS_FILE, NULL);
	//g_warning("(%p) filename %s", self, filename);

	fileData = g_key_file_to_data (keyFile, &size, NULL);
	//g_warning("(%p) fileData %p", self, fileData);

	iniFile = fopen (filename, "w");
	fputs (fileData, iniFile);
	fclose (iniFile);
	g_key_file_free (keyFile);
	g_free (fileData);
	g_free (filename);
}

//widget/touchscreen interaction callbacks
static void queen_beecon_button_press (GtkWidget *widget, GdkEventButton *event, QueenBeecon *self)
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	if (self->priv->operationalStatus==1) { // Keep Sleeping if disabled
		self->priv->isPressed = TRUE;
		gtk_widget_queue_draw (GTK_WIDGET (self));
		return;
	}
	if (self->priv->updOnClick) {
		self->priv->isPressed = TRUE;
		gtk_widget_queue_draw (GTK_WIDGET (self));
	}
}

static void queen_beecon_button_release (GtkWidget *widget, GdkEventButton *event, QueenBeecon *self)
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	if (self->priv->operationalStatus==1) { // Wake up and restore size and operations
		self->priv->isPressed = FALSE;
		self->priv->operationalStatus=0;
		queen_beecon_write_settings (self, TRUE);
		if (self->priv->updOnDBUS && self->priv->dbus_mon_connection==NULL && self->priv->operationalStatus==0) { //Is DBUS Monitor active?
			g_warning("(%p) DBUS monitor starting, rearm connection, match and filter", self);
			if (!queen_beecon_dbus_monitor_manager(self, QBW_INIT_DBUS_MONITOR, self->priv->updOnDBUSBus, self->priv->updOnDBUSMatchRule)) { // If error during reinitialization of DBUS monitor ... restore previous settings
				self->priv->updOnDBUS          = 0;
			}
		}
		if (self->priv->updOnStartup && !self->priv->updOnDBUS) { // do we have to update on startup?
			queen_beecon_update_content (self, qbwExecReason[QBW_WAKEUP_CLICK]);
		} else {
			queen_beecon_update_content_layout (self); // No... only update layout
		}
		gtk_widget_queue_draw (GTK_WIDGET (self));
		return;
	}
	if (self->priv->updOnClick) {
		self->priv->isPressed = FALSE;
		queen_beecon_update_content(self, qbwExecReason[QBW_CLICK]);
		gtk_widget_queue_draw (GTK_WIDGET (self));
	}
}

static void queen_beecon_leave_event (GtkWidget *widget, GdkEventCrossing *event, QueenBeecon *self)
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	if (self->priv->operationalStatus==1) { // Keep Sleeping if disabled
		self->priv->isPressed = FALSE;
		gtk_widget_queue_draw (GTK_WIDGET (self));
		return;
	}
	if (self->priv->updOnClick) {
		self->priv->isPressed = FALSE;
		gtk_widget_queue_draw (GTK_WIDGET (self));
	}
}

static void queen_beecon_check_desktop (GObject *gobject, GParamSpec *pspec, QueenBeecon *self)
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	if (self->priv->operationalStatus==1) { // Keep Sleeping if disabled
		gtk_widget_queue_draw (GTK_WIDGET (self));
		return;
	}
	if (self->priv->updOnDesktop) {
		queen_beecon_update_content (self, qbwExecReason[QBW_DESKTOP_SWITCH]);
		gtk_widget_queue_draw (GTK_WIDGET (self));
	}
}

static gboolean queen_beecon_connection_event (ConIcConnection *connection, ConIcConnectionEvent *event, QueenBeecon *self)
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	ConIcConnectionStatus status = con_ic_connection_event_get_status(event);
	if(status == CON_IC_STATUS_CONNECTED) {
		self->priv->isConnected = TRUE;
	} else {
		self->priv->isConnected = FALSE;
	}
	if (self->priv->operationalStatus==1) { // Keep Sleeping if disabled
		gtk_widget_queue_draw (GTK_WIDGET (self));
		return TRUE;
	}
	if(self->priv->updNeworkPolicy != NETWORK__UNRELATED) {
		queen_beecon_update_content(self, qbwExecReason[QBW_CONNECTION_EVENT]);
	}
	return TRUE;
}

//D-Bus CB
static void queen_beecon_dbus_cb_need_update_content_layout (QueenBeecon *self, const gchar *update)
{
	if (!g_strcmp0(update,"update_layout")) queen_beecon_update_content_layout (self);
	if (!g_strcmp0(update,"update_content")) queen_beecon_update_content (self, qbwExecReason[QBW_DBUS_SET_PARAM_UPDATE]);
}

static gboolean queen_beecon_dbus_cb_dbus_method_monitor (QueenBeecon *self, const gchar *newStatus, GError **error)
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	hildon_banner_show_informationf (NULL, NULL, "dbus_method_monitor@qbw(%s) %s", self->priv->qbwDbusId, newStatus);

	if (!newStatus) {g_set_error (error, DBUS_GERROR, DBUS_GERROR_REMOTE_EXCEPTION, "No Status");return FALSE;}

	self->priv->dMM = !g_strcmp0(newStatus,"on")?TRUE:FALSE;
	return TRUE;
}

static gboolean queen_beecon_dbus_cb_reset_rearm_timer (QueenBeecon *self, GError **error)
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	if (self->priv->dMM) hildon_banner_show_informationf (NULL, NULL, "reset_rearm_timer@qbw(%s)", self->priv->qbwDbusId);

	if (self->priv->updateTimerID) { // New instance loaded, we assume timers need reset
		g_warning("(%p) removing self->priv->updateTimerID=%d", self, self->priv->updateTimerID);
		g_source_remove (self->priv->updateTimerID);
	}
	if (self->priv->delaySeconds > 0 && self->priv->operationalStatus==0) { // New instance loaded, we assume timers need rearm if instance is enabled
		g_warning("(%p) re-arming execution timer, delaySeconds=%d", self, self->priv->delaySeconds);
		self->priv->updateTimerID = g_timeout_add_seconds (self->priv->delaySeconds, (GSourceFunc)queen_beecon_update_content, self);
	}
	return TRUE;
}

static gboolean queen_beecon_dbus_cb_dbus_show (QueenBeecon *self, GError **error)
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	if (self->priv->dMM) hildon_banner_show_informationf (NULL, NULL, "show@qbw(%s)", self->priv->qbwDbusId);
	self->priv->widgetVisible = 1; //Show widget
	queen_beecon_write_settings (self, TRUE);
	queen_beecon_update_content_layout (self);
	return TRUE;
}

static gboolean queen_beecon_dbus_cb_dbus_hide (QueenBeecon *self, GError **error)
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	if (self->priv->dMM) hildon_banner_show_informationf (NULL, NULL, "hide@qbw(%s)", self->priv->qbwDbusId);
	self->priv->widgetVisible = 0; //Hide Widget
	queen_beecon_write_settings (self, TRUE);
	queen_beecon_update_content_layout (self);
	return TRUE;
}

static gboolean queen_beecon_dbus_cb_dbus_wakeup (QueenBeecon *self, GError **error)
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	if (self->priv->dMM) hildon_banner_show_informationf (NULL, NULL, "wakeup@qbw(%s)", self->priv->qbwDbusId);
	if (self->priv->operationalStatus==0) return TRUE;
	self->priv->operationalStatus=0;
	queen_beecon_write_settings (self, TRUE);
	if( (self->priv->updateTimerID == 0) && (self->priv->delaySeconds > 0)) {
		g_warning("(%p) re-arming execution timer, delaySeconds=%d", self, self->priv->delaySeconds);
		self->priv->updateTimerID = g_timeout_add_seconds (self->priv->delaySeconds, (GSourceFunc)queen_beecon_update_content, self);
	}
	if (self->priv->updOnDBUS && self->priv->dbus_mon_connection==NULL && self->priv->operationalStatus==0) { //Is DBUS Monitor active?
		g_warning("(%p) DBUS monitor starting, rearm connection, match and filter", self);
		if (!queen_beecon_dbus_monitor_manager(self, QBW_INIT_DBUS_MONITOR, self->priv->updOnDBUSBus, self->priv->updOnDBUSMatchRule)) { // If error during reinitialization of DBUS monitor ... restore previous settings
			self->priv->updOnDBUS          = 0;
		}
	}
	if (!self->priv->updOnDBUS && self->priv->updOnStartup) queen_beecon_update_content (self, qbwExecReason[QBW_DBUS_WAKEUP]);
	else queen_beecon_update_content_layout (self);
	return TRUE;
}

static gboolean queen_beecon_dbus_cb_dbus_sleep (QueenBeecon *self, GError **error)
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	if (self->priv->dMM) hildon_banner_show_informationf (NULL, NULL, "sleep@qbw@qbw(%s)", self->priv->qbwDbusId);
	if (self->priv->operationalStatus==1) return TRUE;
	self->priv->operationalStatus=1;
	queen_beecon_write_settings (self, TRUE);
	if (self->priv->updateTimerID) {
		g_warning("(%p) removing self->priv->updateTimerID=%d", self, self->priv->updateTimerID);
		g_source_remove (self->priv->updateTimerID);
	}

	queen_beecon_dbus_monitor_manager(self, QBW_DEINIT_DBUS_MONITOR, self->priv->updOnDBUSBus, self->priv->updOnDBUSMatchRule); // Disable DBUS Monitor

	queen_beecon_update_content_layout (self);
	return TRUE;
}

static gboolean queen_beecon_dbus_cb_dbus_update_content (QueenBeecon *self, GError **error)
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	if (self->priv->dMM) hildon_banner_show_informationf (NULL, NULL, "update_content@qbw(%s)",  self->priv->qbwDbusId);
	queen_beecon_update_content (self, qbwExecReason[QBW_DBUS_UPDATE_CONTENT]);
	return TRUE;
}

static gboolean queen_beecon_dbus_cb_dbus_update_layout (QueenBeecon *self, GError **error)
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	if (self->priv->dMM) hildon_banner_show_informationf (NULL, NULL, "update_layout@qbw(%s)", self->priv->qbwDbusId);
	queen_beecon_update_content_layout (self);
	return TRUE;
}

static gboolean queen_beecon_dbus_cb_dbus_exec (QueenBeecon *self, const gchar *cmd, GError **error)
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	gchar *backupCmd = self->priv->instanceCmd; // Backup current Instance Command
	if (self->priv->dMM) hildon_banner_show_informationf (NULL, NULL, "exec@qbw(%s) %s", self->priv->qbwDbusId, cmd);

	if (!cmd) {g_set_error (error, DBUS_GERROR, DBUS_GERROR_REMOTE_EXCEPTION, "No Command");return FALSE;}
	self->priv->instanceCmd = (gchar *)cmd; // Instantiate new one-shot temporary command
	queen_beecon_update_content (self, qbwExecReason[QBW_DBUS_EXEC]); // And run it
	self->priv->instanceCmd = backupCmd; // Revert back to saved command

	return TRUE;
}

static gboolean queen_beecon_dbus_cb_dbus_set_param_string (QueenBeecon *self, const gchar *param, const gchar *value, const gchar *update, GError **error)
{
	gboolean RC = FALSE;
	g_warning ("(%p) %s",self, G_STRFUNC);
	if (self->priv->dMM) hildon_banner_show_informationf (NULL, NULL, "set_param_string@qbw(%s) %s %s %s", self->priv->qbwDbusId, param, value, update);

	if (!param || !value) {g_set_error (error, DBUS_GERROR, DBUS_GERROR_REMOTE_EXCEPTION, "No Param or Value");return FALSE;}

	RC = write_settings_have_key(self->priv->widgetID, param, (void *) value, 's');
	if (!RC) return FALSE;
	queen_beecon_read_settings (self, TRUE, FALSE, NULL);

	queen_beecon_dbus_cb_need_update_content_layout(self, update);
	return TRUE;
}

static gboolean queen_beecon_dbus_cb_dbus_set_param_int32 (QueenBeecon *self, const gchar *param, const gint value, const gchar *update, GError **error)
{
	gboolean RC = FALSE;
	g_warning ("(%p) %s",self, G_STRFUNC);
	if (self->priv->dMM) hildon_banner_show_informationf (NULL, NULL, "set_param_int32@qbw(%s) %s %d %s", self->priv->qbwDbusId, param, value, update);

	if (!param) {g_set_error (error, DBUS_GERROR, DBUS_GERROR_REMOTE_EXCEPTION, "No Param or Value");return FALSE;}

	RC = write_settings_have_key(self->priv->widgetID, param, (void *) &value, 'i');
	if (!RC) return FALSE;
	queen_beecon_read_settings (self, TRUE, FALSE, NULL);

	queen_beecon_dbus_cb_need_update_content_layout(self, update);
	return TRUE;
}

static gboolean queen_beecon_dbus_cb_dbus_set_param_uint32 (QueenBeecon *self, const gchar *param, const guint value, const gchar *update, GError **error)
{
	gboolean RC = FALSE;
	g_warning ("(%p) %s",self, G_STRFUNC);
	if (self->priv->dMM) hildon_banner_show_informationf (NULL, NULL, "set_param_uint32@qbw(%s) %s %d %s", self->priv->qbwDbusId, param, value, update);

	if (!param || !value) {g_set_error (error, DBUS_GERROR, DBUS_GERROR_REMOTE_EXCEPTION, "No Param or Value");return FALSE;}

	RC = write_settings_have_key(self->priv->widgetID, param, (void *) &value, 'u');
	if (!RC) return FALSE;
	queen_beecon_read_settings (self, TRUE, FALSE, NULL);

	queen_beecon_dbus_cb_need_update_content_layout(self, update);
	return TRUE;
}

static gboolean queen_beecon_dbus_cb_dbus_set_param_double (QueenBeecon *self, const gchar *param, const gdouble value, const gchar *update, GError **error)
{
	gboolean RC = FALSE;
	g_warning ("(%p) %s",self, G_STRFUNC);
	if (self->priv->dMM) hildon_banner_show_informationf (NULL, NULL, "set_param_double@qbw(%s) %s %f %s", self->priv->qbwDbusId, param, value, update);

	if (!param) {g_set_error (error, DBUS_GERROR, DBUS_GERROR_REMOTE_EXCEPTION, "No Param or Value");return FALSE;}

	RC = write_settings_have_key(self->priv->widgetID, param, (void *) &value, 'd');
	if (!RC) return FALSE;
	queen_beecon_read_settings (self, TRUE, FALSE, NULL);

	queen_beecon_dbus_cb_need_update_content_layout(self, update);
	return TRUE;
}

static gboolean queen_beecon_dbus_cb_dbus_set_param_boolean (QueenBeecon *self, const gchar *param, const gboolean value, const gchar *update, GError **error)
{
	gboolean RC = FALSE;
	g_warning ("(%p) %s",self, G_STRFUNC);
	if (self->priv->dMM) hildon_banner_show_informationf (NULL, NULL, "set_param_boolean@qbw(%s) %s %d %s", self->priv->qbwDbusId, param, value, update);

	if (!param) {g_set_error (error, DBUS_GERROR, DBUS_GERROR_REMOTE_EXCEPTION, "No Param or Value");return FALSE;}

	RC = write_settings_have_key(self->priv->widgetID, param, (void *) &value, 'b');
	if (!RC) return FALSE;
	queen_beecon_read_settings (self, TRUE, FALSE, NULL);

	queen_beecon_dbus_cb_need_update_content_layout(self, update);
	return TRUE;
}

static gboolean queen_beecon_dbus_cb_dbus_get_param (QueenBeecon *self, const gchar *param, gchar **value, GError **error)
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	if (self->priv->dMM) hildon_banner_show_informationf (NULL, NULL, "get_param@qbw(%s) %s", G_STRFUNC, self->priv->qbwDbusId, param);

	if (!param) {g_set_error (error, DBUS_GERROR, DBUS_GERROR_REMOTE_EXCEPTION, "No Param");return FALSE;}

	*value = read_settings_have_key (self->priv->widgetID, param);
	return TRUE;
}

static gboolean queen_beecon_dbus_cb_dbus_get_current_results_text (QueenBeecon *self, gchar **value, GError **error)
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	if (self->priv->dMM) hildon_banner_show_informationf (NULL, NULL, "get_current_results_text@qbw(%s)", G_STRFUNC, self->priv->qbwDbusId);

	*value = g_strdup(gtk_label_get_label(GTK_LABEL (self->priv->cmdResult_lb)));
	return TRUE;
}

static gboolean queen_beecon_dbus_cb_dbus_set_position (QueenBeecon *self, const gint widXOrigin, const gint widYOrigin, GError **error)
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	if (self->priv->dMM) hildon_banner_show_informationf (NULL, NULL, "set_position@qbw(%s) X=%d Y=%d", self->priv->qbwDbusId, widXOrigin, widYOrigin);

	gtk_window_move (GTK_WINDOW (self), widXOrigin, widYOrigin); // Remember our position ... maybe we need to move a little bit
	return TRUE;
}

static gboolean queen_beecon_dbus_cb_dbus_get_position (QueenBeecon *self, gint *widXOrigin, gint *widYOrigin, GError **error)
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	if (self->priv->dMM) hildon_banner_show_informationf (NULL, NULL, "get_position@qbw(%s)", self->priv->qbwDbusId);

	gtk_window_get_position (GTK_WINDOW (self), widXOrigin, widYOrigin); // Remember our position ... maybe we need to move a little bit
	return TRUE;
}

static gboolean queen_beecon_dbus_cb_dbus_get_exit_status (QueenBeecon *self, gint *exitStatus, GError **error)
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	if (self->priv->dMM) hildon_banner_show_informationf (NULL, NULL, "get_exit_status@qbw(%s)", self->priv->qbwDbusId);

	*exitStatus = self->priv->cmdExitStatus;
	return TRUE;
}

//Content/widget creation/update
static void queen_beecon_content_create (QueenBeecon *self)
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	self->priv->contents = gtk_event_box_new ();
	//g_warning ("(%p) gtk_event_box_new ()= %p",self, self->priv->contents);
	gtk_event_box_set_visible_window (GTK_EVENT_BOX (self->priv->contents), FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (self->priv->contents), 0);

	self->priv->tableLayout = gtk_table_new(1, 1, FALSE);
	//g_warning ("(%p) tableLayout gtk_table_new ()= %p",self, self->priv->tableLayout);

	queen_beecon_exec_animation_progress(self, QBW_INIT_PROGRESS_ANIMATION);

	// Create Title/Result Label
	self->priv->cmdTitle_lb = gtk_label_new ("Not Updated");
	//g_warning ("(%p) cmdTitle_lb gtk_label_new ()= %p",self, self->priv->cmdTitle_lb);
	//g_warning("(%p) gtk_table_attach self->priv->cmdTitle_lb=%p self->priv->tableLayout=%p", self, self->priv->cmdTitle_lb, self->priv->tableLayout);
	gtk_table_attach(GTK_TABLE(self->priv->tableLayout), self->priv->cmdTitle_lb, 0, 1, 0, 1, GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 0, 0);

	self->priv->cmdResult_lb = gtk_label_new ("Not Updated");
	//g_warning ("(%p) cmdResult_lb gtk_label_new ()= %p",self, self->priv->cmdResult_lb);
	//g_warning("(%p) gtk_table_attach self->priv->cmdResult_lb=%p self->priv->tableLayout=%p", self, self->priv->cmdResult_lb, self->priv->tableLayout);
	gtk_table_attach(GTK_TABLE(self->priv->tableLayout), GTK_WIDGET(self->priv->cmdResult_lb), 0, 1, 0, 1, GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 0, 0);

	GtkWidget *box = gtk_hbox_new (FALSE, 0);
	//g_warning ("(%p) box gtk_hbox_new ()= %p",self, box);
	gtk_box_pack_start (GTK_BOX (box), self->priv->tableLayout, FALSE, FALSE, 0);
	gtk_container_add (GTK_CONTAINER (self->priv->contents), box);

	gtk_box_pack_start (GTK_BOX (self->priv->homeWidget), self->priv->contents, FALSE, FALSE, 0);

	//widget drawing signal connections
	g_signal_connect (self->priv->contents, "button-release-event", G_CALLBACK (queen_beecon_button_release), self);
	g_signal_connect (self->priv->contents, "button-press-event", G_CALLBACK (queen_beecon_button_press), self);
	g_signal_connect (self->priv->contents, "leave-notify-event", G_CALLBACK (queen_beecon_leave_event), self);

	gtk_widget_show_all (self->priv->homeWidget);
}

static void queen_beecon_update_content_layout (QueenBeecon *self)
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	GdkColor color;
	PangoFontDescription *fd = NULL;//AP1
	gboolean isCmdImage = FALSE, isResImage = FALSE;
	gint rsImgZoomW=0, rsImgZoomH=0;
	gint cmImgZoomW=0, cmImgZoomH=0;
	gchar *rsImgFilename = NULL, *auxrsImgFilename = NULL, *sysrsImgFilename = NULL, *cmdImgFilename = NULL, *auxcmdImgFilename = NULL, *syscmdImgFilename = NULL;
	gchar *noImgFilename = g_strdup_printf("%s%s", SYSTEM_PUBLIC_ICON_DIR, "queen-beecon-noimg.png");
	//g_warning("(%p) No Image filename=[%s]", self, noImgFilename);

	if(self->priv->instanceCmd == NULL || self->priv->instanceTitle == NULL) {
		//g_warning("(%p) self->priv->instanceTitle = %p [%s]", self, self->priv->instanceTitle, self->priv->instanceTitle);
		//g_warning("(%p) self->priv->instanceCmd = %p [%s]", self, self->priv->instanceCmd, self->priv->instanceCmd);
		gtk_label_set_markup (GTK_LABEL (self->priv->cmdTitle_lb), "Error:");
		gtk_label_set_markup (GTK_LABEL (self->priv->cmdResult_lb), "No commands");
		return;
	}

	//g_warning("(%p) self->priv->instanceTitle = %p [%s]", self, self->priv->instanceTitle, self->priv->instanceTitle);
	gtk_label_set_markup (GTK_LABEL (self->priv->cmdTitle_lb), self->priv->instanceTitle);

	if (self->priv->operationalStatus==1) { // Widget instance is disabled and minimized on screen
		// Let's define widget geometry and size
		//g_warning ("(%p) Disabled Updating widget geometry w=%0.0f h=%0.0f",self, (float)60, (float)60);

		GdkGeometry hints;
		hints.min_width = (int)60;//AP3
		hints.min_height = (int)60;//AP3
		hints.max_width = (int)90;//AP3
		hints.max_height = (int)90;//AP3
		gtk_window_set_default_size (GTK_WINDOW (self), 60, 60);
		gtk_window_set_geometry_hints (GTK_WINDOW (self), self->priv->homeWidget, &hints, GDK_HINT_MIN_SIZE | GDK_HINT_MAX_SIZE);
		gtk_widget_set_size_request (GTK_WIDGET (self), (int)60, (int)60);//AP
		gtk_window_resize (GTK_WINDOW (self), (int)60, (int)60);//AP

		//g_warning("(%p) Disabled Let's process TITLE Output: Do we need result Image or Text?", self);
		if (self->priv->cmdTitle_img) gtk_widget_destroy(GTK_WIDGET(self->priv->cmdTitle_img));
		syscmdImgFilename = g_strconcat (SYSTEM_PUBLIC_ICON_DIR, "queen-beecon-zzz.png", NULL);
		//g_warning ("(%p) Disabled syscmdImgFilename = %s", self, syscmdImgFilename);
		//g_warning ("(%p) Disabled noImgFilename = %s", self, noImgFilename);
		GdkPixbuf      *cmdPixBuf = gdk_pixbuf_new_from_file_at_scale (syscmdImgFilename, -1, -1, TRUE, NULL);
		if (!cmdPixBuf) cmdPixBuf = gdk_pixbuf_new_from_file_at_scale (noImgFilename, -1, -1, TRUE, NULL);
		//g_warning ("(%p) Disabled cmdPixBuf = %p", self, cmdPixBuf);
		//g_warning ("(%p) Disabled self->priv->cmdTitle_img = %p", self, self->priv->cmdTitle_img);
		self->priv->cmdTitle_img = gtk_image_new_from_pixbuf (cmdPixBuf);
		//g_warning ("(%p) cmdTitle_img gtk_image_new_from_pixbuf (cmdPixBuf)= %p", self, self->priv->cmdTitle_img);
		//g_warning ("(%p) cmdImgVisibilityPosition self->priv->cmdTitle_img Absolute %d Relative rX=%0.1f rY=%0.1f", self, self->priv->cmdImgVisibilityPosition, ((self->priv->cmdImgVisibilityPosition-1)%3)*0.5,((self->priv->cmdImgVisibilityPosition-1)/3)*0.5);
		gtk_widget_set_size_request(GTK_WIDGET(self->priv->cmdTitle_img), 60, 60);
		gtk_misc_set_alignment(GTK_MISC (self->priv->cmdTitle_img),0.5,0.0);
		g_object_unref (cmdPixBuf);
		g_free(syscmdImgFilename);
		//g_warning("(%p) gtk_table_attach self->priv->cmdTitle_img=%p self->priv->tableLayout=%p", self, self->priv->cmdTitle_img, self->priv->tableLayout);
		gtk_table_attach(GTK_TABLE(self->priv->tableLayout), self->priv->cmdTitle_img, 0, 1, 0, 1, GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 0, 0);
		gtk_widget_show (GTK_WIDGET(self->priv->cmdTitle_img));
		if (!self->priv->widgetVisible) {
			//g_warning("(%p) gtk_widget_hide (GTK_WIDGET(self->priv->cmdTitle_img)); %p", self, self->priv->cmdTitle_img);
			gtk_widget_hide (GTK_WIDGET(self->priv->cmdTitle_img));
		}
		//g_warning("(%p) gtk_widget_hide (GTK_WIDGET(self->priv->cmdResult_img)); %p", self, self->priv->cmdResult_img);
		if (self->priv->cmdResult_img) gtk_widget_hide (GTK_WIDGET(self->priv->cmdResult_img));// Visible

		// Update Results Layout (Label/image Font + Colors + Alignment + Position + ...)
		fd = pango_font_description_from_string("Nokia,Sans 9");//AP1
		gtk_widget_modify_font(GTK_WIDGET(self->priv->cmdTitle_lb), fd);//AP1
		gdk_color_parse("#FFFFFF", &color);
		gtk_widget_modify_fg (GTK_WIDGET(self->priv->cmdTitle_lb), GTK_STATE_NORMAL, &color); // White text
		gtk_widget_set_size_request(GTK_WIDGET(self->priv->cmdTitle_lb), 60, 60);
		gtk_label_set_angle(GTK_LABEL(self->priv->cmdTitle_lb), 0);//
		gtk_misc_set_alignment(GTK_MISC (self->priv->cmdTitle_lb),0.5,1.0); // Bottom Center aligned
		gtk_misc_set_padding (GTK_MISC (self->priv->cmdTitle_lb), 1, 1);//AP1
		gtk_widget_show (GTK_WIDGET(self->priv->cmdTitle_lb));
		if (!self->priv->widgetVisible) {
			//g_warning("(%p) gtk_widget_hide (GTK_WIDGET(self->priv->cmdTitle_lb)); %p", self, self->priv->cmdTitle_lb);
			gtk_widget_hide (GTK_WIDGET(self->priv->cmdTitle_lb));
		}

		//g_warning("(%p) gtk_widget_hide (GTK_WIDGET(self->priv->cmdResult_lb)); %p", self, self->priv->cmdResult_lb);
		gtk_widget_hide (GTK_WIDGET(self->priv->cmdResult_lb));// Visible

		g_free(noImgFilename);noImgFilename=NULL;
		g_warning("(%p) Done drawing disabled instance", self);
		return;
	}

	// Let's define widget geometry and size
	//g_warning ("(%p) Updating widget geometry w=%0.0f h=%0.0f",self, self->priv->widWidth, self->priv->widHeight);
	GdkGeometry hints;
	hints.min_width = (int)(self->priv->widWidth);//AP3
	hints.min_height = (int)(self->priv->widHeight);//AP3
	hints.max_width = self->priv->widWidth>90?(int)(self->priv->widWidth):90;//AP3
	hints.max_height = self->priv->widHeight>90?(int)(self->priv->widHeight):90;//AP3
	gtk_window_set_default_size (GTK_WINDOW (self), self->priv->widWidth, self->priv->widHeight);
	gtk_window_set_geometry_hints (GTK_WINDOW (self), self->priv->homeWidget, &hints, GDK_HINT_MIN_SIZE | GDK_HINT_MAX_SIZE);
	gtk_widget_set_size_request (GTK_WIDGET (self), (int)(self->priv->widWidth), (int)(self->priv->widHeight));//AP
	gtk_window_resize (GTK_WINDOW (self), (int)(self->priv->widWidth), (int)(self->priv->widHeight));//AP

	gtk_widget_set_size_request(GTK_WIDGET(self->priv->cmdTitle_lb), self->priv->widWidth, self->priv->widHeight);
	gtk_widget_set_size_request(GTK_WIDGET(self->priv->cmdResult_lb), self->priv->widWidth, self->priv->widHeight);

	// Update Results Layout (Label/image Font + Colors + Alignment + Position + ...)
	fd = pango_font_description_from_string(self->priv->resExtFont);//AP1
	gtk_widget_modify_font(GTK_WIDGET(self->priv->cmdResult_lb), fd);//AP1

#ifdef xNEW_COLOR_DIALOG
	gdk_color_parse(self->priv->resExtFgRGB,&color);
#else
	gdk_color_parse(p_colors[self->priv->resFgRGB].colorRGB,&color);
#endif
	gtk_widget_modify_fg (GTK_WIDGET(self->priv->cmdResult_lb), GTK_STATE_NORMAL, &color);
	//g_warning ("(%p) resVisibilityPosition self->priv->cmdResult_lb Absolute %d Relative rX=%0.1f rY=%0.1f", self, self->priv->resVisibilityPosition, ((self->priv->resVisibilityPosition-1)%3)*0.5,((self->priv->resVisibilityPosition-1)/3)*0.5);
	gtk_misc_set_alignment(GTK_MISC (self->priv->cmdResult_lb),((self->priv->resVisibilityPosition-1)%3)*0.5,((self->priv->resVisibilityPosition-1)/3)*0.5);
	gtk_misc_set_padding (GTK_MISC (self->priv->cmdResult_lb), 2, 2);//AP1
	gtk_label_set_angle(GTK_LABEL(self->priv->cmdResult_lb), self->priv->resTextAngle*90.00);//
	gtk_label_set_justify(GTK_LABEL(self->priv->cmdResult_lb), self->priv->resJustify);
	if (self->priv->resVisibilityPosition && self->priv->widgetVisible) {
		//g_warning("(%p) showing self->priv->cmdResult_lb=%p", self, self->priv->cmdResult_lb);
		gtk_widget_show (GTK_WIDGET(self->priv->cmdResult_lb));
	} else {
		//g_warning("(%p) hiding self->priv->cmdResult_lb=%p", self, self->priv->cmdResult_lb);
		gtk_widget_hide (GTK_WIDGET(self->priv->cmdResult_lb));
	}
	//v Results Image
	//g_warning("(%p) Let's process RESULT Output: Do we need result Image or Text?", self);
	if (self->priv->widgetType!=0) {
		g_warning("(%p) I'm SNIPPET (resImgFilename=%s)", self, self->priv->resImgFilename);
		if (self->priv->resImgFilename[0]!='\0' && self->priv->resImgFilename[0]!=';') {
			if (self->priv->resImgFilename[0]=='/') {// if / leading let's assume absolute path for img filename
				rsImgFilename = g_strconcat (self->priv->resImgFilename, NULL);
			} else {
				rsImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_PRIVATE_DIR, self->priv->resImgFilename, NULL);
				auxrsImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_MYDOCS_IMAGE_DIR, self->priv->resImgFilename, NULL);
				sysrsImgFilename = g_strconcat (SYSTEM_PUBLIC_ICON_DIR, self->priv->resImgFilename, NULL);
			}
			gint w=48,h=48;
			//g_warning ("(%p) Yes!!! auxrsImgFilename = %s", self, auxrsImgFilename);
			//g_warning ("(%p) Yes!!! rsImgFilename = %s", self, rsImgFilename);
			//g_warning ("(%p) Yes!!! sysrsImgFilename = %s", self, sysrsImgFilename);
			//g_warning ("(%p) Yes!!! noImgFilename = %s", self, noImgFilename);
			GdkPixbufFormat *resPixBufFmt = NULL;
			if (auxrsImgFilename) resPixBufFmt = gdk_pixbuf_get_file_info(auxrsImgFilename,&w,&h);
			if (!resPixBufFmt) resPixBufFmt = gdk_pixbuf_get_file_info(rsImgFilename,&w,&h);
			rsImgZoomW=self->priv->resImgZoom==0?-1:self->priv->resImgZoom==1?self->priv->widWidth:(self->priv->resImgZoom-1)*w*5/100;
			rsImgZoomH=self->priv->resImgZoom==0?-1:self->priv->resImgZoom==1?self->priv->widHeight:(self->priv->resImgZoom-1)*h*5/100;
			isResImage=TRUE;
		}
	} else {//AP3
		switch (self->priv->cmdExitStatus) {
		case -1:
			g_warning("(%p) I'm BEECON (lt0=%s)", self, self->priv->beecon_lt0_ImgFilename);
			if (self->priv->beecon_lt0_ImgFilename[0]!='\0' && self->priv->beecon_lt0_ImgFilename[0]!=';') {
				if (self->priv->beecon_lt0_ImgFilename[0]=='/') {// if / leading let's assume absolute path for img filename
					rsImgFilename = g_strconcat (self->priv->beecon_lt0_ImgFilename, NULL);
				} else {
					rsImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_PRIVATE_DIR, self->priv->beecon_lt0_ImgFilename, NULL);
					auxrsImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_MYDOCS_IMAGE_DIR, self->priv->beecon_lt0_ImgFilename, NULL);
					sysrsImgFilename = g_strconcat (SYSTEM_PUBLIC_ICON_DIR, self->priv->beecon_lt0_ImgFilename, NULL);
				}
				gint w=48,h=48;
				GdkPixbufFormat *resPixBufFmt = NULL;
				if (auxrsImgFilename) resPixBufFmt = gdk_pixbuf_get_file_info(auxrsImgFilename,&w,&h);
				if (!resPixBufFmt) resPixBufFmt = gdk_pixbuf_get_file_info(rsImgFilename,&w,&h);
				rsImgZoomW=self->priv->beecon_lt0_ImgZoom==0?-1:self->priv->beecon_lt0_ImgZoom==1?self->priv->widWidth:(self->priv->beecon_lt0_ImgZoom-1)*w*5/100;
				rsImgZoomH=self->priv->beecon_lt0_ImgZoom==0?-1:self->priv->beecon_lt0_ImgZoom==1?self->priv->widHeight:(self->priv->beecon_lt0_ImgZoom-1)*h*5/100;
				isResImage=TRUE;
			}
			break;
		case 0:
			g_warning("(%p) I'm BEECON (eq0=%s)", self, self->priv->beecon_eq0_ImgFilename);
			if (self->priv->beecon_eq0_ImgFilename[0]!='\0' && self->priv->beecon_eq0_ImgFilename[0]!=';') {
				if (self->priv->beecon_eq0_ImgFilename[0]=='/') {// if / leading let's assume absolute path for img filename
					rsImgFilename = g_strconcat (self->priv->beecon_eq0_ImgFilename, NULL);
				} else {
					rsImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_PRIVATE_DIR, self->priv->beecon_eq0_ImgFilename, NULL);
					auxrsImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_MYDOCS_IMAGE_DIR, self->priv->beecon_eq0_ImgFilename, NULL);
					sysrsImgFilename = g_strconcat (SYSTEM_PUBLIC_ICON_DIR, self->priv->beecon_eq0_ImgFilename, NULL);
				}
				gint w=48,h=48;
				GdkPixbufFormat *resPixBufFmt = NULL;
				if (auxrsImgFilename) resPixBufFmt = gdk_pixbuf_get_file_info(auxrsImgFilename,&w,&h);
				if (!resPixBufFmt) resPixBufFmt = gdk_pixbuf_get_file_info(rsImgFilename,&w,&h);
				rsImgZoomW=self->priv->beecon_eq0_ImgZoom==0?-1:self->priv->beecon_eq0_ImgZoom==1?self->priv->widWidth:(self->priv->beecon_eq0_ImgZoom-1)*w*5/100;
				rsImgZoomH=self->priv->beecon_eq0_ImgZoom==0?-1:self->priv->beecon_eq0_ImgZoom==1?self->priv->widHeight:(self->priv->beecon_eq0_ImgZoom-1)*h*5/100;
				isResImage=TRUE;
			}
			break;
		case 1:
			g_warning("(%p) I'm BEECON (eq1=%s)", self, self->priv->beecon_eq1_ImgFilename);
			if (self->priv->beecon_eq1_ImgFilename[0]!='\0' && self->priv->beecon_eq1_ImgFilename[0]!=';') {
				if (self->priv->beecon_eq1_ImgFilename[0]=='/') {// if / leading let's assume absolute path for img filename
					rsImgFilename = g_strconcat (self->priv->beecon_eq1_ImgFilename, NULL);
				} else {
					rsImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_PRIVATE_DIR, self->priv->beecon_eq1_ImgFilename, NULL);
					auxrsImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_MYDOCS_IMAGE_DIR, self->priv->beecon_eq1_ImgFilename, NULL);
					sysrsImgFilename = g_strconcat (SYSTEM_PUBLIC_ICON_DIR, self->priv->beecon_eq1_ImgFilename, NULL);
				}
				gint w=48,h=48;
				GdkPixbufFormat *resPixBufFmt = NULL;
				if (auxrsImgFilename) resPixBufFmt = gdk_pixbuf_get_file_info(auxrsImgFilename,&w,&h);
				if (!resPixBufFmt) resPixBufFmt = gdk_pixbuf_get_file_info(rsImgFilename,&w,&h);
				rsImgZoomW=self->priv->beecon_eq1_ImgZoom==0?-1:self->priv->beecon_eq1_ImgZoom==1?self->priv->widWidth:(self->priv->beecon_eq1_ImgZoom-1)*w*5/100;
				rsImgZoomH=self->priv->beecon_eq1_ImgZoom==0?-1:self->priv->beecon_eq1_ImgZoom==1?self->priv->widHeight:(self->priv->beecon_eq1_ImgZoom-1)*h*5/100;
				isResImage=TRUE;
			}
			break;
		case 2:
			g_warning("(%p) I'm BEECON (ge2=%s)", self, self->priv->beecon_ge2_ImgFilename);
			if (self->priv->beecon_ge2_ImgFilename[0]!='\0' && self->priv->beecon_ge2_ImgFilename[0]!=';') {
				if (self->priv->beecon_ge2_ImgFilename[0]=='/') {// if / leading let's assume absolute path for img filename
					rsImgFilename = g_strconcat (self->priv->beecon_ge2_ImgFilename, NULL);
				} else {
					rsImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_PRIVATE_DIR, self->priv->beecon_ge2_ImgFilename, NULL);
					auxrsImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_MYDOCS_IMAGE_DIR, self->priv->beecon_ge2_ImgFilename, NULL);
					sysrsImgFilename = g_strconcat (SYSTEM_PUBLIC_ICON_DIR, self->priv->beecon_ge2_ImgFilename, NULL);
				}
				gint w=48,h=48;
				GdkPixbufFormat *resPixBufFmt = NULL;
				if (auxrsImgFilename) resPixBufFmt = gdk_pixbuf_get_file_info(auxrsImgFilename,&w,&h);
				if (!resPixBufFmt) resPixBufFmt = gdk_pixbuf_get_file_info(rsImgFilename,&w,&h);
				rsImgZoomW=self->priv->beecon_ge2_ImgZoom==0?-1:self->priv->beecon_ge2_ImgZoom==1?self->priv->widWidth:(self->priv->beecon_ge2_ImgZoom-1)*w*5/100;
				rsImgZoomH=self->priv->beecon_ge2_ImgZoom==0?-1:self->priv->beecon_ge2_ImgZoom==1?self->priv->widHeight:(self->priv->beecon_ge2_ImgZoom-1)*h*5/100;
				isResImage=TRUE;
			}
			break;
		default:
			g_warning("(%p) I'm BEECON (idxge2=%s)", self, self->priv->beecon_idxge2_ImgFilename);
			if (self->priv->beecon_idxge2_ImgFilename[0]!='\0' && self->priv->beecon_idxge2_ImgFilename[0]!=';') {
				if (self->priv->beecon_idxge2_ImgFilename[0]=='/') {// if / leading let's assume absolute path for img filename
					rsImgFilename = g_strdup_printf("%s.%d", self->priv->beecon_idxge2_ImgFilename, self->priv->cmdExitStatus);
				} else {
					rsImgFilename = g_strdup_printf("%s%s%s.%d", HOME_DIR, QUEEN_BEECON_PRIVATE_DIR, self->priv->beecon_idxge2_ImgFilename, self->priv->cmdExitStatus);
					auxrsImgFilename = g_strdup_printf("%s%s%s.%d", HOME_DIR, QUEEN_BEECON_MYDOCS_IMAGE_DIR, self->priv->beecon_idxge2_ImgFilename, self->priv->cmdExitStatus);
					sysrsImgFilename = g_strdup_printf("%s%s.%d", SYSTEM_PUBLIC_ICON_DIR, self->priv->beecon_idxge2_ImgFilename, self->priv->cmdExitStatus);
				}
				gint w=48,h=48;
				GdkPixbufFormat *resPixBufFmt = NULL;
				if (auxrsImgFilename) resPixBufFmt = gdk_pixbuf_get_file_info(auxrsImgFilename,&w,&h);
				if (!resPixBufFmt) resPixBufFmt = gdk_pixbuf_get_file_info(rsImgFilename,&w,&h);
				rsImgZoomW=self->priv->beecon_idxge2_ImgZoom==0?-1:self->priv->beecon_idxge2_ImgZoom==1?self->priv->widWidth:(self->priv->beecon_idxge2_ImgZoom-1)*w*5/100;
				rsImgZoomH=self->priv->beecon_idxge2_ImgZoom==0?-1:self->priv->beecon_idxge2_ImgZoom==1?self->priv->widHeight:(self->priv->beecon_idxge2_ImgZoom-1)*h*5/100;
				isResImage=TRUE;
			}
			break;
		}
	}//AP3
	if (self->priv->cmdResult_img) gtk_widget_destroy(GTK_WIDGET(self->priv->cmdResult_img));
	if (isResImage) {
		//g_warning ("(%p) Yes!!! auxrsImgFilename = %s", self, auxrsImgFilename);
		//g_warning ("(%p) Yes!!! rsImgFilename = %s", self, rsImgFilename);
		//g_warning ("(%p) Yes!!! sysrsImgFilename = %s", self, sysrsImgFilename);
		//g_warning ("(%p) Yes!!! noImgFilename = %s", self, noImgFilename);
		//g_warning ("(%p) rsImgZoomW=%d rsImgZoomH=%d", self, rsImgZoomW, rsImgZoomH);
		GdkPixbuf     *rsPixBuf = NULL;
		if (auxrsImgFilename!=NULL) rsPixBuf = gdk_pixbuf_new_from_file_at_scale (auxrsImgFilename, rsImgZoomW, rsImgZoomH, TRUE, NULL);
		if (!rsPixBuf) if (rsImgFilename!=NULL) rsPixBuf = gdk_pixbuf_new_from_file_at_scale (rsImgFilename, rsImgZoomW, rsImgZoomH, TRUE, NULL);
		if (!rsPixBuf) if (sysrsImgFilename!=NULL) rsPixBuf = gdk_pixbuf_new_from_file_at_scale (sysrsImgFilename, rsImgZoomW, rsImgZoomH, TRUE, NULL);
		if (!rsPixBuf) if (noImgFilename!=NULL) rsPixBuf = gdk_pixbuf_new_from_file_at_scale (noImgFilename, rsImgZoomW, rsImgZoomH, TRUE, NULL);
		//g_warning ("(%p) rsPixBuf = %p", self, rsPixBuf);
		//g_warning ("(%p) self->priv->cmdResult_img = %p", self, self->priv->cmdResult_img);
		self->priv->cmdResult_img = gtk_image_new_from_pixbuf (rsPixBuf);
		//g_warning ("(%p) cmdResult_img gtk_image_new_from_pixbuf (rsPixBuf)= %p", self, self->priv->cmdResult_img);
		gtk_widget_set_size_request(GTK_WIDGET(self->priv->cmdResult_img), self->priv->widWidth, self->priv->widHeight);
		//g_warning ("(%p) resImgVisibilityPosition self->priv->cmdResult_img Absolute %d Relative rX=%0.1f rY=%0.1f", self, self->priv->resImgVisibilityPosition, ((self->priv->resImgVisibilityPosition-1)%3)*0.5,((self->priv->resImgVisibilityPosition-1)/3)*0.5);
		gtk_misc_set_alignment(GTK_MISC (self->priv->cmdResult_img),((self->priv->resImgVisibilityPosition-1)%3)*0.5,((self->priv->resImgVisibilityPosition-1)/3)*0.5);
		//g_warning ("(%p) cmdResult_img = %p", self, self->priv->cmdResult_img);
		g_object_unref (rsPixBuf);
		g_free(rsImgFilename);
		g_free(auxrsImgFilename);
		g_free(sysrsImgFilename);
		//g_warning("(%p) gtk_table_attach self->priv->cmdResult_img=%p self->priv->tableLayout=%p", self, self->priv->cmdResult_img, self->priv->tableLayout);
		gtk_table_attach(GTK_TABLE(self->priv->tableLayout), GTK_WIDGET(self->priv->cmdResult_img), 0, 1, 0, 1, GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 0, 0);
		if (self->priv->resImgVisibilityPosition) {
			//g_warning("(%p) showing self->priv->cmdResult_img=%p", self, self->priv->cmdResult_img);
			gtk_widget_show (GTK_WIDGET(self->priv->cmdResult_img));
			if (!self->priv->widgetVisible) gtk_widget_hide (GTK_WIDGET(self->priv->cmdResult_img));
		} else {
			//g_warning("(%p) hiding self->priv->cmdResult_img=%p", self, self->priv->cmdResult_img);
			gtk_widget_hide (GTK_WIDGET(self->priv->cmdResult_img));//AP3
		}
	}
	//^ Results Image

	// Update Command Layout (Label/image Font + Colors + Alignment + Position + ...)
	fd = pango_font_description_from_string(self->priv->cmdExtFont);//AP1
	gtk_widget_modify_font(GTK_WIDGET(self->priv->cmdTitle_lb), fd);//AP1

	gtk_widget_set_size_request(GTK_WIDGET(self->priv->cmdTitle_lb), self->priv->widWidth, self->priv->widHeight);
#ifdef xNEW_COLOR_DIALOG
	gdk_color_parse(self->priv->cmdExtFgRGB,&color);
#else
	gdk_color_parse(p_colors[self->priv->cmdFgRGB].colorRGB,&color);
#endif
	gtk_widget_modify_fg (GTK_WIDGET(self->priv->cmdTitle_lb), GTK_STATE_NORMAL, &color);
	//g_warning ("(%p) cmdVisibilityPosition self->priv->cmdTitle_lb Absolute %d Relative rX=%0.1f rY=%0.1f", self, self->priv->cmdVisibilityPosition, ((self->priv->cmdVisibilityPosition-1)%3)*0.5,((self->priv->cmdVisibilityPosition-1)/3)*0.5);
	gtk_misc_set_alignment(GTK_MISC (self->priv->cmdTitle_lb),((self->priv->cmdVisibilityPosition-1)%3)*0.5,((self->priv->cmdVisibilityPosition-1)/3)*0.5);
	gtk_misc_set_padding (GTK_MISC (self->priv->cmdTitle_lb), 2, 2);//AP1
	gtk_label_set_justify(GTK_LABEL(self->priv->cmdTitle_lb), self->priv->cmdJustify);
	gtk_label_set_angle(GTK_LABEL(self->priv->cmdTitle_lb), self->priv->cmdTextAngle*90.00);//
	self->priv->cmdVisibilityPosition?gtk_widget_show (GTK_WIDGET(self->priv->cmdTitle_lb)):gtk_widget_hide (GTK_WIDGET(self->priv->cmdTitle_lb));//AP3
	if (!self->priv->widgetVisible) gtk_widget_hide (GTK_WIDGET(self->priv->cmdTitle_lb));

	//v Command Image
	//g_warning("(%p) Let's process TITLE Output: Do we need result Image or Text?", self);
	if (self->priv->cmdTitle_img) gtk_widget_destroy(GTK_WIDGET(self->priv->cmdTitle_img));
	if (self->priv->cmdImgFilename[0]!='\0' && self->priv->cmdImgFilename[0]!=';') {
		if (self->priv->cmdImgFilename[0]=='/') // if / leading let's assume absolute path for img filename
			cmdImgFilename = g_strconcat (self->priv->cmdImgFilename, NULL);
		else {
			cmdImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_PRIVATE_DIR, self->priv->cmdImgFilename, NULL);
			auxcmdImgFilename = g_strconcat (HOME_DIR, QUEEN_BEECON_MYDOCS_IMAGE_DIR, self->priv->cmdImgFilename, NULL);
			syscmdImgFilename = g_strconcat (SYSTEM_PUBLIC_ICON_DIR, self->priv->cmdImgFilename, NULL);
		}
		isCmdImage=TRUE;
		//g_warning ("(%p) cmImgZoomW=%d cmImgZoomH=%d", self, cmImgZoomW, cmImgZoomH);
		//g_warning ("(%p) Yes!!! auxcmdImgFilename = %s", self, auxcmdImgFilename);
		//g_warning ("(%p) Yes!!! cmdImgFilename = %s", self, cmdImgFilename);
		//g_warning ("(%p) Yes!!! syscmdImgFilename = %s", self, syscmdImgFilename);
		//g_warning ("(%p) Yes!!! noImgFilename = %s", self, noImgFilename);

		gint w=48,h=48;
		GdkPixbufFormat *cmdPixBufFmt = NULL;
		if (auxcmdImgFilename) cmdPixBufFmt = gdk_pixbuf_get_file_info(auxcmdImgFilename,&w,&h);
		if (!cmdPixBufFmt) cmdPixBufFmt = gdk_pixbuf_get_file_info(cmdImgFilename,&w,&h);
		cmImgZoomW=self->priv->cmdImgZoom==0?-1:self->priv->cmdImgZoom==1?self->priv->widWidth:(self->priv->cmdImgZoom-1)*w*5/100;
		cmImgZoomH=self->priv->cmdImgZoom==0?-1:self->priv->cmdImgZoom==1?self->priv->widHeight:(self->priv->cmdImgZoom-1)*h*5/100;
		//g_warning ("(%p) cmImgZoomW=%d cmImgZoomH=%d", self, cmImgZoomW, cmImgZoomH);
		GdkPixbuf      *cmdPixBuf = NULL;
		if (auxcmdImgFilename!=NULL) cmdPixBuf = gdk_pixbuf_new_from_file_at_scale (auxcmdImgFilename, cmImgZoomW, cmImgZoomH, TRUE, NULL);
		if (!cmdPixBuf) if (cmdImgFilename!=NULL) cmdPixBuf = gdk_pixbuf_new_from_file_at_scale (cmdImgFilename, cmImgZoomW, cmImgZoomH, TRUE, NULL);
		if (!cmdPixBuf) if (syscmdImgFilename!=NULL) cmdPixBuf = gdk_pixbuf_new_from_file_at_scale (syscmdImgFilename, cmImgZoomW, cmImgZoomH, TRUE, NULL);
		if (!cmdPixBuf) if (noImgFilename!=NULL) cmdPixBuf = gdk_pixbuf_new_from_file_at_scale (noImgFilename, cmImgZoomW, cmImgZoomH, TRUE, NULL);
		//g_warning ("(%p) cmdPixBuf = %p", self, cmdPixBuf);
		//g_warning ("(%p) self->priv->cmdTitle_img = %p", self, self->priv->cmdTitle_img);
		self->priv->cmdTitle_img = gtk_image_new_from_pixbuf (cmdPixBuf);
		//g_warning ("(%p) cmdTitle_img gtk_image_new_from_pixbuf (cmdPixBuf)= %p", self, self->priv->cmdTitle_img);
		gtk_widget_set_size_request(GTK_WIDGET(self->priv->cmdTitle_img), self->priv->widWidth, self->priv->widHeight);
		//g_warning ("(%p) cmdImgVisibilityPosition self->priv->cmdTitle_img Absolute %d Relative rX=%0.1f rY=%0.1f", self, self->priv->cmdImgVisibilityPosition, ((self->priv->cmdImgVisibilityPosition-1)%3)*0.5,((self->priv->cmdImgVisibilityPosition-1)/3)*0.5);
		gtk_misc_set_alignment(GTK_MISC (self->priv->cmdTitle_img),((self->priv->cmdImgVisibilityPosition-1)%3)*0.5,((self->priv->cmdImgVisibilityPosition-1)/3)*0.5);
		g_object_unref (cmdPixBuf);
		g_free(cmdImgFilename);
		g_free(auxcmdImgFilename);
		g_free(syscmdImgFilename);
		//g_warning("(%p) gtk_table_attach self->priv->cmdTitle_img=%p self->priv->tableLayout=%p", self, self->priv->cmdTitle_img, self->priv->tableLayout);
		gtk_table_attach(GTK_TABLE(self->priv->tableLayout), self->priv->cmdTitle_img, 0, 1, 0, 1, GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 0, 0);
		if (self->priv->cmdImgVisibilityPosition!=0) { //AP2
			gtk_widget_show (GTK_WIDGET(self->priv->cmdTitle_img));
			if (!self->priv->widgetVisible) gtk_widget_hide (GTK_WIDGET(self->priv->cmdTitle_img));
		} else
			gtk_widget_hide (GTK_WIDGET(self->priv->cmdTitle_img));//AP3
	}
	//^ Command Image
	g_free(noImgFilename);noImgFilename=NULL;
}

#ifdef xNEW_COLOR_DIALOG
static void queen_beecon_blend_gradient(gint width, gint height, cairo_t *cr, cairo_pattern_t *pat, const gchar *colStr, double alphaUp, double alphaDown, gboolean isPressed)
{
	GdkColor color,color1;
	gdk_color_parse("#FFFFFF", &color1);
	//g_warning ("queen_beecon_blend_gradient cr=%p pat=%p colIdx=%d alphaUp=%0.2f alphaDown=%0.2f isPressed=%d", cr, pat, colIdx, alphaUp, alphaDown, isPressed);
	gdk_color_parse(colStr, &color);
	//g_warning ("queen_beecon_blend_gradient color (%s) rgb(%d,%d,%d)", colStr, color.red, color.green, color.blue);
	if (!isPressed) {
		cairo_pattern_add_color_stop_rgba(pat, 0.0, color1.red, color1.green, color1.blue, alphaUp);
		cairo_pattern_add_color_stop_rgba(pat, 4.0/height /*0.05*/, (gdouble)color.red/65535, (gdouble)color.green/65535, (gdouble)color.blue/65535, alphaUp);
		cairo_pattern_add_color_stop_rgba(pat, 1.0-4.0/height /*0.95*/, (gdouble)color.red/65535, (gdouble)color.green/65535, (gdouble)color.blue/65535, alphaUp);
		cairo_pattern_add_color_stop_rgba(pat, 1.0, 0, 0, 0, alphaUp);
	} else {
		cairo_pattern_add_color_stop_rgba(pat, 0.0, 0, 0, 0, alphaDown);
		cairo_pattern_add_color_stop_rgba(pat, 4.0/height /*0.05*/, (gdouble)color.red/65535, (gdouble)color.green/65535, (gdouble)color.blue/65535, alphaDown);
		cairo_pattern_add_color_stop_rgba(pat, 1.0-4.0/height /*0.95*/, (gdouble)color.red/65535, (gdouble)color.green/65535, (gdouble)color.blue/65535, alphaDown);
		cairo_pattern_add_color_stop_rgba(pat, 1.0, color1.red, color1.green, color1.blue, alphaDown);
	}
}
#else
#ifdef OLD_COLOR
void queen_beecon_blend_gradient(cairo_t *cr, cairo_pattern_t *pat, guint colIdx, double alphaUp, double alphaDown, gboolean isPressed)
{
	GdkColor color,color1;
	gdk_color_parse("#FFFFFF", &color1);
	//g_warning ("queen_beecon_blend_gradient cr=%p pat=%p colIdx=%d alphaUp=%0.2f alphaDown=%0.2f isPressed=%d", cr, pat, colIdx, alphaUp, alphaDown, isPressed);
	if (!gdk_color_parse(p_colors[colIdx].colorRGB, &color)) {
		//g_warning ("gdk_color_parse color (%s)", p_colors[colIdx].colorRGB);
	}
	//g_warning ("queen_beecon_blend_gradient color (%s) rgb(%d,%d,%d)", p_colors[colIdx].colorRGB, color.red, color.green, color.blue);
	if (!isPressed) {
		cairo_pattern_add_color_stop_rgba(pat, 0.0, color1.red, color1.green, color1.blue, alphaUp);
		cairo_pattern_add_color_stop_rgba(pat, 0.05, color.red, color.green, color.blue, alphaUp);
		cairo_pattern_add_color_stop_rgba(pat, 0.95, color.red, color.green, color.blue, alphaUp);
		cairo_pattern_add_color_stop_rgba(pat, 1.0, 0, 0, 0, alphaUp);
	} else {
		cairo_pattern_add_color_stop_rgba(pat, 0.0, 0, 0, 0, alphaDown);
		cairo_pattern_add_color_stop_rgba(pat, 0.05, color.red, color.green, color.blue, alphaDown);
		cairo_pattern_add_color_stop_rgba(pat, 0.95, color.red, color.green, color.blue, alphaDown);
		cairo_pattern_add_color_stop_rgba(pat, 1.0, color1.red, color1.green, color1.blue, alphaDown);
	}
}
#endif
#endif

static void queen_beecon_draw_canvas(GtkWidget *widget)
{
	QueenBeecon *self = QUEEN_BEECON (widget);
	g_warning ("(%p) %s",self, G_STRFUNC);
	cairo_t *cr=NULL;
	gint width, height, x, y;
	gint radius = 5;

	if (!self->priv->widgetVisible) return;

	width = widget->allocation.width;
	height = widget->allocation.height;
	x = widget->allocation.x;
	y = widget->allocation.y;

	if (self->priv->operationalStatus==1) { // Widget instance is hidden or disabled/minimized on screen... don't draw canvas
		//g_warning ("(%p) Disabled drawing small canvas (snippet like) canvas...", self);
		cr = gdk_cairo_create(GDK_DRAWABLE (widget->window));
		cairo_move_to(cr, x + radius, y);
		cairo_line_to(cr, x + width - radius, y);
		cairo_curve_to(cr, x + width - radius, y, x + width, y, x + width,y + radius);
		cairo_line_to(cr, x + width, y + height - radius);
		cairo_curve_to(cr, x + width, y + height - radius, x + width,y + height, x + width - radius, y + height);
		cairo_line_to(cr, x + radius, y + height);
		cairo_curve_to(cr, x + radius, y + height, x, y + height, x,y + height - radius);
		cairo_line_to(cr, x, y + radius);
		cairo_curve_to(cr, x, y + radius, x, y, x + radius, y);
		cairo_set_operator (cr, CAIRO_OPERATOR_SOURCE);

		cairo_set_source_rgba (cr, 0, 0, 0, .7);
		cairo_fill_preserve(cr);

		cairo_set_source_rgba (cr, 1, 1, 1, 1);
		cairo_set_line_width (cr, 1);
		cairo_stroke (cr);

		cairo_destroy(cr);
		return;
	}

	if (self->priv->hideCanvas && !self->priv->isPressed) return; // Don't draw canvas if not needed

	cairo_pattern_t *pat = cairo_pattern_create_linear(width/2, 0, width/2, height-1);

	cr = gdk_cairo_create(GDK_DRAWABLE (widget->window));
	//g_warning ("(%p) Populating canvas...", self);

	if (self->priv->widgetType!=0) {
#ifdef xNEW_COLOR_DIALOG
		queen_beecon_blend_gradient (width, height, cr, pat, self->priv->snippetExtBgRGB, 0.90, 0.65, self->priv->isPressed);
#else
#ifdef OLD_COLOR
		queen_beecon_blend_gradient (width, height, cr, pat, self->priv->snippetBgRGB, 0.90, 0.65, self->priv->isPressed);
#endif
#endif
	} else {
		switch (self->priv->cmdExitStatus) {
		case -1:
#ifdef xNEW_COLOR_DIALOG
			queen_beecon_blend_gradient (width, height, cr, pat, self->priv->beecon_lt0_ExtBgRGB, 0.90, 0.65, self->priv->isPressed);
#else
#ifdef OLD_COLOR_DIALOG
			queen_beecon_blend_gradient (width, height, cr, pat, self->priv->beecon_lt0_BgRGB, 0.90, 0.65, self->priv->isPressed);
#endif
#endif
			break;
		case 0:
#ifdef xNEW_COLOR_DIALOG
			queen_beecon_blend_gradient (width, height, cr, pat, self->priv->beecon_eq0_ExtBgRGB, 0.90, 0.65, self->priv->isPressed);
#else
#ifdef OLD_COLOR
			queen_beecon_blend_gradient (width, height, cr, pat, self->priv->beecon_eq0_BgRGB, 0.90, 0.65, self->priv->isPressed);
#endif
#endif
			break;
		case 1:
#ifdef xNEW_COLOR_DIALOG
			queen_beecon_blend_gradient (width, height, cr, pat, self->priv->beecon_eq1_ExtBgRGB, 0.90, 0.65, self->priv->isPressed);
#else
#ifdef OLD_COLOR
			queen_beecon_blend_gradient (width, height, cr, pat, self->priv->beecon_eq1_BgRGB, 0.90, 0.65, self->priv->isPressed);
#endif
#endif
			break;
		case 2:
#ifdef xNEW_COLOR_DIALOG
			queen_beecon_blend_gradient (width, height, cr, pat, self->priv->beecon_ge2_ExtBgRGB, 0.90, 0.65, self->priv->isPressed);
#else
#ifdef OLD_COLOR
			queen_beecon_blend_gradient (width, height, cr, pat, self->priv->beecon_ge2_BgRGB, 0.90, 0.65, self->priv->isPressed);
#endif
#endif
			break;
		default:
#ifdef xNEW_COLOR_DIALOG
			queen_beecon_blend_gradient (width, height, cr, pat, self->priv->beecon_idxge2_ExtBgRGB, 0.90, 0.65, self->priv->isPressed);
#else
#ifdef OLD_COLOR
			queen_beecon_blend_gradient (width, height, cr, pat, self->priv->beecon_idxge2_BgRGB, 0.90, 0.65, self->priv->isPressed);
#endif
#endif
			break;
		}
	}//AP3

	cairo_set_line_join(cr, CAIRO_LINE_JOIN_ROUND);//AP3

//	if (self->priv->widgetType==0) {// Is Beecon ... draw cell
	if (self->priv->isPressed) {// Is pressed ... draw cell
		gint l= width / 4;//AP3
		gint h= height / 2;//AP3

		cairo_move_to(cr, x, y + h - 1);
		cairo_line_to(cr, x + l - 1, y + h * 2 - 1);
		cairo_line_to(cr, x + l * 3 - 1, y + h * 2 - 1);
		cairo_line_to(cr, x + l * 4 - 1, y + h - 1);
		cairo_line_to(cr, x + l * 3 - 1 , y);
		cairo_line_to(cr, x + l - 1 , y);
		cairo_line_to(cr, x, y + h - 1);
	}//AP3
//	if (self->priv->widgetType!=0 || self->priv->isPressed) {// Is snippet os isPressed ... draw rectangle
//	if (self->priv->widgetType!=0 || self->priv->isPressed) {// Is snippet os isPressed ... draw rectangle
		cairo_move_to(cr, x + radius, y);
		cairo_line_to(cr, x + width - radius, y);
		cairo_curve_to(cr, x + width - radius, y, x + width, y, x + width,y + radius);
		cairo_line_to(cr, x + width, y + height - radius);
		cairo_curve_to(cr, x + width, y + height - radius, x + width,y + height, x + width - radius, y + height);
		cairo_line_to(cr, x + radius, y + height);
		cairo_curve_to(cr, x + radius, y + height, x, y + height, x,y + height - radius);
		cairo_line_to(cr, x, y + radius);
		cairo_curve_to(cr, x, y + radius, x, y, x + radius, y);
//	}

	cairo_set_operator (cr, CAIRO_OPERATOR_SOURCE);

	cairo_set_source(cr, pat);
	cairo_fill_preserve(cr);

	cairo_set_source_rgba (cr, 1, 1, 1, 1);
	cairo_set_line_width (cr, 2);
	cairo_stroke (cr);

	cairo_pattern_destroy(pat);
	cairo_destroy(cr);
}

static gboolean queen_beecon_resize_hack(QueenBeecon *self)
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	if(self->priv->widgetID != NULL) {
		//g_warning("(%p) REALIZE HACK calling queen_beecon_read_settings (self)", self);
		queen_beecon_read_settings (self, TRUE, FALSE, NULL);

		if (self->priv->updOnDBUS && self->priv->dbus_mon_connection==NULL && self->priv->operationalStatus==0) { //Is DBUS Monitor active?
			g_warning("(%p) DBUS monitor starting, rearm connection, match and filter", self);
			if (!queen_beecon_dbus_monitor_manager(self, QBW_INIT_DBUS_MONITOR, self->priv->updOnDBUSBus, self->priv->updOnDBUSMatchRule)) { // If error during reinitialization of DBUS monitor ... restore previous settings
				self->priv->updOnDBUS          = 0;
			}
		}

		if( (self->priv->updateTimerID == 0) && (self->priv->delaySeconds > 0)) {
			g_warning("(%p) Arming execution timer, delaySeconds=%d", self, self->priv->delaySeconds);
			self->priv->updateTimerID = g_timeout_add_seconds (self->priv->delaySeconds, (GSourceFunc)queen_beecon_update_content, self);
		}

    	queen_beecon_exec_animation_progress(self, QBW_CUSTOM_PROGRESS_ANIMATION);
    	queen_beecon_exec_animation_progress(self, QBW_START_PROGRESS_ANIMATION);

		if (self->priv->updOnStartup && self->priv->operationalStatus==0) { // do we have to update on startup?
			g_warning("(%p) RESIZE HACK queen_beecon_update_content (self)", self);
			queen_beecon_update_content (self, qbwExecReason[QBW_STARTUP_UPDATE]);
		} else {
			queen_beecon_update_content_layout (self); // No... only update layout
		}

    	queen_beecon_exec_animation_progress(self, QBW_STOP_PROGRESS_ANIMATION);
	} else {
		g_warning("HACK unsuccessful");
 	}
	return FALSE;
}

static gboolean queen_beecon_update_content (QueenBeecon *self, const gchar *impulse)
{
	g_warning ("(%p) %s",self, G_STRFUNC);

	if(self->priv->widgetID == NULL) {
		g_warning("(%p) Widget instance unknown... aborting",self);
		return(FALSE);
	}

	if (self->priv->operationalStatus==1) { // Keep Sleeping if disabled
		return FALSE; // If widget is disabled then switch off timer auto re-arming
	}

	if(self->priv->updNeworkPolicy == NETWORK__ONLY_CONNECTED && self->priv->isConnected == FALSE) {
		queen_beecon_update_content_layout (self); // Only update layout
		return TRUE;
	}

	if(self->priv->updNeworkPolicy == NETWORK__ONLY_DISCONNECTED && self->priv->isConnected == TRUE) {
		queen_beecon_update_content_layout (self); // Only update layout
		return TRUE;
	}

	g_warning("(%p) TEST execInProgress... %d",self, self->priv->execInProgress);
	if (self->priv->execInProgress==TRUE) {// Exec is already in progress ... don't do anything
		g_warning("(%p) Exec already in progress...",self);
		return (TRUE);
	} else {
		g_warning("(%p) SET execInProgress...",self);
		self->priv->execInProgress = TRUE;
	}

	gint i;
	for (i=QBW_TIMER_UPDATE;qbwExecReason[i];i++) if (impulse==qbwExecReason[i]) break;
	if (i==QBW_LAST) i=QBW_TIMER_UPDATE;
	g_warning("(%p) EXEC(%s) PREXPAND [%s]", self, qbwExecReason[i], self->priv->instanceCmd);
	gchar *instanceCmdSubst = queen_beecon_g_command_param_subst(self, self->priv->instanceCmd, qbwExecReason[i]);
	g_warning("(%p) EXEC(%s) EXPANDED [%s]", self, qbwExecReason[i], instanceCmdSubst);

#ifdef OLD_EXEC
	FILE *fp=NULL;
	fp = popen (instanceCmdSubst, "r");
	g_warning("(%p) ========> popen(%s) returned %p", self, instanceCmdSubst, fp);//AP >> 8 & 0xFF);//AP
#endif

#ifndef OLD_EXEC
	queen_beecon_async_execute(instanceCmdSubst, self);
#endif
	g_free(instanceCmdSubst);

#ifdef OLD_EXEC
	size_t l;//AP
	line = g_malloc0(4096);//AP Big Big command output buffer//AP
	l=fread (line, 1, 4096, fp);
	if (l>0) {//to this "buffer-based" for multiline handling in widget //AP
		line[l-1]='\000';//AP
		g_warning("(%p) ========> fread() read returned %d [%s]", self, l, line);
	}
	gint exitCode=pclose(fp);
	g_warning("(%p) ppclose(fp) returned 0x%08X", self, exitCode);

	gtk_label_set_markup (GTK_LABEL (self->priv->cmdResult_lb), "No Output");//AP

	if ((self->priv->cmdExitStatus=(exitCode >> 8 & 0xff)) > 0x70) {
		gchar *buff = NULL;//AP output buffer//AP
		self->priv->cmdExitStatus=-1;
		if (l>0) {
			buff = g_strdup_printf("[!?%04x]\n%s", exitCode, line);//If command has output we issue a newline after Exit Code
		} else {
			buff = g_strdup_printf("[!?%04x]", exitCode);
		}
		gtk_label_set_markup (GTK_LABEL (self->priv->cmdResult_lb), buff);//AP
		g_free(buff);
	} else {
		if (l>0) gtk_label_set_markup (GTK_LABEL (self->priv->cmdResult_lb), line);//AP
	}
	g_free(line);

#endif

	g_signal_emit_by_name (self, "sig_content_updated", self->priv->cmdExitStatus);

	// Assume something changed ... let's update content layout!!!
	//g_warning("(%p) Command executed, let's assume something changed = UPDATE CONTENT LAYOUT", self);
#ifdef OLD_EXEC
	queen_beecon_update_content_layout (self);
#endif

	return(TRUE);
}

static void queen_beecon_dispose (GObject *object)
{
	g_warning ("(%p) %s",object, G_STRFUNC);
//	QueenBeecon *self = QUEEN_BEECON (object);

	G_OBJECT_CLASS (queen_beecon_parent_class)->dispose (object);
}

static void queen_beecon_finalize (GObject *object)
{
	g_warning ("(%p) %s",object, G_STRFUNC);
	QueenBeecon *self = QUEEN_BEECON (object);

	queen_beecon_exec_animation_progress(self, QBW_DEINIT_PROGRESS_ANIMATION);

	if (self->priv->updateTimerID) {
		g_warning("(%p) removing self->priv->updateTimerID = %d", self, self->priv->updateTimerID);
		g_source_remove (self->priv->updateTimerID);
	}

	if (self->priv->qbwDbusId != NULL){g_free(self->priv->qbwDbusId);self->priv->qbwDbusId = NULL;}

	g_warning("(%p) self->priv->connection = %p", self, self->priv->connection);
	g_object_unref (self->priv->connection);

	if (self->priv->dbus_mon_connection!=NULL) {
		g_warning ("(%p) dbus_connection_unref:[%p]",self, self->priv->dbus_mon_connection);
		//dbus_connection_close (self->priv->dbus_mon_connection);
		dbus_connection_unref (self->priv->dbus_mon_connection);
		self->priv->dbus_mon_connection = NULL;
	}

	g_warning("(%p) self->priv->c_titles = %p", self, self->priv->c_titles);
	g_strfreev(self->priv->c_titles); self->priv->c_titles = NULL;
	g_warning("(%p) self->priv->c_commands = %p", self, self->priv->c_commands);
	g_strfreev(self->priv->c_commands);self->priv->c_commands = NULL;

	g_warning("(%p) self->priv->beecon_lt0_ImgFilename = %p", self, self->priv->beecon_lt0_ImgFilename);
	if (self->priv->beecon_lt0_ImgFilename != NULL){g_free(self->priv->beecon_lt0_ImgFilename);self->priv->beecon_lt0_ImgFilename = NULL;}
	g_warning("(%p) self->priv->beecon_eq0_ImgFilename = %p", self, self->priv->beecon_eq0_ImgFilename);
	if (self->priv->beecon_eq0_ImgFilename != NULL){g_free(self->priv->beecon_eq0_ImgFilename);self->priv->beecon_eq0_ImgFilename = NULL;}
	g_warning("(%p) self->priv->beecon_eq1_ImgFilename = %p", self, self->priv->beecon_eq1_ImgFilename);
	if (self->priv->beecon_eq1_ImgFilename != NULL){g_free(self->priv->beecon_eq1_ImgFilename);self->priv->beecon_eq1_ImgFilename = NULL;}
	g_warning("(%p) self->priv->beecon_ge2_ImgFilename = %p", self, self->priv->beecon_ge2_ImgFilename);
	if (self->priv->beecon_ge2_ImgFilename != NULL){g_free(self->priv->beecon_ge2_ImgFilename);self->priv->beecon_ge2_ImgFilename = NULL;}
	g_warning("(%p) self->priv->beecon_idxge2_ImgFilename = %p", self, self->priv->beecon_idxge2_ImgFilename);
	if (self->priv->beecon_idxge2_ImgFilename != NULL){g_free(self->priv->beecon_idxge2_ImgFilename);self->priv->beecon_idxge2_ImgFilename = NULL;}

	g_warning("(%p) self->priv->snippetExtBgRGB = %p", self, self->priv->snippetExtBgRGB);
	if (self->priv->snippetExtBgRGB != NULL){g_free(self->priv->snippetExtBgRGB);self->priv->snippetExtBgRGB = NULL;}
	g_warning("(%p) self->priv->beecon_lt0_ExtBgRGB = %p", self, self->priv->beecon_lt0_ExtBgRGB);
	if (self->priv->beecon_lt0_ExtBgRGB != NULL){g_free(self->priv->beecon_lt0_ExtBgRGB);self->priv->beecon_lt0_ExtBgRGB = NULL;}
	g_warning("(%p) self->priv->beecon_eq0_ExtBgRGB = %p", self, self->priv->beecon_eq0_ExtBgRGB);
	if (self->priv->beecon_eq0_ExtBgRGB != NULL){g_free(self->priv->beecon_eq0_ExtBgRGB);self->priv->beecon_eq0_ExtBgRGB = NULL;}
	g_warning("(%p) self->priv->beecon_eq1_ExtBgRGB = %p", self, self->priv->beecon_eq1_ExtBgRGB);
	if (self->priv->beecon_eq1_ExtBgRGB != NULL){g_free(self->priv->beecon_eq1_ExtBgRGB);self->priv->beecon_eq1_ExtBgRGB = NULL;}
	g_warning("(%p) self->priv->beecon_ge2_ExtBgRGB = %p", self, self->priv->beecon_ge2_ExtBgRGB);
	if (self->priv->beecon_ge2_ExtBgRGB != NULL){g_free(self->priv->beecon_ge2_ExtBgRGB);self->priv->beecon_ge2_ExtBgRGB = NULL;}
	g_warning("(%p) self->priv->beecon_idxge2_ExtBgRGB = %p", self, self->priv->beecon_idxge2_ExtBgRGB);
	if (self->priv->beecon_idxge2_ExtBgRGB != NULL){g_free(self->priv->beecon_idxge2_ExtBgRGB);self->priv->beecon_idxge2_ExtBgRGB = NULL;}

	g_warning("(%p) self->priv->cmdExtFgRGB = %p", self, self->priv->cmdExtFgRGB);
	if (self->priv->cmdExtFgRGB != NULL){g_free(self->priv->cmdExtFgRGB);self->priv->cmdExtFgRGB = NULL;}
	g_warning("(%p) self->priv->resExtFgRGB = %p", self, self->priv->resExtFgRGB);
	if (self->priv->resExtFgRGB != NULL){g_free(self->priv->resExtFgRGB);self->priv->resExtFgRGB = NULL;}

	g_warning("(%p) self->priv->cmdExtFont = %p", self, self->priv->cmdExtFont);
	if (self->priv->cmdExtFont != NULL){g_free(self->priv->cmdExtFont);self->priv->cmdExtFont = NULL;}
	g_warning("(%p) self->priv->resExtFont = %p", self, self->priv->resExtFont);
	if (self->priv->resExtFont != NULL){g_free(self->priv->resExtFont);self->priv->resExtFont = NULL;}

	g_warning("(%p) self->priv->cmdImgFilename = %p", self, self->priv->cmdImgFilename);
	if (self->priv->cmdImgFilename != NULL){g_free(self->priv->cmdImgFilename);self->priv->cmdImgFilename = NULL;}
	g_warning("(%p) self->priv->resImgFilename = %p", self, self->priv->resImgFilename);
	if (self->priv->resImgFilename != NULL){g_free(self->priv->resImgFilename);self->priv->resImgFilename = NULL;}

	g_warning("(%p) self->priv->instanceTitle = %p", self, self->priv->instanceTitle);
	if (self->priv->instanceTitle != NULL){g_free(self->priv->instanceTitle);self->priv->instanceTitle = NULL;}
	g_warning("(%p) self->priv->instanceCmd = %p", self, self->priv->instanceCmd);
	if (self->priv->instanceCmd != NULL){g_free(self->priv->instanceCmd);self->priv->instanceCmd = NULL;}

#ifdef DBUS_MONITOR_MODE
	g_warning("(%p) self->priv->updOnDBUSMatchRule = %p", self, self->priv->updOnDBUSMatchRule);
	if (self->priv->updOnDBUSMatchRule != NULL){g_free(self->priv->updOnDBUSMatchRule);self->priv->updOnDBUSMatchRule = NULL;}
#endif

	g_warning ("(%p) END OF queen_beecon_finalize",object);
	G_OBJECT_CLASS (queen_beecon_parent_class)->finalize (object);
}

static void queen_beecon_register_dbus_service (QueenBeecon *self, gchar *qbwInstId)
{
	g_warning ("(%p) %s (instance ID=%s)",self, G_STRFUNC, qbwInstId);
	g_return_if_fail (self);

	QueenBeeconClass *klass = QUEEN_BEECON_GET_CLASS (self);

	//g_warning("(%p) dc=%p px=%p dbus-reg=%d", self, klass->dbus_conn, klass->bus_proxy, klass->dbus_registered);
	if (klass->dbus_conn && klass->bus_proxy ) {//&& !klass->dbus_registered) {
		guint request_name_ret;
		GError *error = NULL;

		gchar *bpid = g_strconcat(QBW_DBUS_PATH, qbwInstId, NULL);
		//g_warning("(%p) Registering dbus_g_connection_register_g_object dc=%p ph=%s", self, klass->dbus_conn, bpid);
		dbus_g_connection_register_g_object (klass->dbus_conn, bpid, G_OBJECT (self));
		g_free(bpid);
		if (!org_freedesktop_DBus_request_name (klass->bus_proxy, QBW_DBUS_SERVICE, 0, &request_name_ret, &error)) {
			//g_warning ("Failed to request name: %s\n", error->message);
			g_clear_error (&error);
			return;
		}
		g_warning("(%p) request_name_ret rqn=%d", self, request_name_ret);

		switch (request_name_ret) {
			case DBUS_REQUEST_NAME_REPLY_EXISTS:
				g_warning("(%p) Already running", self);
				break;
			case DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER: /* Yay! */
				g_warning("(%p) Yay! Primary owner",self);
				klass->dbus_registered = TRUE;
				break;
			case DBUS_REQUEST_NAME_REPLY_ALREADY_OWNER:
				g_warning("(%p) Yay! Already owner",self);
				break;
			default:
				g_warning("(%p) Uhoh!", self);
				break;
		}
	}
}

static void queen_beecon_realize (GtkWidget *widget)
{
	g_warning ("(%p) %s",widget, G_STRFUNC);
	QueenBeecon *self = QUEEN_BEECON (widget);
	GdkScreen *screen = NULL;

	screen = gtk_widget_get_screen (widget);
	gtk_widget_set_colormap (widget, gdk_screen_get_rgba_colormap (screen));

	gtk_widget_set_app_paintable (widget, TRUE);

	GTK_WIDGET_CLASS (queen_beecon_parent_class)->realize (widget);
	self->priv->widgetID = hd_home_plugin_item_get_applet_id (HD_HOME_PLUGIN_ITEM (widget));

	char *last_dash = strrchr (self->priv->widgetID, '-');
	self->priv->qbwDbusId = NULL;
	self->priv->qbwDbusId = g_strdup_printf("id%s",&last_dash[1]);
	queen_beecon_register_dbus_service (self, self->priv->qbwDbusId);//id);
}

static gboolean queen_beecon_expose_event (GtkWidget *widget, GdkEventExpose *event)
{
	g_warning ("(%p) %s(%d) area(x%d,y%d,w%d,h%d) %d more events",widget, G_STRFUNC, event->type, event->area.x, event->area.y, event->area.width, event->area.height, event->count);

	// Let's draw the canvas with basic background shapes Beecon, Snippet...
	queen_beecon_draw_canvas (GTK_WIDGET (widget));

	return GTK_WIDGET_CLASS (queen_beecon_parent_class)->expose_event (widget, event);
}

static void queen_beecon_class_init (QueenBeeconClass *klass)
{
	g_warning ("(%p) %s",klass, G_STRFUNC);
	GError *error = NULL;

	GObjectClass *object_class = G_OBJECT_CLASS (klass);
	GtkWidgetClass *widget_class = GTK_WIDGET_CLASS (klass);

	object_class->dispose = queen_beecon_dispose;
	object_class->finalize = queen_beecon_finalize;

	widget_class->realize = queen_beecon_realize;
	widget_class->expose_event = queen_beecon_expose_event;

	g_type_class_add_private (klass, sizeof (QueenBeeconPrivate));

	queen_beecon_signals[SIG_CONTENT_UPDATED] = g_signal_new("sig_content_updated",
									QUEEN_BEECON_TYPE,
									G_SIGNAL_RUN_LAST,
									G_STRUCT_OFFSET (QueenBeeconClass, queen_beecon_dbus_sig_content_updated),
									NULL, NULL,
									g_cclosure_marshal_VOID__INT,
									G_TYPE_NONE, 1,
									G_TYPE_INT);

	klass->dbus_registered = FALSE;

	klass->dbus_conn = dbus_g_bus_get (DBUS_BUS_SESSION, &error);
	g_warning ("(%p) dbus_g_bus_get dc=%p",klass, klass->dbus_conn);
	if (error) {
		g_warning ("(%p) Failed to open connection to session bus: %s", klass, error->message);
		g_clear_error (&error);
		return;
	}

	klass->bus_proxy = dbus_g_proxy_new_for_name (klass->dbus_conn, DBUS_SERVICE_DBUS, DBUS_PATH_DBUS, DBUS_INTERFACE_DBUS);
	//g_warning ("(%p) dbus_g_proxy_new_for_name px=%p",klass, klass->bus_proxy);

	//g_warning ("(%p) dbus_g_object_type_install_info=%p",klass, &dbus_glib_queen_beecon_object_info);
	dbus_g_object_type_install_info (QUEEN_BEECON_TYPE, &dbus_glib_queen_beecon_object_info);
}

static void queen_beecon_class_finalize (QueenBeeconClass *klass)
{
	g_warning ("(%p) %s",klass, G_STRFUNC);
	beecon_config_file_housekeeping(klass); // Last housekeeping!!! How HARD!!!! :)

	if (klass->bus_proxy) {
		g_warning ("(%p) org_freedesktop_DBus_release_name px=%p svc=%s",klass, klass->bus_proxy, QBW_DBUS_SERVICE);
		org_freedesktop_DBus_release_name (klass->bus_proxy, QBW_DBUS_SERVICE, NULL, NULL);
		g_warning ("(%p) unref proxy px=%p",klass, klass->bus_proxy);
		g_object_unref (klass->bus_proxy);
	}

	if (klass->dbus_conn)
		g_warning ("(%p) unref dbus_conn dc=%p",klass, klass->dbus_conn);
		dbus_g_connection_unref (klass->dbus_conn);
}

static void queen_beecon_init (QueenBeecon *self)
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	self->priv = QUEEN_BEECON_GET_PRIVATE (self);

	beecon_config_file_housekeeping(self);// Let's do some preventive housekeeping before each instance creation

	GtkClipboard *clipboard = NULL;
	/* Allow clipboard data to be stored even when the application is closed: */
	clipboard = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
	gtk_clipboard_set_can_store (clipboard, NULL, 0);

	self->priv->dMM = FALSE;
	self->priv->widgetID = NULL;

	self->priv->cmdExitStatus = -1;
	self->priv->updateTimerID = 0;
	self->priv->isPressed = FALSE;
	self->priv->widXOrigin=-1;
	self->priv->widYOrigin=-1;

	self->priv->connection = con_ic_connection_new ();
	g_signal_connect (self->priv->connection, "connection-event", G_CALLBACK (queen_beecon_connection_event), self);
	g_object_set (self->priv->connection, "automatic-connection-events", TRUE, NULL);
	self->priv->isConnected = FALSE;

	self->priv->dbus_mon_connection = NULL;
	self->priv->updOnDBUS = FALSE;

	self->priv->beeExecuting_img = NULL;
	self->priv->execAuxOutput = NULL;
	self->priv->execInProgress = FALSE;
	self->priv->dbusVerboseMsg = NULL;

	self->priv->cmdTitle_lb = NULL;
	self->priv->cmdTitle_img = NULL;
	self->priv->cmdResult_lb = NULL;
	self->priv->cmdResult_img = NULL;

	self->priv->beecon_lt0_ImgFilename = NULL;
	self->priv->beecon_eq0_ImgFilename = NULL;
	self->priv->beecon_eq1_ImgFilename = NULL;
	self->priv->beecon_ge2_ImgFilename = NULL;
	self->priv->beecon_idxge2_ImgFilename = NULL;
	self->priv->cmdExtFont = NULL;
	self->priv->resExtFont = NULL;
	self->priv->cmdImgFilename = NULL;
	self->priv->resImgFilename = NULL;
	self->priv->instanceTitle = NULL;
	self->priv->instanceCmd = NULL;

	self->priv->snippetExtBgRGB = NULL;
	self->priv->beecon_lt0_ExtBgRGB = NULL;
	self->priv->beecon_eq0_ExtBgRGB = NULL;
	self->priv->beecon_eq1_ExtBgRGB = NULL;
	self->priv->beecon_ge2_ExtBgRGB = NULL;
	self->priv->beecon_idxge2_ExtBgRGB = NULL;
	self->priv->cmdExtFgRGB = NULL;
	self->priv->resExtFgRGB = NULL;

	// Create/Prepare primary and secondary image directories
	gchar *auxdirname = g_strconcat (HOME_DIR, QUEEN_BEECON_MYDOCS_IMAGE_DIR, NULL);
	//g_warning("(%p) opening/creating private auxdirname %s", self, auxdirname);
	if(!g_mkdir_with_parents (auxdirname, 0755)) { // Let's create our directory if not already existing
		//g_warning("(%p) problems creating/opening private auxdirname %s", self, auxdirname);
	} else
		g_free(auxdirname);

	gchar *dirname = g_strconcat (HOME_DIR, QUEEN_BEECON_PRIVATE_DIR, NULL);
	//g_warning("(%p) opening/creating private dirname %s", self, dirname);
	if(!g_mkdir_with_parents (dirname, 0755)) {// Let's create our directory if not already existing
		//g_warning("(%p) problems creating/opening private dirname %s", self, dirname);
	} else
		g_free(dirname);
	//EO Create/Prepare primary and secondary image directories

//	//D-Bus init
//	gchar *id = NULL;
//	id = hd_home_plugin_item_get_applet_id (HD_HOME_PLUGIN_ITEM (self));
//	g_warning("(%p) Registering DBUS Service id=%s", self,id);
//	queen_beecon_register_dbus_service (self, "test");//id);
//	g_free(id); id=NULL;

	// Initialize settings button
	hd_home_plugin_item_set_settings (&self->parent, TRUE);
	g_signal_connect (&self->parent, "show-settings", G_CALLBACK (queen_beecon_settings), self);

	GdkGeometry hints;
	hints.min_width = (int)(60);//AP3
	hints.min_height = (int)(60);//AP3
	hints.max_width = (int)(90);//AP3
	hints.max_height = (int)(90);//AP3
	gtk_window_set_default_size (GTK_WINDOW (self), 130, 115);
	gtk_window_set_geometry_hints (GTK_WINDOW (self), self->priv->homeWidget, &hints, GDK_HINT_MIN_SIZE | GDK_HINT_MAX_SIZE);
	gtk_widget_set_size_request (GTK_WIDGET (self), (int)(130), (int)(115));//AP3
	gtk_window_resize (GTK_WINDOW (self), (int)(130), (int)(115));//AP3

	self->priv->homeWidget = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (self), self->priv->homeWidget);
	gtk_widget_show (self->priv->homeWidget);

	//g_warning("(%p) INIT calling queen_beecon_content_create (self)", self);
	queen_beecon_content_create (self);

	g_timeout_add (500, (GSourceFunc)queen_beecon_resize_hack, self);

	//g_warning("(%p) INIT Let's arm notify::is-on-current-desktop", self);
	g_signal_connect (self, "notify::is-on-current-desktop", G_CALLBACK (queen_beecon_check_desktop), self);
}

QueenBeecon* queen_beecon_new (void)
{
	g_warning ("%s", G_STRFUNC);
	return g_object_new (QUEEN_BEECON_TYPE, NULL);
}

static void on_interval_picker_value_changed(HildonPickerButton *button, GtkWidget *interval)
{
	g_warning ("%s", G_STRFUNC);
	int cmdSel = hildon_picker_button_get_active (HILDON_PICKER_BUTTON (button));
	//cmdSel == 9?gtk_widget_show (GTK_WIDGET(interval)):gtk_widget_hide (GTK_WIDGET(interval));
	cmdSel == 9 ? gtk_widget_set_sensitive (GTK_WIDGET(interval), TRUE):gtk_widget_set_sensitive (GTK_WIDGET(interval), FALSE);
}

static void color_button_clicked_cb(HildonButton *button, struct _colorAux *data)
{
	g_warning ("%s", G_STRFUNC);
	GtkWidget *dialog;

	dialog = he_color_dialog_new_with_color(data->WC);
	if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT) {
		//g_warning ("Accept");
		he_color_dialog_get_color (HE_COLOR_DIALOG(dialog), data->WC);
//		if (data->FG) {
//			gtk_widget_modify_fg (GTK_WIDGET (data->WP), GTK_STATE_NORMAL, data->WC);gtk_widget_modify_fg (GTK_WIDGET (data->WP), GTK_STATE_PRELIGHT, data->WC);
//		} else {
			gtk_widget_modify_bg (GTK_WIDGET (data->WP), GTK_STATE_NORMAL, data->WC);gtk_widget_modify_bg (GTK_WIDGET (data->WP), GTK_STATE_PRELIGHT, data->WC);
//		}
	}
	gtk_widget_destroy (dialog);
}

static void font_button_clicked_cb(HildonButton *button, gpointer data)
{
	g_warning ("%s", G_STRFUNC);
	GtkWidget *dialog;
	gchar *value;
	value = g_strdup(hildon_button_get_value (button));

	dialog = he_font_dialog_new_with_font(value);
	g_free(value);
	if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT) {
		//g_warning ("Accept");
		hildon_button_set_value (button, he_font_dialog_get_font (HE_FONT_DIALOG(dialog)));
	}
	gtk_widget_destroy (dialog);
}

//Separate window dialogs
static void queen_beecon_settings (HDHomePluginItem *hitem, QueenBeecon *self)
{
	g_warning ("(%p) %s",self, G_STRFUNC);

	gboolean settingsRunning = TRUE, reloadInstanceSettings = TRUE;
	int i;
	HildonGtkInputMode input_mode;
	self->priv->selectorW = NULL,
	self->priv->cmdSelectorW = NULL; //for command list

	beecon_config_file_housekeeping(self); // Housekeeping!!! How HARD!!!! :)

	//g_warning("(%p) Ingresso in Settings reloadInstanceSettings=%d", self, reloadInstanceSettings);
	while(reloadInstanceSettings) { // First time we go free and easy
		reloadInstanceSettings = FALSE; // Door wide shut!
		settingsRunning = TRUE;
		//g_warning ("(%p) settingsRunning in outer settings diaolg loop= %d",self, settingsRunning);
		gchar *dTitle = g_strdup_printf("Queen BeeCon Widget Settings [%s]", self->priv->qbwDbusId);
		self->priv->dialogW = gtk_dialog_new_with_buttons (dTitle, NULL, GTK_DIALOG_DESTROY_WITH_PARENT, //
																										 _("wdgt_bd_save"), GTK_RESPONSE_ACCEPT,
																										 "Save & Run", NON_GTK_RESPONSE_SAVE_AND_RUN,
																										 "Add Cmd", NON_GTK_RESPONSE_ADD_CMD,
																										 "Edit Cmd", NON_GTK_RESPONSE_EDIT_CMD,
																										 "Advanced", NON_GTK_RESPONSE_ADVANCED,
																										 NULL);
		g_free(dTitle);

		//g_warning("(%p) Building settings dialog %p", self, dialog);
		self->priv->settingsAreaW = gtk_dialog_get_content_area (GTK_DIALOG (self->priv->dialogW));
		self->priv->scrollW = hildon_pannable_area_new ();
		g_object_set (self->priv->scrollW, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);

		self->priv->content_areaW = gtk_vbox_new (FALSE, 0);
		hildon_pannable_area_add_with_viewport (HILDON_PANNABLE_AREA (self->priv->scrollW), self->priv->content_areaW);
		gtk_container_add (GTK_CONTAINER (self->priv->settingsAreaW), self->priv->scrollW);
		gtk_window_set_default_size (GTK_WINDOW (self->priv->dialogW), -1, 400);

		queen_beecon_read_settings(self, FALSE, FALSE, NULL);

		self->priv->widCmdTypeBoxW = gtk_hbox_new (FALSE, 0);
		//BEGIN Command Selector
		self->priv->widgetTypeW = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->widgetTypeW), "Beecon");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->widgetTypeW), "Snippet");//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->widgetTypeW), 0, self->priv->widgetType);//AP1

		self->priv->widgetTypeSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1

		hildon_button_set_title (HILDON_BUTTON (self->priv->widgetTypeSelectorW), "Type");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->widgetTypeSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->widgetTypeSelectorW), HILDON_TOUCH_SELECTOR (self->priv->widgetTypeW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->widCmdTypeBoxW), self->priv->widgetTypeSelectorW, FALSE, FALSE, 0);//AP

		self->priv->widgetVisibleW = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->widgetVisibleW), "Hidden");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->widgetVisibleW), "Visible");//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->widgetVisibleW), 0, self->priv->widgetVisible);//AP1

		self->priv->widgetVisibleSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->widgetVisibleSelectorW), "Show");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->widgetVisibleSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->widgetVisibleSelectorW), HILDON_TOUCH_SELECTOR (self->priv->widgetVisibleW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->widCmdTypeBoxW), self->priv->widgetVisibleSelectorW, FALSE, FALSE, 0);//AP

		self->priv->widgetOperationalStatusW = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->widgetOperationalStatusW), "Enabled");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->widgetOperationalStatusW), "Disabled");//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->widgetOperationalStatusW), 0, self->priv->operationalStatus);//AP1

		self->priv->widgetOperationalStatusSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->widgetOperationalStatusSelectorW), "Status");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->widgetOperationalStatusSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->widgetOperationalStatusSelectorW), HILDON_TOUCH_SELECTOR (self->priv->widgetOperationalStatusW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->widCmdTypeBoxW), self->priv->widgetOperationalStatusSelectorW, FALSE, FALSE, 0);//AP

		self->priv->selectorW = hildon_touch_selector_new_text ();
		//g_warning("(%p) Created command selector %p self->priv->c_size = %d", self, self->priv->selectorW, self->priv->c_size);
		for(i=0;i<self->priv->c_size;i++)
		{
			hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->selectorW), self->priv->c_titles[i]);
			//g_warning("(%p) Append Titles [%s]-[%s]", self, self->priv->c_titles[i], self->priv->instanceTitle);
			if(g_strcmp0(self->priv->c_titles[i],self->priv->instanceTitle) == 0) {
				//g_warning("(%p) Commands [%s]-[%s]", self, self->priv->c_commands[i], self->priv->instanceCmd);
				if(g_strcmp0(self->priv->c_commands[i],self->priv->instanceCmd) == 0) {
					//g_warning("(%p) Active [%s]-[%s]", self, self->priv->c_commands[i], self->priv->instanceCmd);
					hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->selectorW), 0, i);
				}
			}
		}
		self->priv->cmdSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
		hildon_button_set_title (HILDON_BUTTON (self->priv->cmdSelectorW), "Command Selection");
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->cmdSelectorW), 0, 0.5, 0, 0);
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->cmdSelectorW), HILDON_TOUCH_SELECTOR (self->priv->selectorW));
		gtk_box_pack_start (GTK_BOX (self->priv->widCmdTypeBoxW), self->priv->cmdSelectorW, TRUE, TRUE, 0);//AP
		//END

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->widCmdTypeBoxW);//AP1

#ifdef SHOW_QBW_SETTINGS_HELP
		gchar helpWarnMsg[1024];

		g_sprintf(helpWarnMsg,
				"<span font_desc=\"Nokia Sans 13\"><b><u><span foreground=\"red\">BEECONS</span></u></b> are small hexagonal cells whose background color or images change dynamically according to command exit status.\n<b><u><span foreground=\"red\">SNIPPETS</span></u></b> are normal text boxes with fixed background color or images which are not influenced by the command exit status.\n<b><span foreground=\"red\">WARNING!!!</span></b> For IMAGE filenames, leave blank or prepend \";\" for text only results. Default storage location for images, if no path specified:\n1<sup>st</sup> <span foreground=\"red\">%s%s</span>\n2<sup>nd</sup> <span foreground=\"red\">%s%s</span></span>",
				HOME_DIR,
				QUEEN_BEECON_MYDOCS_IMAGE_DIR,
				HOME_DIR,
				QUEEN_BEECON_PRIVATE_DIR);
		self->priv->widHelpLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (widHelpLabel), helpWarnMsg);
		gtk_misc_set_alignment (GTK_MISC (widHelpLabel), 0, 0);
		gtk_label_set_line_wrap (GTK_LABEL (widHelpLabel), TRUE);
		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), widHelpLabel);
#endif

		g_warning("(%p) Widget Size & Position Tuning", self);
		self->priv->widgetSizeLabelW = gtk_label_new ("");//AP1
		gtk_label_set_markup (GTK_LABEL (self->priv->widgetSizeLabelW), "Widget Size &amp; Position Tuning");//AP1
		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->widgetSizeLabelW);//AP1

		self->priv->widthBoxW = gtk_vbox_new (FALSE, 0);

		self->priv->widthLabelW = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (self->priv->widthLabelW), "Width: <small>(10-800 Pixels)</small>");
		gtk_misc_set_alignment (GTK_MISC (self->priv->widthLabelW), 0, 0.5);
		gtk_misc_set_padding (GTK_MISC (self->priv->widthLabelW), HILDON_MARGIN_DOUBLE, 0);
		gtk_box_pack_start (GTK_BOX (self->priv->widthBoxW), self->priv->widthLabelW, FALSE, FALSE, 0);

		self->priv->widthSelectW = gtk_hscale_new_with_range ((gdouble)10.0, (gdouble)SIZE_WIDTH_ALL, (gdouble)5.0);
		//g_warning("(%p) widWidth %f", self, self->priv->widWidth);
		gtk_range_set_value(GTK_RANGE(self->priv->widthSelectW), self->priv->widWidth);
		gtk_box_pack_start (GTK_BOX (self->priv->widthBoxW), self->priv->widthSelectW, TRUE, TRUE, 0);

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->widthBoxW);

		//layout opts heightBox //AP
		self->priv->heightBoxW = gtk_vbox_new (FALSE, 0);//AP

		self->priv->heightLabelW = gtk_label_new ("");//AP

		gtk_label_set_markup (GTK_LABEL (self->priv->heightLabelW), "Height: <small>(10-420 Pixels)</small>");
		gtk_misc_set_alignment (GTK_MISC (self->priv->heightLabelW), 0, 0.5);//AP
		gtk_misc_set_padding (GTK_MISC (self->priv->heightLabelW), HILDON_MARGIN_DOUBLE, 0);//AP
		gtk_box_pack_start (GTK_BOX (self->priv->heightBoxW), self->priv->heightLabelW, FALSE, FALSE, 0);//AP

		self->priv->heightSelectW = gtk_hscale_new_with_range ((gdouble)10.0, (gdouble)SIZE_HEIGHT_ALL, (gdouble)5.0);//AP
		//g_warning("(%p) widHeight %f", self, self->priv->widHeight);
		gtk_range_set_value(GTK_RANGE(self->priv->heightSelectW), self->priv->widHeight);//AP
		gtk_box_pack_start (GTK_BOX (self->priv->heightBoxW), self->priv->heightSelectW, TRUE, TRUE, 0);//AP

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->heightBoxW);//AP

		self->priv->widPositionBoxW = gtk_hbox_new (FALSE, 0);//AP1

		self->priv->widPositionLabelW = gtk_label_new ("");//AP1
		gtk_label_set_markup (GTK_LABEL (self->priv->widPositionLabelW), "<small>Tune (X,Y)</small>");
		gtk_misc_set_alignment (GTK_MISC (self->priv->widPositionLabelW), 0, 0.8);//AP1
		gtk_misc_set_padding (GTK_MISC (self->priv->widPositionLabelW), HILDON_MARGIN_DOUBLE, 0);//AP1

		// Check if we have moved our widget window through settings for fine tuning
		gint widXOrigin, widYOrigin;
		gtk_window_get_position (GTK_WINDOW (self), &widXOrigin, &widYOrigin); // Remember our position ... maybe we need to move a little bit

		self->priv->widPositionXW = gtk_hscale_new_with_range ((gdouble)widXOrigin-5, (gdouble)widXOrigin+5, (gdouble)1);//AP1
		gtk_range_set_value(GTK_RANGE(self->priv->widPositionXW), widXOrigin);//AP1

		self->priv->widPositionYW = gtk_hscale_new_with_range ((gdouble)widYOrigin-5, (gdouble)widYOrigin+5, (gdouble)1);//AP1
		gtk_range_set_value(GTK_RANGE(self->priv->widPositionYW), widYOrigin);//AP1

		gtk_box_pack_start (GTK_BOX (self->priv->widPositionBoxW), self->priv->widPositionLabelW, FALSE, FALSE, 0);//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->widPositionBoxW), self->priv->widPositionXW, TRUE, TRUE, 0);//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->widPositionBoxW), self->priv->widPositionYW, TRUE, TRUE, 0);//AP1

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->widPositionBoxW);//AP1

		self->priv->widgetBgLabelW = gtk_label_new ("Status Background Colors & Images");//AP1
		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->widgetBgLabelW);//AP1

#ifdef NEW_COLOR_DIALOG
		self->priv->hidCanvSnipBgBoxW = gtk_hbox_new (FALSE, 0);//AP1
#else
		self->priv->hidCanvSnipBgBoxW = gtk_hbox_new (FALSE, 0);//AP1
#endif

		self->priv->checkBtHideCanvasW = hildon_check_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		gtk_button_set_label (GTK_BUTTON (self->priv->checkBtHideCanvasW), "Hide Background");
		//g_warning("(%p) hideCanvas %d", self, self->priv->hideCanvas);
		hildon_check_button_set_active (HILDON_CHECK_BUTTON (self->priv->checkBtHideCanvasW), self->priv->hideCanvas);
		gtk_box_pack_start (GTK_BOX (self->priv->hidCanvSnipBgBoxW), self->priv->checkBtHideCanvasW, TRUE, TRUE, 0);//AP

//#ifdef CUTOFF
#ifdef NEW_COLOR_DIALOG
		g_warning("(%p) snippetExtBgRGB %s", self, self->priv->snippetExtBgRGB);
		gdk_color_parse(self->priv->snippetExtBgRGB, &self->priv->snippetBgRGBC);
		g_warning("(%p) color r=%4x g=%4x b=%4x", self, self->priv->snippetBgRGBC.red,self->priv->snippetBgRGBC.green,self->priv->snippetBgRGBC.blue);
		self->priv->snippetBgRGBSelectorW = he_color_button_new_with_color(&self->priv->snippetBgRGBC);
		g_warning("(%p) snippetBgRGBSelector ptr %p", self, self->priv->snippetBgRGBSelectorW);
		hildon_gtk_widget_set_theme_size (self->priv->snippetBgRGBSelectorW, HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		he_color_button_set_markup_label (HE_COLOR_BUTTON(self->priv->snippetBgRGBSelectorW), "<small><span font_desc=\"Nokia Sans 12\" foreground=\"white\"> Snippet BgCol </span>\n<span font_desc=\"Nokia Sans 12\" foreground=\"black\"> Snippet BgCol </span></small>");
		g_warning("he_color_button_new %p", self->priv->snippetBgRGBSelectorW);
		gtk_box_pack_start (GTK_BOX (self->priv->hidCanvSnipBgBoxW), self->priv->snippetBgRGBSelectorW, FALSE, FALSE, 0);//AP
#else
#ifdef OLD_COLOR
		gtk_box_pack_start (GTK_BOX (self->priv->hidCanvSnipBgBoxW), self->priv->checkBtHideCanvasW, TRUE, TRUE, 0);//AP

		self->priv->snippetBgRGBW = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_colors[i].colorName!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->snippetBgRGBW), p_colors[i].colorName);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->snippetBgRGBW), 0, self->priv->snippetBgRGB);//AP1

		self->priv->snippetBgRGBSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->snippetBgRGBSelectorW), "Snip Bg");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->snippetBgRGBSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->snippetBgRGBSelectorW), HILDON_TOUCH_SELECTOR (self->priv->snippetBgRGBW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->hidCanvSnipBgBoxW), self->priv->snippetBgRGBSelectorW, TRUE, TRUE, 0);//AP
#endif
#endif
		struct _colorAux snI;
		GtkWidget *buttonsn = hildon_button_new_with_text ( HILDON_SIZE_FINGER_HEIGHT | HILDON_SIZE_AUTO_WIDTH,
												HILDON_BUTTON_ARRANGEMENT_VERTICAL,
												"Snippet",
												"Background Color");
		hildon_button_set_image (HILDON_BUTTON (buttonsn), gtk_image_new_from_stock (GTK_STOCK_SELECT_COLOR, GTK_ICON_SIZE_MENU));
        gtk_box_pack_start (GTK_BOX (self->priv->hidCanvSnipBgBoxW), buttonsn, FALSE, FALSE, 0);

		GtkWidget *snipPVLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (snipPVLabel), "<small><span font_desc=\"Nokia Sans 12\" foreground=\"white\"> Lite </span>\n<span font_desc=\"Nokia Sans 12\" foreground=\"black\"> Dark </span></small>");
		//g_warning("(%p) self->priv->snippetExtBgRGB=%s",self,self->priv->snippetExtBgRGB);
		gdk_color_parse(self->priv->snippetExtBgRGB, &self->priv->snippetBgRGBC);
		GtkWidget *snipPVEvt = gtk_event_box_new ();
		gtk_container_add (GTK_CONTAINER (snipPVEvt), snipPVLabel);
		gtk_widget_modify_bg (GTK_WIDGET (snipPVEvt), GTK_STATE_NORMAL, &self->priv->snippetBgRGBC);gtk_widget_modify_bg (GTK_WIDGET (snipPVEvt), GTK_STATE_PRELIGHT, &self->priv->snippetBgRGBC);
        gtk_box_pack_start (GTK_BOX (self->priv->hidCanvSnipBgBoxW), snipPVEvt, FALSE, FALSE, 0);

        snI.WC = &self->priv->snippetBgRGBC; snI.WP = snipPVEvt;  snI.FG = FALSE;
        g_signal_connect (buttonsn, "clicked", G_CALLBACK (color_button_clicked_cb), &snI);

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->hidCanvSnipBgBoxW);//AP1

#ifdef SHOW_QBW_SETTINGS_HELP
		self->priv->snipHelpLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (snipHelpLabel), "<span font_desc=\"Nokia Sans 12\"><b><u>Not affected</u></b> by Command Exit Status</span>");
		gtk_misc_set_alignment (GTK_MISC (snipHelpLabel), 1, 0);
		gtk_label_set_line_wrap (GTK_LABEL (snipHelpLabel), TRUE);
		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), snipHelpLabel);
#endif

		self->priv->beeconExitStatusesLabelW = gtk_label_new ("");
		g_warning("(%p) Beecon Statuses: Image, Scale, Background Color", self);
		gtk_label_set_markup (GTK_LABEL (self->priv->beeconExitStatusesLabelW), "<small>Beecon Statuses: Image, Scale, Background Color</small>");//AP1
		gtk_misc_set_alignment (GTK_MISC (self->priv->beeconExitStatusesLabelW), 0.5, 0.5);
		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->beeconExitStatusesLabelW);//AP1

		//BEGIN beecon images image
		self->priv->beelt0BoxW = gtk_hbox_new (FALSE, 0);//AP1

		self->priv->beelt0BoxxW = gtk_hbox_new (TRUE, 0);//AP1
		self->priv->beecon_lt0_ImgLabelW = gtk_label_new ("");
		//g_warning("(%p) lt0", self);
		gtk_label_set_markup (GTK_LABEL (self->priv->beecon_lt0_ImgLabelW), "<span foreground=\"red\"><b>&lt;0</b></span>");//AP1
		gtk_misc_set_alignment (GTK_MISC (self->priv->beecon_lt0_ImgLabelW), 0, 0.5);
		gtk_box_pack_start (GTK_BOX (self->priv->beelt0BoxxW), self->priv->beecon_lt0_ImgLabelW, TRUE, TRUE, 0);//AP
		gtk_box_pack_start (GTK_BOX (self->priv->beelt0BoxW), self->priv->beelt0BoxxW, FALSE, FALSE, 0);//AP

		self->priv->beecon_lt0_ImgEntryW = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		input_mode = hildon_gtk_entry_get_input_mode (GTK_ENTRY (self->priv->beecon_lt0_ImgEntryW));
		input_mode &= ~HILDON_GTK_INPUT_MODE_AUTOCAP;hildon_gtk_entry_set_input_mode (GTK_ENTRY (self->priv->beecon_lt0_ImgEntryW), input_mode);
		hildon_entry_set_text(HILDON_ENTRY (self->priv->beecon_lt0_ImgEntryW), self->priv->beecon_lt0_ImgFilename);
		gtk_box_pack_start (GTK_BOX (self->priv->beelt0BoxW), self->priv->beecon_lt0_ImgEntryW, TRUE, TRUE, 0);//AP

		self->priv->beecon_lt0_ImgZoomW = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_lt0_ImgZoomW), "1:1");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_lt0_ImgZoomW), "Fit");//AP1
		for(i=5;i<=200;i+=5) {//AP1
				char *b = g_strdup_printf("%d %%",i);
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_lt0_ImgZoomW), b);//AP1
				g_free(b);
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_lt0_ImgZoomW), 0, self->priv->beecon_lt0_ImgZoom);//AP1
		self->priv->beecon_lt0_ImgZoomSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->beecon_lt0_ImgZoomSelectorW), "Scale");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->beecon_lt0_ImgZoomSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->beecon_lt0_ImgZoomSelectorW), HILDON_TOUCH_SELECTOR (self->priv->beecon_lt0_ImgZoomW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->beelt0BoxW), self->priv->beecon_lt0_ImgZoomSelectorW, FALSE, FALSE, 0);//AP

#ifdef NEW_COLOR_DIALOG
		gdk_color_parse(self->priv->beecon_lt0_ExtBgRGB, &self->priv->lt0_BgRGBC);
		self->priv->beecon_lt0_BgRGBSelectorW = he_color_button_new_with_color(&self->priv->lt0_BgRGBC);
		hildon_gtk_widget_set_theme_size (self->priv->beecon_lt0_BgRGBSelectorW, HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		he_color_button_set_markup_label (HE_COLOR_BUTTON(self->priv->beecon_lt0_BgRGBSelectorW), "<small><span font_desc=\"Nokia Sans 12\" foreground=\"white\"> BgCol </span>\n<span font_desc=\"Nokia Sans 12\" foreground=\"black\"> BgCol </span></small>");
		g_warning("he_color_button_new %p", self->priv->beecon_lt0_BgRGBSelectorW);
		gtk_box_pack_start (GTK_BOX (self->priv->beelt0BoxW), self->priv->beecon_lt0_BgRGBSelectorW, FALSE, FALSE, 0);//AP
#else
#ifdef OLD_COLOR
		self->priv->beecon_lt0_BgRGBW = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_colors[i].colorName!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_lt0_BgRGBW), p_colors[i].colorName);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_lt0_BgRGBW), 0, self->priv->beecon_lt0_BgRGB);//AP1

		self->priv->beecon_lt0_BgRGBSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->beecon_lt0_BgRGBSelectorW), "Bg Color");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->beecon_lt0_BgRGBSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->beecon_lt0_BgRGBSelectorW), HILDON_TOUCH_SELECTOR (self->priv->beecon_lt0_BgRGBW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->beelt0BoxW), self->priv->beecon_lt0_BgRGBSelectorW, FALSE, FALSE, 0);//AP
#endif
#endif
		struct _colorAux lt0;
		GtkWidget *buttonlt0 = hildon_button_new_with_text ( HILDON_SIZE_FINGER_HEIGHT | HILDON_SIZE_AUTO_WIDTH,
												HILDON_BUTTON_ARRANGEMENT_VERTICAL,
												NULL,
												"Bg");
		hildon_button_set_image (HILDON_BUTTON (buttonlt0), gtk_image_new_from_stock (GTK_STOCK_SELECT_COLOR, GTK_ICON_SIZE_MENU));
        gtk_box_pack_start (GTK_BOX (self->priv->beelt0BoxW), buttonlt0, FALSE, FALSE, 0);

		GtkWidget *lt0PVLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (lt0PVLabel), "<small><span font_desc=\"Nokia Sans 12\" foreground=\"white\"> Lite </span>\n<span font_desc=\"Nokia Sans 12\" foreground=\"black\"> Dark </span></small>");
		//g_warning("(%p) self->priv->beecon_lt0_ExtBgRGB=%s",self,self->priv->beecon_lt0_ExtBgRGB);
		gdk_color_parse(self->priv->beecon_lt0_ExtBgRGB, &self->priv->lt0_BgRGBC);
		GtkWidget *lt0PVEvt = gtk_event_box_new ();
		gtk_container_add (GTK_CONTAINER (lt0PVEvt), lt0PVLabel);
		gtk_widget_modify_bg (GTK_WIDGET (lt0PVEvt), GTK_STATE_NORMAL, &self->priv->lt0_BgRGBC);gtk_widget_modify_bg (GTK_WIDGET (lt0PVEvt), GTK_STATE_PRELIGHT, &self->priv->lt0_BgRGBC);
        gtk_box_pack_start (GTK_BOX (self->priv->beelt0BoxW), lt0PVEvt, FALSE, FALSE, 0);

        lt0.WC = &self->priv->lt0_BgRGBC; lt0.WP = lt0PVEvt;  lt0.FG = FALSE;
        g_signal_connect (buttonlt0, "clicked", G_CALLBACK (color_button_clicked_cb), &lt0);

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->beelt0BoxW);//AP1

		self->priv->beeeq0BoxW = gtk_hbox_new (FALSE, 0);//AP1
		//BEGIN beecon images image

		self->priv->beeeq0BoxxW = gtk_hbox_new (TRUE, 0);//AP1
		self->priv->beecon_eq0_ImgLabelW = gtk_label_new ("");
		//g_warning("(%p) eq0", self);
		gtk_label_set_markup (GTK_LABEL (self->priv->beecon_eq0_ImgLabelW), "<span foreground=\"red\"><b>=0</b></span>");//AP1
		gtk_misc_set_alignment (GTK_MISC (self->priv->beecon_eq0_ImgLabelW), 0, 0.5);
		gtk_box_pack_start (GTK_BOX (self->priv->beeeq0BoxxW), self->priv->beecon_eq0_ImgLabelW, TRUE, TRUE, 0);//AP
		gtk_box_pack_start (GTK_BOX (self->priv->beeeq0BoxW), self->priv->beeeq0BoxxW, FALSE, FALSE, 0);//AP

		self->priv->beecon_eq0_ImgEntryW = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		input_mode = hildon_gtk_entry_get_input_mode (GTK_ENTRY (self->priv->beecon_eq0_ImgEntryW));
		input_mode &= ~HILDON_GTK_INPUT_MODE_AUTOCAP;hildon_gtk_entry_set_input_mode (GTK_ENTRY (self->priv->beecon_eq0_ImgEntryW), input_mode);
		hildon_entry_set_text(HILDON_ENTRY (self->priv->beecon_eq0_ImgEntryW), self->priv->beecon_eq0_ImgFilename);
		gtk_box_pack_start (GTK_BOX (self->priv->beeeq0BoxW), self->priv->beecon_eq0_ImgEntryW, TRUE, TRUE, 0);//AP
		//END title image

		self->priv->beecon_eq0_ImgZoomW = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_eq0_ImgZoomW), "1:1");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_eq0_ImgZoomW), "Fit");//AP1
		for(i=5;i<=200;i+=5) {//AP1
				char *b = g_strdup_printf("%d %%",i);
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_eq0_ImgZoomW), b);//AP1
				g_free(b);
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_eq0_ImgZoomW), 0, self->priv->beecon_eq0_ImgZoom);//AP1
		self->priv->beecon_eq0_ImgZoomSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->beecon_eq0_ImgZoomSelectorW), "Scale");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->beecon_eq0_ImgZoomSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->beecon_eq0_ImgZoomSelectorW), HILDON_TOUCH_SELECTOR (self->priv->beecon_eq0_ImgZoomW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->beeeq0BoxW), self->priv->beecon_eq0_ImgZoomSelectorW, FALSE, FALSE, 0);//AP

#ifdef NEW_COLOR_DIALOG
		gdk_color_parse(self->priv->beecon_eq0_ExtBgRGB, &self->priv->eq0_BgRGBC);
		self->priv->beecon_eq0_BgRGBSelectorW = he_color_button_new_with_color(&self->priv->eq0_BgRGBC);
		hildon_gtk_widget_set_theme_size (self->priv->beecon_eq0_BgRGBSelectorW, HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		he_color_button_set_markup_label (HE_COLOR_BUTTON(self->priv->beecon_eq0_BgRGBSelectorW), "<small><span font_desc=\"Nokia Sans 12\" foreground=\"white\"> BgCol </span>\n<span font_desc=\"Nokia Sans 12\" foreground=\"black\"> BgCol </span></small>");
		g_warning("he_color_button_new %p", self->priv->beecon_eq0_BgRGBSelectorW);
		gtk_box_pack_start (GTK_BOX (self->priv->beeeq0BoxW), self->priv->beecon_eq0_BgRGBSelectorW, FALSE, FALSE, 0);//AP
#else
#ifdef OLD_COLOR
		self->priv->beecon_eq0_BgRGBW = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_colors[i].colorName!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_eq0_BgRGBW), p_colors[i].colorName);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_eq0_BgRGBW), 0, self->priv->beecon_eq0_BgRGB);//AP1

		self->priv->beecon_eq0_BgRGBSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->beecon_eq0_BgRGBSelectorW), "Bg Color");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->beecon_eq0_BgRGBSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->beecon_eq0_BgRGBSelectorW), HILDON_TOUCH_SELECTOR (self->priv->beecon_eq0_BgRGBW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->beeeq0BoxW), self->priv->beecon_eq0_BgRGBSelectorW, FALSE, FALSE, 0);//AP
#endif
#endif
		struct _colorAux eq0;
		GtkWidget *buttoneq0 = hildon_button_new_with_text ( HILDON_SIZE_FINGER_HEIGHT | HILDON_SIZE_AUTO_WIDTH,
												HILDON_BUTTON_ARRANGEMENT_VERTICAL,
												NULL,
												"Bg");
		hildon_button_set_image (HILDON_BUTTON (buttoneq0), gtk_image_new_from_stock (GTK_STOCK_SELECT_COLOR, GTK_ICON_SIZE_MENU));
        gtk_box_pack_start (GTK_BOX (self->priv->beeeq0BoxW), buttoneq0, FALSE, FALSE, 0);

		GtkWidget *eq0PVLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (eq0PVLabel), "<small><span font_desc=\"Nokia Sans 12\" foreground=\"white\"> Lite </span>\n<span font_desc=\"Nokia Sans 12\" foreground=\"black\"> Dark </span></small>");
		//g_warning("(%p) self->priv->beecon_eq0_ExtBgRGB=%s",self,self->priv->beecon_eq0_ExtBgRGB);
		gdk_color_parse(self->priv->beecon_eq0_ExtBgRGB, &self->priv->eq0_BgRGBC);
		GtkWidget *eq0PVEvt = gtk_event_box_new ();
		gtk_container_add (GTK_CONTAINER (eq0PVEvt), eq0PVLabel);
		gtk_widget_modify_bg (GTK_WIDGET (eq0PVEvt), GTK_STATE_NORMAL, &self->priv->eq0_BgRGBC);gtk_widget_modify_bg (GTK_WIDGET (eq0PVEvt), GTK_STATE_PRELIGHT, &self->priv->eq0_BgRGBC);
        gtk_box_pack_start (GTK_BOX (self->priv->beeeq0BoxW), eq0PVEvt, FALSE, FALSE, 0);

        eq0.WC = &self->priv->eq0_BgRGBC; eq0.WP = eq0PVEvt; eq0.FG = FALSE;
        g_signal_connect (buttoneq0, "clicked", G_CALLBACK (color_button_clicked_cb), &eq0);

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->beeeq0BoxW);//AP1

		self->priv->beeeq1BoxW = gtk_hbox_new (FALSE, 0);//AP1
		//BEGIN beecon images image
		self->priv->beeeq1BoxxW = gtk_hbox_new (TRUE, 0);//AP1
		self->priv->beecon_eq1_ImgLabelW = gtk_label_new ("");
		//g_warning("(%p) eq1", self);
		gtk_label_set_markup (GTK_LABEL (self->priv->beecon_eq1_ImgLabelW), "<span foreground=\"red\"><b>=1</b></span>");//AP1
		gtk_misc_set_alignment (GTK_MISC (self->priv->beecon_eq1_ImgLabelW), 0, 0.5);
		gtk_box_pack_start (GTK_BOX (self->priv->beeeq1BoxxW), self->priv->beecon_eq1_ImgLabelW, TRUE, TRUE, 0);//AP
		gtk_box_pack_start (GTK_BOX (self->priv->beeeq1BoxW), self->priv->beeeq1BoxxW, FALSE, FALSE, 0);//AP

		self->priv->beecon_eq1_ImgEntryW = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		input_mode = hildon_gtk_entry_get_input_mode (GTK_ENTRY (self->priv->beecon_eq1_ImgEntryW));
		input_mode &= ~HILDON_GTK_INPUT_MODE_AUTOCAP;hildon_gtk_entry_set_input_mode (GTK_ENTRY (self->priv->beecon_eq1_ImgEntryW), input_mode);
		hildon_entry_set_text(HILDON_ENTRY (self->priv->beecon_eq1_ImgEntryW), self->priv->beecon_eq1_ImgFilename);
		gtk_box_pack_start (GTK_BOX (self->priv->beeeq1BoxW), self->priv->beecon_eq1_ImgEntryW, TRUE, TRUE, 0);//AP
		//END title image

		self->priv->beecon_eq1_ImgZoomW = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_eq1_ImgZoomW), "1:1");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_eq1_ImgZoomW), "Fit");//AP1
		for(i=5;i<=200;i+=5) {//AP1
				char *b = g_strdup_printf("%d %%",i);
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_eq1_ImgZoomW), b);//AP1
				g_free(b);
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_eq1_ImgZoomW), 0, self->priv->beecon_eq1_ImgZoom);//AP1
		self->priv->beecon_eq1_ImgZoomSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->beecon_eq1_ImgZoomSelectorW), "Scale");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->beecon_eq1_ImgZoomSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->beecon_eq1_ImgZoomSelectorW), HILDON_TOUCH_SELECTOR (self->priv->beecon_eq1_ImgZoomW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->beeeq1BoxW), self->priv->beecon_eq1_ImgZoomSelectorW, FALSE, FALSE, 0);//AP

#ifdef NEW_COLOR_DIALOG
		gdk_color_parse(self->priv->beecon_eq1_ExtBgRGB, &self->priv->eq1_BgRGBC);
		self->priv->beecon_eq1_BgRGBSelectorW = he_color_button_new_with_color(&self->priv->eq1_BgRGBC);
		hildon_gtk_widget_set_theme_size (self->priv->beecon_eq1_BgRGBSelectorW, HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		he_color_button_set_markup_label (HE_COLOR_BUTTON(self->priv->beecon_eq1_BgRGBSelectorW), "<small><span font_desc=\"Nokia Sans 12\" foreground=\"white\"> BgCol </span>\n<span font_desc=\"Nokia Sans 12\" foreground=\"black\"> BgCol </span></small>");
		g_warning("he_color_button_new %p", self->priv->beecon_eq1_BgRGBSelectorW);
		gtk_box_pack_start (GTK_BOX (self->priv->beeeq1BoxW), self->priv->beecon_eq1_BgRGBSelectorW, FALSE, FALSE, 0);//AP
#else
#ifdef OLD_COLOR
		self->priv->beecon_eq1_BgRGBW = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_colors[i].colorName!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_eq1_BgRGBW), p_colors[i].colorName);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_eq1_BgRGBW), 0, self->priv->beecon_eq1_BgRGB);//AP1

		self->priv->beecon_eq1_BgRGBSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->beecon_eq1_BgRGBSelectorW), "Bg Color");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->beecon_eq1_BgRGBSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->beecon_eq1_BgRGBSelectorW), HILDON_TOUCH_SELECTOR (self->priv->beecon_eq1_BgRGBW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->beeeq1BoxW), self->priv->beecon_eq1_BgRGBSelectorW, FALSE, FALSE, 0);//AP
#endif
#endif
		struct _colorAux eq1;
		GtkWidget *buttoneq1 = hildon_button_new_with_text ( HILDON_SIZE_FINGER_HEIGHT | HILDON_SIZE_AUTO_WIDTH,
												HILDON_BUTTON_ARRANGEMENT_VERTICAL,
												NULL,
												"Bg");
		hildon_button_set_image (HILDON_BUTTON (buttoneq1), gtk_image_new_from_stock (GTK_STOCK_SELECT_COLOR, GTK_ICON_SIZE_MENU));
        gtk_box_pack_start (GTK_BOX (self->priv->beeeq1BoxW), buttoneq1, FALSE, FALSE, 0);

		GtkWidget *eq1PVLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (eq1PVLabel), "<small><span font_desc=\"Nokia Sans 12\" foreground=\"white\"> Lite </span>\n<span font_desc=\"Nokia Sans 12\" foreground=\"black\"> Dark </span></small>");
		//g_warning("(%p) self->priv->beecon_eq1_ExtBgRGB=%s",self,self->priv->beecon_eq1_ExtBgRGB);
		gdk_color_parse(self->priv->beecon_eq1_ExtBgRGB, &self->priv->eq1_BgRGBC);
		GtkWidget *eq1PVEvt = gtk_event_box_new ();
		gtk_container_add (GTK_CONTAINER (eq1PVEvt), eq1PVLabel);
		gtk_widget_modify_bg (GTK_WIDGET (eq1PVEvt), GTK_STATE_NORMAL, &self->priv->eq1_BgRGBC);gtk_widget_modify_bg (GTK_WIDGET (eq1PVEvt), GTK_STATE_PRELIGHT, &self->priv->eq1_BgRGBC);
        gtk_box_pack_start (GTK_BOX (self->priv->beeeq1BoxW), eq1PVEvt, FALSE, FALSE, 0);

        eq1.WC = &self->priv->eq1_BgRGBC; eq1.WP = eq1PVEvt; eq1.FG = FALSE;
        g_signal_connect (buttoneq1, "clicked", G_CALLBACK (color_button_clicked_cb), &eq1);

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->beeeq1BoxW);//AP1

		self->priv->beege2BoxW = gtk_hbox_new (FALSE, 0);//AP1

		self->priv->beege2BoxxW = gtk_hbox_new (TRUE, 0);//AP1
		self->priv->beecon_ge2_ImgLabelW = gtk_label_new ("");
		//g_warning("(%p) ge2", self);
		gtk_label_set_markup (GTK_LABEL (self->priv->beecon_ge2_ImgLabelW), "<span foreground=\"red\"><b>=2</b></span>");//AP1
		gtk_misc_set_alignment (GTK_MISC (self->priv->beecon_ge2_ImgLabelW), 0, 0.5);
		gtk_box_pack_start (GTK_BOX (self->priv->beege2BoxxW), self->priv->beecon_ge2_ImgLabelW, TRUE, TRUE, 0);//AP
		gtk_box_pack_start (GTK_BOX (self->priv->beege2BoxW), self->priv->beege2BoxxW, FALSE, FALSE, 0);//AP

		self->priv->beecon_ge2_ImgEntryW = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		input_mode = hildon_gtk_entry_get_input_mode (GTK_ENTRY (self->priv->beecon_ge2_ImgEntryW));
		input_mode &= ~HILDON_GTK_INPUT_MODE_AUTOCAP;hildon_gtk_entry_set_input_mode (GTK_ENTRY (self->priv->beecon_ge2_ImgEntryW), input_mode);
		hildon_entry_set_text(HILDON_ENTRY (self->priv->beecon_ge2_ImgEntryW), self->priv->beecon_ge2_ImgFilename);
		gtk_box_pack_start (GTK_BOX (self->priv->beege2BoxW), self->priv->beecon_ge2_ImgEntryW, TRUE, TRUE, 0);//AP
		//END title image

		self->priv->beecon_ge2_ImgZoomW = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_ge2_ImgZoomW), "1:1");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_ge2_ImgZoomW), "Fit");//AP1
		for(i=5;i<=200;i+=5) {//AP1
				char *b = g_strdup_printf("%d %%",i);
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_ge2_ImgZoomW), b);//AP1
				g_free(b);
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_ge2_ImgZoomW), 0, self->priv->beecon_ge2_ImgZoom);//AP1
		self->priv->beecon_ge2_ImgZoomSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->beecon_ge2_ImgZoomSelectorW), "Scale");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->beecon_ge2_ImgZoomSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->beecon_ge2_ImgZoomSelectorW), HILDON_TOUCH_SELECTOR (self->priv->beecon_ge2_ImgZoomW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->beege2BoxW), self->priv->beecon_ge2_ImgZoomSelectorW, FALSE, FALSE, 0);//AP

#ifdef NEW_COLOR_DIALOG
		gdk_color_parse(self->priv->beecon_ge2_ExtBgRGB, &self->priv->ge2_BgRGBC);
		self->priv->beecon_ge2_BgRGBSelectorW = he_color_button_new_with_color(&self->priv->ge2_BgRGBC);
		hildon_gtk_widget_set_theme_size (self->priv->beecon_ge2_BgRGBSelectorW, HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		he_color_button_set_markup_label (HE_COLOR_BUTTON(self->priv->beecon_ge2_BgRGBSelectorW), "<small><span font_desc=\"Nokia Sans 12\" foreground=\"white\"> BgCol </span>\n<span font_desc=\"Nokia Sans 12\" foreground=\"black\"> BgCol </span></small>");
		g_warning("he_color_button_new %p", self->priv->beecon_ge2_BgRGBSelectorW);
		gtk_box_pack_start (GTK_BOX (self->priv->beege2BoxW), self->priv->beecon_ge2_BgRGBSelectorW, FALSE, FALSE, 0);//AP
#else
#ifdef OLD_COLOR
		self->priv->beecon_ge2_BgRGBW = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_colors[i].colorName!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_ge2_BgRGBW), p_colors[i].colorName);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_ge2_BgRGBW), 0, self->priv->beecon_ge2_BgRGB);//AP1

		self->priv->beecon_ge2_BgRGBSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->beecon_ge2_BgRGBSelectorW), "Bg Color");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->beecon_ge2_BgRGBSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->beecon_ge2_BgRGBSelectorW), HILDON_TOUCH_SELECTOR (self->priv->beecon_ge2_BgRGBW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->beege2BoxW), self->priv->beecon_ge2_BgRGBSelectorW, FALSE, FALSE, 0);//AP
#endif
#endif
		struct _colorAux ge2;
		GtkWidget *buttonge2 = hildon_button_new_with_text ( HILDON_SIZE_FINGER_HEIGHT | HILDON_SIZE_AUTO_WIDTH,
												HILDON_BUTTON_ARRANGEMENT_VERTICAL,
												NULL,
												"Bg");
		hildon_button_set_image (HILDON_BUTTON (buttonge2), gtk_image_new_from_stock (GTK_STOCK_SELECT_COLOR, GTK_ICON_SIZE_MENU));
        gtk_box_pack_start (GTK_BOX (self->priv->beege2BoxW), buttonge2, FALSE, FALSE, 0);

		GtkWidget *ge2PVLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (ge2PVLabel), "<small><span font_desc=\"Nokia Sans 12\" foreground=\"white\"> Lite </span>\n<span font_desc=\"Nokia Sans 12\" foreground=\"black\"> Dark </span></small>");
		//g_warning("(%p) self->priv->beecon_ge2_ExtBgRGB=%s",self,self->priv->beecon_ge2_ExtBgRGB);
		gdk_color_parse(self->priv->beecon_ge2_ExtBgRGB, &self->priv->ge2_BgRGBC);
		GtkWidget *ge2PVEvt = gtk_event_box_new ();
		gtk_container_add (GTK_CONTAINER (ge2PVEvt), ge2PVLabel);
		gtk_widget_modify_bg (GTK_WIDGET (ge2PVEvt), GTK_STATE_NORMAL, &self->priv->ge2_BgRGBC);gtk_widget_modify_bg (GTK_WIDGET (ge2PVEvt), GTK_STATE_PRELIGHT, &self->priv->ge2_BgRGBC);
        gtk_box_pack_start (GTK_BOX (self->priv->beege2BoxW), ge2PVEvt, FALSE, FALSE, 0);

        ge2.WC = &self->priv->ge2_BgRGBC; ge2.WP = ge2PVEvt; ge2.FG = FALSE;
        g_signal_connect (buttonge2, "clicked", G_CALLBACK (color_button_clicked_cb), &ge2);

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->beege2BoxW);//AP1

		self->priv->beeidxge2BoxW = gtk_hbox_new (FALSE, 0);//AP1

		self->priv->beeidxge2BoxxW = gtk_hbox_new (TRUE, 0);//AP1
		self->priv->beecon_idxge2_ImgLabelW = gtk_label_new ("");
		//g_warning("(%p) ge3", self);
		gtk_label_set_markup (GTK_LABEL (self->priv->beecon_idxge2_ImgLabelW), "<span foreground=\"red\"><b>&#8805;3</b></span>");//AP1
		gtk_misc_set_alignment (GTK_MISC (self->priv->beecon_idxge2_ImgLabelW), 0, 0.5);
		gtk_box_pack_start (GTK_BOX (self->priv->beeidxge2BoxxW), self->priv->beecon_idxge2_ImgLabelW, TRUE, TRUE, 0);//AP
		gtk_box_pack_start (GTK_BOX (self->priv->beeidxge2BoxW), self->priv->beeidxge2BoxxW, FALSE, FALSE, 0);//AP

		self->priv->beecon_idxge2_ImgEntryW = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		input_mode = hildon_gtk_entry_get_input_mode (GTK_ENTRY (self->priv->beecon_idxge2_ImgEntryW));
		input_mode &= ~HILDON_GTK_INPUT_MODE_AUTOCAP;hildon_gtk_entry_set_input_mode (GTK_ENTRY (self->priv->beecon_idxge2_ImgEntryW), input_mode);
		hildon_entry_set_text(HILDON_ENTRY (self->priv->beecon_idxge2_ImgEntryW), self->priv->beecon_idxge2_ImgFilename);
		gtk_box_pack_start (GTK_BOX (self->priv->beeidxge2BoxW), self->priv->beecon_idxge2_ImgEntryW, TRUE, TRUE, 0);//AP
		//END title image

		self->priv->beecon_idxge2_ImgZoomW = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_idxge2_ImgZoomW), "1:1");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_idxge2_ImgZoomW), "Fit");//AP1
		for(i=5;i<=200;i+=5) {//AP1
				gchar *b = g_strdup_printf("%d %%",i);
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_idxge2_ImgZoomW), b);//AP1
				g_free(b);
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_idxge2_ImgZoomW), 0, self->priv->beecon_idxge2_ImgZoom);//AP1
		self->priv->beecon_idxge2_ImgZoomSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->beecon_idxge2_ImgZoomSelectorW), "Scale");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->beecon_idxge2_ImgZoomSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->beecon_idxge2_ImgZoomSelectorW), HILDON_TOUCH_SELECTOR (self->priv->beecon_idxge2_ImgZoomW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->beeidxge2BoxW), self->priv->beecon_idxge2_ImgZoomSelectorW, FALSE, FALSE, 0);//AP

#ifdef NEW_COLOR_DIALOG
		gdk_color_parse(self->priv->beecon_idxge2_ExtBgRGB, &self->priv->idxge2_BgRGBC);
		self->priv->beecon_idxge2_BgRGBSelectorW = he_color_button_new_with_color(&self->priv->idxge2_BgRGBC);
		hildon_gtk_widget_set_theme_size (self->priv->beecon_idxge2_BgRGBSelectorW, HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		he_color_button_set_markup_label (HE_COLOR_BUTTON(self->priv->beecon_idxge2_BgRGBSelectorW), "<small><span font_desc=\"Nokia Sans 12\" foreground=\"white\"> BgCol </span>\n<span font_desc=\"Nokia Sans 12\" foreground=\"black\"> BgCol </span></small>");
		g_warning("he_color_button_new %p", self->priv->beecon_idxge2_BgRGBSelectorW);
		gtk_box_pack_start (GTK_BOX (self->priv->beeidxge2BoxW), self->priv->beecon_idxge2_BgRGBSelectorW, FALSE, FALSE, 0);//AP
#else
#ifdef OLD_COLOR
		self->priv->beecon_idxge2_BgRGBW = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_colors[i].colorName!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_idxge2_BgRGBW), p_colors[i].colorName);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_idxge2_BgRGBW), 0, self->priv->beecon_idxge2_BgRGB);//AP1

		self->priv->beecon_idxge2_BgRGBSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->beecon_idxge2_BgRGBSelectorW), "Bg Color");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->beecon_idxge2_BgRGBSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->beecon_idxge2_BgRGBSelectorW), HILDON_TOUCH_SELECTOR (self->priv->beecon_idxge2_BgRGBW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->beeidxge2BoxW), self->priv->beecon_idxge2_BgRGBSelectorW, FALSE, FALSE, 0);//AP
#endif
#endif
		struct _colorAux idxge2;
		GtkWidget *buttonidxge2 = hildon_button_new_with_text ( HILDON_SIZE_FINGER_HEIGHT | HILDON_SIZE_AUTO_WIDTH,
												HILDON_BUTTON_ARRANGEMENT_VERTICAL,
												NULL,
												"Bg");
		hildon_button_set_image (HILDON_BUTTON (buttonidxge2), gtk_image_new_from_stock (GTK_STOCK_SELECT_COLOR, GTK_ICON_SIZE_MENU));
        gtk_box_pack_start (GTK_BOX (self->priv->beeidxge2BoxW), buttonidxge2, FALSE, FALSE, 0);

		GtkWidget *idxge2PVLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (idxge2PVLabel), "<small><span font_desc=\"Nokia Sans 12\" foreground=\"white\"> Lite </span>\n<span font_desc=\"Nokia Sans 12\" foreground=\"black\"> Dark </span></small>");
		//g_warning("(%p) self->priv->beecon_idxge2_ExtBgRGB=%s",self,self->priv->beecon_idxge2_ExtBgRGB);
		gdk_color_parse(self->priv->beecon_idxge2_ExtBgRGB, &self->priv->idxge2_BgRGBC);
		GtkWidget *idxge2PVEvt = gtk_event_box_new ();
		gtk_container_add (GTK_CONTAINER (idxge2PVEvt), idxge2PVLabel);
		gtk_widget_modify_bg (GTK_WIDGET (idxge2PVEvt), GTK_STATE_NORMAL, &self->priv->idxge2_BgRGBC);gtk_widget_modify_bg (GTK_WIDGET (idxge2PVEvt), GTK_STATE_PRELIGHT, &self->priv->idxge2_BgRGBC);
        gtk_box_pack_start (GTK_BOX (self->priv->beeidxge2BoxW), idxge2PVEvt, FALSE, FALSE, 0);

        idxge2.WC = &self->priv->idxge2_BgRGBC; idxge2.WP = idxge2PVEvt; idxge2.FG = FALSE;
        g_signal_connect (buttonidxge2, "clicked", G_CALLBACK (color_button_clicked_cb), &idxge2);

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->beeidxge2BoxW);//AP1
//#endif CUTOFF

		//BEGIN
		//layout opts

		g_warning("(%p) Command Title Settings", self);
		self->priv->LayoutCmdLabelW = gtk_label_new ("Command Title Settings");//AP1
		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->LayoutCmdLabelW);//AP1

		//BEGIN title image
		//self->priv->titleImgLabel = gtk_label_new ("");
		//gtk_label_set_markup (GTK_LABEL (titleImgLabel), "<span font_desc=\"Nokia Sans 12\">Image Filename:</span>");//AP1
		//gtk_misc_set_alignment (GTK_MISC (titleImgLabel), 0, 0.5);
		//gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), titleImgLabel);//AP1

		self->priv->cmdImgVisPosBoxW = gtk_hbox_new (FALSE, 0);//AP1

		//g_warning("(%p) cmd img file", self);
		self->priv->titleImgEntryW = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		input_mode = hildon_gtk_entry_get_input_mode (GTK_ENTRY (self->priv->titleImgEntryW));
		input_mode &= ~HILDON_GTK_INPUT_MODE_AUTOCAP;hildon_gtk_entry_set_input_mode (GTK_ENTRY (self->priv->titleImgEntryW), input_mode);
		hildon_entry_set_text(HILDON_ENTRY (self->priv->titleImgEntryW), self->priv->cmdImgFilename);
		gtk_box_pack_start (GTK_BOX (self->priv->cmdImgVisPosBoxW), self->priv->titleImgEntryW, TRUE, TRUE, 0);//AP1
		//END title image

		//g_warning("(%p) cmd img zoom", self);
		self->priv->beecon_cmdImgZoomW = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_cmdImgZoomW), "1:1");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_cmdImgZoomW), "Fit");//AP1
		for(i=5;i<=200;i+=5) {//AP1
				char *b = g_strdup_printf("%d %%",i);
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_cmdImgZoomW), b);//AP1
				g_free(b);
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_cmdImgZoomW), 0, self->priv->cmdImgZoom);//AP1
		self->priv->beecon_cmdImgZoomSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->beecon_cmdImgZoomSelectorW), "Scale");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->beecon_cmdImgZoomSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->beecon_cmdImgZoomSelectorW), HILDON_TOUCH_SELECTOR (self->priv->beecon_cmdImgZoomW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->cmdImgVisPosBoxW), self->priv->beecon_cmdImgZoomSelectorW, FALSE, FALSE, 0);//AP

		//g_warning("(%p) cmd img visi", self);
		self->priv->cmdImgVisibilityPositionW = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_visible_position[i]!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->cmdImgVisibilityPositionW), p_visible_position[i]);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->cmdImgVisibilityPositionW), 0, self->priv->cmdImgVisibilityPosition);//AP1

		self->priv->cmdImgVisibilityPositionSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->cmdImgVisibilityPositionSelectorW), "Position");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->cmdImgVisibilityPositionSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->cmdImgVisibilityPositionSelectorW), HILDON_TOUCH_SELECTOR (self->priv->cmdImgVisibilityPositionW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->cmdImgVisPosBoxW), self->priv->cmdImgVisibilityPositionSelectorW, FALSE, FALSE, 0);//AP1

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->cmdImgVisPosBoxW);//AP1

#ifdef OLD_FONT_DIALOG
		self->priv->cmdFontBox = gtk_hbox_new (FALSE, 0);//AP1

		self->priv->cmdFontFam = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_fonts[i]!=NULL;i++) {//AP1
			int j;
			for (j=0;j<4;j++) {//AP1
				gchar fs[256];//AP1
				g_sprintf(fs, "%s %s",p_fonts[i], p_fonts_types[j]);//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (cmdFontFam), fs);//AP1
			}//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (cmdFontFam), 0, self->priv->cmdFontName);//AP1

		self->priv->cmdFontSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_THUMB_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (cmdFontSelector), "Font Face: ");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (cmdFontSelector), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (cmdFontSelector), HILDON_TOUCH_SELECTOR (cmdFontFam));//AP1
		gtk_box_pack_start (GTK_BOX (cmdFontBox), cmdFontSelector, FALSE, FALSE, 0);//AP1

		self->priv->cmdFontSz = gtk_hscale_new_with_range ((gdouble)8, (gdouble)72, (gdouble)1);//AP1
		gtk_range_set_value(GTK_RANGE(cmdFontSz), self->priv->cmdFontSize);//AP1
		gtk_box_pack_start (GTK_BOX (cmdFontBox), cmdFontSz, TRUE, TRUE, 0);//AP1

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), cmdFontBox);//AP1
		//END
#endif
//---------
		self->priv->cmdExtFontBoxW = gtk_hbox_new (FALSE, 0);//AP1

		//g_warning("(%p) cmd font", self);
#ifdef NEW_FONT_DIALOG
		GtkWidget *buttoncfo = hildon_button_new_with_text ( HILDON_SIZE_FINGER_HEIGHT | HILDON_SIZE_AUTO_WIDTH,
												HILDON_BUTTON_ARRANGEMENT_VERTICAL,
												"Title",
												self->priv->cmdExtFont);
		hildon_button_set_image (HILDON_BUTTON (buttoncfo), gtk_image_new_from_stock (GTK_STOCK_SELECT_FONT, GTK_ICON_SIZE_MENU));
		hildon_button_set_alignment (HILDON_BUTTON (buttoncfo), 0, 0.5, 0, 0);
        g_signal_connect (buttoncfo, "clicked", G_CALLBACK (font_button_clicked_cb), NULL);
		gtk_box_pack_start (GTK_BOX (self->priv->cmdExtFontBoxW), buttoncfo, TRUE, TRUE, 0);
#else
		self->priv->cmdExtFontFamW = he_font_button_new_with_font (self->priv->cmdExtFont);
		hildon_gtk_widget_set_theme_size (self->priv->cmdExtFontFamW, HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		gtk_box_pack_start (GTK_BOX (self->priv->cmdExtFontBoxW), self->priv->cmdExtFontFamW, TRUE, TRUE, 0);
#endif

		//g_warning("(%p) cmd color", self);
#ifdef NEW_COLOR_DIALOG
		gdk_color_parse(self->priv->cmdExtFgRGB, &self->priv->cmdFgRGBC);
		self->priv->cmdFgRGBSelectorW = he_color_button_new_with_color(&self->priv->cmdFgRGBC);
		hildon_gtk_widget_set_theme_size (self->priv->cmdFgRGBSelectorW, HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		he_color_button_set_markup_label (HE_COLOR_BUTTON(self->priv->cmdFgRGBSelectorW), "<small><span font_desc=\"Nokia Sans 12\" foreground=\"white\"> FgCol </span>\n<span font_desc=\"Nokia Sans 12\" foreground=\"black\"> FgCol </span></small>");
		g_warning("he_color_button_new %p", self->priv->cmdFgRGBSelectorW);
		gtk_box_pack_start (GTK_BOX (self->priv->cmdExtFontBoxW), self->priv->cmdFgRGBSelectorW, FALSE, FALSE, 0);//AP
#else
#ifdef OLD_COLOR
		self->priv->cmdFgRGBW = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_colors[i].colorName!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->cmdFgRGBW), p_colors[i].colorName);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->cmdFgRGBW), 0, self->priv->cmdFgRGB);//AP1

		self->priv->cmdFgRGBSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->cmdFgRGBSelectorW), "Color");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->cmdFgRGBSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->cmdFgRGBSelectorW), HILDON_TOUCH_SELECTOR (self->priv->cmdFgRGBW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->cmdExtFontBoxW), self->priv->cmdFgRGBSelectorW, FALSE, FALSE, 0);//AP1
#endif
#endif
		struct _colorAux fgc;
		GtkWidget *buttonfgc = hildon_button_new_with_text ( HILDON_SIZE_FINGER_HEIGHT | HILDON_SIZE_AUTO_WIDTH,
												HILDON_BUTTON_ARRANGEMENT_VERTICAL,
												NULL,
												"Fg");
		hildon_button_set_image (HILDON_BUTTON (buttonfgc), gtk_image_new_from_stock (GTK_STOCK_SELECT_COLOR, GTK_ICON_SIZE_MENU));
        gtk_box_pack_start (GTK_BOX (self->priv->cmdExtFontBoxW), buttonfgc, FALSE, FALSE, 0);

		GtkWidget *fgcPVLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (fgcPVLabel), "     ");
		//g_warning("(%p) self->priv->cmdExtFgRGB=%s",self,self->priv->cmdExtFgRGB);
		gdk_color_parse(self->priv->cmdExtFgRGB, &self->priv->cmdFgRGBC);
		GtkWidget *fgcPVEvt = gtk_event_box_new ();
		gtk_container_add (GTK_CONTAINER (fgcPVEvt), fgcPVLabel);
		gtk_widget_modify_bg (GTK_WIDGET (fgcPVEvt), GTK_STATE_NORMAL, &self->priv->cmdFgRGBC);gtk_widget_modify_bg (GTK_WIDGET (fgcPVEvt), GTK_STATE_PRELIGHT, &self->priv->cmdFgRGBC);
        gtk_box_pack_start (GTK_BOX (self->priv->cmdExtFontBoxW), fgcPVEvt, FALSE, FALSE, 0);

        fgc.WC = &self->priv->cmdFgRGBC; fgc.WP = fgcPVEvt; fgc.FG = TRUE;
        g_signal_connect (buttonfgc, "clicked", G_CALLBACK (color_button_clicked_cb), &fgc);

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->cmdExtFontBoxW);//AP1
//---------

		self->priv->cmdPosColJusBoxW = gtk_hbox_new (TRUE, 0);//AP1

		//g_warning("(%p) cmd visib", self);
		self->priv->cmdVisibilityPositionW = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_visible_position[i]!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->cmdVisibilityPositionW), p_visible_position[i]);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->cmdVisibilityPositionW), 0, self->priv->cmdVisibilityPosition);//AP1

		self->priv->cmdVisibilityPositionSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->cmdVisibilityPositionSelectorW), "Position");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->cmdVisibilityPositionSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->cmdVisibilityPositionSelectorW), HILDON_TOUCH_SELECTOR (self->priv->cmdVisibilityPositionW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->cmdPosColJusBoxW), self->priv->cmdVisibilityPositionSelectorW, TRUE, TRUE, 0);//AP1

		//g_warning("(%p) cmd angle", self);
		self->priv->cmdTextAngleW = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->cmdTextAngleW), "0°");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->cmdTextAngleW), "90°");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->cmdTextAngleW), "180°");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->cmdTextAngleW), "270°");//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->cmdTextAngleW), 0, self->priv->cmdTextAngle);//AP1

		self->priv->cmdTextAngleSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->cmdTextAngleSelectorW), "Angle");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->cmdTextAngleSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->cmdTextAngleSelectorW), HILDON_TOUCH_SELECTOR (self->priv->cmdTextAngleW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->cmdPosColJusBoxW), self->priv->cmdTextAngleSelectorW, TRUE, TRUE, 0);//AP1

		//g_warning("(%p) cmd justify", self);
		self->priv->cmdJustifyW = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_justification[i]!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->cmdJustifyW), p_justification[i]);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->cmdJustifyW), 0, self->priv->cmdJustify);//AP1

		self->priv->cmdJustifySelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->cmdJustifySelectorW), "Justification");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->cmdJustifySelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->cmdJustifySelectorW), HILDON_TOUCH_SELECTOR (self->priv->cmdJustifyW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->cmdPosColJusBoxW), self->priv->cmdJustifySelectorW, TRUE, TRUE, 0);//AP1

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->cmdPosColJusBoxW);//AP1
//----------------------------
		g_warning("(%p) Command Results Settings", self);
		self->priv->LayoutResLabelW = gtk_label_new ("Command Results Settings");//AP1
		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->LayoutResLabelW);//AP1

		//BEGIN results image
		//self->priv->resultImgLabel = gtk_label_new ("");
		//gtk_label_set_markup (GTK_LABEL (resultImgLabel), "<span font_desc=\"Nokia Sans 12\">Image Filename:</span>");//AP1
		//gtk_misc_set_alignment (GTK_MISC (resultImgLabel), 0, 0.5);
		//gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), resultImgLabel);

		self->priv->resImgVisPosBoxW = gtk_hbox_new (FALSE, 0);//AP1

		//g_warning("(%p) res img file", self);
		self->priv->resultsImgEntryW = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		input_mode = hildon_gtk_entry_get_input_mode (GTK_ENTRY (self->priv->resultsImgEntryW));
		input_mode &= ~HILDON_GTK_INPUT_MODE_AUTOCAP;hildon_gtk_entry_set_input_mode (GTK_ENTRY (self->priv->resultsImgEntryW), input_mode);
		hildon_entry_set_text(HILDON_ENTRY (self->priv->resultsImgEntryW), self->priv->resImgFilename);
		gtk_box_pack_start (GTK_BOX (self->priv->resImgVisPosBoxW), self->priv->resultsImgEntryW, TRUE, TRUE, 0);//AP1
		//END results image

		//g_warning("(%p) res img zoom", self);
		self->priv->beecon_resImgZoomW = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_resImgZoomW), "1:1");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_resImgZoomW), "Fit");//AP1
		for(i=5;i<=200;i+=5) {//AP1
				char *b = g_strdup_printf("%d %%",i);
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->beecon_resImgZoomW), b);//AP1
				g_free(b);
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_resImgZoomW), 0, self->priv->resImgZoom);//AP1
		self->priv->beecon_resImgZoomSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->beecon_resImgZoomSelectorW), "Scale");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->beecon_resImgZoomSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->beecon_resImgZoomSelectorW), HILDON_TOUCH_SELECTOR (self->priv->beecon_resImgZoomW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->resImgVisPosBoxW), self->priv->beecon_resImgZoomSelectorW, FALSE, FALSE, 0);//AP

		//g_warning("(%p) res img visi", self);
		self->priv->resImgVisibilityPositionW = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_visible_position[i]!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->resImgVisibilityPositionW), p_visible_position[i]);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->resImgVisibilityPositionW), 0, self->priv->resImgVisibilityPosition);//AP1

		self->priv->resImgVisibilityPositionSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->resImgVisibilityPositionSelectorW), "Position");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->resImgVisibilityPositionSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->resImgVisibilityPositionSelectorW), HILDON_TOUCH_SELECTOR (self->priv->resImgVisibilityPositionW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->resImgVisPosBoxW), self->priv->resImgVisibilityPositionSelectorW, FALSE, FALSE, 0);//AP1

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->resImgVisPosBoxW);//AP1

#ifdef OLD_FONT_DIALOG
		self->priv->resFontBox = gtk_hbox_new (FALSE, 0);//AP1

		self->priv->resFontFam = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_fonts[i]!=NULL;i++) {//AP1
			int j;
			for (j=0;j<4;j++) {//AP1
				gchar fs[256];//AP1
				g_sprintf(fs, "%s %s",p_fonts[i], p_fonts_types[j]);//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (resFontFam), fs);//AP1
			}//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (resFontFam), 0, self->priv->resFontName);//AP1

		self->priv->resFontSelector = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_THUMB_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
		hildon_button_set_title (HILDON_BUTTON (resFontSelector), "Font Face: ");
		hildon_button_set_alignment (HILDON_BUTTON (resFontSelector), 0, 0.5, 0, 0);
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (resFontSelector), HILDON_TOUCH_SELECTOR (resFontFam));
		gtk_box_pack_start (GTK_BOX (resFontBox), resFontSelector, FALSE, FALSE, 0);//AP1

		self->priv->resFontSz = gtk_hscale_new_with_range ((gdouble)8, (gdouble)72, (gdouble)1);//AP1
		gtk_range_set_value(GTK_RANGE(resFontSz), self->priv->resFontSize);//AP1
		gtk_box_pack_start (GTK_BOX (resFontBox), resFontSz, TRUE, TRUE, 0);//AP1

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), resFontBox);//AP1
		//END
#endif
//---------
		self->priv->resExtFontBoxW = gtk_hbox_new (FALSE, 0);//AP1

		//g_warning("(%p) res font", self);
#ifdef NEW_FONT_DIALOG
		GtkWidget *buttonrfo = hildon_button_new_with_text ( HILDON_SIZE_FINGER_HEIGHT | HILDON_SIZE_AUTO_WIDTH,
												HILDON_BUTTON_ARRANGEMENT_VERTICAL,
												"Results",
												self->priv->resExtFont);
		hildon_button_set_image (HILDON_BUTTON (buttonrfo), gtk_image_new_from_stock (GTK_STOCK_SELECT_FONT, GTK_ICON_SIZE_MENU));
		hildon_button_set_alignment (HILDON_BUTTON (buttonrfo), 0, 0.5, 0, 0);
        g_signal_connect (buttonrfo, "clicked", G_CALLBACK (font_button_clicked_cb), NULL);
		gtk_box_pack_start (GTK_BOX (self->priv->resExtFontBoxW), buttonrfo, TRUE, TRUE, 0);
#else
		self->priv->resExtFontFamW = he_font_button_new_with_font (self->priv->resExtFont);
		hildon_gtk_widget_set_theme_size (self->priv->resExtFontFamW, HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		gtk_box_pack_start (GTK_BOX (self->priv->resExtFontBoxW), self->priv->resExtFontFamW, TRUE, TRUE, 0);
#endif

		//g_warning("(%p) res color", self);
#ifdef NEW_COLOR_DIALOG
		gdk_color_parse(self->priv->resExtFgRGB, &self->priv->resFgRGBC);
		self->priv->resFgRGBSelectorW = he_color_button_new_with_color(&self->priv->resFgRGBC);
		hildon_gtk_widget_set_theme_size (self->priv->resFgRGBSelectorW, HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		he_color_button_set_markup_label (HE_COLOR_BUTTON(self->priv->resFgRGBSelectorW), "<small><span font_desc=\"Nokia Sans 12\" foreground=\"white\"> FgCol </span>\n<span font_desc=\"Nokia Sans 12\" foreground=\"black\"> FgCol </span></small>");
		g_warning("he_color_button_new %p", self->priv->resFgRGBSelectorW);
		gtk_box_pack_start (GTK_BOX (self->priv->resExtFontBoxW), self->priv->resFgRGBSelectorW, FALSE, FALSE, 0);//AP
#else
#ifdef OLD_COLOR
		self->priv->resFgRGBW = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_colors[i].colorName!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->resFgRGBW), p_colors[i].colorName);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->resFgRGBW), 0, self->priv->resFgRGB);//AP1

		self->priv->resFgRGBSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->resFgRGBSelectorW), "Color");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->resFgRGBSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->resFgRGBSelectorW), HILDON_TOUCH_SELECTOR (self->priv->resFgRGBW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->resExtFontBoxW), self->priv->resFgRGBSelectorW, FALSE, FALSE, 0);//AP1
#endif
#endif
		struct _colorAux fgr;
		GtkWidget *buttonfgr = hildon_button_new_with_text ( HILDON_SIZE_FINGER_HEIGHT | HILDON_SIZE_AUTO_WIDTH,
												HILDON_BUTTON_ARRANGEMENT_VERTICAL,
												NULL,
												"Fg");
		hildon_button_set_image (HILDON_BUTTON (buttonfgr), gtk_image_new_from_stock (GTK_STOCK_SELECT_COLOR, GTK_ICON_SIZE_MENU));
        gtk_box_pack_start (GTK_BOX (self->priv->resExtFontBoxW), buttonfgr, FALSE, FALSE, 0);

		GtkWidget *fgrPVLabel = gtk_label_new ("");
		gtk_label_set_markup (GTK_LABEL (fgrPVLabel), "     ");
		//g_warning("(%p) self->priv->resExtFgRGB=%s",self,self->priv->resExtFgRGB);
		gdk_color_parse(self->priv->resExtFgRGB, &self->priv->resFgRGBC);
		GtkWidget *fgrPVEvt = gtk_event_box_new ();
		gtk_container_add (GTK_CONTAINER (fgrPVEvt), fgrPVLabel);
		gtk_widget_modify_bg (GTK_WIDGET (fgrPVEvt), GTK_STATE_NORMAL, &self->priv->resFgRGBC);gtk_widget_modify_bg (GTK_WIDGET (fgrPVEvt), GTK_STATE_PRELIGHT, &self->priv->resFgRGBC);
        gtk_box_pack_start (GTK_BOX (self->priv->resExtFontBoxW), fgrPVEvt, FALSE, FALSE, 0);

        fgr.WC = &self->priv->resFgRGBC; fgr.WP = fgrPVEvt; fgr.FG = TRUE;
        g_signal_connect (buttonfgr, "clicked", G_CALLBACK (color_button_clicked_cb), &fgr);

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->resExtFontBoxW);//AP1
//---------

		self->priv->resVisColJusBoxW = gtk_hbox_new (TRUE, 0);//AP1

		//g_warning("(%p) res visib", self);
		self->priv->resVisibilityPositionW = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_visible_position[i]!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->resVisibilityPositionW), p_visible_position[i]);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->resVisibilityPositionW), 0, self->priv->resVisibilityPosition);//AP1

		self->priv->resVisibilityPositionSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->resVisibilityPositionSelectorW), "Position");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->resVisibilityPositionSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->resVisibilityPositionSelectorW), HILDON_TOUCH_SELECTOR (self->priv->resVisibilityPositionW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->resVisColJusBoxW), self->priv->resVisibilityPositionSelectorW, TRUE, TRUE, 0);//AP1

		//g_warning("(%p) res angle", self);
		self->priv->resTextAngleW = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->resTextAngleW), "0°");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->resTextAngleW), "90°");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->resTextAngleW), "180°");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->resTextAngleW), "270°");//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->resTextAngleW), 0, self->priv->resTextAngle);//AP1

		self->priv->resTextAngleSelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->resTextAngleSelectorW), "Angle");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->resTextAngleSelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->resTextAngleSelectorW), HILDON_TOUCH_SELECTOR (self->priv->resTextAngleW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->resVisColJusBoxW), self->priv->resTextAngleSelectorW, TRUE, TRUE, 0);//AP1

		//g_warning("(%p) res angle", self);
		self->priv->resJustifyW = hildon_touch_selector_new_text ();//AP1
		for(i=0;p_justification[i]!=NULL;i++) {//AP1
				hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->resJustifyW), p_justification[i]);//AP1
		}//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->resJustifyW), 0, self->priv->resJustify);//AP1

		//g_warning("(%p) res justify", self);
		self->priv->resJustifySelectorW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->resJustifySelectorW), "Justification");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->resJustifySelectorW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->resJustifySelectorW), HILDON_TOUCH_SELECTOR (self->priv->resJustifyW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->resVisColJusBoxW), self->priv->resJustifySelectorW, TRUE, TRUE, 0);//AP1

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->resVisColJusBoxW);//AP1

		//BEGIN Update Policy
		g_warning("(%p) Update Policy", self);
		self->priv->updPolicyLabelW = gtk_label_new ("Update Policy");
		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->updPolicyLabelW);

		self->priv->updBoxW = gtk_hbox_new (TRUE, 0);//AP1

		self->priv->checkBtStartupW = hildon_check_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		gtk_button_set_label (GTK_BUTTON (self->priv->checkBtStartupW), "@Startup");
		//gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->checkBtStartupW);
		hildon_check_button_set_active (HILDON_CHECK_BUTTON (self->priv->checkBtStartupW), self->priv->updOnStartup);
		gtk_box_pack_start (GTK_BOX (self->priv->updBoxW), self->priv->checkBtStartupW, TRUE, TRUE, 0);//AP1

		self->priv->checkBtClickW = hildon_check_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		gtk_button_set_label (GTK_BUTTON (self->priv->checkBtClickW), "@Click");
		//gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->checkBtClickW);
		hildon_check_button_set_active (HILDON_CHECK_BUTTON (self->priv->checkBtClickW), self->priv->updOnClick);
		gtk_box_pack_start (GTK_BOX (self->priv->updBoxW), self->priv->checkBtClickW, TRUE, TRUE, 0);//AP1

		self->priv->checkBtDesktopW = hildon_check_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		gtk_button_set_label (GTK_BUTTON (self->priv->checkBtDesktopW), "@Desktop");
		//gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->checkBtDesktopW);
		hildon_check_button_set_active (HILDON_CHECK_BUTTON (self->priv->checkBtDesktopW), self->priv->updOnDesktop);
		gtk_box_pack_start (GTK_BOX (self->priv->updBoxW), self->priv->checkBtDesktopW, TRUE, TRUE, 0);//AP1
		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->updBoxW);//AP1

		self->priv->intervalNetBoxW = gtk_hbox_new (TRUE, 0);//AP1

		self->priv->intervalSelectorW = hildon_touch_selector_new_text ();
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->intervalSelectorW), "Disable");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->intervalSelectorW), "30\"");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->intervalSelectorW), "1'");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->intervalSelectorW), "5'");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->intervalSelectorW), "30'");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->intervalSelectorW), "1h");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->intervalSelectorW), "6h");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->intervalSelectorW), "12h");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->intervalSelectorW), "Day");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->intervalSelectorW), "Custom(\")");

		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->intervalSelectorW), 0, self->priv->delayIndex);

		self->priv->intervalSelBtW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
		hildon_button_set_title (HILDON_BUTTON (self->priv->intervalSelBtW), "Update Interval");
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->intervalSelBtW), 0, 0.5, 0, 0);
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->intervalSelBtW), HILDON_TOUCH_SELECTOR (self->priv->intervalSelectorW));
		gtk_box_pack_start (GTK_BOX (self->priv->intervalNetBoxW), self->priv->intervalSelBtW, TRUE, TRUE, 0);//AP1

		self->priv->intervalCustomEntryW = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		input_mode = hildon_gtk_entry_get_input_mode (GTK_ENTRY (self->priv->intervalCustomEntryW));
		input_mode &= ~HILDON_GTK_INPUT_MODE_AUTOCAP;hildon_gtk_entry_set_input_mode (GTK_ENTRY (self->priv->intervalCustomEntryW), input_mode);
		gchar *cusIntervalEntryStr = g_strdup_printf("%u", self->priv->customIntervalSecs);
		//g_warning ("(%p) cusIntervalEntryStr = %s", self, cusIntervalEntryStr);
		hildon_entry_set_text(HILDON_ENTRY (self->priv->intervalCustomEntryW), cusIntervalEntryStr);
		g_free(cusIntervalEntryStr);
		gtk_box_pack_start (GTK_BOX (self->priv->intervalNetBoxW), self->priv->intervalCustomEntryW, TRUE, TRUE, 0);//AP1
		self->priv->delayIndex == 9 ? gtk_widget_set_sensitive (GTK_WIDGET(self->priv->intervalCustomEntryW), TRUE):gtk_widget_set_sensitive (GTK_WIDGET(self->priv->intervalCustomEntryW), FALSE);

		//g_warning ("(%p) self->priv->delayIndex = %d", self, self->priv->delayIndex);
		g_signal_connect (G_OBJECT (self->priv->intervalSelBtW), "value-changed",G_CALLBACK (on_interval_picker_value_changed), HILDON_ENTRY (self->priv->intervalCustomEntryW));

//		self->priv->updIntervalLabelW = gtk_label_new ("");
//		gtk_label_set_markup (GTK_LABEL (self->priv->updIntervalLabelW), "<small>'0' disables periodic updating.</small>");
//		gtk_misc_set_alignment (GTK_MISC (self->priv->updIntervalLabelW), 0, 0);
//		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->updIntervalLabelW);

		self->priv->networkPolicySelW = hildon_touch_selector_new_text ();
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->networkPolicySelW), "Disabled");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->networkPolicySelW), "When Connected");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->networkPolicySelW), "When Disconnected");
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->networkPolicySelW), 0, self->priv->updNeworkPolicy);

		self->priv->networkPolBtW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
		hildon_button_set_title (HILDON_BUTTON (self->priv->networkPolBtW), "Network");
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->networkPolBtW), 0, 0.5, 0, 0);
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->networkPolBtW), HILDON_TOUCH_SELECTOR (self->priv->networkPolicySelW));
		gtk_box_pack_start (GTK_BOX (self->priv->intervalNetBoxW), self->priv->networkPolBtW, TRUE, TRUE, 0);//AP1

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->intervalNetBoxW);

		//self->priv->networkPolBtHelpW = gtk_label_new ("");
		//gtk_label_set_markup (GTK_LABEL (self->priv->networkPolBtHelpW), "<small>If enabled, the selected network event will trigger the command.</small>");
		//gtk_misc_set_alignment (GTK_MISC (self->priv->networkPolBtHelpW), 0, 0);
		//gtk_label_set_line_wrap (GTK_LABEL (self->priv->networkPolBtHelpW), TRUE);
		//gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->networkPolBtHelpW);

#ifdef DBUS_MONITOR_MODE
		//BEGIN DBUS Event Monitoring
		g_warning("(%p) DBUS Event Monitoring", self);
		self->priv->monDBUSLabelW = gtk_label_new ("DBUS Event Monitoring");
		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->monDBUSLabelW);

		self->priv->DBUSBoxW = gtk_hbox_new (TRUE, 0);//AP1

		self->priv->updOnDBUSSelectorW = hildon_touch_selector_new_text ();//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->updOnDBUSSelectorW), "Disabled");//AP1
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->updOnDBUSSelectorW), "Enabled");//AP1
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->updOnDBUSSelectorW), 0, self->priv->updOnDBUS);//AP1

		self->priv->updOnDBUSW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);//AP1
		hildon_button_set_title (HILDON_BUTTON (self->priv->updOnDBUSW), "DBUS Monitor");//AP1
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->updOnDBUSW), 0, 0.5, 0, 0);//AP1
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->updOnDBUSW), HILDON_TOUCH_SELECTOR (self->priv->updOnDBUSSelectorW));//AP1
		gtk_box_pack_start (GTK_BOX (self->priv->DBUSBoxW), self->priv->updOnDBUSW, TRUE, TRUE, 0);//AP

		self->priv->updOnDBUSbusSelectorW = hildon_touch_selector_new_text ();
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->updOnDBUSbusSelectorW), "System");
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->updOnDBUSbusSelectorW), "Session");
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->updOnDBUSbusSelectorW), 0, self->priv->updOnDBUSBus);

		self->priv->updOnDBUSbusW = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
		hildon_button_set_title (HILDON_BUTTON (self->priv->updOnDBUSbusW), "DBUS Type");
		hildon_button_set_alignment (HILDON_BUTTON (self->priv->updOnDBUSbusW), 0, 0.5, 0, 0);
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->updOnDBUSbusW), HILDON_TOUCH_SELECTOR (self->priv->updOnDBUSbusSelectorW));
		gtk_box_pack_start (GTK_BOX (self->priv->DBUSBoxW), self->priv->updOnDBUSbusW, TRUE, TRUE, 0);//AP1

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->DBUSBoxW);

		self->priv->updOnDBUSMatchRuleBoxW = gtk_hbox_new (FALSE, 0);//AP1

		self->priv->updOnDBUSMatchRuleLabelW = gtk_label_new ("");
		g_warning("(%p) Match Rule", self);
		gtk_label_set_markup (GTK_LABEL (self->priv->updOnDBUSMatchRuleLabelW), "<span foreground=\"red\" font=\"13\">Match Rule: </span>");//AP1
		gtk_misc_set_alignment (GTK_MISC (self->priv->updOnDBUSMatchRuleLabelW), 0, 0.5);
		gtk_box_pack_start (GTK_BOX (self->priv->updOnDBUSMatchRuleBoxW), self->priv->updOnDBUSMatchRuleLabelW, FALSE, FALSE, 0);//AP

		self->priv->updOnDBUSMatchRuleW = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
		input_mode = hildon_gtk_entry_get_input_mode (GTK_ENTRY (self->priv->updOnDBUSMatchRuleW));
		input_mode &= ~HILDON_GTK_INPUT_MODE_AUTOCAP;hildon_gtk_entry_set_input_mode (GTK_ENTRY (self->priv->updOnDBUSMatchRuleW), input_mode);
		hildon_entry_set_text(HILDON_ENTRY (self->priv->updOnDBUSMatchRuleW), self->priv->updOnDBUSMatchRule);
		gtk_box_pack_start (GTK_BOX (self->priv->updOnDBUSMatchRuleBoxW), self->priv->updOnDBUSMatchRuleW, TRUE, TRUE, 0);//AP

		gtk_container_add (GTK_CONTAINER (self->priv->content_areaW), self->priv->updOnDBUSMatchRuleBoxW);
#endif

		gtk_widget_show_all (self->priv->dialogW);
		//self->priv->delayIndex == 9?gtk_widget_show (GTK_WIDGET(intervalCustomEntry)):gtk_widget_hide (GTK_WIDGET(intervalCustomEntry));
		//END

		//BEGIN settings processing
		//g_warning ("(%p) settingsRunning out= %d",self, settingsRunning);
		while ( settingsRunning ) {
			int setDialogReturn = 0;
			self->priv->currentDialog=self->priv->dialogW;
			setDialogReturn = gtk_dialog_run (GTK_DIALOG (self->priv->dialogW));
			//g_warning ("(%p) setDialogReturn() = %d",self, setDialogReturn);
			if ( setDialogReturn == GTK_RESPONSE_ACCEPT || setDialogReturn == NON_GTK_RESPONSE_SAVE_AND_RUN || setDialogReturn == NON_GTK_RESPONSE_ADVANCED ) {
				//g_warning ("(%p) setDialogReturn = %d", self, setDialogReturn);
				if (setDialogReturn == NON_GTK_RESPONSE_ADVANCED) {
					//g_warning ("(%p) NON_GTK_RESPONSE_ADVANCED call PRO dialog",self);
					self->priv->goProW = hildon_note_new_confirmation (GTK_WINDOW(self->priv->dialogW), "WARNING! Settings need to be saved before proceeding with Advanced Functions.\n\nAre you really sure you want to go \"PRO\"?");
					gint retcode = gtk_dialog_run (GTK_DIALOG (self->priv->goProW));
					gtk_widget_destroy (self->priv->goProW);
					if (retcode != GTK_RESPONSE_OK) {
						//g_warning ("(%p) NON_GTK_RESPONSE_ADVANCED got scared!!! Beat it! :)",self);
						continue;
					}
				}
				int cmdSel = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->selectorW), 0);
				//g_warning ("(%p) GTK_RESPONSE_ACCEPT cmdSel = %d c_size = %d",self, cmdSel, self->priv->c_size);
				if(cmdSel < self->priv->c_size && cmdSel >= 0) {
					//g_warning ("(%p) Fetching cmdSel in internal command list", self);
					g_free(self->priv->instanceTitle);self->priv->instanceTitle=NULL;
					self->priv->instanceTitle = strdup(self->priv->c_titles[cmdSel]);
					//g_warning("(%p) self->priv->instanceTitle = %p [%s]", self, self->priv->instanceTitle, self->priv->instanceTitle);
					g_free(self->priv->instanceCmd);self->priv->instanceCmd=NULL;
					self->priv->instanceCmd = strdup(self->priv->c_commands[cmdSel]);
					//g_warning("(%p) self->priv->instanceCmd = %p [%s]", self, self->priv->instanceCmd, self->priv->instanceCmd);
				}

				self->priv->widgetType = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->widgetTypeW), 0);//AP2

				self->priv->widgetVisible = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->widgetVisibleW), 0);//AP2

				guint prevOperationalStatus = self->priv->operationalStatus;
				self->priv->operationalStatus = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->widgetOperationalStatusW), 0);//AP2

				self->priv->hideCanvas = hildon_check_button_get_active (HILDON_CHECK_BUTTON (self->priv->checkBtHideCanvasW));
#ifdef xNEW_COLOR_DIALOG
//				he_color_button_get_color (HE_COLOR_BUTTON(self->priv->snippetBgRGBSelectorW), &self->priv->snippetBgRGBC);
				g_free(self->priv->snippetExtBgRGB); self->priv->snippetExtBgRGB = gdk_color_to_string(&self->priv->snippetBgRGBC);
#else
				self->priv->snippetBgRGB = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->snippetBgRGBW), 0);//AP2
#endif
//#ifdef CUTOFF
				//g_warning("(%p) self->priv->beecon_lt0_ImgFilename = %p", self, self->priv->beecon_lt0_ImgFilename);
				//g_free(self->priv->beecon_lt0_ImgFilename);self->priv->beecon_lt0_ImgFilename = NULL;
				self->priv->beecon_lt0_ImgZoom = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_lt0_ImgZoomW), 0);//AP2
				g_free(self->priv->beecon_lt0_ImgFilename);self->priv->beecon_lt0_ImgFilename = g_strdup(hildon_entry_get_text (HILDON_ENTRY (self->priv->beecon_lt0_ImgEntryW)));
#ifdef xNEW_COLOR_DIALOG
//				he_color_button_get_color (HE_COLOR_BUTTON(self->priv->beecon_lt0_BgRGBSelectorW), &self->priv->lt0_BgRGBC);
				g_free(self->priv->beecon_lt0_ExtBgRGB); self->priv->beecon_lt0_ExtBgRGB = gdk_color_to_string(&self->priv->lt0_BgRGBC);
#else
				self->priv->beecon_lt0_BgRGB = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_lt0_BgRGBW), 0);//AP2
#endif

				//g_warning("(%p) self->priv->beecon_eq0_ImgFilename = %p", self, self->priv->beecon_eq0_ImgFilename);
				//g_free(self->priv->beecon_eq0_ImgFilename);self->priv->beecon_eq0_ImgFilename = NULL;
				self->priv->beecon_eq0_ImgZoom = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_eq0_ImgZoomW), 0);//AP2
				g_free(self->priv->beecon_eq0_ImgFilename);self->priv->beecon_eq0_ImgFilename = g_strdup(hildon_entry_get_text (HILDON_ENTRY (self->priv->beecon_eq0_ImgEntryW)));
#ifdef xNEW_COLOR_DIALOG
//				he_color_button_get_color (HE_COLOR_BUTTON(self->priv->beecon_eq0_BgRGBSelectorW), &self->priv->eq0_BgRGBC);
				g_free(self->priv->beecon_eq0_ExtBgRGB); self->priv->beecon_eq0_ExtBgRGB = gdk_color_to_string(&self->priv->eq0_BgRGBC);
#else
				self->priv->beecon_eq0_BgRGB = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_eq0_BgRGBW), 0);//AP2
#endif

				//g_warning("(%p) self->priv->beecon_eq1_ImgFilename = %p", self, self->priv->beecon_eq1_ImgFilename);
				//g_free(self->priv->beecon_eq1_ImgFilename);self->priv->beecon_eq1_ImgFilename = NULL;
				self->priv->beecon_eq1_ImgZoom = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_eq1_ImgZoomW), 0);//AP2
				g_free(self->priv->beecon_eq1_ImgFilename);self->priv->beecon_eq1_ImgFilename = g_strdup(hildon_entry_get_text (HILDON_ENTRY (self->priv->beecon_eq1_ImgEntryW)));
#ifdef xNEW_COLOR_DIALOG
//				he_color_button_get_color (HE_COLOR_BUTTON(self->priv->beecon_eq1_BgRGBSelectorW), &self->priv->eq1_BgRGBC);
				g_free(self->priv->beecon_eq1_ExtBgRGB); self->priv->beecon_eq1_ExtBgRGB = gdk_color_to_string(&self->priv->eq1_BgRGBC);
#else
				self->priv->beecon_eq1_BgRGB = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_eq1_BgRGBW), 0);//AP2
#endif

				//g_warning("(%p) self->priv->beecon_ge2_ImgFilename = %p", self, self->priv->beecon_ge2_ImgFilename);
				//g_free(self->priv->beecon_ge2_ImgFilename);self->priv->beecon_ge2_ImgFilename = NULL;
				self->priv->beecon_ge2_ImgZoom = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_ge2_ImgZoomW), 0);//AP2
				g_free(self->priv->beecon_ge2_ImgFilename);self->priv->beecon_ge2_ImgFilename = g_strdup(hildon_entry_get_text (HILDON_ENTRY (self->priv->beecon_ge2_ImgEntryW)));
#ifdef xNEW_COLOR_DIALOG
//				he_color_button_get_color (HE_COLOR_BUTTON(self->priv->beecon_ge2_BgRGBSelectorW), &self->priv->ge2_BgRGBC);
				g_free(self->priv->beecon_ge2_ExtBgRGB); self->priv->beecon_ge2_ExtBgRGB = gdk_color_to_string(&self->priv->ge2_BgRGBC);
#else
				self->priv->beecon_ge2_BgRGB = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_ge2_BgRGBW), 0);//AP2
#endif

				//g_warning("(%p) self->priv->beecon_idxge2_ImgFilename = %p", self, self->priv->beecon_idxge2_ImgFilename);
				//g_free(self->priv->beecon_idxge2_ImgFilename);self->priv->beecon_idxge2_ImgFilename = NULL;
				self->priv->beecon_idxge2_ImgZoom = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_idxge2_ImgZoomW), 0);//AP2
				g_free(self->priv->beecon_idxge2_ImgFilename);self->priv->beecon_idxge2_ImgFilename = g_strdup(hildon_entry_get_text (HILDON_ENTRY (self->priv->beecon_idxge2_ImgEntryW)));
#ifdef xNEW_COLOR_DIALOG
//				he_color_button_get_color (HE_COLOR_BUTTON(self->priv->beecon_idxge2_BgRGBSelectorW), &self->priv->idxge2_BgRGBC);
				g_free(self->priv->beecon_idxge2_ExtBgRGB); self->priv->beecon_idxge2_ExtBgRGB = gdk_color_to_string(&self->priv->idxge2_BgRGBC);
#else
				self->priv->beecon_idxge2_BgRGB = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_idxge2_BgRGBW), 0);//AP2
#endif

				self->priv->widXOrigin = gtk_range_get_value(GTK_RANGE(self->priv->widPositionXW));
				self->priv->widYOrigin = gtk_range_get_value(GTK_RANGE(self->priv->widPositionYW));

				//g_warning ("(%p) Window Position Previous x=%d y=%d Current x=%d y=%d ", self, widXOrigin, widYOrigin, self->priv->widXOrigin, self->priv->widYOrigin);
				if (self->priv->widXOrigin != widXOrigin || self->priv->widYOrigin != widYOrigin) {
					//g_warning ("(%p) Fine Tuning Window Position x=%d y=%d", self, self->priv->widXOrigin, self->priv->widYOrigin);
					gtk_window_move (GTK_WINDOW (self), (int)(self->priv->widXOrigin), (int)(self->priv->widYOrigin));//AP
				}

				self->priv->widWidth = gtk_range_get_value(GTK_RANGE(self->priv->widthSelectW));
				self->priv->widHeight = gtk_range_get_value(GTK_RANGE(self->priv->heightSelectW));
//#endif CUTOFF
				//g_warning("(%p) self->priv->cmdImgFilename = %p", self, self->priv->cmdImgFilename);
				//g_free(self->priv->cmdImgFilename);self->priv->cmdImgFilename = NULL;
				g_free(self->priv->cmdImgFilename);self->priv->cmdImgFilename = g_strdup(hildon_entry_get_text (HILDON_ENTRY (self->priv->titleImgEntryW)));
				self->priv->cmdImgZoom = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_cmdImgZoomW), 0);//AP2
#ifdef xNEW_COLOR_DIALOG
//				he_color_button_get_color (HE_COLOR_BUTTON(self->priv->cmdFgRGBSelectorW), &self->priv->cmdFgRGBC);
				g_free(self->priv->cmdExtFgRGB); self->priv->cmdExtFgRGB = gdk_color_to_string(&self->priv->cmdFgRGBC);
#else
				self->priv->cmdFgRGB = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->cmdFgRGBW), 0);//AP2
#endif
				self->priv->cmdTextAngle = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->cmdTextAngleW), 0);//AP2
				self->priv->cmdVisibilityPosition = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->cmdVisibilityPositionW), 0);//AP2
				self->priv->cmdImgVisibilityPosition = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->cmdImgVisibilityPositionW), 0);//AP2
				self->priv->cmdJustify = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->cmdJustifyW), 0);//AP2

#ifdef NEW_FONT_DIALOG
				self->priv->cmdExtFont = g_strdup(hildon_button_get_value (HILDON_BUTTON(buttoncfo)));
#else
				self->priv->cmdFontName = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (cmdFontFam), 0);//AP1
				self->priv->cmdFontSize = gtk_range_get_value(GTK_RANGE(cmdFontSz));//AP1
#endif

				//g_warning("(%p) self->priv->resImgFilename = %p", self, self->priv->resImgFilename);
				g_free(self->priv->resImgFilename);self->priv->resImgFilename = g_strdup(hildon_entry_get_text (HILDON_ENTRY (self->priv->resultsImgEntryW)));
				self->priv->resImgZoom = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->beecon_resImgZoomW), 0);//AP2
#ifdef xNEW_COLOR_DIALOG
//				he_color_button_get_color (HE_COLOR_BUTTON(self->priv->resFgRGBSelectorW), &self->priv->resFgRGBC);
				g_free(self->priv->resExtFgRGB); self->priv->resExtFgRGB = gdk_color_to_string(&self->priv->resFgRGBC);
#else
				self->priv->resFgRGB = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->resFgRGBW), 0);//AP2
#endif
				self->priv->resTextAngle = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->resTextAngleW), 0);//AP2
				self->priv->resVisibilityPosition = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->resVisibilityPositionW), 0);//AP2
				self->priv->resImgVisibilityPosition = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->resImgVisibilityPositionW), 0);//AP2
				self->priv->resJustify = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->resJustifyW), 0);//AP2

#ifdef NEW_FONT_DIALOG
				self->priv->resExtFont = g_strdup(hildon_button_get_value (HILDON_BUTTON(buttonrfo)));
#else
				self->priv->resFontName = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->resFontFamW), 0);//AP1
				self->priv->resFontSize = gtk_range_get_value(GTK_RANGE(self->priv->resFontSzW));//AP1
#endif

#ifdef DBUS_MONITOR_MODE
				// Need previous state
				guint  prev_updOnDBUS          = self->priv->updOnDBUS;
				guint  prev_updOnDBUSBus       = self->priv->updOnDBUSBus;
				gchar *prev_updOnDBUSMatchRule = g_strdup(self->priv->updOnDBUSMatchRule);

				self->priv->updOnDBUS = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->updOnDBUSSelectorW), 0);
				g_warning("(%p) self->priv->updOnDBUS = %d (1=Enabled 0=Disabled)", self, self->priv->updOnDBUS);
				self->priv->updOnDBUSBus =  hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->updOnDBUSbusSelectorW), 0); //(0=system/1=session)
				g_warning("(%p) self->priv->updOnDBUSBus = %d (0=System 1=Session)", self, self->priv->updOnDBUSBus);
				g_free(self->priv->updOnDBUSMatchRule);
				self->priv->updOnDBUSMatchRule = g_strdup(hildon_entry_get_text (HILDON_ENTRY (self->priv->updOnDBUSMatchRuleW)));
				g_warning("(%p) self->priv->updOnDBUSMatchRule = %p [%s]", self, self->priv->updOnDBUSMatchRule, self->priv->updOnDBUSMatchRule);

				if (self->priv->updOnDBUS!=prev_updOnDBUS ||
						self->priv->updOnDBUSBus!=prev_updOnDBUSBus ||
						g_strcmp0(prev_updOnDBUSMatchRule, self->priv->updOnDBUSMatchRule)) { // Hase something changed here?
					g_warning("(%p) DBUS monitor active, disarm connection, match and filter", self);
					queen_beecon_dbus_monitor_manager(self, QBW_DEINIT_DBUS_MONITOR, prev_updOnDBUSBus, prev_updOnDBUSMatchRule);
				}
				if (self->priv->updOnDBUS && self->priv->operationalStatus==0) { //Is DBUS Monitor active and Instance active?
					g_warning("(%p) DBUS monitor starting, rearm connection, match and filter", self);
					if (!queen_beecon_dbus_monitor_manager(self, QBW_INIT_DBUS_MONITOR, self->priv->updOnDBUSBus, self->priv->updOnDBUSMatchRule)) { // If error during reinitialization of DBUS monitor ... restore previous settings
						self->priv->updOnDBUS          = 0;
						reloadInstanceSettings = TRUE;
					}
				}
				if (self->priv->operationalStatus!=0) { //Instance is disabled, disarm DBUS Monitor
					queen_beecon_dbus_monitor_manager(self, QBW_DEINIT_DBUS_MONITOR, self->priv->updOnDBUSBus, self->priv->updOnDBUSMatchRule);
				}

				g_free(prev_updOnDBUSMatchRule); //Not needed any more
#endif

				self->priv->updOnStartup = hildon_check_button_get_active (HILDON_CHECK_BUTTON (self->priv->checkBtStartupW));
				self->priv->updOnClick = hildon_check_button_get_active (HILDON_CHECK_BUTTON (self->priv->checkBtClickW));
				self->priv->updOnDesktop = hildon_check_button_get_active (HILDON_CHECK_BUTTON (self->priv->checkBtDesktopW));

				self->priv->delayIndex = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->intervalSelectorW), 0);
				//g_warning ("(%p) got self->priv->delayIndex %u",self, self->priv->delayIndex);
				gchar *cusIntervalEntryStrX;
				gchar *cusIntervalEntryStrY = g_strdup(hildon_entry_get_text (HILDON_ENTRY (self->priv->intervalCustomEntryW)));
				//g_warning ("(%p) cusIntervalEntryStrY %s",self, cusIntervalEntryStrY);
				self->priv->customIntervalSecs = strtol(cusIntervalEntryStrY, &cusIntervalEntryStrX, 0);
				g_free(cusIntervalEntryStrY);
				//g_warning ("(%p) self->priv->delayIndex %u",self, self->priv->delayIndex);

				guint prevDelaySeconds = self->priv->delaySeconds;
				if (self->priv->delayIndex == 9) { // Custom Seconds
					self->priv->delaySeconds = self->priv->customIntervalSecs;
				} else {// Indexed Timer
					self->priv->delaySeconds = GetSeconds(self->priv->delayIndex);
				}
				//g_warning ("(%p) self->priv->delaySeconds %u",self, self->priv->delaySeconds);

				if(self->priv->delaySeconds != prevDelaySeconds ||
						self->priv->delaySeconds==0 ||
						self->priv->operationalStatus==1 ||
						(prevOperationalStatus == 1 && self->priv->operationalStatus==0)) { // Do we need to reset and rearm timer?
					if (self->priv->updateTimerID) {
						g_warning("(%p) removing self->priv->updateTimerID=%d", self, self->priv->updateTimerID);
						g_source_remove (self->priv->updateTimerID);
					}
					if (self->priv->delaySeconds > 0 && self->priv->operationalStatus==0) {
						g_warning("(%p) re-arming execution timer, delaySeconds=%d", self, self->priv->delaySeconds);
						self->priv->updateTimerID = g_timeout_add_seconds (self->priv->delaySeconds, (GSourceFunc)queen_beecon_update_content, self);
					}
				}

				self->priv->updNeworkPolicy = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->networkPolicySelW), 0);

				//g_warning ("(%p) GTK_RESPONSE_ACCEPT write settings()",self);
				queen_beecon_write_settings (self, TRUE);

				if (setDialogReturn == NON_GTK_RESPONSE_ADVANCED) {
					guint  prev_updOnDBUSBus       = self->priv->updOnDBUSBus;
					gchar *prev_updOnDBUSMatchRule = g_strdup(self->priv->updOnDBUSMatchRule);

					//g_warning ("(%p) NON_GTK_RESPONSE_ADVANCED gone PRO call PRO dialog",self);
					if (!queen_beecon_advanced_dialog(self, hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->selectorW), 0))) {
						//g_warning ("(%p) NON_GTK_RESPONSE_ADVANCED nothing relevant happened ... just refresh command selector and nothing else to do",self);

						gint cmdSel = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->selectorW), 0);
						//g_warning ("(%p) NON_GTK_RESPONSE_ADVANCED cmdSel = %d c_size = %d",self, cmdSel, self->priv->c_size);
						self->priv->selectorW = hildon_touch_selector_new_text ();
						//g_warning ("(%p) NON_GTK_RESPONSE_ADVANCED new selector %p", self, selector);
						for(i=0;i<self->priv->c_size;i++) {
							//g_warning ("(%p) NON_GTK_RESPONSE_ADVANCED rebuilding selector c_titles[%d] = %s", self, i, self->priv->c_titles[i]);
							hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->selectorW), self->priv->c_titles[i]);
						}
						//g_warning ("(%p) NON_GTK_RESPONSE_ADVANCED cmdSelector %p selector %p", self, cmdSelector, selector);
						hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->cmdSelectorW), HILDON_TOUCH_SELECTOR (self->priv->selectorW));
						hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->selectorW), 0, cmdSel);
						hildon_picker_button_set_active (HILDON_PICKER_BUTTON (self->priv->cmdSelectorW), cmdSel);
						g_free(prev_updOnDBUSMatchRule);
						continue;
					}
					//g_warning ("(%p) NON_GTK_RESPONSE_ADVANCED something happened... let's queen_beecon_update_content_layout",self);
					queen_beecon_update_content_layout (self);
					//g_warning ("(%p) NON_GTK_RESPONSE_ADVANCED reloadInstanceSettings=TRUE",self);
					reloadInstanceSettings=TRUE;
					if (self->priv->updateTimerID) { // New instance loaded, we assume timers need reset
						g_warning("(%p) removing self->priv->updateTimerID=%d", self, self->priv->updateTimerID);
						g_source_remove (self->priv->updateTimerID);
					}
					if (self->priv->delaySeconds > 0 && self->priv->operationalStatus==0) { // New instance loaded, we assume timers need rearm if instance is enabled
						g_warning("(%p) re-arming execution timer, delaySeconds=%d", self, self->priv->delaySeconds);
						self->priv->updateTimerID = g_timeout_add_seconds (self->priv->delaySeconds, (GSourceFunc)queen_beecon_update_content, self);
					}

					queen_beecon_dbus_monitor_manager(self, QBW_DEINIT_DBUS_MONITOR, prev_updOnDBUSBus, prev_updOnDBUSMatchRule);

					if (self->priv->updOnDBUS && self->priv->operationalStatus==0) { //Is DBUS Monitor active?
						g_warning("(%p) DBUS monitor starting, rearm connection, match and filter", self);
						if (!queen_beecon_dbus_monitor_manager(self, QBW_INIT_DBUS_MONITOR, self->priv->updOnDBUSBus, self->priv->updOnDBUSMatchRule)) { // If error during reinitialization of DBUS monitor ... restore previous settings
							self->priv->updOnDBUS          = 0;
						}
					}

					g_free(prev_updOnDBUSMatchRule);
				}
				if (setDialogReturn == NON_GTK_RESPONSE_SAVE_AND_RUN) {
					//g_warning ("(%p) NON_GTK_RESPONSE_SAVE_AND_RUN update content requested! self->priv->operationalStatus=%d",self, self->priv->operationalStatus);
					if (self->priv->operationalStatus==0) {// Wake up and restore size and operations
						queen_beecon_update_content (self, qbwExecReason[QBW_SETTINGS_SAVE_RUN]);
					} else {
						hildon_banner_show_information (NULL, NULL, "WARNING! Widget is disabled, command NOT executed!");
					}
				} else { //GTK_RESPONSE_ACCEPT == NON_GTK_RESPONSE_SAVE
					//g_warning ("(%p) GTK_RESPONSE_ACCEPT update content layout",self);
					queen_beecon_update_content_layout (self);
				}
				//g_warning ("(%p) settingsRunning = 0",self);
				settingsRunning = FALSE;
			} else if(setDialogReturn == NON_GTK_RESPONSE_ADD_CMD || setDialogReturn == NON_GTK_RESPONSE_EDIT_CMD ) { // ADD/EDIT COMMAND
				gint cmdSel = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (self->priv->selectorW), 0);
				//g_warning ("(%p) NON_GTK_RESPONSE_xxxx_CMD cmdSel = %d c_size = %d",self, cmdSel, self->priv->c_size);

				gint prevRollCall = self->priv->c_size; // Let's count how many command we have before operation
				if( setDialogReturn == NON_GTK_RESPONSE_ADD_CMD ) { // New command input
					//g_warning ("(%p) NON_GTK_RESPONSE_ADD_CMD call edit/add dialog",self);
					if (!queen_beecon_edit_add_dialog(self, TRUE, 0)) continue; // ADD/EDIT Dialog Cancelled ... just yield and loop again
				} else { // If current active selection then edit command
					//g_warning ("(%p) NON_GTK_RESPONSE_EDIT_CMD call edit/add dialog command [%d]",self, cmdSel);
					if (!queen_beecon_edit_add_dialog(self, FALSE, cmdSel)) continue; // ADD/EDIT Dialog Cancelled ... just yield and loop again
				}
				//g_warning ("(%p) NON_GTK_RESPONSE_xxxx_CMD write settings()",self);
				queen_beecon_write_settings (self, FALSE); // We write commands to config file

				self->priv->selectorW = hildon_touch_selector_new_text ();
				//g_warning ("(%p) NON_GTK_RESPONSE_xxxx_CMD new selector %p", self, selector);
				for(i=0;i<self->priv->c_size;i++) {
					//g_warning ("(%p) NON_GTK_RESPONSE_xxxx_CMD rebuilding selector c_titles[%d] = %s", self, i, self->priv->c_titles[i]);
					hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (self->priv->selectorW), self->priv->c_titles[i]);
				}
				if (self->priv->c_size < prevRollCall) {// TRUE if command has been deleted
					cmdSel = 0;
				} else if (self->priv->c_size > prevRollCall) {// TRUE if command has been added
					cmdSel = self->priv->c_size - 1;
				}
				//g_warning ("(%p) NON_GTK_RESPONSE_xxxx_CMD cmdSelector %p selector %p", self, cmdSelector, selector);
				hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->cmdSelectorW), HILDON_TOUCH_SELECTOR (self->priv->selectorW));
				hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (self->priv->selectorW), 0, cmdSel);
			    hildon_picker_button_set_active (HILDON_PICKER_BUTTON (self->priv->cmdSelectorW), cmdSel);
				//END ADD/EDIT COMMAND
			} else
				settingsRunning = FALSE;
		}
		gtk_widget_destroy (self->priv->dialogW);
	}
	//END
	gtk_widget_queue_draw (GTK_WIDGET (self));//AP3
}

static gboolean queen_beecon_edit_add_dialog ( QueenBeecon *self, gboolean new, gint curr)
{
	g_warning ("(%p) %s new=%d curr=%d",self, G_STRFUNC, new, curr);
	GtkWidget *dialog = NULL;
	HildonGtkInputMode input_mode;
	gchar *title = NULL;
	gboolean needWrite = TRUE;

	if ( new ) {// ADD Title
		title = g_strconcat ("Add new command", NULL);
		dialog = gtk_dialog_new_with_buttons (title, NULL, 0, _("wdgt_bd_save"), GTK_RESPONSE_ACCEPT, NULL);
	} else {// EDIT Title
		if (curr>=0) {
			title = g_strconcat ("Edit ", self->priv->c_titles[curr] ," List Command", NULL);
			dialog = gtk_dialog_new_with_buttons (title, NULL, 0, _("wdgt_bd_save"), GTK_RESPONSE_ACCEPT, _("wdgt_bd_delete"), NON_GTK_RESPONSE_DELETE_CMD, NULL);
		} else {
			title = g_strconcat ("Edit ", self->priv->instanceTitle ," Instance Command (Use button to can add it to list)", NULL);
			dialog = gtk_dialog_new_with_buttons (title, NULL, 0, _("wdgt_bd_save"), GTK_RESPONSE_ACCEPT, "Add to List", NON_GTK_RESPONSE_ADD_CMD, NULL);
		}
	}
	GtkWidget *content_area = gtk_dialog_get_content_area (GTK_DIALOG (dialog));
	GtkSizeGroup *group = GTK_SIZE_GROUP (gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL));

	//BEGIN title
	GtkWidget *titleBox = gtk_hbox_new (FALSE, 0);

	GtkWidget *titleLabel = gtk_label_new ("Title:");
	gtk_misc_set_alignment (GTK_MISC (titleLabel), 0, 0.5);
	gtk_misc_set_padding (GTK_MISC (titleLabel), HILDON_MARGIN_DOUBLE, 0);
	gtk_size_group_add_widget (group, titleLabel);

	GtkWidget *titleEntry = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
	input_mode = hildon_gtk_entry_get_input_mode (GTK_ENTRY (titleEntry));
	input_mode &= ~HILDON_GTK_INPUT_MODE_AUTOCAP;hildon_gtk_entry_set_input_mode (GTK_ENTRY (titleEntry), input_mode);
	gtk_box_pack_start (GTK_BOX (titleBox), titleLabel, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (titleBox), titleEntry, TRUE, TRUE, 0);

	gtk_container_add (GTK_CONTAINER (content_area), titleBox);

	//BEGIN command
	GtkWidget *commandBox = gtk_hbox_new (FALSE, 0);

	GtkWidget *commandLabel = gtk_label_new ("Command:");
	gtk_misc_set_alignment (GTK_MISC (commandLabel), 0, 0.5);
	gtk_misc_set_padding (GTK_MISC (commandLabel), HILDON_MARGIN_DOUBLE, 0);
	gtk_size_group_add_widget (group, commandLabel);

	GtkWidget *commandEntry = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
	input_mode = hildon_gtk_entry_get_input_mode (GTK_ENTRY (commandEntry));
	input_mode &= ~HILDON_GTK_INPUT_MODE_AUTOCAP;hildon_gtk_entry_set_input_mode (GTK_ENTRY (commandEntry), input_mode);
	gtk_box_pack_start (GTK_BOX (commandBox), commandLabel, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (commandBox), commandEntry, TRUE, TRUE, 0);

	gtk_container_add (GTK_CONTAINER (content_area), commandBox);
	//END BUILD DIALOG

	if(!new) {// EDIT
		if (curr>=0) { // Edit List command
			hildon_entry_set_text(HILDON_ENTRY (titleEntry), self->priv->c_titles[curr]);
			hildon_entry_set_text(HILDON_ENTRY (commandEntry), self->priv->c_commands[curr]);
		} else { // Edit Instance command
			hildon_entry_set_text(HILDON_ENTRY (titleEntry), self->priv->instanceTitle);
			hildon_entry_set_text(HILDON_ENTRY (commandEntry), self->priv->instanceCmd);
		}
	}

	//END

	gtk_widget_show_all (dialog);
	int dialogRunResponse = gtk_dialog_run (GTK_DIALOG (dialog));

	switch(dialogRunResponse) {
		case GTK_RESPONSE_ACCEPT:
			if(g_strcmp0((gchar *)"",hildon_entry_get_text (HILDON_ENTRY (titleEntry))) == 0)
				hildon_entry_set_text(HILDON_ENTRY (titleEntry), "[No Title]");
			if ( new ) // ADD
				AddCommand(self, g_strdup(hildon_entry_get_text (HILDON_ENTRY (titleEntry))), g_strdup(hildon_entry_get_text (HILDON_ENTRY (commandEntry))), TRUE);
			else // EDIT
				EditCommand(self, g_strdup(hildon_entry_get_text (HILDON_ENTRY (titleEntry))), g_strdup(hildon_entry_get_text (HILDON_ENTRY (commandEntry))), TRUE, curr);
			break;
		case NON_GTK_RESPONSE_ADD_CMD:
			AddCommand(self, g_strdup(hildon_entry_get_text (HILDON_ENTRY (titleEntry))), g_strdup(hildon_entry_get_text (HILDON_ENTRY (commandEntry))), TRUE);
			break;
		case NON_GTK_RESPONSE_DELETE_CMD:
			DelCommand(self, curr); // DELETE command in list
			break;
		default:
			needWrite = FALSE;
	}
	gtk_widget_destroy (dialog);
	g_free(title);
	return ( needWrite );
}

static void on_command_picker_value_changed(HildonPickerButton * button, QueenBeecon *self)
{
	int cmdSel = hildon_picker_button_get_active (HILDON_PICKER_BUTTON (button));
	gchar *c = g_strdup(self->priv->c_commands[cmdSel]);
	gtk_text_buffer_set_text(self->priv->cmdTestDriveBuffer,c,-1);
	g_free(c);

}

static void testDriveBt_clicked_cb(HildonButton * button, QueenBeecon *self)
{
	int cmdSel;
	FILE *fp = NULL;
	gchar *line;//AP Big Big command output buffer//AP
	size_t l;//AP
	GtkTextIter start, end;
	line = g_malloc0(4096);
	gtk_text_buffer_get_bounds (self->priv->cmdTestDriveBuffer, &start, &end);
	gchar *c = g_strdup(gtk_text_buffer_get_text (self->priv->cmdTestDriveBuffer,&start, &end, FALSE));
	if (c[0] == '\0') {
		cmdSel = hildon_picker_button_get_active (HILDON_PICKER_BUTTON (self->priv->commandPicker));
		g_free(c);
		c = g_strdup(self->priv->c_commands[cmdSel]);
		gtk_text_buffer_set_text(self->priv->cmdTestDriveBuffer,c,-1);
	}
	//g_warning("(%p) TEST DRIVE CMD %s %s", self, qbwExecReason[QBW_TEST_DRIVE], c);
	gchar *instanceCmdSubst = queen_beecon_g_command_param_subst(self, c, qbwExecReason[QBW_TEST_DRIVE]);
	fp = popen (instanceCmdSubst, "r");
	//g_warning("(%p) ========> popen(%s) TEST DRIVE returned %p", self, instanceCmdSubst, fp);
	g_free(instanceCmdSubst);

	if ((l=fread (line, 1, sizeof line, fp))!=0) //to this "buffer-based" for multiline handling in widget //AP
		line[l-1]='\000';//AP
	gint exitCode=pclose(fp);
	//g_warning("(%p) ppclose(fp) returned 0x%08X", self, exitCode);

	exitCode = (exitCode >> 8) & 0xff;
	gchar *buff = g_strdup_printf("[Exit Code = %d]\n%s", (char)exitCode, line);//If command has output we issue a newline after Exit Code
	gtk_text_buffer_set_text(self->priv->cmdOutputBuffer,buff,-1);
	g_free(buff);
	g_free(line);
	g_free(c);
}

static void copyCommandBt_clicked_cb ( HildonButton * button, QueenBeecon *self )
{
	g_warning ("(%p) %s",self, G_STRFUNC);

	GtkClipboard *clipboard = NULL;
	GtkTextIter start, end;
	gtk_text_buffer_get_bounds (self->priv->cmdTestDriveBuffer, &start, &end);
	gtk_text_buffer_select_range (self->priv->cmdTestDriveBuffer, &start, &end);
	/* do copy */
	clipboard = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
	gtk_text_buffer_copy_clipboard (GTK_TEXT_BUFFER(self->priv->cmdTestDriveBuffer), clipboard);
}

static void pasteCommandBt_clicked_cb ( HildonButton * button, QueenBeecon *self )
{
	g_warning ("(%p) %s",self, G_STRFUNC);

	GtkClipboard *clipboard = NULL;
	GtkTextIter start, end;
	gtk_text_buffer_get_bounds (self->priv->cmdTestDriveBuffer, &start, &end);
	gtk_text_buffer_select_range (self->priv->cmdTestDriveBuffer, &start, &end);
	  /* do paste */
	clipboard = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
	gtk_text_buffer_paste_clipboard (GTK_TEXT_BUFFER (self->priv->cmdTestDriveBuffer), clipboard, NULL, TRUE);
}

static void updateCommandBt_clicked_cb ( HildonButton * button, QueenBeecon *self )
{
	g_warning ("(%p) %s",self, G_STRFUNC);

	int cmdSel;
	GtkWidget *confirmDlg;
	gchar *confirmMsg;
	gint retcode;
	GtkTextIter start, end;

	gtk_text_buffer_get_bounds (self->priv->cmdTestDriveBuffer, &start, &end);
	gchar *c = g_strdup(gtk_text_buffer_get_text (self->priv->cmdTestDriveBuffer,&start, &end, FALSE));
	//g_warning("(%p) Current Test Drive Command Buffer [%s]", self, c);
	if ( !c || c[0]=='\0' ) {
		hildon_banner_show_informationf (NULL, NULL, "WARNING! Test Drive Buffer empty or not valid.\nUnable to update selected command.");
		//g_warning("(%p) Warning! Test Drive buffer empty or not valid. Unable to update selected command.", self);
		g_free(c);
		return;
	}

	cmdSel = hildon_picker_button_get_active (HILDON_PICKER_BUTTON (self->priv->commandPicker));
	if (cmdSel>=0) { //Update command in list
		confirmMsg = g_strdup_printf("Warning! You are about to update currently selected command with Test Drive buffer.\n\ntitle=[%s]\ncommand=[%s]\n\n\nAre you Sure?", self->priv->c_titles[cmdSel], self->priv->c_commands[cmdSel]);
		confirmDlg = hildon_note_new_confirmation (GTK_WINDOW(NULL), confirmMsg);
		retcode = gtk_dialog_run (GTK_DIALOG (confirmDlg));
		gtk_widget_destroy (confirmDlg);
		g_free(confirmMsg);
	} else { //Update command in instance
		confirmMsg = g_strdup_printf("WARNING! You are about to Update current Instance Command with Test Drive buffer.\n\nAre you Sure?");
		confirmDlg = hildon_note_new_confirmation (GTK_WINDOW(NULL), confirmMsg);
		retcode = gtk_dialog_run (GTK_DIALOG (confirmDlg));
		gtk_widget_destroy (confirmDlg);
		g_free(confirmMsg);
	}
	if (retcode != GTK_RESPONSE_OK) {
		//g_warning ("(%p) Didn't like to confirm ... got scared!!! Beat it! :)",self);
		return;
	}

	if (cmdSel>=0) { //Update command in list
		//g_warning("(%p) Current Title Command to update [%s]", self, self->priv->c_titles[cmdSel]);
		EditCommand(self, g_strdup(self->priv->c_titles[cmdSel]), g_strdup(c), FALSE, cmdSel);
	} else { //Update command in instance
		//g_warning("(%p) Current Title Instance Command to update [%s]", self, self->priv->instanceTitle);
		EditCommand(self, g_strdup(self->priv->instanceTitle), g_strdup(c), TRUE, cmdSel);
	}
	hildon_banner_show_informationf (NULL, NULL, "Command successfully updated.");
	g_free(c);
}

static void importCommandBt_clicked_cb ( HildonButton * button, QueenBeecon *self )
{
	g_warning ("(%p) %s",self, G_STRFUNC);

	GtkTextIter start, end;
	gboolean fileExists = FALSE;
	GKeyFile *keyFile = NULL;
	gint retcode;

	gtk_text_buffer_get_iter_at_line(self->priv->importExportBuffer, &start, 4);
	gtk_text_buffer_get_end_iter(self->priv->importExportBuffer, &end);
	gchar *c = g_strdup(gtk_text_buffer_get_text (self->priv->importExportBuffer,&start, &end, FALSE));
	if (!c || c[0]=='\0') {
		//g_warning("(%p) error with c=%p", self, c);
		hildon_banner_show_informationf (NULL, NULL, "WARNING! Import Buffer is empty!\nPlease paste relevant Command Export Data first.");
		g_free(c);
		return;
	}
	GtkWidget *confirmDlg = hildon_note_new_confirmation (GTK_WINDOW(NULL), "WARNING! You are about to import the Command Data currently in Import Buffer.\n\nAre you Sure?");	retcode = gtk_dialog_run (GTK_DIALOG (confirmDlg));	gtk_widget_destroy (confirmDlg);
	if (retcode != GTK_RESPONSE_OK) {
		//g_warning ("(%p) Didn't like to confirm ... got scared!!! Beat it! :)",self);
		g_free(c);
		return;
	}
	//g_warning("(%p) c=%s", self, c);

	guint calcChksum = checksum(c);//very trivial :)
	//g_warning("(%p) import command data checksum=%d", self, calcChksum);
	g_free(c);
	keyFile = g_key_file_new();
	//g_warning("(%p) keyfile %p", self, keyFile);

	gtk_text_buffer_get_iter_at_line(self->priv->importExportBuffer, &start, 0);
	c = g_strdup(gtk_text_buffer_get_text (self->priv->importExportBuffer,&start, &end, FALSE));

	fileExists = g_key_file_load_from_data (keyFile, c, strlen(c), G_KEY_FILE_KEEP_COMMENTS, NULL);
	if (!fileExists) {
		//g_warning("(%p) Import from ADB command buffer error g_key_file_load_from_data()", self);
		g_key_file_free (keyFile);
		g_free(c);
		return;
	}

	//g_warning("(%p) Export/Import buffer ready for KeyFile operations", self);
	// Get all the elements
	gdouble exportVersion = g_key_file_get_double (keyFile, "queen-beecon-header", "version", NULL);
	//g_warning("(%p) exportVersion=%f", self, exportVersion);
	if (exportVersion!=QUEEN_BEECON_SETTINGS_VERSION) {
		hildon_banner_show_informationf (NULL, NULL, "WARNING! WRONG Version for Import Data!");
		//g_warning("(%p) WRONG Version!!! Handle new version in next release possibly", self);
		g_key_file_free (keyFile);
		g_free(c);
		return;
	}

	guint stampChksum = g_key_file_get_integer (keyFile, "queen-beecon-header", "checksum", NULL);
	//g_warning("(%p) stampChksum=%d", self, stampChksum);
	g_free(c);

	if (stampChksum==calcChksum||stampChksum==911) {
		//g_warning("(%p) CHECKSUM is GOOD!!! ready to read and import command data!", self);
		gchar *title = g_key_file_get_string (keyFile, "queen-beecon-exported-command", "title", NULL);
		gchar *command = g_key_file_get_string (keyFile, "queen-beecon-exported-command", "command", NULL);
		g_key_file_free (keyFile);

		//g_warning("(%p) About to call AddCommand title=[%s] command=[%s]", self, title, command);
		AddCommand(self, g_strdup(title), g_strdup(command), FALSE);

		queen_beecon_write_settings (self, FALSE); // We write commands to config file

		//g_warning("(%p) Rebuilding command selector adding new command", self);
		GtkWidget *commandPickerSelector = hildon_touch_selector_new_text ();
		gint i;
		for(i=0;i<self->priv->c_size;i++)
		{
			//g_warning("(%p) Append Command [%d] [%s]", self, i, self->priv->c_titles[i]);
			hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (commandPickerSelector), self->priv->c_titles[i]);
		}
		//g_warning("(%p) Rebuilding command to selector [%p] set active %d", self, commandPickerSelector, self->priv->c_size-1);
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (commandPickerSelector), 0, self->priv->c_size-1);
		//g_warning("(%p) Rebuilding command selector set selector [%p] to picker [%p]", self, commandPickerSelector, self->priv->commandPicker);
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->commandPicker), HILDON_TOUCH_SELECTOR (commandPickerSelector));
		//g_warning("(%p) Rebuilding command to picker [%p] set active %d", self, self->priv->commandPicker, self->priv->c_size-1);
		hildon_picker_button_set_active (HILDON_PICKER_BUTTON (self->priv->commandPicker), self->priv->c_size-1);

		c = g_strdup(self->priv->c_commands[self->priv->c_size-1]);
		//g_warning("(%p) Filling command Test Drive Buffer [%p] with new command [%s]", self, self->priv->cmdTestDriveBuffer, c);
		gtk_text_buffer_set_text(self->priv->cmdTestDriveBuffer,c,-1);
		g_free(c);
		//g_warning("(%p) Command successfully added to Command List and to Test Drive command input.", self);
		hildon_banner_show_informationf (NULL, NULL, "SUCCESS! Command added to Command List and to Test Drive command input.");
		//GtkWidget *info = hildon_note_new_information (NULL, "SUCCESS! Command added to Command List and to Test Drive command input.");gtk_dialog_run (GTK_DIALOG (info));gtk_object_destroy (GTK_OBJECT (info));
	} else {
		hildon_banner_show_informationf (NULL, NULL, "WARNING! Bad Checksum!\nPossibly corrupt Import Command Data!");
		//g_warning("(%p) Bad Checksum, possibly corrupt import command data!", self);
	}
}

static void exportCommandBt_clicked_cb ( HildonButton * button, QueenBeecon *self )
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	int cmdSel;
	GtkTextIter start, end;

	gtk_text_buffer_get_bounds (self->priv->cmdTestDriveBuffer, &start, &end);
	gchar *c = g_strdup(gtk_text_buffer_get_text (self->priv->cmdTestDriveBuffer,&start, &end, FALSE));
	//g_warning("(%p) cmdTestDriveBuffer %s", self, c);
	if (!c || c[0]=='\0') {
		//g_warning("(%p) error with c=%p", self, c);
		hildon_banner_show_informationf (NULL, NULL, "WARNING! Command Buffer is empty!\nPlease select from List or type New Command first.");
		g_free(c);
		return;
	}
	cmdSel = hildon_picker_button_get_active (HILDON_PICKER_BUTTON (self->priv->commandPicker));
	//g_warning("(%p) cmdSel %d", self, cmdSel);
	gchar *exportData = g_strdup_printf("title=%s\ncommand=%s", self->priv->c_titles[cmdSel], c);
	//g_warning("(%p) exportData (checksum here applies = %d", self, checksum(exportData));
	gchar* headerVersion = g_strdup_printf("[queen-beecon-header]\nversion=%f\nchecksum=%d\n[queen-beecon-exported-command]\n%s", QUEEN_BEECON_SETTINGS_VERSION, checksum(exportData),exportData);//very trivial :)
	//g_warning("(%p) headerVersion %s", self, headerVersion);
	gtk_text_buffer_set_text (self->priv->importExportBuffer, headerVersion, -1);
	g_free(c);
	g_free(exportData);
	g_free(headerVersion);

}

static void pasteFromClipboardADBExportImportBt_clicked_cb ( HildonButton * button, QueenBeecon *self )
{
	g_warning ("(%p) %s",self, G_STRFUNC);

	GtkClipboard *clipboard = NULL;
	GtkTextIter start, end;
	gtk_text_buffer_get_bounds (self->priv->importExportBuffer, &start, &end);
	gtk_text_buffer_select_range (self->priv->importExportBuffer, &start, &end);
	/* do paste */
	clipboard = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
	gtk_text_buffer_paste_clipboard (GTK_TEXT_BUFFER (self->priv->importExportBuffer), clipboard, NULL, TRUE);
}

static void copyToClipboardADBExportImportBt_clicked_cb ( HildonButton * button, QueenBeecon *self )
{
	g_warning ("(%p) %s",self, G_STRFUNC);

	GtkClipboard *clipboard = NULL;
	GtkTextIter start, end;
	gtk_text_buffer_get_bounds (self->priv->importExportBuffer, &start, &end);
	gtk_text_buffer_select_range (self->priv->importExportBuffer, &start, &end);
	/* do copy */
	clipboard = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
	gtk_text_buffer_copy_clipboard (GTK_TEXT_BUFFER(self->priv->importExportBuffer), clipboard);
}

static void importInstanceBt_clicked_cb ( HildonButton *button, QueenBeecon *self )
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	GtkTextIter start, end;
	gchar *confirmMsg;
	GtkWidget *confirmDlg;
	gint retcode;
	gboolean fileExists;
	GKeyFile *keyFile = NULL;

	gtk_text_buffer_get_iter_at_line(self->priv->importExportBuffer, &start, 4);
	gtk_text_buffer_get_end_iter(self->priv->importExportBuffer, &end);
	gchar *c = g_strdup(gtk_text_buffer_get_text (self->priv->importExportBuffer,&start, &end, FALSE));
	if (!c || c[0]=='\0') {
		//g_warning("(%p) error with c=%p", self, c);
		hildon_banner_show_informationf (NULL, NULL, "WARNING! Import Buffer is empty!\nPlease paste relevant Instance Export Data first.");
		g_free(c);
		return;
	}
	confirmMsg = g_strdup_printf("WARNING! You are about to Import the Instance Data currently in Import Buffer.\n\nAre you Sure?");
	confirmDlg = hildon_note_new_confirmation (GTK_WINDOW(NULL), confirmMsg);
	retcode = gtk_dialog_run (GTK_DIALOG (confirmDlg));
	gtk_widget_destroy (confirmDlg);
	g_free(confirmMsg);
	if (retcode != GTK_RESPONSE_OK) {
		//g_warning ("(%p) Didn't like to confirm ... got scared!!! Beat it! :)",self);
		g_free(c);
		return;
	}

	//g_warning("(%p) c=%s", self, c);

	guint calcChksum = checksum(c);//very trivial :)
	//g_warning("(%p) import instance data checksum=%d", self, calcChksum);
	g_free(c);

	keyFile = g_key_file_new();
	//g_warning("(%p) keyfile %p", self, keyFile);

	gtk_text_buffer_get_iter_at_line(self->priv->importExportBuffer, &start, 0);
	c = g_strdup(gtk_text_buffer_get_text (self->priv->importExportBuffer,&start, &end, FALSE));

	fileExists = g_key_file_load_from_data (keyFile, c, strlen(c), G_KEY_FILE_KEEP_COMMENTS, NULL);
	if (!fileExists) {
		//g_warning("(%p) Import from ADB instance buffer error g_key_file_load_from_data()", self);
		g_key_file_free (keyFile);
		g_free(c);
		return;
	}

	//g_warning("(%p) Export/Import buffer ready for KeyFile operations", self);
	// Get all the elements
	gdouble exportVersion = g_key_file_get_double (keyFile, "queen-beecon-header", "version", NULL);
	//g_warning("(%p) exportVersion=%f", self, exportVersion);
	if (exportVersion!=QUEEN_BEECON_SETTINGS_VERSION) {
		//g_warning("(%p) WRONG Version!!!", self);
		g_key_file_free (keyFile);
		g_free(c);
		return;
	}

	guint stampChksum = g_key_file_get_integer (keyFile, "queen-beecon-header", "checksum", NULL);
	//g_warning("(%p) stampChksum=%d", self, stampChksum);

	if (stampChksum==calcChksum||stampChksum==911) {
		//g_warning("(%p) CHECKSUM is GOOD!!! ready to read and import instance data!", self);
		queen_beecon_read_settings ( self, TRUE, TRUE, c);

		//g_warning("(%p) AddCommand title=[%s] command=[%s]", self, self->priv->instanceTitle, self->priv->instanceCmd);
		AddCommand(self, g_strdup(self->priv->instanceTitle), g_strdup(self->priv->instanceCmd), TRUE);

		queen_beecon_write_settings (self, FALSE); // We write current added command to config file

		//g_warning("(%p) Rebuilding command selector adding new command", self);
		GtkWidget *commandPickerSelector = hildon_touch_selector_new_text ();
		gint i;
		for(i=0;i<self->priv->c_size;i++)
		{
			//g_warning("(%p) Append Command [%d] [%s]", self, i, self->priv->c_titles[i]);
			hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (commandPickerSelector), self->priv->c_titles[i]);
		}
		//g_warning("(%p) Rebuilding command to selector [%p] set active %d", self, commandPickerSelector, self->priv->c_size-1);
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (commandPickerSelector), 0, self->priv->c_size-1);

		//g_warning("(%p) Rebuilding command selector set selector [%p] to picker [%p]", self, commandPickerSelector, self->priv->commandPicker);
		hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->commandPicker), HILDON_TOUCH_SELECTOR (commandPickerSelector));

		//g_warning("(%p) Rebuilding command to picker [%p] set active %d", self, self->priv->commandPicker, self->priv->c_size-1);
		hildon_picker_button_set_active (HILDON_PICKER_BUTTON (self->priv->commandPicker), self->priv->c_size-1);
		hildon_banner_show_informationf (NULL, NULL, "SUCCESS! Instance imported into current Beecon/Snippet!\nCommand added to command list.");
		//GtkWidget *info = hildon_note_new_information (NULL, "SUCCESS! Instance imported into current Beecon/Snippet!\nCommand added to command list.");gtk_dialog_run (GTK_DIALOG (info));gtk_object_destroy (GTK_OBJECT (info));
		self->priv->instanceImportOK=TRUE;
		//g_warning("(%p) Instance Settings loaded successfully", self);
		g_free(c);
		g_key_file_free (keyFile);
		gtk_dialog_response(GTK_DIALOG (self->priv->advancedDialog), GTK_RESPONSE_NONE);
	} else {
		hildon_banner_show_informationf (NULL, NULL, "WARNING! Bad Checksum!\nPossibly corrupt Import Instance Data!");
		//g_warning("(%p) Bad Checksum, possibly corrupt import data!", self);
		g_free(c);
		g_key_file_free (keyFile);
	}
}

static void exportInstanceBt_clicked_cb ( HildonButton * button, QueenBeecon *self )
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	gchar *filename = NULL;
	gboolean fileExists;
	GKeyFile *keyFile = NULL;
	GError *error=NULL;
	gchar **instance_keys = NULL;
	gsize element_count;
	GtkTextIter start,end;
	int i;

	if(self->priv->widgetID == NULL) {
		g_warning("(%p) Widget instance not initialized, not reading settings..", self);
		return;
	}

	keyFile = g_key_file_new();
	//g_warning("(%p) keyfile %p", self, keyFile);
	filename = g_strconcat (HOME_DIR, QUEEN_BEECON_SETTINGS_FILE, NULL);
	//g_warning("(%p) filename %s", self, filename);
	fileExists = g_key_file_load_from_file (keyFile, filename, G_KEY_FILE_KEEP_COMMENTS, NULL);
	//g_warning("(%p) fileExists %d", self, fileExists);

	gdouble settingsVer = g_key_file_get_double (keyFile, "config", "version", NULL);
	g_warning("(%p) settingsVer %f", self, settingsVer);

	/* Get all the elements */
	instance_keys = g_key_file_get_keys (keyFile, self->priv->widgetID, &element_count, NULL);
	//g_warning("(%p) instance_keys %p", self, instance_keys);
	if (instance_keys != NULL && element_count != 0) {
		gtk_text_buffer_set_text (self->priv->importExportBuffer, "", -1);
		gtk_text_buffer_get_iter_at_line(self->priv->importExportBuffer, &end, 0);
		for (i = 0; i < element_count; i++) {
			gchar *keyVal = g_strdup_printf("%s=%s\n", instance_keys [i], g_key_file_get_value(keyFile, self->priv->widgetID, instance_keys [i], &error));
			//g_warning("(%p) keyVal %s", self, keyVal);
			gtk_text_buffer_insert (self->priv->importExportBuffer, &end, keyVal, -1);
			g_free(keyVal);
		}
		//Let's eval buffer checksum
		gtk_text_buffer_get_bounds (self->priv->importExportBuffer, &start, &end);
		gchar *c = g_strdup(gtk_text_buffer_get_text (self->priv->importExportBuffer,&start, &end, FALSE));
		gchar *headerVersion = g_strdup_printf("[queen-beecon-header]\nversion=%f\nchecksum=%d\n[queen-beecon-exported-instance]\n", settingsVer, checksum(c));//very trivial :)
		g_free(c);
		//g_warning("(%p) headerVersion %s", self, headerVersion);
		gtk_text_buffer_get_iter_at_line(self->priv->importExportBuffer, &end, 0);
		gtk_text_buffer_insert (self->priv->importExportBuffer, &end, headerVersion, -1);
		g_free(headerVersion);
	}
	g_key_file_free (keyFile);
	g_free (filename);

	//g_warning("(%p) Instance Settings exported", self);
}

static void importFileBufferBt_clicked_cb ( HildonButton * button, QueenBeecon *self )
{
	g_warning ("(%p) %s",self, G_STRFUNC);

	GtkWidget *file_chooser = hildon_file_chooser_dialog_new (NULL, GTK_FILE_CHOOSER_ACTION_OPEN);
	//gtk_window_set_title (GTK_WINDOW (file_chooser), "Choose file to import from");
	if (gtk_dialog_run (GTK_DIALOG (file_chooser)) == GTK_RESPONSE_OK) {
		GtkTextIter start, end;
		GError *error = NULL;
		gchar *filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (file_chooser));

		if (!filename) {
			gtk_widget_destroy (file_chooser);
			return;
		}

		gchar *contents = NULL;
		if (!g_file_get_contents (filename, &contents, NULL, &error)) {
			hildon_banner_show_informationf (NULL, NULL, "Importing failed: %s", error->message);
			g_free (filename);
			g_clear_error (&error);
			gtk_widget_destroy (file_chooser);
			return;
		}

		gtk_text_buffer_get_bounds (self->priv->importExportBuffer, &start, &end);
		gtk_text_buffer_delete (self->priv->importExportBuffer, &start, &end);
		gtk_text_buffer_insert (self->priv->importExportBuffer, &start, contents, -1);

		g_free (filename);
		g_free (contents);
	}
	gtk_widget_destroy (file_chooser);
}

static void exportFileBufferBt_clicked_cb ( HildonButton * button, QueenBeecon *self )
{
	g_warning ("(%p) %s",self, G_STRFUNC);

	gchar *mydocsdir = g_strdup (g_getenv ("MYDOCSDIR"));
	if (!mydocsdir) mydocsdir = g_build_filename (g_get_home_dir (), "MyDocs", NULL);

	GtkWidget *file_chooser = hildon_file_chooser_dialog_new (NULL, GTK_FILE_CHOOSER_ACTION_SAVE);
	gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (file_chooser), mydocsdir);
	g_free (mydocsdir);

	if (gtk_dialog_run (GTK_DIALOG (file_chooser)) == GTK_RESPONSE_OK) {
		GtkTextIter start, end;
		GError *error = NULL;
		gchar *filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (file_chooser));

		if (!filename) {
			gtk_widget_destroy (file_chooser);
			return;
		}

		gtk_text_buffer_get_bounds (self->priv->importExportBuffer, &start, &end);

		gchar *contents = gtk_text_buffer_get_text (self->priv->importExportBuffer, &start, &end, FALSE);
		if (!contents) {
			hildon_banner_show_information (NULL, NULL, "Exporting failed");
			g_free (filename);
			gtk_widget_destroy (file_chooser);
			return;
		}

		if (!g_file_set_contents (filename, contents, -1, &error)) {
			hildon_banner_show_informationf (NULL, NULL, "Exporting failed: %s", error->message);
			g_clear_error (&error);
		}
		g_free (filename);
		g_free (contents);
	}
	gtk_widget_destroy (file_chooser);
}

static gboolean queen_beecon_advanced_dialog ( QueenBeecon *self, gint cmdSel )
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	HildonGtkInputMode input_mode;
	gboolean reReadSettings = FALSE;
	gboolean timeToGoBack = FALSE;
	gchar *title = NULL;

	title = g_strconcat ("Advanced Settings and Tools (... Hic Sunt Leones!)", NULL);
	self->priv->advancedDialog = gtk_dialog_new_with_buttons (title, NULL, 0, NULL);
	g_free(title);

	//g_warning("(%p) Building advanced settings dialog %p", self, dialog);
	GtkWidget *settingsArea = gtk_dialog_get_content_area (GTK_DIALOG (self->priv->advancedDialog));
	GtkWidget *scroll = hildon_pannable_area_new ();
	g_object_set (scroll, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	gtk_container_add (GTK_CONTAINER (settingsArea), scroll);
	gtk_window_set_default_size (GTK_WINDOW (self->priv->advancedDialog), -1, 380);

	GtkWidget *content_area = gtk_vbox_new (FALSE, 0);
	hildon_pannable_area_add_with_viewport (HILDON_PANNABLE_AREA (scroll), content_area);

	GtkWidget *cmdSelectionLabel = gtk_label_new ("Command Test Drive");
	gtk_box_pack_start (GTK_BOX (content_area), cmdSelectionLabel, FALSE, FALSE, 0);

    GtkWidget *cmdTestDriveLabelHelp = gtk_label_new ("");
	gtk_label_set_markup (GTK_LABEL (cmdTestDriveLabelHelp), "<span font_desc=\"Nokia Sans 13\">Type command you would like to execute and press <u>TestDrive</u> to see RAW Output in box below.</span>");//AP1
	gtk_box_pack_start (GTK_BOX (content_area), cmdTestDriveLabelHelp, TRUE, TRUE, 0);

	//BEGIN Command Selector

	GtkWidget *testDriveBox = gtk_hbox_new (FALSE, 0);

	GtkWidget *commandPickerSelector = hildon_touch_selector_new_text ();
	gint i;
	for(i=0;i<self->priv->c_size;i++)
	{
		hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (commandPickerSelector), self->priv->c_titles[i]);
	}
	self->priv->commandPicker = hildon_picker_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
	hildon_button_set_title (HILDON_BUTTON (self->priv->commandPicker), "Commands: ");
	hildon_button_set_alignment (HILDON_BUTTON (self->priv->commandPicker), 0, 0.5, 0, 0);
	hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (self->priv->commandPicker), HILDON_TOUCH_SELECTOR (commandPickerSelector));
	hildon_picker_button_set_active (HILDON_PICKER_BUTTON (self->priv->commandPicker), cmdSel);
	gtk_box_pack_start (GTK_BOX (testDriveBox), self->priv->commandPicker, TRUE, TRUE, 0);

	GtkWidget *testDriveBt = hildon_button_new_with_text (HILDON_SIZE_FINGER_HEIGHT |
                                          HILDON_SIZE_AUTO_WIDTH, HILDON_BUTTON_ARRANGEMENT_VERTICAL,
										  "TestDrive",
                                          NULL);
	hildon_button_set_value (HILDON_BUTTON (testDriveBt), "Command");
	hildon_button_set_alignment (HILDON_BUTTON (testDriveBt), 0, 0.5, 0, 0);//AP1
	g_signal_connect (testDriveBt, "clicked", G_CALLBACK (testDriveBt_clicked_cb), self);
    gtk_box_pack_start (GTK_BOX (testDriveBox), testDriveBt, FALSE, FALSE, 0);


	GtkWidget *updateCmdBt = hildon_button_new_with_text (HILDON_SIZE_FINGER_HEIGHT |
                                          HILDON_SIZE_AUTO_WIDTH, HILDON_BUTTON_ARRANGEMENT_VERTICAL,
										  "Update",
                                          NULL);
	hildon_button_set_alignment (HILDON_BUTTON (updateCmdBt), 0, 0.5, 0, 0);//AP1
	hildon_button_set_value (HILDON_BUTTON (updateCmdBt), "Command");
	g_signal_connect (updateCmdBt, "clicked", G_CALLBACK (updateCommandBt_clicked_cb), self);
    gtk_box_pack_start (GTK_BOX (testDriveBox), updateCmdBt, FALSE, FALSE, 0);

	GtkWidget *copyCmdBt = hildon_button_new_with_text (HILDON_SIZE_FINGER_HEIGHT |
                                          HILDON_SIZE_AUTO_WIDTH, HILDON_BUTTON_ARRANGEMENT_VERTICAL,
										  "Copy",
                                          NULL);
	hildon_button_set_alignment (HILDON_BUTTON (copyCmdBt), 0, 0.5, 0, 0);//AP1
	hildon_button_set_value (HILDON_BUTTON (copyCmdBt), "Command");
	g_signal_connect (copyCmdBt, "clicked", G_CALLBACK (copyCommandBt_clicked_cb), self);
    gtk_box_pack_start (GTK_BOX (testDriveBox), copyCmdBt, FALSE, FALSE, 0);

    GtkWidget *pasteCmdBt = hildon_button_new_with_text (HILDON_SIZE_FINGER_HEIGHT |
                                          HILDON_SIZE_AUTO_WIDTH, HILDON_BUTTON_ARRANGEMENT_VERTICAL,
										  "Paste",
                                          NULL);
	hildon_button_set_alignment (HILDON_BUTTON (pasteCmdBt), 0, 0.5, 0, 0);//AP1
	hildon_button_set_value (HILDON_BUTTON (pasteCmdBt), "Command");
	g_signal_connect (pasteCmdBt, "clicked", G_CALLBACK (pasteCommandBt_clicked_cb), self);
    gtk_box_pack_start (GTK_BOX (testDriveBox), pasteCmdBt, FALSE, FALSE, 0);

    gtk_box_pack_start (GTK_BOX (content_area), testDriveBox, TRUE, TRUE, 0);

	GtkWidget *cmdTestDrive = hildon_text_view_new ();
	input_mode = hildon_gtk_text_view_get_input_mode(GTK_TEXT_VIEW (cmdTestDrive));
	input_mode &= ~HILDON_GTK_INPUT_MODE_AUTOCAP; hildon_gtk_text_view_set_input_mode(GTK_TEXT_VIEW (cmdTestDrive), input_mode);
	gtk_widget_set_size_request (GTK_WIDGET (cmdTestDrive), -1, 150);//AP
	gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (cmdTestDrive), GTK_WRAP_WORD_CHAR);
	gtk_box_pack_start (GTK_BOX (content_area), cmdTestDrive, TRUE, TRUE, 0);

	GtkWidget *cmdOutput = hildon_text_view_new ();
	input_mode = hildon_gtk_text_view_get_input_mode(GTK_TEXT_VIEW (cmdOutput));
	input_mode &= ~HILDON_GTK_INPUT_MODE_AUTOCAP; hildon_gtk_text_view_set_input_mode(GTK_TEXT_VIEW (cmdOutput), input_mode);
	gtk_widget_set_size_request (GTK_WIDGET (cmdOutput), -1, 150);//AP
	hildon_text_view_set_placeholder(HILDON_TEXT_VIEW (cmdOutput), "Exit Status & Command RAW Output will be displayed HERE");
	gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (cmdOutput), GTK_WRAP_WORD_CHAR);
	gtk_text_view_set_editable(GTK_TEXT_VIEW(cmdOutput), FALSE);
	gtk_box_pack_start (GTK_BOX (content_area), cmdOutput, FALSE, FALSE, 0);

	GtkWidget *IEBufferLabel = gtk_label_new ("Import/Export Operations");
	gtk_box_pack_start (GTK_BOX (content_area), IEBufferLabel, FALSE, FALSE, 0);

	GtkWidget *cmdImportBox = gtk_hbox_new (TRUE, 0);

	GtkWidget *importCommandBt = hildon_button_new_with_text (HILDON_SIZE_FINGER_HEIGHT |
                                          HILDON_SIZE_AUTO_WIDTH, HILDON_BUTTON_ARRANGEMENT_VERTICAL,
										  "Import",
                                          NULL);
	hildon_button_set_alignment (HILDON_BUTTON (importCommandBt), 0, 0.5, 0, 0);//AP1
	hildon_button_set_value (HILDON_BUTTON (importCommandBt), "Buffer to Command");
	g_signal_connect (importCommandBt, "clicked", G_CALLBACK (importCommandBt_clicked_cb), self);
    gtk_box_pack_start (GTK_BOX (cmdImportBox), importCommandBt, TRUE, TRUE, 0);

	GtkWidget *pasteFromClipboardBt = hildon_button_new_with_text (HILDON_SIZE_FINGER_HEIGHT |
                                          HILDON_SIZE_AUTO_WIDTH, HILDON_BUTTON_ARRANGEMENT_VERTICAL,
										  "Paste",
                                          NULL);
	hildon_button_set_alignment (HILDON_BUTTON (pasteFromClipboardBt), 0, 0.5, 0, 0);//AP1
	hildon_button_set_value (HILDON_BUTTON (pasteFromClipboardBt), "Clipboard to Buffer");
	g_signal_connect (pasteFromClipboardBt, "clicked", G_CALLBACK (pasteFromClipboardADBExportImportBt_clicked_cb), self);
    gtk_box_pack_start (GTK_BOX (cmdImportBox), pasteFromClipboardBt, TRUE, TRUE, 0);

    GtkWidget *importFileBufferBt = hildon_button_new_with_text (HILDON_SIZE_FINGER_HEIGHT |
                                              HILDON_SIZE_AUTO_WIDTH, HILDON_BUTTON_ARRANGEMENT_VERTICAL,
    										  "Import",
                                              NULL);
    hildon_button_set_alignment (HILDON_BUTTON (importFileBufferBt), 0, 0.5, 0, 0);//AP1
    hildon_button_set_value (HILDON_BUTTON (importFileBufferBt), "File to Buffer");
    g_signal_connect (importFileBufferBt, "clicked", G_CALLBACK (importFileBufferBt_clicked_cb), self);
    gtk_box_pack_start (GTK_BOX (cmdImportBox), importFileBufferBt, TRUE, TRUE, 0);

	GtkWidget *importInstanceBt = hildon_button_new_with_text (HILDON_SIZE_FINGER_HEIGHT |
                                          HILDON_SIZE_AUTO_WIDTH, HILDON_BUTTON_ARRANGEMENT_VERTICAL,
										  "Import",
                                          NULL);
	hildon_button_set_alignment (HILDON_BUTTON (importInstanceBt), 0, 0.5, 0, 0);//AP1
	hildon_button_set_value (HILDON_BUTTON (importInstanceBt), "Buffer to Beecon");
	g_signal_connect (importInstanceBt, "clicked", G_CALLBACK (importInstanceBt_clicked_cb), self);
    gtk_box_pack_start (GTK_BOX (cmdImportBox), importInstanceBt, TRUE, TRUE, 0);

	gtk_box_pack_start (GTK_BOX (content_area), cmdImportBox, TRUE, TRUE, 0);

	GtkWidget *cmdExportBox = gtk_hbox_new (TRUE, 0);

	GtkWidget *exportCommandBt = hildon_button_new_with_text (HILDON_SIZE_FINGER_HEIGHT |
                                          HILDON_SIZE_AUTO_WIDTH, HILDON_BUTTON_ARRANGEMENT_VERTICAL,
										  "Export",
                                          NULL);
	hildon_button_set_alignment (HILDON_BUTTON (exportCommandBt), 0, 0.5, 0, 0);//AP1
	hildon_button_set_value (HILDON_BUTTON (exportCommandBt), "Command to Buffer");
	g_signal_connect (exportCommandBt, "clicked", G_CALLBACK (exportCommandBt_clicked_cb), self);
    gtk_box_pack_start (GTK_BOX (cmdExportBox), exportCommandBt, TRUE, TRUE, 0);

	GtkWidget *copyToClipboardBt = hildon_button_new_with_text (HILDON_SIZE_FINGER_HEIGHT |
                                          HILDON_SIZE_AUTO_WIDTH, HILDON_BUTTON_ARRANGEMENT_VERTICAL,
										  "Copy",
                                          NULL);
	hildon_button_set_alignment (HILDON_BUTTON (copyToClipboardBt), 0, 0.5, 0, 0);//AP1
	hildon_button_set_value (HILDON_BUTTON (copyToClipboardBt), "Buffer to Clipboard");
	g_signal_connect (copyToClipboardBt, "clicked", G_CALLBACK (copyToClipboardADBExportImportBt_clicked_cb), self);
    gtk_box_pack_start (GTK_BOX (cmdExportBox), copyToClipboardBt, TRUE, TRUE, 0);

    GtkWidget *exportFileBufferBt = hildon_button_new_with_text (HILDON_SIZE_FINGER_HEIGHT |
                                              HILDON_SIZE_AUTO_WIDTH, HILDON_BUTTON_ARRANGEMENT_VERTICAL,
    										  "Export",
                                              NULL);
    hildon_button_set_alignment (HILDON_BUTTON (exportFileBufferBt), 0, 0.5, 0, 0);//AP1
    hildon_button_set_value (HILDON_BUTTON (exportFileBufferBt), "Buffer to File");
    g_signal_connect (exportFileBufferBt, "clicked", G_CALLBACK (exportFileBufferBt_clicked_cb), self);
    gtk_box_pack_start (GTK_BOX (cmdExportBox), exportFileBufferBt, TRUE, TRUE, 0);

    GtkWidget *exportInstanceBt = hildon_button_new_with_text (HILDON_SIZE_FINGER_HEIGHT |
                                          HILDON_SIZE_AUTO_WIDTH, HILDON_BUTTON_ARRANGEMENT_VERTICAL,
										  "Export",
                                          NULL);
	hildon_button_set_alignment (HILDON_BUTTON (exportInstanceBt), 0, 0.5, 0, 0);//AP1
	hildon_button_set_value (HILDON_BUTTON (exportInstanceBt), "Beecon to Buffer");
	g_signal_connect (exportInstanceBt, "clicked", G_CALLBACK (exportInstanceBt_clicked_cb), self);
    gtk_box_pack_start (GTK_BOX (cmdExportBox), exportInstanceBt, TRUE, TRUE, 0);

	gtk_box_pack_start (GTK_BOX (content_area), cmdExportBox, TRUE, TRUE, 0);

	GtkWidget *IEBufferLabelHelp = gtk_label_new ("");
	gtk_label_set_markup (GTK_LABEL (IEBufferLabelHelp), "<span font_desc=\"Nokia Sans 13\">Buffer for Command or Instance Export/Import ... handle with care!</span>");//AP1
	gtk_label_set_line_wrap (GTK_LABEL (IEBufferLabelHelp), TRUE);
	gtk_misc_set_alignment (GTK_MISC (IEBufferLabelHelp), 0.5, 0.5);
	gtk_box_pack_start (GTK_BOX (content_area), IEBufferLabelHelp, FALSE, FALSE, 0);

	GtkWidget *cmdInstanceText = hildon_text_view_new ();
	input_mode = hildon_gtk_text_view_get_input_mode(GTK_TEXT_VIEW (cmdInstanceText));
	input_mode &= ~HILDON_GTK_INPUT_MODE_AUTOCAP; hildon_gtk_text_view_set_input_mode(GTK_TEXT_VIEW (cmdInstanceText), input_mode);
	gtk_widget_set_size_request (GTK_WIDGET (cmdInstanceText), -1, 200);//AP
	gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (cmdInstanceText), GTK_WRAP_WORD_CHAR);
	gtk_box_pack_start (GTK_BOX (content_area), cmdInstanceText, FALSE, FALSE, 0);

	//END

	gtk_widget_show_all (self->priv->advancedDialog);

	PangoFontDescription *fd = pango_font_description_from_string("Monospace bold 13");//AP1
	gtk_widget_modify_font(GTK_WIDGET (cmdInstanceText), fd);//AP1
	gtk_widget_modify_font(GTK_WIDGET (cmdTestDrive), fd);//AP1
	gtk_widget_modify_font(GTK_WIDGET (cmdOutput), fd);//AP1

	self->priv->importExportBuffer = hildon_text_view_get_buffer (HILDON_TEXT_VIEW (cmdInstanceText));
	self->priv->cmdTestDriveBuffer = hildon_text_view_get_buffer (HILDON_TEXT_VIEW (cmdTestDrive));
	self->priv->cmdOutputBuffer = hildon_text_view_get_buffer (HILDON_TEXT_VIEW (cmdOutput));

	g_signal_connect (G_OBJECT (self->priv->commandPicker), "value-changed",G_CALLBACK (on_command_picker_value_changed), self);

	cmdSel = hildon_touch_selector_get_active (HILDON_TOUCH_SELECTOR (commandPickerSelector), 0);
	if (cmdSel>=0) {
		//g_warning ("(%p) Working on global selector title=[%s] command=[%s]", self, self->priv->c_titles[cmdSel], self->priv->c_commands[cmdSel]);
		gchar *c = g_strdup(self->priv->c_commands[cmdSel]);
		gtk_text_buffer_set_text(self->priv->cmdTestDriveBuffer,c,-1);
		g_free(c);
	} else {
		//g_warning ("(%p) Working on instance title=[%s] command=[%s]", self, self->priv->instanceTitle, self->priv->instanceCmd);
		gchar *c = g_strdup(self->priv->instanceCmd);
		gtk_text_buffer_set_text(self->priv->cmdTestDriveBuffer,c,-1);
		g_free(c);
	}
	self->priv->instanceImportOK=FALSE;

	while (!timeToGoBack) {
		self->priv->currentDialog=self->priv->advancedDialog;
		int dialogRunResponse = gtk_dialog_run (GTK_DIALOG (self->priv->advancedDialog));
		//g_warning ("(%p) Advanced Dialogue response =[%d]", self, dialogRunResponse);

		switch(dialogRunResponse) {
			case GTK_RESPONSE_ACCEPT:
				//g_warning ("(%p) GTK_RESPONSE_ACCEPT...", self);
				break;
			default:
				//g_warning ("(%p) Time to go back... response %d", self, dialogRunResponse);
				timeToGoBack = TRUE;
				if (self->priv->instanceImportOK) reReadSettings=TRUE;
				break;
		}
	}
	gtk_widget_destroy (self->priv->advancedDialog);

	return(reReadSettings);
}

//Auxiliary functions
static void AddCommand(QueenBeecon *self, gchar * s_title, gchar * s_command, gboolean doInstantiate)
{
g_warning ("(%p) AddCommand title=[%s] command=[%s] doInstantiate=%d", self, s_title, s_command, doInstantiate);
	int i;

	gchar **newTitles = malloc( sizeof(gchar*)*(self->priv->c_size+2) );
	gchar **newCommands = malloc( sizeof(gchar*)*(self->priv->c_size+2) );

	for(i=0;i<self->priv->c_size;i++) {
		newTitles[i] = g_strdup(self->priv->c_titles[i]);
		newCommands[i] = g_strdup(self->priv->c_commands[i]);
	}

	g_strfreev(self->priv->c_titles);
	self->priv->c_titles = NULL;
	g_strfreev(self->priv->c_commands);
	self->priv->c_commands = NULL;

	newTitles[self->priv->c_size] = s_title;
	newCommands[self->priv->c_size] = s_command;

	newTitles[self->priv->c_size+1] = NULL;
	newCommands[self->priv->c_size+1] = NULL;

	if (doInstantiate) {
		if (self->priv->instanceTitle!=NULL) g_free(self->priv->instanceTitle);	self->priv->instanceTitle = NULL;
		self->priv->instanceTitle = strdup(newTitles[self->priv->c_size]);
		//g_warning("(%p) self->priv->instanceTitle = %p [%s]", self, self->priv->instanceTitle, self->priv->instanceTitle);

		if (self->priv->instanceCmd!=NULL) g_free(self->priv->instanceCmd);	self->priv->instanceCmd = NULL;
		self->priv->instanceCmd = strdup(newCommands[self->priv->c_size]);
		//g_warning("(%p) self->priv->instanceCmd = %p [%s]", self, self->priv->instanceCmd, self->priv->instanceCmd);
	}

	self->priv->c_size += 1;

	self->priv->c_titles = newTitles;
	self->priv->c_commands = newCommands;
}

static void EditCommand(QueenBeecon *self, gchar * s_title, gchar * s_command, gboolean doInstantiate, int index)
{
g_warning ("(%p) EditCommand title=[%s] command=[%s] index=[%d]", self, s_title, s_command, index);
	//Clean old
	if (index>=0) { // Command is one of the listed commands
		g_free(self->priv->c_titles[index]);
		self->priv->c_titles[index] = s_title;

		g_free(self->priv->c_commands[index]);
		self->priv->c_commands[index] = s_command;
	}

	if (doInstantiate) {
		if (self->priv->instanceTitle!=NULL) g_free(self->priv->instanceTitle);
		self->priv->instanceTitle = g_strdup(s_title);

		if (self->priv->instanceCmd!=NULL) g_free(self->priv->instanceCmd);
		self->priv->instanceCmd = g_strdup(s_command);
	}
}

static void DelCommand(QueenBeecon *self, int index)
{
	g_warning ("(%p) %s index=%d", self, G_STRFUNC, index);
	int i;

	gchar **newTitles = malloc( sizeof(gchar*)*(self->priv->c_size) );
	gchar **newCommands = malloc( sizeof(gchar*)*(self->priv->c_size) );

	for(i=0;i<self->priv->c_size;i++) {
		//index is the delete target
		if(i < index) {
			newTitles[i] = g_strdup(self->priv->c_titles[i]);
			newCommands[i] = g_strdup(self->priv->c_commands[i]);
		} else if(i > index) {
			newTitles[i-1] = g_strdup(self->priv->c_titles[i]);
			newCommands[i-1] = g_strdup(self->priv->c_commands[i]);
		}
	}
	newTitles[self->priv->c_size-1] = NULL;
	newCommands[self->priv->c_size-1] = NULL;

	//clear old
	g_strfreev(self->priv->c_titles);
	self->priv->c_titles = NULL;

	g_strfreev(self->priv->c_commands);
	self->priv->c_commands = NULL;

	//assign new
	self->priv->c_titles = newTitles;
	self->priv->c_commands = newCommands;

	if (self->priv->instanceTitle!=NULL) g_free(self->priv->instanceTitle);
	self->priv->instanceTitle = NULL;

	if (self->priv->instanceCmd!=NULL) g_free(self->priv->instanceCmd);
	self->priv->instanceCmd = NULL;

	if(self->priv->c_size > 1) {
		self->priv->instanceTitle = g_strdup(newTitles[0]);
		//g_warning("(%p) self->priv->instanceTitle = %p [%s]", self, self->priv->instanceTitle, self->priv->instanceTitle);
		self->priv->instanceCmd = g_strdup(newCommands[0]);
		//g_warning("(%p) self->priv->instanceCmd = %p [%s]", self, self->priv->instanceCmd, self->priv->instanceCmd);
	}

	self->priv->c_size -= 1;//decrement size
}

static guint GetSeconds(guint index)
{
	//g_warning ("%s index=%d",G_STRFUNC, index);
	if(index > 0 && index < 9)
	{
		guint intervalTimes[] = {0, 30, 60, 300, 1800, 3600, 21600, 43200, 86400};
		return intervalTimes[index];
	}
	return 0;
}

static guint checksum(gchar *buffer)
{
	int i;
	guint chksm=0;

	for (i=0;buffer[i]!='\0';i++) if ((guint)buffer[i]>32 && (guint)buffer[i]<127) chksm+=(guint)(buffer[i]^i)<<1;
	return(chksm);
}

#ifdef GLOBAL_WIDGET_HEARTBEAT_TIMER
//Housekeeping timer
//static gboolean home_applet_timer (gpointer data)
//{
//	g_warning ("home_applet_timer (gpointer data)called");
//
//	beecon_config_file_housekeeping(data);
//
//	/* repeat this timer */
//return TRUE;
//}
#endif

static void beecon_config_file_housekeeping(gpointer data)
{
	g_warning ("(%p) %s", data, G_STRFUNC);
	GKeyFile *keyFile = NULL;
	gchar *filename = NULL;
	gchar *fileData = NULL;
	FILE *iniFile = NULL;
	gsize size;
	gboolean fileExists;
	GError *error = NULL;
    gchar **groups = NULL;
	gint i;
	gsize groupLength;

	// :) Do not mess up with the housekeeper!!!
	if (housekeeping) return;

	housekeeping=1;
	keyFile = g_key_file_new();
	//g_warning("(%p) keyfile%p", data, keyFile);
	filename = g_strconcat (HOME_DIR, QUEEN_BEECON_SETTINGS_FILE, NULL);
	//g_warning("(%p) filename %s",data, filename);
	fileExists = g_key_file_load_from_file (keyFile, filename, G_KEY_FILE_KEEP_COMMENTS, NULL);
	//g_warning("(%p) fileExists %d", data, fileExists);

	if (fileExists) {
	    groups = g_key_file_get_groups (keyFile, &groupLength);
    	//g_warning("(%p) Found Groups=%d", data, groupLength);
	    for(i=0; i<groupLength; i++) {
	    	//g_warning("(%p) Group=%s", data, groups[i]);
	    	if ( !strncmp(QUEEN_BEECON_INSTANCE_BASENAME, groups[i], strlen(QUEEN_BEECON_INSTANCE_BASENAME)) ) {
		    	//g_warning("(%p) Instance groups here = [%s] = [%s]", data, QUEEN_BEECON_INSTANCE_BASENAME, groups[i]);
		    	gchar *instanceDir = g_strdup_printf("%s/%s", SYSTEM_INSTANCE_BASE_DIR, groups[i]);
		    	//g_warning("(%p) Instance dir = [%s]", data, instanceDir);
	    		GDir *dir = g_dir_open (instanceDir, 0, NULL);
	    		g_free(instanceDir);
	    		if (!dir) {
					//g_warning("(%p) No Instance Directory... Time to delete group from Config File [%s]", data, groups[i]);
					if (!g_key_file_remove_group (keyFile, groups[i], &error)) {
						g_warning("(%p) Delete group error [%s]", data, error->message);
					}
				} else {
					//g_warning("(%p) Instance Directory successfully open ... Instance is alive and kicking [%s]", data, groups[i]);
					g_dir_close (dir);
       		    }
	    	}
	    }
		g_strfreev(groups);

		fileData = g_key_file_to_data (keyFile, &size, NULL);
		//g_warning("(%p) fileData %p", data, fileData);
		iniFile = fopen (filename, "w");
		fputs (fileData, iniFile);
		fclose (iniFile);
		g_free (fileData);
	}
	g_free (filename);
	g_key_file_free (keyFile);
	housekeeping=0; // Everything is clean and easy!!!
}

static gchar *queen_beecon_g_key_file_get_string(GKeyFile *key_file, const gchar *group_name, const gchar *key, gchar *defaultValue)
{
	GError *error=NULL;
	gchar *setting = g_key_file_get_string(key_file, group_name, key,&error);
	if (error) {
		g_warning("No setting [%s] ->[%s]", key, defaultValue);
		g_clear_error (&error);//AP3
		return(defaultValue);
	} else
		return(setting);
}

static gboolean queen_beecon_g_key_file_get_boolean(GKeyFile *key_file, const gchar *group_name, const gchar *key, gboolean defaultValue)
{
	GError *error=NULL;
	gboolean setting = g_key_file_get_boolean(key_file, group_name, key,&error);
	if (error) {
		g_warning("No setting [%s] ->[%d]", key, defaultValue);
		g_clear_error (&error);//AP3
		return(defaultValue);
	} else
		return(setting);
}

static gint queen_beecon_g_key_file_get_integer(GKeyFile *key_file, const gchar *group_name, const gchar *key, gint defaultValue)
{
	GError *error=NULL;
	gint setting = g_key_file_get_integer(key_file, group_name, key,&error);
	if (error) {
		g_warning("No setting [%s] ->[%d]", key, defaultValue);
		g_clear_error (&error);//AP3
		return(defaultValue);
	}else
		return(setting);
}

static gdouble queen_beecon_g_key_file_get_double(GKeyFile *key_file, const gchar *group_name, const gchar *key, gdouble defaultValue)
{
	GError *error=NULL;
	gdouble setting = g_key_file_get_double(key_file, group_name, key, &error);
	if (error) {
		g_warning("No setting [%s] ->[%f]", key, defaultValue);
		g_clear_error (&error);//AP3
		return(defaultValue);
	} else
		return(setting);
}

static gboolean write_settings_have_key(const gchar *group_name, const gchar *key, void *value, char keyType)
{
	g_warning ("%s %s %s %p %c", G_STRFUNC, group_name, key, value, keyType);
	GKeyFile *keyFile = NULL;
	gchar *filename = NULL;
	gchar *fileData = NULL;
	FILE *iniFile = NULL;
	gsize size;
	gboolean fileExists;
	GError *error = NULL;
	gboolean RC = TRUE;

	keyFile = g_key_file_new();
	//g_warning("keyfile %p", keyFile);
	filename = g_strconcat (HOME_DIR, QUEEN_BEECON_SETTINGS_FILE, NULL);
	//g_warning("filename %s", filename);
	fileExists = g_key_file_load_from_file (keyFile, filename, G_KEY_FILE_KEEP_COMMENTS, NULL);
	//g_warning("fileExists %d", fileExists);

	if (fileExists) {
		if (!g_key_file_has_key(keyFile, group_name, key, &error)) {
			//g_warning ("g_key_file_has_key failed: %s\n", error->message);
			g_clear_error (&error);
			RC = FALSE; // If key is not present in settings file then returns FALSE
		} else {
			switch (keyType) {
			case 'b':
				//g_warning("bool %s %s %d", group_name, key, *(gboolean *)value);
				g_key_file_set_boolean (keyFile, group_name, key, *(gboolean *)value);
				break;
			case 'i':
			case 'u':
				//g_warning("int uint %s %s %d", group_name, key, *(gint *)value);
				g_key_file_set_integer (keyFile, group_name, key, *(gint *)value);
				break;
			case 'd':
				//g_warning("double %s %s %f", group_name, key, *(gdouble *)value);
				g_key_file_set_double (keyFile, group_name, key, *(gdouble *)value);
				break;
			case 's':
			default:
				//g_warning("string %s %s %s", group_name, key, (gchar *)value);
				g_key_file_set_string (keyFile, group_name, key, (gchar *)value);
			}
			fileData = g_key_file_to_data (keyFile, &size, NULL);
			//g_warning("fileData %p", fileData);
			iniFile = fopen (filename, "w");
			fputs (fileData, iniFile);
			fclose (iniFile);
			g_free (fileData);
		}
	} else RC = FALSE;
	g_free (filename);
	g_key_file_free (keyFile);
	return(RC);
}

static gchar *read_settings_have_key (const gchar *group_name, const gchar *key)
{
	g_warning ("%s %s %s", G_STRFUNC, group_name, key);
	gchar *filename = NULL;
	gboolean fileExists;
	GKeyFile *keyFile = NULL;
	GError *error=NULL;
	gchar *prm = NULL;

	keyFile = g_key_file_new();
	//g_warning("keyfile %p", keyFile);
	filename = g_strconcat (HOME_DIR, QUEEN_BEECON_SETTINGS_FILE, NULL);
	//g_warning("filename %s", filename);
	fileExists = g_key_file_load_from_file (keyFile, filename, G_KEY_FILE_KEEP_COMMENTS, NULL);
	//g_warning("fileExists %d", fileExists);

	prm = g_strdup(g_key_file_get_string(keyFile, group_name, key, &error));
	if (error) {
		g_warning("No setting [%s] on key file", key);
		g_clear_error (&error);//AP3
		if (prm) g_free (prm);
	}
	//g_warning("gn=%s k=%s vp=%p v=%s", group_name, key, prm, prm);
	g_key_file_free (keyFile);
	g_free (filename);
	return prm;
}

/**
 * g_strreplace
 * @string: a string
 * @search: search string
 * @replacement: replacement string
 *
 * Replaces all occurences of @search in a new copy of @string
 *   by @replacement.
 *
 * Return value: A newly allocated string, where all @search
 *   strings are replaced by the @replacement string.
 *
 * Since: 2.6
 **/
static gchar *g_strreplace (const gchar *string, const gchar *search, const gchar *replacement)
{
  gchar *str, **arr;

  g_return_val_if_fail (string != NULL, NULL);
  g_return_val_if_fail (search != NULL, NULL);

  if (replacement == NULL)
    replacement = "";

  arr = g_strsplit (string, search, -1);
  if (arr != NULL && arr[0] != NULL)
    str = g_strjoinv (replacement, arr);
  else
    str = g_strdup (string);

  g_strfreev (arr);

  return str;
}

/**
 * QBW Internal parameter substitution in run scripts
 **/
static gchar *queen_beecon_g_command_param_subst(QueenBeecon *self, const gchar *cmd, const gchar *action)
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	gchar *r = NULL;
	gchar *x = g_strdup(cmd);
	//g_warning ("(%p) $QBW_ID r=%p x=%p",self, r, x);
	r = g_strreplace(x,"$QBW_ID"                  ,self->priv->qbwDbusId); g_free(x); x = r;
	//g_warning ("(%p) $QBW_EXEC_REASON r=%p x=%p",self, r, x);
	r = g_strreplace(x,"$QBW_EXEC_REASON"         ,action); g_free(x); x = r;
	r = g_strreplace(x,"$QBW_CURRENT_RESULTS_TEXT",gtk_label_get_label(GTK_LABEL (self->priv->cmdResult_lb))); g_free(x); x = r;
	if (self->priv->dbusVerboseMsg) {
		//g_warning ("(%p) $QBW_DBUS_VERBOSE_OUTPUT r=%p x=%p",self, r, x);
		r = g_strreplace(x,"$QBW_DBUS_VERBOSE_OUTPUT",self->priv->dbusVerboseMsg->str); g_free(x); x = r;
	}
	//g_warning ("(%p) FINAL r=%p x=%p",self, r, x);
	return (r);
}

// Asynchronous command execution management
static void queen_beecon_async_sync_exec_out(QueenBeecon *self, const gchar *whoareyou)
{
	g_warning ("(%p) %s %s",self, G_STRFUNC, whoareyou);
	if (++self->priv->syncOutExec == 2) { // Have process and output synchronized?!?!?!
		g_warning ("(%p) SYNCHED!!!",self);
        //g_warning ("(%p) execAuxOutput 3b %p (%s)", self, self->priv->execAuxOutput, self->priv->execAuxOutput);
    	guint lenOut = strlen(self->priv->execAuxOutput);
        //g_warning ("(%p) execAuxOutput 4 %p (%s)", self, self->priv->execAuxOutput, self->priv->execAuxOutput);
    	if(self->priv->execAuxOutput[lenOut-1]=='\n') self->priv->execAuxOutput[lenOut-1]='\0';
    	if(!g_strcmp0(self->priv->execAuxOutput,"")) {
    		//g_warning ("(%p) execAuxOutput 5 %p (%s)", self, self->priv->execAuxOutput, self->priv->execAuxOutput);
    		g_free(self->priv->execAuxOutput);
    		self->priv->execAuxOutput = g_strdup("No Output");//AP
    		//g_warning ("(%p) execAuxOutput 6 %p (%s)", self, self->priv->execAuxOutput, self->priv->execAuxOutput);
    	}
    	//g_warning ("(%p) cond == G_IO_HUP execAuxOutput=%s",self, self->priv->execAuxOutput);
        //g_warning ("(%p) execAuxOutput 7 %p (%s)", self, self->priv->execAuxOutput, self->priv->execAuxOutput);
    	if (self->priv->cmdExitStatus==-1) {
    		gchar *chkOut = g_strdup(self->priv->execAuxOutput);
    		g_free(self->priv->execAuxOutput);
    		self->priv->execAuxOutput = g_strdup_printf("[!?%04x]\n%s", self->priv->cmdStatus, chkOut);//If command has output we issue a newline after Exit Code
    		//g_warning ("(%p) execAuxOutput 2 %p (%s)", self, self->priv->execAuxOutput, self->priv->execAuxOutput);
    		g_free(chkOut);
    	}
    	g_warning("(%p) EXEC OUTPUT [%s]", self, self->priv->execAuxOutput);
    	gtk_label_set_markup (GTK_LABEL (self->priv->cmdResult_lb), self->priv->execAuxOutput);//AP
    	g_free(self->priv->execAuxOutput);self->priv->execAuxOutput = NULL;

    	queen_beecon_update_content_layout (self);
    	queen_beecon_exec_animation_progress(self, QBW_STOP_PROGRESS_ANIMATION);
    	g_warning("(%p) RESET execInProgress...",self);

    	/* Remove timeout callback */
        g_source_remove( self->priv->timeout_id );

    	self->priv->execInProgress = FALSE; // Reset execInProgress flag ready for next execution
	}
}

static void queen_beecon_async_execute_cb_child_watch(GPid pid, gint status, QueenBeecon *self)
{
	g_warning ("(%p) %s => status [0x%04X]",self, G_STRFUNC, status);

	if ((status & 0xff)>0 || ((status >> 8 & 0xff) > 0x70)) {
		self->priv->cmdExitStatus=-1;
		self->priv->cmdStatus=status&0xffff;
	} else {
		self->priv->cmdExitStatus=status >> 8 & 0xff;
	}

    /* Close pid */
    g_spawn_close_pid( pid );

    queen_beecon_async_sync_exec_out(self, "EXEC");
}

static gboolean queen_beecon_async_execute_cb_out_watch(GIOChannel *channel, GIOCondition  cond, QueenBeecon *self)
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	GIOStatus  ret;
    gchar *string = NULL;
    gchar *out;
    gsize  size;

    if( cond == G_IO_HUP ) {
        queen_beecon_async_sync_exec_out(self, "OUTPUT");
        return( FALSE );
    }
	ret = g_io_channel_read_line(channel, &string, &size, NULL, NULL);
	//g_warning ("(%p) ret=%d size=%d string=%p(%s)", self, ret, size, string, string);
	out = g_strconcat (self->priv->execAuxOutput, string, NULL);
	g_free(self->priv->execAuxOutput);
	self->priv->execAuxOutput = out;
	g_free(string);
	return( TRUE );
}

static gboolean queen_beecon_async_execute_cb_timeout(QueenBeecon *self)
{
	g_warning ("(%p) %s",self, G_STRFUNC);
    queen_beecon_exec_animation_progress(self, QBW_FRAME_PROGRESS_ANIMATION);
    return( TRUE );
}

static GIOChannel *queen_beecon_async_execute_set_up_io_channel (gint fd, GIOCondition cond, GIOFunc func, QueenBeecon *self)
{
	g_warning ("(%p) %s",self, G_STRFUNC);
	GIOChannel *ioc;

	/* set up handler for data */
	ioc = g_io_channel_unix_new (fd);
	//g_warning ("(%p) ioc=%p",self, ioc);

	/* Set IOChannel encoding to none to make
	 *  it fit for binary data */
	//g_io_channel_set_encoding (ioc, NULL, NULL);
	//g_io_channel_set_buffered (ioc, FALSE);

	/* Tell the io channel to close the file descriptor
	 *  when the io channel gets destroyed */
	g_io_channel_set_close_on_unref (ioc, TRUE);

	/* g_io_add_watch() adds its own reference,
	 *  which will be dropped when the watch source
	 *  is removed from the main loop (which happens
	 *  when we return FALSE from the callback) */
	g_io_add_watch (ioc, cond, func, self);
	g_io_channel_unref (ioc);

	return ioc;
}

static void queen_beecon_async_execute(gchar *cmd, QueenBeecon *self)
{
	g_warning ("(%p) %s",self, G_STRFUNC);
    GPid        pid;
    gchar      *argv[] = { "/bin/sh", "-c", cmd, NULL };
    gint        out;
    gboolean    ret;
	GError 		*error=NULL;

	//gtk_label_set_markup (GTK_LABEL (self->priv->cmdResult_lb), "");//AP
    if (self->priv->execAuxOutput) g_free(self->priv->execAuxOutput);
	self->priv->execAuxOutput = g_strdup("");
	//self->priv->cmdExitStatus=-1;
	self->priv->syncOutExec=0;

	ret = g_spawn_async_with_pipes( NULL, argv, NULL, G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &pid, NULL, &out, NULL, &error );
    if( ! ret ) {
    	g_warning ("(%p) SPAWN ERROR [%s]",self, error->message );
    	self->priv->cmdStatus = error->code;
    	self->priv->cmdExitStatus=-1;
    	g_clear_error (&error);
    	self->priv->syncOutExec++; // Process never exec-ed
        queen_beecon_async_sync_exec_out(self, "SPAWN FAILED");
        return;
    }

	g_warning ("(%p) SPAWN SUCCEEDED [PID=%d]",self, pid);

    /* Now use GIOChannels to monitor stdout */
    self->priv->out_ch = queen_beecon_async_execute_set_up_io_channel(out, G_IO_IN | G_IO_HUP, (GIOFunc)queen_beecon_async_execute_cb_out_watch, self);

    /* Add watch function to catch termination of the process. This function will clean any remnants of process. */
    g_child_watch_add(pid, (GChildWatchFunc)queen_beecon_async_execute_cb_child_watch, self );

	queen_beecon_exec_animation_progress(self, QBW_CUSTOM_PROGRESS_ANIMATION);
    queen_beecon_exec_animation_progress(self, QBW_START_PROGRESS_ANIMATION);

    ///* Install timeout fnction that will move the progress bar */
    self->priv->timeout_id = g_timeout_add(200, (GSourceFunc)queen_beecon_async_execute_cb_timeout, self);
}

typedef struct {
	gchar *key;
	gchar *val;
} Tokenz;

static gboolean queen_beecon_dbus_monitor_parse_match(DBusMessage *message, gchar *rule)
{
	g_warning ("%s(%s)", G_STRFUNC, rule);
	Tokenz tokens[17];
#define DBUS_PARSE_RULE_LOGIC
#ifdef DBUS_PARSE_RULE_LOGIC
	gboolean inquote=FALSE, inkey=FALSE, invalue=FALSE;
	guint t = 0; // token index
	gchar *s = g_strdup(rule);
	gchar *p = s;
	gchar *k = s;
	gchar *v = s;

	if (*p=='\0') {g_free(s);return FALSE;}
	while (*p!=0 && t<16) {
		//g_warning ("t=%d inquote=%d inkey=%d invalue=%d *p=%c p=%p(%s) k=%p(%s) v=%p(%s)", t, inquote, inkey, invalue, *p, p, p, k, k, v, v);
		switch (*p) {
		case '\\':
			//g_warning ("t=%d inquote=%d inkey=%d invalue=%d *p=%c", t, inquote, inkey, invalue, *p);
			if (invalue) {inquote=TRUE;p++;break;}
			p++;
			break;
		case '\'':
			//g_warning ("t=%d inquote=%d inkey=%d invalue=%d *p=%c", t, inquote, inkey, invalue, *p);
			if (inquote) {inquote=FALSE;p++;}
			if (inkey) {inkey=FALSE;invalue=TRUE;p++;v=p;break;} // found ' value leader
			if (invalue&&!inquote) {*p='\0';tokens[t].val=g_strdup(v);p++;invalue=FALSE;t++;break;} // found ' value trailer
			p++;
			break;
		case ' ':
		case '\t':
			//g_warning ("t=%d inquote=%d inkey=%d invalue=%d *p=%c", t, inquote, inkey, invalue, *p);
			inquote = FALSE;
			if (!invalue) *p='\0'; // leading or trailing blanks or tabs surrounding key or value
			p++;
			break;
		case '=':
			//g_warning ("t=%d inquote=%d inkey=%d invalue=%d *p=%c", t, inquote, inkey, invalue, *p);
			inquote = FALSE;
			if (inkey) {*p='\0';tokens[t].key=g_strdup(k);p++;break;}
			p++;
			break;
		case ',':
			//g_warning ("t=%d inquote=%d inkey=%d invalue=%d *p=%c", t, inquote, inkey, invalue, *p);
			inquote = FALSE;
			if (!invalue) {p++;k=p;inkey=FALSE;break;}
			p++;
			break;
		default:
			//g_warning ("t=%d inquote=%d inkey=%d invalue=%d *p=%c", t, inquote, inkey, invalue, *p);
			if (!inkey&&!invalue){k=p;inkey=TRUE;}
			p++;
			break;
		}
	}
	g_free(s);

	gboolean ismatch = TRUE;
	int i;
	for (i=0;i<t;i++) {
		g_warning ("TOKENS[%d]={%s,%s}", i, tokens[i].key, tokens[i].val);
		if (!g_strcmp0(tokens[i].key,"type")) {
			int message_type = dbus_message_get_type (message);
			if (!g_strcmp0(tokens[i].val, "signal")        && message_type != DBUS_MESSAGE_TYPE_SIGNAL       ) {ismatch=FALSE;break;}
			if (!g_strcmp0(tokens[i].val, "method call")   && message_type != DBUS_MESSAGE_TYPE_METHOD_CALL  ) {ismatch=FALSE;break;}
			if (!g_strcmp0(tokens[i].val, "method return") && message_type != DBUS_MESSAGE_TYPE_METHOD_RETURN) {ismatch=FALSE;break;}
			if (!g_strcmp0(tokens[i].val, "error")         && message_type != DBUS_MESSAGE_TYPE_ERROR        ) {ismatch=FALSE;break;}
		}
		if (!g_strcmp0(tokens[i].key,"sender"))      if (g_strcmp0(tokens[i].val, dbus_message_get_sender      (message))) {ismatch=FALSE;break;}
		if (!g_strcmp0(tokens[i].key,"destination")) if (g_strcmp0(tokens[i].val, dbus_message_get_destination (message))) {ismatch=FALSE;break;}
		if (!g_strcmp0(tokens[i].key,"path"))        if (g_strcmp0(tokens[i].val, dbus_message_get_path        (message))) {ismatch=FALSE;break;}
		if (!g_strcmp0(tokens[i].key,"interface"))   if (g_strcmp0(tokens[i].val, dbus_message_get_interface   (message))) {ismatch=FALSE;break;}
		if (!g_strcmp0(tokens[i].key,"member"))      if (g_strcmp0(tokens[i].val, dbus_message_get_member      (message))) {ismatch=FALSE;break;}
	}
	for (i=0;i<t;i++) {g_free(tokens[i].key); g_free(tokens[i].val);}
#endif
	return ismatch;
}

static DBusHandlerResult queen_beecon_dbus_monitor_filter_function(DBusConnection *connection, DBusMessage *message, QueenBeecon *self)
{
	g_warning ("(%p) %s dc=%p msg=%p",self, G_STRFUNC, connection, message);
	if (queen_beecon_dbus_monitor_parse_match(message, self->priv->updOnDBUSMatchRule) == TRUE) {
		g_warning ("(%p) MATCH!!!",self);
		self->priv->dbusVerboseMsg = g_string_new("");
		dbus_print_message (message, FALSE, self->priv->dbusVerboseMsg);
		queen_beecon_update_content (self, qbwExecReason[QBW_DBUS_MONITOR]);
		g_string_free(self->priv->dbusVerboseMsg,TRUE);self->priv->dbusVerboseMsg = NULL;
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}

static gboolean queen_beecon_dbus_monitor_manager(QueenBeecon *self, QbwDBUSMonitorAction action, guint DBUSBus, const gchar *DBUSMatchRule)
{
	g_warning ("(%p) %s action=%s",self, G_STRFUNC, qbwDBUSMonitorAction[action]);

	dbus_error_init (&self->priv->dbus_mon_error);

	switch (action) {
	case QBW_INIT_DBUS_MONITOR:
		self->priv->dbus_mon_connection = dbus_bus_get (!DBUSBus?DBUS_BUS_SYSTEM:DBUS_BUS_SESSION, &self->priv->dbus_mon_error);
		g_warning ("(%p) dbus_bus_get Bus:[%d] (0=System 1=Session) dbus=%p",self, DBUSBus, self->priv->dbus_mon_connection);

	    if (dbus_error_is_set (&self->priv->dbus_mon_error)){
			gchar *msg=g_strdup_printf("QBW(%s): DBUS Monitor Error connecting to the daemon bus [%s]", self->priv->qbwDbusId, self->priv->dbus_mon_error.message); GtkWidget *info = hildon_note_new_information (NULL, msg);gtk_dialog_run (GTK_DIALOG (info));gtk_object_destroy (GTK_OBJECT (info));g_free(msg);
	    	g_warning ("(%p) DBUS Monitor Error connecting to the daemon bus [%s]",self, self->priv->dbus_mon_error.message);
	        dbus_error_free (&self->priv->dbus_mon_error);
	        return FALSE; //FALSE on error
	    }

		g_warning ("(%p) Adding Match Rule [%s]",self, DBUSMatchRule);
	    dbus_bus_add_match (self->priv->dbus_mon_connection, DBUSMatchRule, &self->priv->dbus_mon_error);
	    if (dbus_error_is_set (&self->priv->dbus_mon_error)){
			gchar *msg=g_strdup_printf("QBW(%s): DBUS Monitor Error [%s] adding Match Rule [%s]\nMonitor Disabled!", self->priv->qbwDbusId, self->priv->dbus_mon_error.message, DBUSMatchRule); GtkWidget *info = hildon_note_new_information (NULL, msg);gtk_dialog_run (GTK_DIALOG (info));gtk_object_destroy (GTK_OBJECT (info));g_free(msg);
	    	g_warning ("(%p) DBUS Monitor Error [%s] adding Match Rule [%s]", self, self->priv->dbus_mon_error.message, DBUSMatchRule);
	        dbus_error_free (&self->priv->dbus_mon_error);

	        g_warning ("(%p) dbus_connection_unref:[%d] (0=System 1=Session)",self, DBUSBus);
		    //dbus_connection_close (self->priv->dbus_mon_connection);
		    dbus_connection_unref (self->priv->dbus_mon_connection);
			self->priv->dbus_mon_connection = NULL;

		    return FALSE; //FALSE on error
	    }

		g_warning ("(%p) Adding Filter [%s]",self, DBUSMatchRule);
	    if (!dbus_connection_add_filter (self->priv->dbus_mon_connection, (DBusHandleMessageFunction)queen_beecon_dbus_monitor_filter_function, self, NULL)) {
			gchar *msg=g_strdup_printf("QBW(%s): DBUS Monitor Undefined Error adding Filter [%s]\nMonitor Disabled!", self->priv->qbwDbusId, DBUSMatchRule); GtkWidget *info = hildon_note_new_information (NULL, msg);gtk_dialog_run (GTK_DIALOG (info));gtk_object_destroy (GTK_OBJECT (info));g_free(msg);
	    	g_warning ("(%p) Error dbus_connection_add_filter failed", self);

			g_warning ("(%p) Removing Match Rule [%s]",self, DBUSMatchRule);
		    dbus_bus_remove_match (self->priv->dbus_mon_connection, DBUSMatchRule, &self->priv->dbus_mon_error);
		    if (dbus_error_is_set (&self->priv->dbus_mon_error)){
				gchar *msg=g_strdup_printf("QBW(%s): DBUS Monitor Error [%s] removing Match Rule [%s]\nMonitor Disabled!", self->priv->qbwDbusId, self->priv->dbus_mon_error.message, DBUSMatchRule); GtkWidget *info = hildon_note_new_information (NULL, msg);gtk_dialog_run (GTK_DIALOG (info));gtk_object_destroy (GTK_OBJECT (info));g_free(msg);
		    	g_warning ("(%p) DBUS Monitor Error [%s] removing Match Rule [%s]", self, self->priv->dbus_mon_error.message, DBUSMatchRule);
		        dbus_error_free (&self->priv->dbus_mon_error);
		    }

	    	g_warning ("(%p) dbus_connection_unref:[%d] (0=System 1=Session)",self, DBUSBus);
		    //dbus_connection_close (self->priv->dbus_mon_connection);
		    dbus_connection_unref (self->priv->dbus_mon_connection);
			self->priv->dbus_mon_connection = NULL;

		    return FALSE; //FALSE on error
	    } else {
	    	g_warning ("(%p) Filter Added", self);
	    }
	    dbus_connection_flush(self->priv->dbus_mon_connection);
		break;
	case QBW_DEINIT_DBUS_MONITOR:
		/* unreference dbus connection if present */
		g_warning ("(%p) dbus_mon_connection:[%p])",self, self->priv->dbus_mon_connection);
		if (self->priv->dbus_mon_connection) {
			g_warning ("(%p) Removing Filter [%s]",self, DBUSMatchRule);
		    dbus_connection_remove_filter (self->priv->dbus_mon_connection, (DBusHandleMessageFunction)queen_beecon_dbus_monitor_filter_function, self);

			g_warning ("(%p) Removing Match Rule [%s]",self, DBUSMatchRule);
		    dbus_bus_remove_match (self->priv->dbus_mon_connection, DBUSMatchRule, &self->priv->dbus_mon_error);
		    if (dbus_error_is_set (&self->priv->dbus_mon_error)){
				gchar *msg=g_strdup_printf("QBW(%s): DBUS Monitor Error [%s] removing Match Rule [%s]\nMonitor Disabled!", self->priv->qbwDbusId, self->priv->dbus_mon_error.message, DBUSMatchRule); GtkWidget *info = hildon_note_new_information (NULL, msg);gtk_dialog_run (GTK_DIALOG (info));gtk_object_destroy (GTK_OBJECT (info));g_free(msg);
		    	g_warning ("(%p) DBUS Monitor Error [%s] removing Match Rule [%s]", self, self->priv->dbus_mon_error.message, DBUSMatchRule);
		        dbus_error_free (&self->priv->dbus_mon_error);
		    }

		    dbus_connection_flush(self->priv->dbus_mon_connection);

			g_warning ("(%p) dbus_connection_unref:[%d] (0=System 1=Session)",self, DBUSBus);
		    //dbus_connection_close (self->priv->dbus_mon_connection);
		    dbus_connection_unref (self->priv->dbus_mon_connection);
			self->priv->dbus_mon_connection = NULL;
		}
		break;
	default:
		return FALSE; // Unhandled command
	}
	return TRUE;
}

static void queen_beecon_exec_animation_progress(QueenBeecon *self, QbwProgressAnimationAction action)
{
	g_warning ("(%p) %s action=%s",self, G_STRFUNC, qbwProgressAnimationAction[action]);
	guint i;

	switch (action) {
	case QBW_INIT_PROGRESS_ANIMATION:
		for (i=0; i < QBW_PROGRESS_ANIMATION_FRAMES; i++) {
			gchar *progressImgFilename = g_strdup_printf("%squeen-beecon-progress%d.png", SYSTEM_PUBLIC_ICON_DIR, i);
			//g_warning("(%p) Loading frame pixbuf %s", self, progressImgFilename);
			self->priv->beeExecuting_pixbuf[i] = gdk_pixbuf_new_from_file(progressImgFilename, NULL);
			g_free(progressImgFilename);
		}
		self->priv->beeExecuting_img = gtk_image_new_from_pixbuf(self->priv->beeExecuting_pixbuf[0]);
		//g_warning("(%p) Progress Image %p", self, self->priv->beeExecuting_img);
		gtk_widget_set_size_request(GTK_WIDGET(self->priv->beeExecuting_img), self->priv->widWidth, self->priv->widHeight);
		gtk_table_attach(GTK_TABLE(self->priv->tableLayout), GTK_WIDGET(self->priv->beeExecuting_img), 0, 1, 0, 1, GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 0, 0);
		gtk_misc_set_alignment(GTK_MISC (self->priv->beeExecuting_img),0.5,0.5);
		break;
	case QBW_CUSTOM_PROGRESS_ANIMATION:
		for (i=0; i < QBW_PROGRESS_ANIMATION_FRAMES; i++) {
			gchar *progressCustomImgFilename = NULL;
			gchar *progressCustomAux1ImgFilename = g_strdup_printf("%s%squeen-beecon-progress%d.png", HOME_DIR, QUEEN_BEECON_MYDOCS_IMAGE_DIR, i);
			gchar *progressCustomAux2ImgFilename = g_strdup_printf("%s%squeen-beecon-progress%d.png", HOME_DIR, QUEEN_BEECON_PRIVATE_DIR, i);
			gint w,h;
			GdkPixbufFormat *progressPixBufFmt = NULL;
			progressPixBufFmt = gdk_pixbuf_get_file_info(progressCustomAux1ImgFilename,&w,&h);
			if (progressPixBufFmt!=NULL) {
				//g_warning("(%p) Progress Image Aux1 [%s] found", self, progressCustomAux1ImgFilename);
				progressCustomImgFilename = progressCustomAux1ImgFilename;
			} else {
				progressPixBufFmt = gdk_pixbuf_get_file_info(progressCustomAux2ImgFilename,&w,&h);
				if (progressPixBufFmt!=NULL) {
					//g_warning("(%p) Progress Image Aux2 [%s] found", self, progressCustomAux2ImgFilename);
					progressCustomImgFilename = progressCustomAux2ImgFilename;
				}
			}
			//g_warning("(%p) Custom Progress Image [%s]", self, progressCustomImgFilename);
			if (progressCustomImgFilename!=NULL) {
				GError *error = NULL;
				GdkPixbuf *pixbuf = NULL;
				//g_warning("(%p) Custom Progress Image [%s] loading", self, progressCustomImgFilename);
				pixbuf = gdk_pixbuf_new_from_file(progressCustomImgFilename, &error);
				if (!pixbuf) {
					g_warning("(%p) Custom Progress Image [%s] pixbuf ERROR [%s]", self, progressCustomImgFilename, error->message);
					g_free(error);
				} else {
					g_warning("(%p) Custom Progress Image [%s] pixbuf SUCCESS", self, progressCustomImgFilename);
					g_object_unref (self->priv->beeExecuting_pixbuf[i]);
					self->priv->beeExecuting_pixbuf[i] = pixbuf;
				}
				gtk_image_set_from_pixbuf (GTK_IMAGE(self->priv->beeExecuting_img), self->priv->beeExecuting_pixbuf[0]);
			}
			g_free(progressCustomAux1ImgFilename);
			g_free(progressCustomAux2ImgFilename);
		}
	case QBW_START_PROGRESS_ANIMATION:
		self->priv->beeExecuting_imgidx=0;
		gtk_widget_show(self->priv->beeExecuting_img);
	case QBW_FRAME_PROGRESS_ANIMATION:
		gtk_image_set_from_pixbuf (GTK_IMAGE(self->priv->beeExecuting_img), self->priv->beeExecuting_pixbuf[self->priv->beeExecuting_imgidx++%QBW_PROGRESS_ANIMATION_FRAMES]);
		break;
	case QBW_STOP_PROGRESS_ANIMATION:
		gtk_widget_hide(self->priv->beeExecuting_img);
		break;
	case QBW_DEINIT_PROGRESS_ANIMATION:
		for (i=0; i < QBW_PROGRESS_ANIMATION_FRAMES; i++) g_object_unref (self->priv->beeExecuting_pixbuf[i]);
		break;
	default:
		return;
	}
	return;
}
