import QtQuick 1.0
import Qt 4.7

Rectangle {
	property string graphurl
	property string iconurl
	property bool switchable : true


	Behavior on opacity{NumberAnimation{duration: 500}}
	Behavior on x{NumberAnimation{duration: 500}}
	Behavior on y{NumberAnimation{duration: 500}}

	id: graphFrame
	width: 800
	height: 250
//	width: parent.width
//	height: parent.height
	color: "#00000000"



	Rectangle{
		id: rectangle1
		x: 350
		y: 75
		width: 100
		height: 100
		 radius: 12
		z: 0
		 gradient: Gradient {
			 GradientStop {position: 0.36; color: "#363535"}
			 GradientStop {position: 0.05;color: "#292525"}
			 GradientStop {position: 0.99;color: "#363535"}
		}
		 border.width: 2
		 border.color: "#bebebe"
		Image {
			id: icon
			anchors.rightMargin: 10
			anchors.leftMargin: 10
			anchors.bottomMargin: 10
			anchors.topMargin: 10
			anchors.fill: parent
			smooth: true
			source: iconurl
		}

	}

 Image {
	 id: graph
	 opacity: 0
	 anchors.fill: parent
	 source: Utilities.decode(graphurl)
 }

 Image {
	 id: loadingImage
	 z: -1
	 opacity: 0
	 anchors.fill: parent
	 source: "qrc:///images/qml/qtweather-qml/images/loading-big.png"
 }

 Rectangle {
	 id: veil
	 color: "#ffffff"
	 width: parent.width
	 height: parent.height
	  radius: 5
	  anchors.rightMargin: 350
	  anchors.leftMargin: 350
	  anchors.bottomMargin: 75
	  anchors.topMargin: 75
	  anchors.fill: parent
	  opacity: 0
  z: 1
 }

 MouseArea {
	 id: mouseArea
	 anchors.rightMargin: 350
	 anchors.leftMargin: 350
	 anchors.bottomMargin: 75
	 anchors.topMargin: 75
	 anchors.fill: parent
	 z: 2
	 enabled: switchable
	 onClicked: {
		 if(graphFrame.state == "graph"){
			 graphFrame.state = ""
		 }

		 else{
			 graphFrame.state = "graph"
		 }
	 }
 }
 states: [
	 State {
		 name: "graph"

		 PropertyChanges {
			 target: icon
			 z: 0
		 }

		 PropertyChanges {
			 target: rectangle1
			 z: 1
		 }

   PropertyChanges {
	   target: veil
	   x: 0
	   y: 0
	   width: 800
	   height: 250
   }

   PropertyChanges {
	   target: mouseArea
	   anchors.rightMargin: 0
	   anchors.leftMargin: 0
	   anchors.bottomMargin: 0
	   anchors.topMargin: 0
   }

   PropertyChanges {
	   target: graph
	   z: 1
   }
	 }
 ]

 transitions: [
	 Transition {
		 to: "graph"
		 SequentialAnimation{
			 PropertyAnimation{ target: veil; property: "opacity"; from: 0; to: 1; duration: 500}
			 ParallelAnimation{
				 PropertyAnimation{ target: veil; property: "anchors.rightMargin"; to: 0; duration: 500}
				 PropertyAnimation{ target: veil; property: "anchors.leftMargin"; to: 0; duration: 500}
				 PropertyAnimation{ target: veil; property: "anchors.topMargin"; to: 0; duration: 500}
				 PropertyAnimation{ target: veil; property: "anchors.bottomMargin"; to: 0; duration: 500}
			 }
			 PropertyAnimation{ target: graph; property: "opacity"; from: 0; to: 1}
			 PropertyAnimation{ target: veil; property: "opacity"; from: 1; to: 0; duration: 500}
		 }

	 },
	 Transition {
		 to: ""
		 SequentialAnimation{
			 PropertyAnimation{ target: veil; property: "opacity"; from: 0; to: 1; duration: 500}

			 PropertyAnimation{ target: graph; property: "opacity"; from: 1; to: 0}
			 ParallelAnimation{
				 PropertyAnimation{ target: veil; property: "anchors.rightMargin"; to: 350; duration: 500}
				 PropertyAnimation{ target: veil; property: "anchors.leftMargin"; to: 350; duration: 500}
				 PropertyAnimation{ target: veil; property: "anchors.topMargin"; to: 75; duration: 500}
				 PropertyAnimation{ target: veil; property: "anchors.bottomMargin"; to: 75; duration: 500}
			 }

			 PropertyAnimation{ target: veil; property: "opacity"; from: 1; to: 0; duration: 500}



		 }

	 }
 ]







}
