/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 */

#include "utils.h"

#include "eWallet.h"
#include "LoginDialog.h"
#include "Constants.h"

QLabelZ::QLabelZ(const QString &text, QWidget *parent=0, Qt::WindowFlags f=0) : QLabel (text, parent, f) {
	select = false;
}
QLabelZ::QLabelZ(QWidget *parent=0, Qt::WindowFlags f=0): QLabel (parent, f) {
	select = false;
}
QLabelZ::~QLabelZ() {
	select = false;
}
void QLabelZ::mouseReleaseEvent(QMouseEvent *ev) {
	//qDebug () << "mouseReleaseEvent " << select << " " << ev;
	if (select) {
		select = false;
		repaint ();
	}
	ev->accept();
   	emit clicked ();
}
void QLabelZ::mousePressEvent(QMouseEvent *ev) {
	//qDebug () << "mousePressEvent " << select << " " << ev;
	if (!select) {
		select = true;
		repaint ();
	}
	ev->accept();
}
void QLabelZ::paintEvent(QPaintEvent* event)
{
    QFrame::paintEvent(event);
    QPainter painter(this);
	QRect r = rect();
    if (select) {
		QBrush b(Qt::cyan, Qt::SolidPattern);
		painter.setBrush(b);
    }
    else {
		QBrush b(Qt::gray, Qt::SolidPattern);
		painter.setBrush(b);
    }

	painter.setPen(Qt::cyan);
	QPen pen = painter.pen();
	pen.setWidth(2);
	painter.setPen(pen);
	painter.setOpacity(0.2);
	painter.drawRoundedRect(r, 15, 15);

   	QLabel::paintEvent(event);
}

void LoginDialog::focus () {
	label->setFocus ();
}

LoginDialog::LoginDialog(bool firstTime, QWidget *paTarget): QWidget(paTarget)
{
	setContextMenuPolicy(Qt::NoContextMenu);

	qDebug () << "asking password " << firstTime;

	isFirstTime = firstTime;
	NTimes = 0;

	QHBoxLayout * layout = new QHBoxLayout(this);
	componentLayout = new QGridLayout ();
	//this->parent = paTarget;

	layout->setSpacing(0);
	layout->setMargin(20);

	componentLayout->setContentsMargins(0, 0, 0, 0);

	QSignalMapper * signalMapper = new QSignalMapper(this);

	label = new QLineEdit("", this);
	label->setContextMenuPolicy(Qt::NoContextMenu);
	label->setEchoMode(QLineEdit::Password); //EchoOnEdit);
	label->setInputMethodHints(Qt::ImhHiddenText | Qt::ImhNoAutoUppercase | Qt::ImhNoPredictiveText);
	//label->setFocus(Qt::TabFocusReason);
	label->setMaxLength(16); //  |
	//label->setAlignment(Qt::AlignCenter);

	componentLayout->setSpacing(5);

	for (int i = 0; i < 12; i++) {
		QString text ('0' + i + 1);

		componentLayout->setColumnMinimumWidth(i % 3, B_SIZE);
		componentLayout->setRowMinimumHeight(i / 3, B_SIZE);

		if (i == 9) {
			text = tr("Ok");
		}
		else {
			if (i == 10) {
				text = "0";
			}
			else
				if (i == 11) {
					text = tr("Clear");
				}
		}

//		imageButton[i] = new QPushButton(QIcon(":/resources/number.png"), text, this); //
//		imageButton[i]->setIconSize(QSize(B_SIZE, B_SIZE));

		imageButton[i] = new QLabelZ (text, this);
		//imageButton[i]->setFrameShadow(QFrame::Raised);
		//imageButton[i]->setFrameShape(QFrame::StyledPanel);
		imageButton[i]->setAlignment(Qt::AlignCenter);

		imageButton[i]->setContextMenuPolicy(Qt::NoContextMenu);
		imageButton[i]->setFocusPolicy(Qt::NoFocus);
		imageButton[i]->setFont(QFont ("Arial", 22, 2, false));
		componentLayout->addWidget(imageButton[i], i / 3, i % 3, 1, 1);
		if (i == 9) {
			QObject::connect(imageButton[i], SIGNAL(clicked()), this, SLOT(acceptS()));
		}
		else {
			if (i == 10) {
				signalMapper->setMapping(imageButton[i], text);
				QObject::connect(imageButton[i], SIGNAL(clicked()), signalMapper, SLOT(map()));
			}
			else
				if (i == 11) {
					QObject::connect(imageButton[i], SIGNAL(clicked()), this, SLOT(clearS()));
				} else {
					signalMapper->setMapping(imageButton[i], text);
					QObject::connect(imageButton[i], SIGNAL(clicked()), signalMapper, SLOT(map()));
				}
		}
	}

	//componentLayout->addItem(new QSpacerItem(2,3), 4, 3, 3, 2);

	connect(signalMapper, SIGNAL(mapped(const QString &)),
	        this, SLOT(select(const QString &)));

	componentLayout->addWidget(label, 4, 0, 1, 3);

	dlgBtnBox = new QDialogButtonBox(this);
	dlgBtnBox->setOrientation(Qt::Vertical);

	QPushButton * aboutButton = new QPushButton(tr("About"), this);
	aboutButton->setFixedHeight(70);
	aboutButton->setContextMenuPolicy(Qt::NoContextMenu);
	aboutButton->setFocusPolicy(Qt::NoFocus);
	aboutButton->setIconSize(QSize(48, 48));
	QObject::connect(aboutButton, SIGNAL(clicked()), this, SLOT(about()));
	dlgBtnBox->addButton(aboutButton, QDialogButtonBox::ActionRole);
#ifdef OPEN_SOURCE_VERSION
	QPushButton * donateButton = new QPushButton(tr("Donate"), this);
	donateButton->setFixedHeight(70);
	donateButton->setContextMenuPolicy(Qt::NoContextMenu);
	donateButton->setFocusPolicy(Qt::NoFocus);
	donateButton->setIconSize(QSize(48, 48));
	QObject::connect(donateButton, SIGNAL(clicked()), this, SLOT(donate()));
	dlgBtnBox->addButton(donateButton, QDialogButtonBox::ActionRole);
#endif
	QPushButton * exitButton = new QPushButton(tr("Exit"), this);
	exitButton->setFixedHeight(70);
	exitButton->setContextMenuPolicy(Qt::NoContextMenu);
	exitButton->setFocusPolicy(Qt::NoFocus);
	exitButton->setIconSize(QSize(48, 48));
	QObject::connect(exitButton, SIGNAL(clicked()), QApplication::instance(), SLOT(quit()));
	dlgBtnBox->addButton(exitButton, QDialogButtonBox::ActionRole);

	layout->addLayout(componentLayout);
	layout->setAlignment(componentLayout, Qt::AlignVCenter | Qt::AlignHCenter);

	layout->addWidget(dlgBtnBox);
	layout->setAlignment(dlgBtnBox, Qt::AlignBottom);

	setLayout(layout);

#ifdef Q_WS_MAEMO_5
	orientationChanged (0);
#endif
}


void LoginDialog::orientationChanged(int o) {
#ifdef Q_WS_MAEMO_5
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
	if (screenGeometry.width() > screenGeometry.height()) {

		componentLayout->setColumnMinimumWidth(3, B_SIZE);
		componentLayout->setRowMinimumHeight(3, 0);

		componentLayout->addWidget(imageButton[9], 0, 3, 1, 1);
		componentLayout->addWidget(imageButton[10], 1, 3, 1, 1);
		componentLayout->addWidget(imageButton[11], 2, 3, 1, 1);

//		for (int i = 0; i < 12; i++) {
//			imageButton[i] ->setFont(QFont ("Arial", 22, 2, false));
//			//imageButton[i] ->setMinimumSize(70, 70);
//		}
		dlgBtnBox->show ();
	}
	else {
		componentLayout->setColumnMinimumWidth(3, 0);
		componentLayout->setRowMinimumHeight(3, B_SIZE);

		componentLayout->addWidget(imageButton[9], 3, 0, 1, 1);
		componentLayout->addWidget(imageButton[10], 3, 1, 1, 1);
		componentLayout->addWidget(imageButton[11], 3, 2, 1, 1);

//		for (int i = 0; i < 12; i++) {
//			imageButton[i] ->setFont(QFont ("Arial", 24, 2, false));
//			//imageButton[i] ->setMinimumSize(90, 90);
//		}
		dlgBtnBox->hide ();
	}
#endif
}

LoginDialog::~LoginDialog()
{
}
void LoginDialog::about()
{
	this->setStyleSheet("QMessageBox QLabel :link { color: #FF0000; }");
#ifdef OPEN_SOURCE_VERSION
	QMessageBox::about(this, tr("About Wallet"), tr("<qt><br><br><p><i><b>qtWallet</b></i>, v.1.0</p>"\
			"<p>Developed by <b>nowheremanmail@gmail.com</b></p>"\
			"<p>Icons by http://pixelmixer.ru/</p>"\
			"<p>if you think that qtWallet is useful for you, please</p>"\
			"<a href=\"https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=nowheremanmail@gmail.com&lc=US&item_name=qtWallet&currency_code=EUR&bn=PP%2dDonationsBF%3abtn_donate_SM%2egif%3aNonHosted\">DONATE</a></qt>").arg(VERSION));
#else
	QMessageBox::about(this, tr("About Wallet"), tr("<qt><br><br><p><i><b>Wallet</b></i>, v.%1</p>"\
			"<p>Developed by <b>nowheremanmail@gmail.com</b></p>"\
			"<p>Icons by http://pixelmixer.ru/</p>"\
			"</qt>").arg(VERSION));
#endif
}
void LoginDialog::donate() {
	QDesktopServices::openUrl( QUrl::fromEncoded("https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=nowheremanmail@gmail.com&lc=US&item_name=qtWallet&currency_code=EUR&bn=PP%2dDonationsBF%3abtn_donate_SM%2egif%3aNonHosted" ) );
}

void LoginDialog::clearS()
{
	label->selectAll();
	label->del();
}

void LoginDialog::acceptS() {
	QString current = label->text();

	if (current.length() == 0) {
#ifdef Q_WS_MAEMO_5
		show_banner (this, tr("Password is required"));
#endif
#ifndef Q_WS_MAEMO_5
		if (messageBox.isNull()) {
			messageBox = new QMessageBox(this);
			messageBox->information(this, "Wallet", tr("Password is required"), QMessageBox::Ok);
		}
		delete messageBox;
		messageBox = 0;
#endif
		return;
	}

	if (isFirstTime) {
		if (NTimes == 0) {
			newPassword = current;
			NTimes = 1;

			clearS ();

#ifdef Q_WS_MAEMO_5
			show_banner (this, tr("For verification, please, enter your password again"));
#endif
#ifndef Q_WS_MAEMO_5
			if (messageBox.isNull()) {
				messageBox = new QMessageBox(this);
				messageBox->information(this, "Wallet", tr("For verification, please, enter your password again"), QMessageBox::Ok);
			}
			delete messageBox;
			messageBox = 0;
#endif
			return;
		}
		if (NTimes == 1) {
			if (newPassword != current) {
				NTimes = 0;
				clearS ();
#ifdef Q_WS_MAEMO_5
				show_banner (this, tr("Invalid password, please enter again"));
#endif
#ifndef Q_WS_MAEMO_5
				if (messageBox.isNull()) {
					messageBox = new QMessageBox(this);
					messageBox->information(this, "Wallet", tr("Invalid password, please enter again"), QMessageBox::Ok);
				}
				delete messageBox;
				messageBox = 0;
#endif
				return;
			}
		}
	}

	qDebug () << "Try to validate password";

	emit finalWithPassword (current);

//	if (parent->finalPassword (current)) {
//
//	}
//	else {
//		clearS ();
//	}
}

void LoginDialog::select(const QString& a) {
	if (label->text().size() < KEY_SIZE) {
		QString current = label->text() + a;
		label->setText (current); //QString ("************************").right(current.size()));
	}
}

void LoginDialog::keyPressEvent(QKeyEvent* event) {
	if (event->key() == Qt::Key_Return || event->key() == Qt::Key_Enter) {
		event->accept();
		acceptS();
	}
}

void LoginDialog::resetF () {
	isFirstTime = true;
	NTimes = 0;
}
