/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 *
 *
 */

//#include <stdlib.h>

#include "utils.h"


#include "eWallet.h"
#include "Constants.h"
#include "DetailedWindow.h"
#include <Qt>
#include "QLabelW.h"
#include "QLabelImage.h"


#ifdef Q_WS_MAEMO_5
#include <QDBusInterface>
#include <QDBusConnection>
#endif
#include <QDesktopServices>



DetailWindow::DetailWindow(Target * _target, const QString & groupName, int istemplate, bool edit, eWallet *paTarget, QWidget *parent) :
		QMainWindow(parent)
{
	setWindowTitle("Wallet");

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5StackedWindow);

	if (!edit)
		connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged(int)));

	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#else
	this->setMinimumSize(WINDOW_WIDTH, WINDOW_HEIGHT);
#endif

	forceClose = false;

	isNew = istemplate > 0 || _target == NULL;
	typeChanged = false;
	fieldsChanged = false;

	this->target = _target;
	this->parent = paTarget;
	this->edit = edit;

	qDebug () << "DETAIL " << target << " " << groupName << " " << istemplate << " " << edit;

	if (istemplate > 0) {
		this->target = new Target ();
		if (istemplate > 1) {
			this->target->name = tr("Copy of ");
			this->target->name.append (_target->name);
		}
		this->target->type = _target->type;
		this->target->groupName = _target->groupName;

		for (int i = 0; i < _target->fields.size(); i++) {
			TargetField * tmp = _target->fields.at(i);

			TargetField * f=  new TargetField (tmp->name, tmp->type, tmp->encrypted, tmp->order);
			this->target->fields.append(f);
			if (istemplate > 1) {
				f->value = tmp->value;
			}
		}

		_target->freeFieldList();
	}
	else
	if (isNew) {
		this->target = new Target ();
		this->target->groupName = groupName;
		this->target->type = this->parent->types->at(0)->name;
		changeFields (0);
	}

	//qDebug () << " going to " << edit << " " << (isNew ? "NEW" : this->target->name);

	orgType = this->target->type;

	deleteFace = false;
	deleteBack = false;

	currentImageN = NULL;
	currentImageBackN = NULL;

	if (_target && istemplate == 0) {
		currentImage = this->target->getPicture();
		currentImageBack = this->target->getPictureBack();
	}
	else {
		currentImage = NULL;
		currentImageBack = NULL;
	}


	if (edit) {
#ifdef Q_WS_MAEMO_5
		menuBar()->addAction(tr("Save"), this, SLOT(saveTarget()));
		if (!isNew)
			menuBar()->addAction(tr("Delete"), this, SLOT(_deleteTarget()));
		menuBar()->addAction(tr("Change Face Pict."), this, SLOT(cardFace()));
		//menuBar()->addAction(tr("Mirror Face Pict."), this, SLOT(mirrorFace()));
		menuBar()->addAction(tr("Rotate Face Pict."), this, SLOT(rotateFace()));
		menuBar()->addAction(tr("Change Back Pict."), this, SLOT(cardBack()));
		//menuBar()->addAction(tr("Mirror Back Pict."), this, SLOT(mirrorBack()));
		menuBar()->addAction(tr("Rotate Back Pict."), this, SLOT(rotateBack()));
		menuBar()->addAction(tr("Delete Face Pict."), this, SLOT(deleteCardFace()));
		menuBar()->addAction(tr("Delete Back Pict."), this, SLOT(deleteCardBack()));
		menuBar()->addAction(tr("Modify fields"), this, SLOT(modifyFields()));
#else
		QMenu * m = menuBar()->addMenu(tr("Card"));
		m->addAction(tr("Save"), this, SLOT(saveTarget()));
		if (!isNew)
			m->addAction(tr("Delete"), this, SLOT(_deleteTarget()));
		m = menuBar()->addMenu(tr("Pictures"));
		m->addAction(tr("Change Face Pict."), this, SLOT(cardFace()));
		//m->addAction(tr("Mirror Face Pict."), this, SLOT(mirrorFace()));
		m->addAction(tr("Rotate Face Pict."), this, SLOT(rotateFace()));
		m->addAction(tr("Delete Face Pict."), this, SLOT(deleteCardFace()));
		m->addSeparator ();
		m->addAction(tr("Change Back Pict."), this, SLOT(cardBack()));
		//m->addAction(tr("Mirror Back Pict."), this, SLOT(mirrorBack()));
		m->addAction(tr("Rotate Back Pict."), this, SLOT(rotateBack()));
		m->addAction(tr("Delete Back Pict."), this, SLOT(deleteCardBack()));
		m = menuBar()->addMenu(tr("Others"));
		m->addAction(tr("Modify fields"), this, SLOT(modifyFields()));
#endif

#ifdef CAMERA
		menuBar()->addAction(tr("Camera"), this, SLOT(takePicture()));
#endif
	}
	else {
#ifdef Q_WS_MAEMO_5
		menuBar()->addAction(tr("New Card"), this, SLOT(_newTarget()));
		menuBar()->addAction(tr("Edit Card"), this, SLOT(_editTarget()));
		menuBar()->addAction(tr("New Card like this"), this, SLOT(_newLikeTarget()));
		menuBar()->addAction(tr("Duplicate Card"), this, SLOT(_duplicateTarget()));
		menuBar()->addAction(tr("Export Face Pict."), this, SLOT(exportCardFace()));
		menuBar()->addAction(tr("Export Back Pict."), this, SLOT(exportCardBack()));
#else
		QMenu * m = menuBar()->addMenu(tr("Card"));
		m->addAction(tr("New Card"), this, SLOT(_newTarget()));
		m->addAction(tr("Edit Card"), this, SLOT(_editTarget()));
		m->addAction(tr("New Card like this"), this, SLOT(_newLikeTarget()));
		m->addAction(tr("Duplicate Card"), this, SLOT(_duplicateTarget()));

		m = menuBar()->addMenu(tr("Pictures"));
		m->addAction(tr("Export Face Pict."), this, SLOT(exportCardFace()));
		m->addAction(tr("Export Back Pict."), this, SLOT(exportCardBack()));
#endif
	}
	
	centralWidget = new QWidget(this);

	//setContextMenuPolicy(Qt::DefaultContextMenu);
	setContextMenuPolicy(Qt::CustomContextMenu);
	//centralWidget->setContextMenuPolicy(Qt::CustomContextMenu);

	vboxlayout = new QVBoxLayout ();
	vboxlayout->setSpacing(0);
	vboxlayout->setMargin(0);

	entryScrollArea = new QScrollArea;
	//entryScrollArea->setProperty("FingerScrollable", false);
	//entryScrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
	entryScrollArea->setWidgetResizable(true);
	entryScrollArea->setWidget(centralWidget);
	entryScrollArea->setProperty("FingerScrollable", true);

//	if (edit) {
//		QAbstractKineticScroller *scroller = entryScrollArea->property("kineticScroller").value<QAbstractKineticScroller *>();
//		if (scroller) {
//			qDebug () << " FOUND !";
//			//scroller->setEnabled(false);
//			//scroller->setMode (QAbstractKineticScroller::OvershootAlwaysOff);
//		}
//	}

	centralWidget->setLayout(vboxlayout);
	setCentralWidget(entryScrollArea);

	// Create layout for the ui controls
	componentLayout = new QGridLayout ();
	// Name label
	if (edit) {
		QLabel * nameLabel = new QLabel(tr("Name"), this);
		componentLayout->addWidget(nameLabel, 1, 1, 1, 2);

	    nameLineEdit = new QLineEdit(this);
		componentLayout->addWidget(nameLineEdit, 1, 3, 1, 4);
		nameLineEdit->setInputMethodHints(Qt::ImhNoAutoUppercase | Qt::ImhNoPredictiveText);

		//TEST this->target->name.append(QString::fromUtf8("áàéèäñç"));

		nameLineEdit->setText (this->target->name);

		nameLineEdit->setFocusPolicy(Qt::StrongFocus);

		nameLabel = new QLabel(tr("Group Name"), this);
		componentLayout->addWidget(nameLabel, 2, 1, 1, 2);

	    groupLineEdit = new QLineEdit(this);
	    groupLineEdit->setInputMethodHints(Qt::ImhNoAutoUppercase | Qt::ImhNoPredictiveText);
		componentLayout->addWidget(groupLineEdit, 2, 3, 1, 4);

		//TEST this->target->groupName.append(QString::fromUtf8("áàéèäñç"));

		groupLineEdit->setText (this->target->groupName);

		groupLineEdit->setFocusPolicy(Qt::StrongFocus);

	}
	else {
		QString title ("Wallet - ");
		title.append (_target->name);
		this->setWindowTitle (title);
	}

	if (edit) {

		static const char *types_string[] = {
		    QT_TR_NOOP("Membership Info"),
		    QT_TR_NOOP("Password"),
		    QT_TR_NOOP("Credit Card"),
		    QT_TR_NOOP("Bank Account"),
		    QT_TR_NOOP("Health Numbers"),
		    QT_TR_NOOP("Passport Info"),
		    QT_TR_NOOP("Note Card"),
		    QT_TR_NOOP("Car Info"),
		    QT_TR_NOOP("Cellular Phone"),
		    QT_TR_NOOP("Serial Number Software"),
		    QT_TR_NOOP("Serial Number Hardware"),
		    QT_TR_NOOP("Web site"),
		    QT_TR_NOOP("ID Card"),
		    QT_TR_NOOP("Social Security Number"),
		    QT_TR_NOOP("Email Account"),
		    QT_TR_NOOP("Driver's License"),
		    QT_TR_NOOP("Others")
		};

		// type label
		QLabel * typeLabel = new QLabel(tr("Type"), this);

		componentLayout->addWidget(typeLabel, 3, 1, 1, 2);

		typeLineEdit = new QComboBox(this);

		bool selected = false;
		for(int i = 0; i < this->parent->types->size(); i++) {
//			qDebug () << this->parent->types->at(i)->id << " " << this->parent->types->at(i)->name;
//			if ((this->parent->types->at(i)->id - 1) < GENERIC_TYPES_NUMBER) {
//				typeLineEdit->addItem (tr(types_string[this->parent->types->at(i)->id - 1]), this->parent->types->at(i)->name);
//			}
//			else {
				typeLineEdit->addItem (this->parent->types->at(i)->name, this->parent->types->at(i)->name);
//			}

			if (this->target->type == this->parent->types->at(i)->name) {
				typeLineEdit->setCurrentIndex(i);
				selected = true;
			}
		}
		if (!selected) {
			typeLineEdit->setCurrentIndex(this->parent->types->size() - 1);
		}

	    connect(typeLineEdit, SIGNAL(activated(int)), this, SLOT(emitCommitData(int)));

		componentLayout->addWidget(typeLineEdit, 3, 3, 1, 4);

		typeLineEdit->setFocusPolicy(Qt::StrongFocus);

	}
	else {
		elType = -1;
		for(int i = 0; i < this->parent->types->size(); i++) {
			if (this->target->type == this->parent->types->at(i)->name) {
				elType = i;
				break;
			}
		}
	}

	vboxlayout->addLayout(componentLayout);

	componentLayout = new QGridLayout ();

	if (edit || this->target->getPicture() != NULL) {
		imageLabel = new QLabelImage(this);
#ifndef OPEN_SOURCE_VERSION
	QObject::connect(imageLabel, SIGNAL(clicked(QImage *)), this, SLOT(seePicture(QImage *)));
#endif
		if (edit) {
			imageLabel->setMaximumSize(BIG_WIDTH, BIG_HEIGH);
			imageLabel->setMinimumSize(BIG_WIDTH, BIG_HEIGH);
		}
		else {
			imageLabel->setMaximumSize(MAX_WIDTH, MAX_HEIGH);
			imageLabel->setMinimumSize(MAX_WIDTH, MAX_HEIGH);
		}

		imageLabel->setPicture (currentImage);

		if (currentImage == NULL) {
			QPixmap available(":/resources/empty_card.png");
			imageLabel->setPixmap(available);
		}
//		else {
//			imageLabel->setPixmap(QPixmap::fromImage (*currentImage));
//		}
		
		//imageLabel->setContextMenuPolicy(Qt::CustomContextMenu);
		QObject::connect(imageLabel, SIGNAL(customContextMenuRequested(const QPoint&)), this, SLOT(cardFaceMenu(const QPoint&)));
//		if (!edit)
//			QObject::connect(imageLabel, SIGNAL(clicked ()), this, SLOT(seePicture()));

#ifdef Q_WS_MAEMO_5
		if (edit) {
			componentLayout->addWidget(imageLabel, 3, 0, 2, 3);
		}
		else
			vboxlayout->addWidget(imageLabel); //, 0, 0, 1, 1);
#else
		componentLayout->addWidget(imageLabel, 3, 0, 2, 3);
#endif
	}
	else {
		imageLabel = NULL;
	}

	if (edit || this->target->getPictureBack() != NULL) {
		imageBackLabel = new QLabelImage(this);
#ifndef OPEN_SOURCE_VERSION
	QObject::connect(imageBackLabel, SIGNAL(clicked (QImage *)), this, SLOT(seePicture(QImage *)));
#endif
		if (edit) {
			imageBackLabel->setMaximumSize(BIG_WIDTH, BIG_HEIGH);
			imageBackLabel->setMinimumSize(BIG_WIDTH, BIG_HEIGH);
		}
		else {
			//imageBackLabel->setMaximumSize(MAX_WIDTH, MAX_HEIGH);
			imageBackLabel->setMaximumSize(MAX_WIDTH, MAX_HEIGH);
			imageBackLabel->setMinimumSize(MAX_WIDTH, MAX_HEIGH);
		}
		imageBackLabel->setPicture (currentImageBack);

		if (currentImageBack == NULL) {
			QPixmap availableBack(":/resources/empty_card_back.png");
			imageBackLabel->setPixmap(availableBack);
		}
//		else {
//			imageBackLabel->setPixmap(QPixmap::fromImage (*currentImageBack));
//		}

		//imageBackLabel->setContextMenuPolicy(Qt::CustomContextMenu);
		QObject::connect(imageBackLabel, SIGNAL(customContextMenuRequested(const QPoint&)), this, SLOT(cardBackMenu(const QPoint&)));
//		if (!edit)
//			QObject::connect(imageBackLabel, SIGNAL(clicked ()), this, SLOT(seeBackPicture()));

#ifdef Q_WS_MAEMO_5
		if (edit) {
			componentLayout->addWidget(imageBackLabel, 3, 3, 2, 3);
		}
		else
			vboxlayout->addWidget(imageBackLabel); //, 1, 0, 1, 1);
#else
		componentLayout->addWidget(imageBackLabel, 3, 3, 2, 3);
#endif
	}
	else {
		imageBackLabel = NULL;
	}

#ifdef Q_WS_MAEMO_5
	if (edit) {
		POS = vboxlayout->count();
		vboxlayout->addLayout(componentLayout);
		componentLayout = new QGridLayout ();
	}
#else
	POS = vboxlayout->count();
	vboxlayout->addLayout(componentLayout);
	componentLayout = new QGridLayout ();
#endif

	showFields (true);

	vboxlayout->addLayout(componentLayout);

	if (edit) {
		QPushButton * saveButton = new QPushButton (tr("Save"), this);
		vboxlayout->addWidget(saveButton);
		QObject::connect(saveButton, SIGNAL(clicked()), this, SLOT(saveTarget()));
	}

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
	orientationChanged(0);
#endif

	if (edit) {
		centralWidget->setFocus ();
		focusNextChild();
		//nameLineEdit->setFocus ();
	}
}

void DetailWindow::modifyFields() {
	if (createFieldDlg.isNull()) {
		for (int i = 0; i < target->fields.count(); i++) {
			TargetField * field = target->fields[i];
			//qDebug () << "getting field " << i;

			field->name = labels[i]->text();
			if (field->type == TYPE_TEXT) {
				//qDebug () << "getting TEX field " << i;
				field->value = ((QTextEdit*)values[i])->toPlainText();
				fieldsChanged |= ((QTextEdit*)values[i])->document ()->isModified ();
			}
			else
			if (field->type == TYPE_IMAGE) {
				fieldsChanged |= ((QLabelW*)values[i])->isModified ();
				((QLabelW*)values[i])->readImage(field);
			}
			else {
				//qDebug () << "getting LIN field " << i;
				field->value = ((QLineEdit*)values[i])->text();
				fieldsChanged |= ((QLineEdit*)values[i])->isModified();
			}
		}

		createFieldDlg = new CreateFieldDialog(this->target, this, this);
		createFieldDlg->setMinimumSize(size().width(),size().height()-100);
		if (createFieldDlg->exec() == QDialog::Accepted) {
			// TODO sort fields!!!
			showFields (false);
		}

		delete createFieldDlg;
		createFieldDlg = 0;
	}

}

void DetailWindow::addField (TargetField * field) {
	target->fields.append(field);

	_addField (field);
	pos++;
}

void DetailWindow::_addField (TargetField * field) {
	////qDebug () << "trying to show " << field->name << " v=" << field->value << " t=" << field->type;

	QLineEdit * nameLabel = new QLineEdit(this);
	nameLabel->setText (field->name);
	nameLabel->setInputMethodHints(Qt::ImhNoAutoUppercase | Qt::ImhNoPredictiveText);

	componentLayout->addWidget(nameLabel, pos, 0, 1, 1);
	this->labels.append (nameLabel);

	nameLabel->setFocusPolicy(Qt::StrongFocus);

	//nameLabel->setContentsMargins(0, 10, 0, 0);
	//ButtonInfo * info = new ButtonInfo (field);
	//nameLabel->setUserData(0, info);

	if (field->type == TYPE_TEXT) {
		QTextEdit * nameLineEdit = new QTextEdit(this);
		nameLineEdit->setPlainText (field->value);
		//nameLineEdit->setInputMethodHints(Qt::ImhNoAutoUppercase | Qt::ImhNoPredictiveText);
		//nameLineEdit->setLineWrapColumnOrWidth(40);
		this->values.append (nameLineEdit);
		componentLayout->addWidget(nameLineEdit, pos, 1, 1, 1);
		componentLayout->setRowMinimumHeight(pos, 300);
		nameLineEdit->setFocusPolicy(Qt::StrongFocus);
		//nameLineEdit->setContentsMargins(0, 0, 20, 0);
	}
	else
	if (field->type == TYPE_PASSWORD) {
#ifdef OPEN_SOURCE_VERSION
		QLineEdit * nameLineEdit = new QLineEdit(this);
		nameLineEdit->setText (field->value);
		nameLineEdit->setInputMethodHints(Qt::ImhNoAutoUppercase | Qt::ImhNoPredictiveText);
		this->values.append (nameLineEdit);

		componentLayout->addWidget(nameLineEdit, pos, 1, 1, 1);
		nameLineEdit->setFocusPolicy(Qt::StrongFocus);
#else
		QLineEdit * nameLineEdit = new QLineEdit(this);
		nameLineEdit->setText (field->value);
		nameLineEdit->setInputMethodHints(Qt::ImhNoAutoUppercase | Qt::ImhNoPredictiveText);
		this->values.append (nameLineEdit);

		QWidget *window = new QWidget (this);
		window->setContentsMargins(0, 0, 0, 0);
		QHBoxLayout * ll = new QHBoxLayout (window);
		ll->setContentsMargins(0, 0, 0, 0);
		ll->addWidget(nameLineEdit);
		QPushButton * generate = new QPushButton(tr("Generate"), window);
		ll->addWidget(generate);
		generate->setUserData(0, new ButtonInfo2 (nameLineEdit)); //ObjectName(field->value);
		signalMapper->setMapping(generate, generate);
		QObject::connect(generate, SIGNAL(clicked()), signalMapper, SLOT(map()));
		window->setLayout(ll);
		this->others.append(window);

		componentLayout->addWidget(window, pos, 1, 1, 1);
		nameLineEdit->setFocusPolicy(Qt::StrongFocus);
#endif
	}
	else
	if (field->type == TYPE_INTEGER) {
		QLineEdit * nameLineEdit = new QLineEdit(this);
		nameLineEdit->setText (field->value);
		nameLineEdit->setInputMethodHints(Qt::ImhDigitsOnly);
		this->values.append (nameLineEdit);
		componentLayout->addWidget(nameLineEdit, pos, 1, 1, 1);
		nameLineEdit->setFocusPolicy(Qt::StrongFocus);
		//nameLineEdit->setContentsMargins(0, 0, 20, 0);
	}
	else
	if (field->type == TYPE_DATE) {
		QLineEdit * nameLineEdit = new QLineEdit(this);
		nameLineEdit->setText (field->value);
		nameLineEdit->setInputMethodHints(Qt::ImhNoAutoUppercase | Qt::ImhNoPredictiveText);
		this->values.append (nameLineEdit);
		componentLayout->addWidget(nameLineEdit, pos, 1, 1, 1);
		nameLineEdit->setFocusPolicy(Qt::StrongFocus);
		//nameLineEdit->setContentsMargins(0, 0, 20, 0);
	}
	else
	if (field->type == TYPE_PHONE_NUMBER) {
		QLineEdit * nameLineEdit = new QLineEdit(this);
		nameLineEdit->setText (field->value);
		if (settings.value("hints/phoneNumber/supportCharacters").toBool()) {
			//qDebug () << "phone support characters";
			nameLineEdit->setInputMethodHints(Qt::ImhNoAutoUppercase | Qt::ImhNoPredictiveText);
		}
		else {
			//qDebug () << "phone only supports numbers";
			nameLineEdit->setInputMethodHints(Qt::ImhDigitsOnly);
		}
		componentLayout->addWidget(nameLineEdit, pos, 1, 1, 1);
		this->values.append (nameLineEdit);
		nameLineEdit->setFocusPolicy(Qt::StrongFocus);
		//nameLineEdit->setContentsMargins(0, 0, 20, 0);
	}
	else
	if (field->type == TYPE_URL) {
		QLineEdit * nameLineEdit = new QLineEdit(this);
		componentLayout->addWidget(nameLineEdit, pos, 1, 1, 1);
		nameLineEdit->setText (field->value);
		//nameLineEdit->setInputMethodHints(Qt::ImhUrlCharactersOnly);
		nameLineEdit->setInputMethodHints(Qt::ImhNoAutoUppercase | Qt::ImhNoPredictiveText);
		this->values.append (nameLineEdit);
		nameLineEdit->setFocusPolicy(Qt::StrongFocus);
		//nameLineEdit->setContentsMargins(0, 0, 20, 0);
	}
	else
	if (field->type == TYPE_IMAGE) {
		//QObject::connect(imageLabel, SIGNAL(clicked ()), this, SLOT(seePicture()));
		QLabelW * imageLabel = new QLabelW("", false, true, true, this);
		imageLabel->setUserData(0, new ButtonInfo (field));
		componentLayout->addWidget(imageLabel, pos, 1, 1, 1);
		imageLabel->setPicture(field);

		this->values.append (imageLabel);
	}
	else {
		QLineEdit * nameLineEdit = new QLineEdit(this);
		componentLayout->addWidget(nameLineEdit, pos, 1, 1, 1);
		//nameLineEdit->setCompleter(NULL);
		nameLineEdit->setInputMethodHints(Qt::ImhNoAutoUppercase | Qt::ImhNoPredictiveText);
		nameLineEdit->setText (field->value);
		this->values.append (nameLineEdit);
		nameLineEdit->setFocusPolicy(Qt::StrongFocus);
		//nameLineEdit->setContentsMargins(0, 0, 20, 0);

		//nameLineEdit->setUserData(0,info);
	}

	////qDebug () << "SHOWN " << field->name << " v=" << field->value << " t=" << field->type;
}

void DetailWindow::showFields (bool firstTime) {

	if (edit) {
		if (!firstTime) {
//			QObjectList list = componentLayout->children();
//			for (int u = 0, N = list.size(); u < N; u++) {
//				componentLayout->removeWidget(list.)
//			}

			for (int i = 0; i < this->labels.size(); i++) {
				componentLayout->removeWidget(this->labels[i]);
				delete this->labels[i];
			}

			for (int i = 0; i < this->values.size(); i++) {
				componentLayout->removeWidget(this->values[i]);
				delete this->values[i];
			}

			for (int i = 0; i < this->others.size(); i++) {
				componentLayout->removeWidget(this->others[i]);
				delete this->others[i];
			}

//#ifdef Q_WS_MAEMO_5
        vboxlayout->removeItem(componentLayout);
        delete componentLayout;
        componentLayout = new QGridLayout ();
        vboxlayout->insertLayout(POS + 1, componentLayout);
//#else
//        int ii = vboxlayout->indexOf(componentLayout);
//        vboxlayout->removeItem(componentLayout);
//        delete componentLayout;
//        componentLayout = new QGridLayout ();
//        vboxlayout->insertLayout(ii, componentLayout);
//#endif
		}

//
//		componentLayout->update();

		this->values.clear();
		this->labels.clear();
		this->others.clear();
	}

	signalMapper = new QSignalMapper(this);
	if (edit)
		QObject::connect(signalMapper, SIGNAL(mapped(QWidget *)), this, SLOT(passGen(QWidget *)));
	else
		QObject::connect(signalMapper, SIGNAL(mapped(QWidget *)), this, SLOT(clickPass(QWidget *)));

	componentLayout->setColumnStretch(0, 10);
	componentLayout->setColumnStretch(1, 25);

	pos = 0;
	if (target) {
		TargetField * field;
		foreach(field, target->fields) {
			if (edit) {
				_addField (field);
			}
			else {
				if (field->value.length() > 0) {
					QLabel * nameLabel;

					if (QLocale::system().name() != "en") {
						if (elType >= 0) {
							int i = 0;

							Target * tt = parent->types->at (elType);
							for (; i < tt->fields.size(); i++) {
								TargetField * tmp = tt->fields.at(i);
								if (tmp->originalName == field->name) {
									nameLabel = new QLabelW(tmp->name, true, false, false, this);
									i = -1;
									break;
								}
							}
							if (i != -1) {
								nameLabel = new QLabelW(field->name, true, false, false, this);
							}
						}
						else {
							nameLabel = new QLabelW(field->name, true, false, false, this);
						}
					}
					else {
						nameLabel = new QLabelW(field->name, true, false, false, this);
					}

					nameLabel->setFont (QFont("arial", 11, 1, true));
					nameLabel->setAlignment(Qt::AlignRight | Qt::AlignVCenter);
					nameLabel->setContentsMargins(0, 0, 10, 0);

					nameLabel->setUserData(0, new ButtonInfo (field));

					componentLayout->addWidget(nameLabel, pos, 0, 1, 1);

					if (field->type == TYPE_PASSWORD) {// || field->name.contains("password", Qt::CaseInsensitive)) {
						QPushButton * nameLineEdit = new QPushButton(tr("Click to see"), this);
						//nameLineEdit->setContextMenuPolicy(Qt::NoContextMenu);
						componentLayout->addWidget(nameLineEdit, pos, 1, 1, 1);

						nameLineEdit->setUserData(0, new ButtonInfo (field)); //ObjectName(field->value);
						signalMapper->setMapping(nameLineEdit, nameLineEdit);

						QObject::connect(nameLineEdit, SIGNAL(clicked()), signalMapper, SLOT(map()));
					}
					else {
						if (field->type == TYPE_TEXT) {
							QLabel * nameLineEdit = new QLabelW(field->value, false, false, false, this);
							nameLineEdit->setUserData(0, new ButtonInfo (field));
							nameLineEdit->setWordWrap(true);
							componentLayout->addWidget(nameLineEdit, pos, 1, 1, 1);
						}
						else
						if (field->type == TYPE_IMAGE) {
							QLabelImage * imageLabel = new QLabelImage(this); //"", false, true, edit, this);
#ifndef OPEN_SOURCE_VERSION
	QObject::connect(imageLabel, SIGNAL(clicked (QImage *)), this, SLOT(seePicture(QImage *)));
#endif
							imageLabel->setUserData(0, new ButtonInfo (field));

							componentLayout->addWidget(imageLabel, pos, 1, 1, 1);
							imageLabel->setPicture(field);
						}
						else {
							QLabel * nameLineEdit = new QLabelW(field->value, false, false, false, this);
							nameLineEdit->setUserData(0, new ButtonInfo (field));
							nameLineEdit->setWordWrap(true);
							componentLayout->addWidget(nameLineEdit, pos, 1, 1, 1);
						}
					}
				}
			}
			pos++;
		}

	}

	////qDebug () << " shown " << pos << " rows";
	if (pos < 20) {
		componentLayout->addItem(new QSpacerItem(1,20 - pos), pos, 0, 20-pos, 2);
		////qDebug () << " add " << (20 - pos) << " rows";
	}
}

void DetailWindow::seePicture(QImage * image) {
	if (viewerWindow.isNull() && image != NULL) {
		viewerWindow = new ImageViewer(new QImage (*image), this);
		viewerWindow->setAttribute(Qt::WA_DeleteOnClose);
        connect(viewerWindow, SIGNAL(destroyed(QObject*)), this, SLOT(windowViewerDestroyed(QObject*)));
        viewerWindow->show();
	}
}

void DetailWindow::windowViewerDestroyed (QObject*) {
    disconnect(viewerWindow, SIGNAL(destroyed(QObject*)), this, SLOT(windowViewerDestroyed(QObject*)));

	delete viewerWindow;
	viewerWindow = 0;
}

void DetailWindow::passGen (QWidget * _wid) {
	QPushButton * b = (QPushButton *)_wid;

	if (createPasswordDlg.isNull()) {
		createPasswordDlg = new CreatePasswordDialog(this);
		createPasswordDlg->setMinimumSize(size().width(),size().height()-100);
		if (createPasswordDlg->exec() == QDialog::Accepted) {
			((ButtonInfo2 *)b->userData(0))->nameLineEdit->setText(createPasswordDlg->getResult());
			((ButtonInfo2 *)b->userData(0))->nameLineEdit->setModified(true);
		}

		delete createPasswordDlg;
		createPasswordDlg = 0;
	}
}

void DetailWindow::clickPass (QWidget * _wid) {
	QPushButton * b = (QPushButton *)_wid;

	////qDebug () << "click on field " << b->userData(0);

	TargetField * f = ((ButtonInfo *)b->userData(0))->field;

	if (b->text() == f->value) {
		b->setText(tr("Click to see"));
	}
	else {
		b->setText(f->value);
	}
}

void DetailWindow::changeFields (int a) {
	typeChanged = true;

	//qDebug () << "selected type " << a;

	for (int i = target->fields.size(); i > 0; i--) {
		TargetField * field = target->fields [i - 1];

		if (field->value.length() == 0) {
			//qDebug () << "remove" << field->name;
			target->fields.removeAt(i - 1);
			delete field;
		}
		else {
			//qDebug () << "keep" << field->name;
		}
	}

	Target * tt = parent->types->at (a);
	for (int i = 0; i < tt->fields.size(); i++) {
		TargetField * tmp = tt->fields.at(i);

		if (!target->existField (tmp->name) && !target->existField (tmp->originalName)) {
			TargetField * f;

			f = new TargetField (tmp->name, tmp->type, tmp->encrypted, tmp->order);

			target->fields.append(f);
		}
	}
}

void DetailWindow::emitCommitData (int a) {
	changeFields (a);
	showFields(false);
}

DetailWindow::~DetailWindow () {
	//target->freeResources();
	//if (currentImageBackN) delete currentImageBackN;
	//if (currentImageN) delete currentImageN;
}

void DetailWindow::saveTarget () {
	if (nameLineEdit->text().length() < 1) {
#ifdef Q_WS_MAEMO_5
		show_information_note (this, tr("Card description is missing"));
#endif
#ifndef Q_WS_MAEMO_5
		if (messageBox.isNull()) {
			messageBox = new QMessageBox(this);
			messageBox->information(this, "Wallet", tr("Card description is missing"), QMessageBox::Ok);
		}
		delete messageBox;
		messageBox = 0;
#endif
		return;
	}

	 if (typeLineEdit->currentIndex() < 0) {
#ifdef Q_WS_MAEMO_5
		 show_information_note (this, tr("Type card is missing"));
#endif
#ifndef Q_WS_MAEMO_5
		if (messageBox.isNull()) {
			messageBox = new QMessageBox(this);
			messageBox->information(this, "Wallet", tr("Type card is missing"), QMessageBox::Ok);
		}
		delete messageBox;
		messageBox = 0;
#endif
		return;
	}
	
#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif

	if (target == NULL) {
		this->target = new Target ();
	}


	this->target->name = nameLineEdit->text();
	this->target->groupName = groupLineEdit->text();
	this->target->type = typeLineEdit->itemData(typeLineEdit->currentIndex()).toString();
	
	////qDebug () << "getting fields ";

	for (int i = 0; i < target->fields.count(); i++) {
		TargetField * field = target->fields[i];
		qDebug () << "getting field " << i;
		
		field->name = labels[i]->text();
		if (field->type == TYPE_TEXT) {
			//qDebug () << "getting TEX field " << i;
			field->value = ((QTextEdit*)values[i])->toPlainText();
		}
		else
		if (field->type == TYPE_IMAGE) {
			((QLabelW*)values[i])->readImage(field);
		}
		else {
			//qDebug () << "getting LIN field " << i;
			field->value = ((QLineEdit*)values[i])->text();
		}
	}
	//qDebug () << "updating target";
	if (isNew) {
		parent->_insertTarget(this->target);
	}
	else {
		parent->_updateTarget(this->target);
	}
	//qDebug () << "updating target face";

	if (deleteFace) {
		//qDebug () << "DELETE FACE";
		target->setPicture (NULL);
		parent->_updateTargetPicture(target);
	}
	else
	if (currentImageN) {
		target->setPicture (currentImageN);
		currentImageN = NULL;
		parent->_updateTargetPicture(target);
	}
	else {
		if (orgType != target->type && target->getPicture() == NULL) {
			parent->_updateTargetPicture(target);
		}
	}

	//qDebug () << "updating target back";

	if (deleteBack) {
		//qDebug () << "DELETE BACK";
		target->setPictureBack (NULL);
		parent->_updateTargetPictureBack(target);
	}
	else
	if (currentImageBackN) {
		target->setPictureBack (currentImageBackN);
		currentImageBackN = NULL;
		parent->_updateTargetPictureBack(target);
	}

	//qDebug () << "end updating ";

	target->freeResources();
	if (currentImageBackN) delete currentImageBackN;
	if (currentImageN) delete currentImageN;

	//qDebug () << "clse ";

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif

	forceClose = true;

	//show_banner(this, tr("Card saved"));

	close();
}

void DetailWindow::forceclose () {
	forceClose = true;
	close();
}

void DetailWindow::_deleteTarget () {
#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif

	if (target) {
		parent->deleteTarget(target);
	}

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif

	forceClose = true;
	close();
}

void DetailWindow::_editTarget () {
	emit editTarget(target);

	forceClose = true;
	close ();
}

void DetailWindow::_newLikeTarget () {
	emit newLikeTarget(target);

	forceClose = true;
	close ();
}
void DetailWindow::_duplicateTarget () {
	emit duplicateTarget(target);

	forceClose = true;
	close ();
}

void DetailWindow::_newTarget () {
	emit newTarget();

	forceClose = true;
	close ();
}



void DetailWindow::loadImage (QSettings & settings, QString q, QImage& res) {
	QImageReader reader;
	reader.setFileName(q);
	//Set/scale image size into screen
//	QSize imageSize = reader.size();
//
//	qDebug () << "IMAGE SIZE " << imageSize.width() << " " << imageSize.height();
//
//	if (imageSize.height() > settings.value("internalImage/HEIGH", _INTERNAL_HEIGH).toInt() || imageSize.width() > settings.value("internalImage/WIDTH", _INTERNAL_WIDTH).toInt()) {
//		QSettings settings;
//		if (settings.value("internalImage/scale", true).toBool()) {
//			//qDebug () << "scaling image " << ::INTERNAL_WIDTH << " " << ::INTERNAL_HEIGH;
//			QSize ss (settings.value("internalImage/WIDTH", _INTERNAL_WIDTH).toInt(), settings.value("internalImage/HEIGH", _INTERNAL_HEIGH).toInt());
//			switch (settings.value("internalImage/aspect", 1).toInt()) {
//			case 1:
//				qDebug () << "scaling with keep aspect image";
//				imageSize.scale(ss, Qt::KeepAspectRatio);
//				break;
//			case 2:
//				qDebug () << "scaling with expanding aspect image";
//				imageSize.scale(ss, Qt::KeepAspectRatioByExpanding);
//				break;
//			default:
//				imageSize.scale(ss, Qt::IgnoreAspectRatio);
//			}
//			qDebug () << "scaled image " << ss.width() << " " << ss.height();
//			reader.setScaledSize(ss);
//		}
//	}
//	else {
//	}
	// Read image
	res = reader.read();
	////qDebug () << "read " << q << " as (" << imageSize << ") with result " << reader.errorString ();
}

//void DetailWindow::labelMenu(const QPoint & _p) {
//	QMenu menu(this);
//	menu.addAction(tr("View"), this, SLOT(cardFace()));
//	menu.exec(_p);
//}

//void DetailWindow::cardMenu(const QPoint & _p) {
//	QPoint p = _p;//this->mapFromGlobal(_p);
//
//	QScrollBar* bar = entryScrollArea->verticalScrollBar();
//
//	if (bar)
//		p.setY(p.y() + bar->value());
//
//	QWidget * tmp = centralWidget->childAt(p);
//	qDebug () << tmp;
//
//	entryScrollArea->ensureVisible(p.x(), p.y());
//
//	if (this->imageLabel != NULL && this->imageLabel->geometry().contains(p)) {
//		QMenu menu(this);
//		if (edit) {
//			menu.addAction(tr("Edit"), this, SLOT(cardFace()));
//			//menu.addAction(tr("Mirror"), this, SLOT(mirrorFace()));
//			menu.addAction(tr("Rotate"), this, SLOT(rotateFace()));
//			menu.addAction(tr("Delete"), this, SLOT(deleteCardFace()));
//		}
//		else {
//			menu.addAction(tr("Export Face"), this, SLOT(exportCardFace()));
//		}
//		menu.exec(_p);
//	}
//	else
//	if (this->imageBackLabel != NULL && this->imageBackLabel->geometry().contains(p)) {
//		QMenu menu(this);
//		if (edit) {
//			menu.addAction(tr("Edit"), this, SLOT(cardBack()));
//			//menu.addAction(tr("Mirror"), this, SLOT(mirrorBack()));
//			menu.addAction(tr("Rotate"), this, SLOT(rotateBack()));
//			menu.addAction(tr("Delete"), this, SLOT(deleteCardBack()));
//		}
//		else {
//			menu.addAction(tr("Export Back"), this, SLOT(exportCardBack()));
//		}
//		menu.exec(_p);
//	}
//	else {
//		if (tmp != NULL) {
//			if (tmp->userData(0) != NULL) {
//				TargetField * f = ((ButtonInfo *)tmp->userData(0))->field;
//
//				if (f->value != NULL && f->value.length() > 0) {
//					QMenu menu(this);
//					if (f->type == TYPE_URL) {
//						menu.addAction(tr("Go to"), tmp, SLOT(m_goto()));
//						menu.addAction(tr("Copy"), tmp, SLOT(m_copy()));
//						//QDesktopServices::openUrl(QUrl::fromUserInput(f->value));
//					}
//					else {
//						if (f->type == TYPE_PHONE_NUMBER) {
//							QString telf = f->value;
//							telf = telf.simplified();
//							telf = telf.replace(" ", "");
//
//							if (telf.length() > 0) {
//								menu.addAction(tr("Call to").arg(telf), tmp, SLOT(m_call()));
//							}
//							//menu.addAction(tr("SMS to"), tmp, SLOT(m_sms()));
//							menu.addAction(tr("Copy"), tmp, SLOT(m_copy()));
//						}
//						else {
//							menu.addAction(tr("Copy"), tmp, SLOT(m_copy()));
//						}
//					}
//					menu.exec(_p);
//				}
//			}
//		}
//	}
//}

void DetailWindow::deleteCardFace()
{
	QPixmap available(":/resources/empty_card.png");
	imageLabel->setPixmap(available);

	deleteFace = true;
}

void DetailWindow::exportImage(QWidget * witdget, QImage * picture, QString name, QString ti)
{
	if (picture != NULL) {
		QString path(QDesktopServices::storageLocation(QDesktopServices::PicturesLocation));

		path.append("/").append(name.simplified().replace(' ', '_')).append(".png");

		QString s = QFileDialog::getSaveFileName(
	                witdget,
	                ti,
	                path,
	                tr("Images (*.png);;"));
		if (!s.isNull () && !s.isEmpty ()) {
			if (s.endsWith(".jpg"))
				picture->save(s, "JPG"); // writes image into ba in PNG format
			else if (s.endsWith(".jpeg"))
				picture->save(s, "JPEG"); // writes image into ba in PNG format
			else if (s.endsWith(".png"))
				picture->save(s, "PNG"); // writes image into ba in PNG format
			else if (s.endsWith(".tiff"))
				picture->save(s, "TIFF"); // writes image into ba in PNG format
			else {
				s.append(".png");
				picture->save(s, "PNG"); // writes image into ba in PNG format
			}
		}
	}
}

void DetailWindow::exportCardFace()
{
	exportImage(this, target->picture, target->name, tr("Choose card face image file"));
}
void DetailWindow::cardFace()
{
	QString path(QDesktopServices::storageLocation(QDesktopServices::PicturesLocation));
	QString s = QFileDialog::getOpenFileName(
	                this,
	                tr("Choose card face image"),
	                path,
	                tr("Images (*.png *.jpg *.gif *.jpeg);;"));

	if (!s.isNull () && !s.isEmpty ()) {
		////qDebug () << "loading " << s;
		if (currentImageN) delete currentImageN;

		currentImageN = new QImage ();
		loadImage(settings, s, *currentImageN); //;
		////qDebug () << "loaded " << s;
		imageLabel->setPixmap(QPixmap::fromImage (*currentImageN));
		////qDebug () << "asigned " << s;
		//update();
		deleteFace = false;
	}
}

void DetailWindow::rotateFace () {
	if (currentImageN) {
		QImage * tmp = currentImageN;

		QMatrix m;
		m.rotate(90);
		currentImageN = new QImage (currentImageN->transformed(m));

		imageLabel->setPixmap(QPixmap::fromImage (*currentImageN));
		delete tmp;
		deleteFace = false;
	}
	else
	if (currentImage) {
		QMatrix m;
		m.rotate(90);
		currentImageN = new QImage (currentImage->transformed(m));

		imageLabel->setPixmap(QPixmap::fromImage (*currentImageN));
		deleteFace = false;
	}
}

void DetailWindow::mirrorFace () {
	if (currentImageN) {
		QImage * tmp = currentImageN;
		currentImageN = new QImage (tmp->mirrored (true, true));
		imageLabel->setPixmap(QPixmap::fromImage (*currentImageN));
		delete tmp;
		deleteFace = false;
	}
	else
	if (currentImage) {
		currentImageN = new QImage (currentImage->mirrored (true, true));
		imageLabel->setPixmap(QPixmap::fromImage (*currentImageN));
		deleteFace = false;
	}
}

void DetailWindow::mirrorBack () {
	if (currentImageBackN) {
		QImage * tmp = currentImageBackN;
		currentImageBackN = new QImage (tmp->mirrored (true, true));
		imageBackLabel->setPixmap(QPixmap::fromImage (*currentImageBackN));
		delete tmp;
		deleteBack = false;
	}
	else
	if (currentImageBack) {
		currentImageBackN = new QImage (currentImageBack->mirrored (true, true));
		imageBackLabel->setPixmap(QPixmap::fromImage (*currentImageBackN));
		deleteBack = false;
	}
}

void DetailWindow::rotateBack () {
	if (currentImageBackN) {
		QImage * tmp = currentImageBackN;
		QMatrix m;
		m.rotate(90);
		currentImageBackN = new QImage (tmp->transformed (m));
		imageBackLabel->setPixmap(QPixmap::fromImage (*currentImageBackN));
		delete tmp;
		deleteBack = false;
	}
	else
	if (currentImageBack) {
		QMatrix m;
		m.rotate(90);
		currentImageBackN = new QImage (currentImageBack->transformed (m));
		imageBackLabel->setPixmap(QPixmap::fromImage (*currentImageBackN));
		deleteBack = false;
	}
}
//void DetailWindow::contextMenuEvent (QContextMenuEvent * event) {
//	//qDebug () << "NOW";
//}
void DetailWindow::cardFaceMenu(const QPoint & pos) {
	QMenu menu(this);
	if (edit) {
		menu.addAction(tr("Edit"), this, SLOT(cardFace()));
		//menu.addAction(tr("Mirror"), this, SLOT(mirrorFace()));
		menu.addAction(tr("Rotate"), this, SLOT(rotateFace()));
		menu.addAction(tr("Delete"), this, SLOT(deleteCardFace()));
	}
	else {
		menu.addAction(tr("Export Face"), this, SLOT(exportCardFace()));
		//menu.addAction(tr("See"), this, SLOT(seePicture()));
	}
	menu.exec(pos);
}
void DetailWindow::imageMenu(const QPoint & pos) {
	QMenu menu(this);
	if (edit) {
		menu.addAction(tr("Edit"), this, SLOT(cardFace()));
		//menu.addAction(tr("Mirror"), this, SLOT(mirrorFace()));
		menu.addAction(tr("Rotate"), this, SLOT(rotateFace()));
		menu.addAction(tr("Delete"), this, SLOT(deleteCardFace()));
	}
	else {
		menu.addAction(tr("Export Face"), this, SLOT(exportCardFace()));
	}
	menu.exec(pos);
}

void DetailWindow::cardBackMenu(const QPoint & pos) {
	QMenu menu(this);
	if (edit) {
		menu.addAction(tr("Edit"), this, SLOT(cardBack()));
		//menu.addAction(tr("Mirror"), this, SLOT(mirrorBack()));
		menu.addAction(tr("Rotate"), this, SLOT(rotateBack()));
		menu.addAction(tr("Delete"), this, SLOT(deleteCardBack()));
	}
	else {
		menu.addAction(tr("Export Back"), this, SLOT(exportCardBack()));
	}
	menu.exec(pos);
}


void DetailWindow::orientationChanged(int o) {
	////qDebug () << "CHAGNED";

	QRect screenGeometry = QApplication::desktop()->screenGeometry();
	if (!edit) {
		if (screenGeometry.width() > screenGeometry.height()) {
			if (imageLabel != NULL) {
				imageLabel->setMaximumSize(MAX_WIDTH, MAX_HEIGH);
				imageLabel->setMinimumSize(MAX_WIDTH, MAX_HEIGH);
			}
			if (imageBackLabel != NULL) {
				imageBackLabel->setMaximumSize(MAX_WIDTH, MAX_HEIGH);
				imageBackLabel->setMinimumSize(MAX_WIDTH, MAX_HEIGH);
			}
		}
		else {
			if (imageLabel != NULL) {
				imageLabel->setMaximumSize(MAX_WIDTH_L, MAX_HEIGH_L);
				imageLabel->setMinimumSize(MAX_WIDTH_L, MAX_HEIGH_L);
			}
			if (imageBackLabel != NULL) {
				imageBackLabel->setMaximumSize(MAX_WIDTH_L, MAX_HEIGH_L);
				imageBackLabel->setMinimumSize(MAX_WIDTH_L, MAX_HEIGH_L);
			}
		}
	}
	else {
	}

	if (screenGeometry.width() > screenGeometry.height()) {
		componentLayout->setColumnMinimumWidth(0, 180);
		componentLayout->setColumnMinimumWidth(1, 580);
	}
	else {
		componentLayout->setColumnMinimumWidth(0, 80);
		componentLayout->setColumnMinimumWidth(1, 360);
	}
}


void DetailWindow::deleteCardBack()
{
	QPixmap available(":/resources/empty_card_back.png");
	imageBackLabel->setPixmap(available);

	deleteBack = true;
}
void DetailWindow::exportCardBack()
{
	exportImage(this, target->pictureBack, target->name, tr("Choose card back image file")); // _BACK
}

void DetailWindow::cardBack()
{
	QString path(QDesktopServices::storageLocation(QDesktopServices::PicturesLocation));
	QString s = QFileDialog::getOpenFileName(
	                this,
	                tr("Choose card back image"),
	                path,
	                tr("Images (*.png *.jpg *.gif *.jpeg);;"));
	if (!s.isNull () && !s.isEmpty ()) {
		////qDebug () << "loading " << s;
		if (currentImageBackN) delete currentImageBackN;
		
		currentImageBackN = new QImage ();
		loadImage(settings, s, *currentImageBackN); //;
		
		imageBackLabel->setPixmap(QPixmap::fromImage (*currentImageBackN));
		//update ();
		deleteBack = false;
	}
}

void DetailWindow::photoTake (QImage* image) {
	if (currentImageN) delete currentImageN;
	currentImageN = new QImage (*image);
	imageLabel->setPixmap(QPixmap::fromImage (*currentImageN));
	deleteBack = false;
}

void DetailWindow::takePicture () {
#ifdef CAMERA
	QCamera * cam = new QCamera;
	connect (cam, SIGNAL(photoReady (QImage*)), this, SLOT(photoTake(QImage*)));

	cam->takePhoto();
#endif
}

void DetailWindow::closeEvent(QCloseEvent *event) {
	//qDebug () << "close event";
	if ((!forceClose) && (edit || isNew)) {
		bool isModified = false;

		isModified |= fieldsChanged || typeChanged || nameLineEdit->isModified() || groupLineEdit->isModified();

		for (int i = 0; (!isModified) && (i < target->fields.count()); i++) {
			TargetField * field = target->fields[i];
			if (field->type == TYPE_TEXT) {
				//qDebug () << "getting TEX field " << i;
				isModified |= ((QTextEdit*)values[i])->document ()->isModified ();
			}
			else
			if (field->type == TYPE_IMAGE) {
				//qDebug () << "getting TEX field " << i;
				isModified |= ((QLabelW*)values[i])->isModified ();
			}
			else {
				//qDebug () << "getting LIN field " << i;
				isModified |= ((QLineEdit*)values[i])->isModified();
			}
		}

		isModified |= deleteFace || currentImageN != NULL;
		isModified |= deleteBack || currentImageBackN != NULL;

		if (isModified) {
			QMessageBox * messageBox = new QMessageBox(this);
			int b = messageBox->information(this, "Wallet", tr("Are you sure you want to discard changes?"), QMessageBox::Yes, QMessageBox::No);
			if (b == QMessageBox::Yes) {
				target->freeFieldList();
				target->freeResources();

				event->accept();
			}
			else {
				event->ignore();
			}
			delete messageBox;
		}
		else {
			target->freeFieldList();
			target->freeResources();

			event->accept();
		}
	}
	else {
		event->accept();
	}
}

void DetailWindow::showN () {
	show ();
	if (!viewerWindow.isNull()) {
		viewerWindow->show();
	}
	if (!createFieldDlg.isNull()) {
		createFieldDlg->show();
	}
	if (!createPasswordDlg.isNull()) {
		createPasswordDlg->show();
	}
}
void DetailWindow::hideN () {
	if (!createPasswordDlg.isNull()) {
		createPasswordDlg->hide();
	}
	if (!createFieldDlg.isNull()) {
		createFieldDlg->hide();
	}
	if (!viewerWindow.isNull()) {
		viewerWindow->hide();
	}
	hide ();
}
