/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 */
#include "utils.h"

#include <Qt>
#include <QtGui>
#include <QFile>
#include <QDesktopServices>
#include <QListView>
#include "CreatePasswordDialog.h"


CreatePasswordDialog::CreatePasswordDialog(QWidget *parent): QDialog(parent) {
	setWindowTitle("Wallet");

	setContextMenuPolicy(Qt::NoContextMenu);
	QHBoxLayout * layout = new QHBoxLayout(this);

	layout->setMargin(0);
	layout->setSpacing(0);

	layout->setSpacing(10);
	layout->setMargin(10);

	QDialogButtonBox* dlgBtnBox = new QDialogButtonBox(this);
	dlgBtnBox->setOrientation(Qt::Vertical);

	generate = new QPushButton(tr("Generate"), this);
//	//closeButton->setFixedHeight(70);
	generate->setContextMenuPolicy(Qt::NoContextMenu);
	generate->setFocusPolicy(Qt::NoFocus);
	generate->setIconSize(QSize(48, 48));
	QObject::connect(generate, SIGNAL(clicked()), this, SLOT(save()));
	dlgBtnBox->addButton(generate, QDialogButtonBox::ActionRole);

	QGridLayout * componentLayout = new QGridLayout ();
	componentLayout->setContentsMargins(15, 0, 15, 0);
	componentLayout->setSpacing(5);

	addCharacters = new QCheckBox(tr("Add lower characters"), this);
	addCharacters->setContextMenuPolicy(Qt::NoContextMenu);
	addCharacters->setChecked(true);
	componentLayout->addWidget(addCharacters, 0, 1, 1, 1);

	addUpper = new QCheckBox(tr("Add upper characters"), this);
	addUpper->setContextMenuPolicy(Qt::NoContextMenu);
	addUpper->setChecked(true);
	componentLayout->addWidget(addUpper, 0, 2, 1, 1);

	addNumbers = new QCheckBox(tr("Add numbers"), this);
	addNumbers->setContextMenuPolicy(Qt::NoContextMenu);
	addNumbers->setChecked(true);
	componentLayout->addWidget(addNumbers, 1, 1, 1, 1);

	addOtherCharacters = new QCheckBox(tr("Add others"), this);
	addOtherCharacters->setContextMenuPolicy(Qt::NoContextMenu);
	addOtherCharacters->setChecked(false);
	componentLayout->addWidget(addOtherCharacters, 2, 1, 1, 1);

	others = new QLineEdit ("()/-_=!&%$*[]{}", this);
	others->setContextMenuPolicy(Qt::NoContextMenu);
	componentLayout->addWidget(others, 2, 2, 1, 1);

	QLabel * nameLabel;
	nameLabel = new QLabel(tr("Password length"), this);
	nameLabel->setContextMenuPolicy(Qt::NoContextMenu);
	componentLayout->addWidget(nameLabel, 3, 1, 1, 1);

	maxLength = new QSpinBox (this);
	maxLength->setMaximum(32);
	maxLength->setMinimum(1);
	maxLength->setValue(6);
	componentLayout->addWidget(maxLength, 3, 2, 1, 2);

	layout->addLayout(componentLayout);
	layout->setAlignment(componentLayout, Qt::AlignVCenter);

	layout->addWidget(dlgBtnBox);
	layout->setAlignment(dlgBtnBox, Qt::AlignBottom);

	setLayout(layout);
}

CreatePasswordDialog::~CreatePasswordDialog() {

}
void CreatePasswordDialog::save () {
	QString chars;
	if (addCharacters->isChecked()) {
		chars.append("abcdefghijklmnopqrstuvwxyz");
	}
	if (addUpper->isChecked()) {
		chars.append("ABCDEFGHIJKLMNOPKRSTUVWXYZ");
	}
	if (addNumbers->isChecked()) {
		chars.append("0123456789");
	}
	if (addOtherCharacters->isChecked()) {
		chars.append(others->text());
	}

    // INIT RANDOM
    QTime time = QTime::currentTime();
    qsrand((uint)time.msec());
    // INIT RANDOM

    for (int i = 0; i < maxLength->value(); i++) {
    	int u = qrand() % chars.length();

    	res.append(chars.at(u));
    }

    qDebug () << "generated " << res;

	done(QDialog::Accepted);
}
