#include "eWallet.h"
#include "Constants.h"
#include "DatabaseManager.h"
#include <Qt>
#include <QtGui>
#include <QFile>
#include <QDesktopServices>
#include <QListView>
#include "RenameGroupDialog.h"

RenameGroupDialog::RenameGroupDialog(QWidget *paTarget) : QDialog(paTarget)
{
	setWindowTitle("Wallet");

	setContextMenuPolicy(Qt::NoContextMenu);
	QHBoxLayout * layout = new QHBoxLayout(this);

	layout->setMargin(0);
	layout->setSpacing(0);

	layout->setSpacing(10);
	layout->setMargin(10);

	QDialogButtonBox* dlgBtnBox = new QDialogButtonBox(this);
	dlgBtnBox->setOrientation(Qt::Vertical);

	QPushButton * closeButton = new QPushButton(tr("Save && Close"), this);
	//closeButton->setFixedHeight(70);
	closeButton->setContextMenuPolicy(Qt::NoContextMenu);
	closeButton->setFocusPolicy(Qt::NoFocus);
	closeButton->setIconSize(QSize(48, 48));
	QObject::connect(closeButton, SIGNAL(clicked()), this, SLOT(save()));
	dlgBtnBox->addButton(closeButton, QDialogButtonBox::ActionRole);

	QGridLayout * componentLayout = new QGridLayout ();
	componentLayout->setContentsMargins(15, 0, 15, 0);
	componentLayout->setSpacing(5);

	// Name label
	QLabel * nameLabel = new QLabel(tr("Name"), this);
	nameLabel->setContextMenuPolicy(Qt::NoContextMenu);
	//nameLabel->setAlignment(Qt::AlignTop);
	componentLayout->addWidget(nameLabel, 1, 1, 1, 2);

// Name line edit
	nameLineEdit = new QLineEdit(this);
	nameLineEdit->setContextMenuPolicy(Qt::NoContextMenu);
	//nameLineEdit->setAlignment(Qt::AlignTop);
	componentLayout->addWidget(nameLineEdit, 1, 3, 1, 4);
	layout->addLayout(componentLayout);
	layout->setAlignment(componentLayout, Qt::AlignVCenter);

	layout->addWidget(dlgBtnBox);
	layout->setAlignment(dlgBtnBox, Qt::AlignBottom);

	setLayout(layout);
}

void RenameGroupDialog::setName (const QString & name) {
	nameLineEdit->setText (name);
}

QString RenameGroupDialog::getName () {
	return nameLineEdit->text();
}

void RenameGroupDialog::save () {
	//update ();
	done(QDialog::Accepted);
}
RenameGroupDialog::~RenameGroupDialog() {

}

